/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractResourceAnnotation;
import org.eclipse.jpt.core.internal.resource.java.NullEnumerated;
import org.eclipse.jpt.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.EnumType;
import org.eclipse.jpt.core.resource.java.EnumeratedAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Attribute;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumeratedImpl
extends AbstractResourceAnnotation<Attribute>
implements EnumeratedAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.Enumerated");
    private static final DeclarationAnnotationElementAdapter<String> VALUE_ADAPTER = EnumeratedImpl.buildValueAdapter();
    private final AnnotationElementAdapter<String> valueAdapter;
    private EnumType value;

    protected EnumeratedImpl(JavaResourceNode parent, Attribute attribute) {
        super(parent, attribute, DECLARATION_ANNOTATION_ADAPTER);
        this.valueAdapter = new ShortCircuitAnnotationElementAdapter<String>(attribute, VALUE_ADAPTER);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.value = this.value(astRoot);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.Enumerated";
    }

    @Override
    public EnumType getValue() {
        return this.value;
    }

    @Override
    public void setValue(EnumType newValue) {
        if (this.attributeValueHasNotChanged((Object)this.value, (Object)newValue)) {
            return;
        }
        EnumType oldValue = this.value;
        this.value = newValue;
        this.valueAdapter.setValue(EnumType.toJavaAnnotationValue(newValue));
        this.firePropertyChanged("valueProperty", (Object)oldValue, (Object)newValue);
    }

    @Override
    public TextRange getValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(VALUE_ADAPTER, astRoot);
    }

    @Override
    public void update(CompilationUnit astRoot) {
        this.setValue(this.value(astRoot));
    }

    protected EnumType value(CompilationUnit astRoot) {
        return EnumType.fromJavaAnnotationValue(this.valueAdapter.getValue(astRoot));
    }

    private static DeclarationAnnotationElementAdapter<String> buildValueAdapter() {
        return new EnumDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "value", false);
    }

    public static class EnumeratedAnnotationDefinition
    implements AnnotationDefinition {
        private static final EnumeratedAnnotationDefinition INSTANCE = new EnumeratedAnnotationDefinition();

        public static AnnotationDefinition instance() {
            return INSTANCE;
        }

        private EnumeratedAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new EnumeratedImpl(parent, (Attribute)member);
        }

        public Annotation buildNullAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new NullEnumerated(parent);
        }

        public String getAnnotationName() {
            return "javax.persistence.Enumerated";
        }
    }
}

