/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jpt.core.JpaAnnotationProvider;
import org.eclipse.jpt.core.ResourceModelListener;
import org.eclipse.jpt.core.internal.resource.java.AbstractJavaResourceNode;
import org.eclipse.jpt.core.internal.resource.java.JavaResourcePersistentTypeImpl;
import org.eclipse.jpt.core.internal.utility.jdt.JDTTools;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.JpaCompilationUnit;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationEditFormatter;
import org.eclipse.jpt.utility.CommandExecutorProvider;
import org.eclipse.jpt.utility.internal.BitTools;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaCompilationUnitImpl
extends AbstractJavaResourceNode
implements JpaCompilationUnit {
    private final ICompilationUnit compilationUnit;
    private final JpaAnnotationProvider annotationProvider;
    private final CommandExecutorProvider modifySharedDocumentCommandExecutorProvider;
    private final AnnotationEditFormatter annotationEditFormatter;
    private final ResourceModelListener resourceModelListener;
    protected JavaResourcePersistentType persistentType;
    protected static final int CLASSPATH_CHANGED_FLAGS = 0x220000;

    public JpaCompilationUnitImpl(ICompilationUnit compilationUnit, JpaAnnotationProvider annotationProvider, CommandExecutorProvider modifySharedDocumentCommandExecutorProvider, AnnotationEditFormatter annotationEditFormatter, ResourceModelListener resourceModelListener) {
        super(null);
        this.compilationUnit = compilationUnit;
        this.annotationProvider = annotationProvider;
        this.modifySharedDocumentCommandExecutorProvider = modifySharedDocumentCommandExecutorProvider;
        this.annotationEditFormatter = annotationEditFormatter;
        this.resourceModelListener = resourceModelListener;
        this.persistentType = this.buildPersistentType();
    }

    protected JavaResourcePersistentType buildPersistentType() {
        this.openCompilationUnit();
        CompilationUnit astRoot = this.buildASTRoot();
        this.closeCompilationUnit();
        return this.buildPersistentType(astRoot);
    }

    protected void openCompilationUnit() {
        try {
            this.compilationUnit.open(null);
        }
        catch (JavaModelException javaModelException) {}
    }

    protected void closeCompilationUnit() {
        try {
            this.compilationUnit.close();
        }
        catch (JavaModelException javaModelException) {}
    }

    protected JavaResourcePersistentType buildPersistentType(CompilationUnit astRoot) {
        TypeDeclaration td = this.getPrimaryType(astRoot);
        return td == null ? null : this.buildPersistentType(astRoot, td);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
    }

    @Override
    protected boolean requiresParent() {
        return false;
    }

    @Override
    public JpaCompilationUnit getJpaCompilationUnit() {
        return this;
    }

    @Override
    public JpaAnnotationProvider getAnnotationProvider() {
        return this.annotationProvider;
    }

    @Override
    public void update(CompilationUnit astRoot) {
        TypeDeclaration td = this.getPrimaryType(astRoot);
        if (td == null) {
            this.persistentType = null;
        } else if (this.persistentType == null) {
            this.persistentType = this.buildPersistentType(astRoot, td);
        } else {
            this.persistentType.update(astRoot);
        }
    }

    @Override
    public TextRange getTextRange(CompilationUnit astRoot) {
        return null;
    }

    @Override
    public ICompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    @Override
    public Iterator<JavaResourcePersistentType> persistableTypes() {
        return this.persistentType == null ? EmptyIterator.instance() : this.persistentType.allPersistableTypes();
    }

    @Override
    public void resourceModelChanged() {
        this.resourceModelListener.resourceModelChanged();
    }

    @Override
    public void resolveTypes() {
        if (this.persistentType != null) {
            this.persistentType.resolveTypes(this.buildASTRoot());
        }
    }

    @Override
    public CommandExecutorProvider getModifySharedDocumentCommandExecutorProvider() {
        return this.modifySharedDocumentCommandExecutorProvider;
    }

    @Override
    public AnnotationEditFormatter getAnnotationEditFormatter() {
        return this.annotationEditFormatter;
    }

    @Override
    public void javaElementChanged(ElementChangedEvent event) {
        this.synchWithJavaDelta(event.getDelta());
    }

    protected void synchWithJavaDelta(IJavaElementDelta delta) {
        switch (delta.getElement().getElementType()) {
            case 2: {
                if (this.classpathHasChanged(delta)) {
                    this.updateFromJava();
                    break;
                }
            }
            case 1: 
            case 3: 
            case 4: {
                this.synchChildrenWithJavaDelta(delta);
                break;
            }
            case 5: {
                if (!this.deltaIsRelevant(delta)) break;
                this.updateFromJava();
                break;
            }
        }
    }

    protected void synchChildrenWithJavaDelta(IJavaElementDelta delta) {
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta child = iJavaElementDeltaArray[n2];
            this.synchWithJavaDelta(child);
            ++n2;
        }
    }

    protected boolean classpathHasChanged(IJavaElementDelta delta) {
        return BitTools.anyFlagsAreSet((int)delta.getFlags(), (int)this.getClasspathChangedFlags());
    }

    protected int getClasspathChangedFlags() {
        return 0x220000;
    }

    protected boolean deltaIsRelevant(IJavaElementDelta delta) {
        if (BitTools.onlyFlagIsSet((int)delta.getFlags(), (int)65536)) {
            return false;
        }
        if (delta.getKind() == 2) {
            return false;
        }
        return delta.getElement().equals(this.compilationUnit);
    }

    protected void updateFromJava() {
        this.update(this.buildASTRoot());
    }

    protected CompilationUnit buildASTRoot() {
        return JDTTools.buildASTRoot(this.compilationUnit);
    }

    protected JavaResourcePersistentType buildPersistentType(CompilationUnit astRoot, TypeDeclaration typeDeclaration) {
        return JavaResourcePersistentTypeImpl.newInstance(this, typeDeclaration, astRoot);
    }

    protected TypeDeclaration getPrimaryType(CompilationUnit astRoot) {
        String primaryTypeName = this.getPrimaryTypeName();
        for (AbstractTypeDeclaration atd : JpaCompilationUnitImpl.types(astRoot)) {
            if (atd.getNodeType() != 55 || !atd.getName().getFullyQualifiedName().equals(primaryTypeName)) continue;
            return atd.resolveBinding() != null ? (TypeDeclaration)atd : null;
        }
        return null;
    }

    protected static List<AbstractTypeDeclaration> types(CompilationUnit astRoot) {
        return astRoot.types();
    }

    protected String getPrimaryTypeName() {
        return JpaCompilationUnitImpl.removeJavaExtension(this.compilationUnit.getElementName());
    }

    protected static String removeJavaExtension(String fileName) {
        int index = fileName.lastIndexOf(".java");
        return index == -1 ? fileName : fileName.substring(0, index);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.persistentType.getName());
    }
}

