/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.db.SchemaContainer;
import org.eclipse.jpt.db.internal.DTPColumnWrapper;
import org.eclipse.jpt.db.internal.DTPDatabaseObject;
import org.eclipse.jpt.db.internal.DTPDatabaseObjectWrapper;
import org.eclipse.jpt.db.internal.DTPSchemaWrapper;
import org.eclipse.jpt.db.internal.DTPTableWrapper;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class DTPSchemaContainerWrapper
extends DTPDatabaseObjectWrapper
implements SchemaContainer {
    private DTPSchemaWrapper[] schemata;

    DTPSchemaContainerWrapper(DTPDatabaseObject parent, Object dtpObject) {
        super(parent, dtpObject);
    }

    @Override
    synchronized void catalogObjectChanged() {
        super.catalogObjectChanged();
    }

    abstract List<org.eclipse.datatools.modelbase.sql.schema.Schema> getDTPSchemata();

    abstract DTPSchemaWrapper getSchema(org.eclipse.datatools.modelbase.sql.schema.Schema var1);

    DTPSchemaWrapper getSchema_(org.eclipse.datatools.modelbase.sql.schema.Schema dtpSchema) {
        DTPSchemaWrapper[] dTPSchemaWrapperArray = this.getSchemata();
        int n = dTPSchemaWrapperArray.length;
        int n2 = 0;
        while (n2 < n) {
            DTPSchemaWrapper schema = dTPSchemaWrapperArray[n2];
            if (schema.wraps(dtpSchema)) {
                return schema;
            }
            ++n2;
        }
        throw new IllegalArgumentException("invalid DTP schema: " + dtpSchema);
    }

    abstract DTPTableWrapper getTable(Table var1);

    DTPTableWrapper getTable_(Table dtpTable) {
        return this.getSchema_(dtpTable.getSchema()).getTable_(dtpTable);
    }

    abstract DTPColumnWrapper getColumn(Column var1);

    DTPColumnWrapper getColumn_(Column dtpColumn) {
        return this.getTable_(dtpColumn.getTable()).getColumn_(dtpColumn);
    }

    @Override
    public Iterator<Schema> schemata() {
        return new ArrayIterator((Object[])this.getSchemata());
    }

    Iterator<DTPSchemaWrapper> schemaWrappers() {
        return new ArrayIterator((Object[])this.getSchemata());
    }

    synchronized DTPSchemaWrapper[] getSchemata() {
        if (this.schemata == null) {
            this.schemata = this.buildSchemata();
        }
        return this.schemata;
    }

    private DTPSchemaWrapper[] buildSchemata() {
        List<org.eclipse.datatools.modelbase.sql.schema.Schema> dtpSchemata = this.getDTPSchemata();
        Object[] result = new DTPSchemaWrapper[dtpSchemata.size()];
        int i = result.length;
        while (i-- > 0) {
            result[i] = new DTPSchemaWrapper(this, dtpSchemata.get(i));
        }
        return (DTPSchemaWrapper[])CollectionTools.sort((Object[])result);
    }

    @Override
    public int schemataSize() {
        return this.getSchemata().length;
    }

    @Override
    public DTPSchemaWrapper getSchemaNamed(String name) {
        return (DTPSchemaWrapper)this.selectDatabaseObjectNamed(this.getSchemata(), name);
    }

    @Override
    public Iterator<String> sortedSchemaIdentifiers() {
        return new TransformationIterator<DTPSchemaWrapper, String>(this.schemaWrappers()){

            protected String transform(DTPSchemaWrapper next) {
                return next.getIdentifier();
            }
        };
    }

    @Override
    public DTPSchemaWrapper getSchemaForIdentifier(String identifier) {
        return (DTPSchemaWrapper)this.selectDatabaseObjectForIdentifier(this.getSchemata(), identifier);
    }

    @Override
    public DTPSchemaWrapper getDefaultSchema() {
        return this.getDatabase().getDefaultSchema(this);
    }

    @Override
    synchronized void startListening() {
        if (this.schemata != null) {
            this.startSchemata();
        }
        super.startListening();
    }

    private void startSchemata() {
        DTPSchemaWrapper[] dTPSchemaWrapperArray = this.schemata;
        int n = this.schemata.length;
        int n2 = 0;
        while (n2 < n) {
            DTPSchemaWrapper schema = dTPSchemaWrapperArray[n2];
            schema.startListening();
            ++n2;
        }
    }

    @Override
    synchronized void stopListening() {
        if (this.schemata != null) {
            this.stopSchemata();
        }
        super.stopListening();
    }

    private void stopSchemata() {
        DTPSchemaWrapper[] dTPSchemaWrapperArray = this.schemata;
        int n = this.schemata.length;
        int n2 = 0;
        while (n2 < n) {
            DTPSchemaWrapper schema = dTPSchemaWrapperArray[n2];
            schema.stopListening();
            ++n2;
        }
    }

    @Override
    synchronized void clear() {
        if (this.schemata != null) {
            this.clearSchemata();
        }
    }

    private void clearSchemata() {
        this.stopSchemata();
        DTPSchemaWrapper[] dTPSchemaWrapperArray = this.schemata;
        int n = this.schemata.length;
        int n2 = 0;
        while (n2 < n) {
            DTPSchemaWrapper schema = dTPSchemaWrapperArray[n2];
            schema.clear();
            ++n2;
        }
        this.schemata = null;
    }
}

