/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.context.ExistenceType;
import org.eclipse.jpt.eclipselink.core.context.ExpiryTimeOfDay;
import org.eclipse.jpt.eclipselink.core.context.java.EclipseLinkJavaEntity;
import org.eclipse.jpt.eclipselink.core.context.java.JavaCaching;
import org.eclipse.jpt.eclipselink.core.resource.java.CacheAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.CacheCoordinationType;
import org.eclipse.jpt.eclipselink.core.resource.java.CacheType;
import org.eclipse.jpt.eclipselink.core.resource.java.ExistenceCheckingAnnotation;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.java.EclipseLinkJavaContextModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class EclipseLinkJavaCachingTests
extends EclipseLinkJavaContextModelTestCase {
    public EclipseLinkJavaCachingTests(String name) {
        super(name);
    }

    private void createCacheTypeEnum() throws Exception {
        this.createEnumAndMembers("org.eclipse.persistence.annotations", "CacheType", "SOFT_WEAK, HARD_WEAK, WEAK, SOFT, FULL, CACHE, NONE;");
    }

    private void createCacheCoordinationTypeEnum() throws Exception {
        this.createEnumAndMembers("org.eclipse.persistence.annotations", "CacheCoordinationType", "SEND_OBJECT_CHANGES, INVALIDATE_CHANGED_OBJECTS, SEND_NEW_OBJECTS_WITH_CHANGES, NONE;");
    }

    private void createExistenceTypeEnum() throws Exception {
        this.createEnumAndMembers("org.eclipse.persistence.annotations", "ExistenceType", "CHECK_CACHE, CHECK_DATABASE, ASSUME_EXISTENCE, ASSUME_NON_EXISTENCE;");
    }

    private void createCacheAnnotation() throws Exception {
        this.createCacheTypeEnum();
        this.createCacheCoordinationTypeEnum();
        this.createTimeOfDayAnnotation();
        this.createAnnotationAndMembers("org.eclipse.persistence.annotations", "Cache", "CacheType type() default SOFT_WEAK; int size() default 100; boolean shared() default true; int expiry() default -1; TimeOfDay expiryTimeOfDay() default @TimeOfDay(specified=false); boolean alwaysRefresh() default false; boolean refreshOnlyIfNewer() default false; boolean disableHits() default false; CacheCoordinationType coordinationType() default SEND_OBJECT_CHANGES;");
    }

    private void createTimeOfDayAnnotation() throws Exception {
        this.createAnnotationAndMembers("org.eclipse.persistence.annotations", "TimeOfDay", "int hour() default 0; int minute() default 0; int second() default 0; int millisecond() default 0;");
    }

    private void createExistenceCheckingAnnotation() throws Exception {
        this.createExistenceTypeEnum();
        this.createAnnotationAndMembers("org.eclipse.persistence.annotations", "ExistenceChecking", "ExistenceType value() default CHECK_CACHE;; int size() default 100; boolean shared() default true; int expiry() default -1; TimeOfDay expiryTimeOfDay() default @TimeOfDay(specified=false); boolean alwaysRefresh() default false; boolean refreshOnlyIfNewer() default false; boolean disableHits() default false; CacheCoordinationType coordinationType() default SEND_OBJECT_CHANGES;");
    }

    private ICompilationUnit createTestEntity() throws Exception {
        this.createCacheAnnotation();
        this.createExistenceCheckingAnnotation();
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    public void testSetSpecifiedShared() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.javaPersistentType().getMapping();
        JavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((boolean)true, (boolean)caching.isShared());
        caching.setSpecifiedShared(Boolean.FALSE);
        EclipseLinkJavaCachingTests.assertEquals((Object)Boolean.FALSE, (Object)entity.getCaching().getSpecifiedShared());
        EclipseLinkJavaCachingTests.assertEquals((boolean)false, (boolean)entity.getCaching().isShared());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        CacheAnnotation cacheAnnotation = (CacheAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Cache");
        EclipseLinkJavaCachingTests.assertEquals((Object)Boolean.FALSE, (Object)cacheAnnotation.getShared());
    }

    public void testSetSpecifiedSharedFalseUnsetsOtherCacheSettings() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.javaPersistentType().getMapping();
        JavaCaching caching = entity.getCaching();
        caching.setSpecifiedType(org.eclipse.jpt.eclipselink.core.context.CacheType.HARD_WEAK);
        caching.setSpecifiedSize(Integer.valueOf(500));
        caching.setSpecifiedAlwaysRefresh(Boolean.FALSE);
        caching.setSpecifiedRefreshOnlyIfNewer(Boolean.FALSE);
        caching.setSpecifiedDisableHits(Boolean.FALSE);
        caching.setSpecifiedCoordinationType(org.eclipse.jpt.eclipselink.core.context.CacheCoordinationType.INVALIDATE_CHANGED_OBJECTS);
        caching.setExistenceChecking(true);
        caching.setSpecifiedExistenceType(ExistenceType.CHECK_CACHE);
        caching.setExpiry(Integer.valueOf(8000));
        caching.setSpecifiedShared(Boolean.FALSE);
        EclipseLinkJavaCachingTests.assertEquals(null, (Object)caching.getSpecifiedType());
        EclipseLinkJavaCachingTests.assertEquals(null, (Object)caching.getSpecifiedSize());
        EclipseLinkJavaCachingTests.assertEquals(null, (Object)caching.getSpecifiedAlwaysRefresh());
        EclipseLinkJavaCachingTests.assertEquals(null, (Object)caching.getSpecifiedRefreshOnlyIfNewer());
        EclipseLinkJavaCachingTests.assertEquals(null, (Object)caching.getSpecifiedDisableHits());
        EclipseLinkJavaCachingTests.assertEquals(null, (Object)caching.getSpecifiedCoordinationType());
        EclipseLinkJavaCachingTests.assertEquals(null, (Object)caching.getExpiry());
        EclipseLinkJavaCachingTests.assertTrue((boolean)caching.hasExistenceChecking());
        EclipseLinkJavaCachingTests.assertEquals((Object)ExistenceType.CHECK_CACHE, (Object)caching.getSpecifiedExistenceType());
        caching.setSpecifiedShared(null);
        ExpiryTimeOfDay timeOfDayExpiry = caching.addExpiryTimeOfDay();
        timeOfDayExpiry.setHour(Integer.valueOf(5));
        caching.setSpecifiedShared(Boolean.FALSE);
        EclipseLinkJavaCachingTests.assertNull((Object)caching.getExpiryTimeOfDay());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        CacheAnnotation cacheAnnotation = (CacheAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Cache");
        EclipseLinkJavaCachingTests.assertEquals((Object)Boolean.FALSE, (Object)cacheAnnotation.getShared());
        EclipseLinkJavaCachingTests.assertNull((Object)cacheAnnotation.getExpiryTimeOfDay());
    }

    public void testGetSpecifiedShared() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.javaPersistentType().getMapping();
        JavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((boolean)true, (boolean)caching.isShared());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        CacheAnnotation cacheAnnotation = (CacheAnnotation)typeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.Cache");
        cacheAnnotation.setShared(Boolean.FALSE);
        EclipseLinkJavaCachingTests.assertEquals((Object)Boolean.FALSE, (Object)cacheAnnotation.getShared());
        EclipseLinkJavaCachingTests.assertEquals((Object)Boolean.FALSE, (Object)entity.getCaching().getSpecifiedShared());
        EclipseLinkJavaCachingTests.assertEquals((boolean)false, (boolean)entity.getCaching().isShared());
    }

    public void testSetSpecifiedType() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.javaPersistentType().getMapping();
        JavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.CacheType.SOFT_WEAK, (Object)caching.getType());
        caching.setSpecifiedType(org.eclipse.jpt.eclipselink.core.context.CacheType.HARD_WEAK);
        EclipseLinkJavaCachingTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.CacheType.HARD_WEAK, (Object)entity.getCaching().getSpecifiedType());
        EclipseLinkJavaCachingTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.CacheType.HARD_WEAK, (Object)entity.getCaching().getType());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        CacheAnnotation cacheAnnotation = (CacheAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Cache");
        EclipseLinkJavaCachingTests.assertEquals((Object)CacheType.HARD_WEAK, (Object)cacheAnnotation.getType());
        caching.setSpecifiedType(org.eclipse.jpt.eclipselink.core.context.CacheType.SOFT_WEAK);
        EclipseLinkJavaCachingTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.CacheType.SOFT_WEAK, (Object)caching.getSpecifiedType());
        EclipseLinkJavaCachingTests.assertEquals((Object)CacheType.SOFT_WEAK, (Object)cacheAnnotation.getType());
        caching.setSpecifiedType(null);
        EclipseLinkJavaCachingTests.assertNull((Object)caching.getSpecifiedType());
        EclipseLinkJavaCachingTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.CacheType.SOFT_WEAK, (Object)caching.getType());
    }

    public void testGetSpecifiedType() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.javaPersistentType().getMapping();
        JavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.CacheType.SOFT_WEAK, (Object)caching.getType());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        CacheAnnotation cacheAnnotation = (CacheAnnotation)typeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.Cache");
        cacheAnnotation.setType(CacheType.HARD_WEAK);
        EclipseLinkJavaCachingTests.assertEquals((Object)CacheType.HARD_WEAK, (Object)cacheAnnotation.getType());
        EclipseLinkJavaCachingTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.CacheType.HARD_WEAK, (Object)entity.getCaching().getSpecifiedType());
        EclipseLinkJavaCachingTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.CacheType.HARD_WEAK, (Object)entity.getCaching().getType());
    }

    public void testSetSpecifiedAlwaysRefresh() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.javaPersistentType().getMapping();
        JavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((boolean)false, (boolean)caching.isAlwaysRefresh());
        caching.setSpecifiedAlwaysRefresh(Boolean.FALSE);
        EclipseLinkJavaCachingTests.assertEquals((Object)Boolean.FALSE, (Object)entity.getCaching().getSpecifiedAlwaysRefresh());
        EclipseLinkJavaCachingTests.assertEquals((boolean)false, (boolean)entity.getCaching().isAlwaysRefresh());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        CacheAnnotation cacheAnnotation = (CacheAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Cache");
        EclipseLinkJavaCachingTests.assertEquals((Object)Boolean.FALSE, (Object)cacheAnnotation.getAlwaysRefresh());
    }

    public void testGetSpecifiedAlwaysRefresh() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.javaPersistentType().getMapping();
        JavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((boolean)false, (boolean)caching.isAlwaysRefresh());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        CacheAnnotation cacheAnnotation = (CacheAnnotation)typeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.Cache");
        cacheAnnotation.setAlwaysRefresh(Boolean.TRUE);
        EclipseLinkJavaCachingTests.assertEquals((Object)Boolean.TRUE, (Object)cacheAnnotation.getAlwaysRefresh());
        EclipseLinkJavaCachingTests.assertEquals((Object)Boolean.TRUE, (Object)entity.getCaching().getSpecifiedAlwaysRefresh());
        EclipseLinkJavaCachingTests.assertEquals((boolean)true, (boolean)entity.getCaching().isAlwaysRefresh());
    }

    public void testSetSpecifiedRefreshOnlyIfNewer() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.javaPersistentType().getMapping();
        JavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((boolean)false, (boolean)caching.isRefreshOnlyIfNewer());
        caching.setSpecifiedRefreshOnlyIfNewer(Boolean.TRUE);
        EclipseLinkJavaCachingTests.assertEquals((Object)Boolean.TRUE, (Object)entity.getCaching().getSpecifiedRefreshOnlyIfNewer());
        EclipseLinkJavaCachingTests.assertEquals((boolean)true, (boolean)entity.getCaching().isRefreshOnlyIfNewer());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        CacheAnnotation cacheAnnotation = (CacheAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Cache");
        EclipseLinkJavaCachingTests.assertEquals((Object)Boolean.TRUE, (Object)cacheAnnotation.getRefreshOnlyIfNewer());
    }

    public void testGetSpecifiedRefreshOnlyIfNewer() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.javaPersistentType().getMapping();
        JavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((boolean)false, (boolean)caching.isRefreshOnlyIfNewer());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        CacheAnnotation cacheAnnotation = (CacheAnnotation)typeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.Cache");
        cacheAnnotation.setRefreshOnlyIfNewer(Boolean.TRUE);
        EclipseLinkJavaCachingTests.assertEquals((Object)Boolean.TRUE, (Object)cacheAnnotation.getRefreshOnlyIfNewer());
        EclipseLinkJavaCachingTests.assertEquals((Object)Boolean.TRUE, (Object)entity.getCaching().getSpecifiedRefreshOnlyIfNewer());
        EclipseLinkJavaCachingTests.assertEquals((boolean)true, (boolean)entity.getCaching().isRefreshOnlyIfNewer());
    }

    public void testSetSpecifiedDisableHits() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.javaPersistentType().getMapping();
        JavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((boolean)false, (boolean)caching.isDisableHits());
        caching.setSpecifiedDisableHits(Boolean.TRUE);
        EclipseLinkJavaCachingTests.assertEquals((Object)Boolean.TRUE, (Object)entity.getCaching().getSpecifiedDisableHits());
        EclipseLinkJavaCachingTests.assertEquals((boolean)true, (boolean)entity.getCaching().isDisableHits());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        CacheAnnotation cacheAnnotation = (CacheAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Cache");
        EclipseLinkJavaCachingTests.assertEquals((Object)Boolean.TRUE, (Object)cacheAnnotation.getDisableHits());
    }

    public void testGetSpecifiedDisableHits() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.javaPersistentType().getMapping();
        JavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((boolean)false, (boolean)caching.isDisableHits());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        CacheAnnotation cacheAnnotation = (CacheAnnotation)typeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.Cache");
        cacheAnnotation.setDisableHits(Boolean.TRUE);
        EclipseLinkJavaCachingTests.assertEquals((Object)Boolean.TRUE, (Object)cacheAnnotation.getDisableHits());
        EclipseLinkJavaCachingTests.assertEquals((Object)Boolean.TRUE, (Object)entity.getCaching().getSpecifiedDisableHits());
        EclipseLinkJavaCachingTests.assertEquals((boolean)true, (boolean)entity.getCaching().isDisableHits());
    }

    public void testSetSpecifiedCoordinationType() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.javaPersistentType().getMapping();
        JavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.CacheCoordinationType.SEND_OBJECT_CHANGES, (Object)caching.getCoordinationType());
        caching.setSpecifiedCoordinationType(org.eclipse.jpt.eclipselink.core.context.CacheCoordinationType.INVALIDATE_CHANGED_OBJECTS);
        EclipseLinkJavaCachingTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.CacheCoordinationType.INVALIDATE_CHANGED_OBJECTS, (Object)entity.getCaching().getSpecifiedCoordinationType());
        EclipseLinkJavaCachingTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.CacheCoordinationType.INVALIDATE_CHANGED_OBJECTS, (Object)entity.getCaching().getCoordinationType());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        CacheAnnotation cacheAnnotation = (CacheAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Cache");
        EclipseLinkJavaCachingTests.assertEquals((Object)CacheCoordinationType.INVALIDATE_CHANGED_OBJECTS, (Object)cacheAnnotation.getCoordinationType());
        caching.setSpecifiedCoordinationType(org.eclipse.jpt.eclipselink.core.context.CacheCoordinationType.SEND_OBJECT_CHANGES);
        EclipseLinkJavaCachingTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.CacheCoordinationType.SEND_OBJECT_CHANGES, (Object)caching.getSpecifiedCoordinationType());
        EclipseLinkJavaCachingTests.assertEquals((Object)CacheCoordinationType.SEND_OBJECT_CHANGES, (Object)cacheAnnotation.getCoordinationType());
        caching.setSpecifiedCoordinationType(null);
        EclipseLinkJavaCachingTests.assertNull((Object)caching.getSpecifiedCoordinationType());
        EclipseLinkJavaCachingTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.CacheCoordinationType.SEND_OBJECT_CHANGES, (Object)caching.getCoordinationType());
    }

    public void testGetSpecifiedCoordinationType() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.javaPersistentType().getMapping();
        JavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.CacheCoordinationType.SEND_OBJECT_CHANGES, (Object)caching.getCoordinationType());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        CacheAnnotation cacheAnnotation = (CacheAnnotation)typeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.Cache");
        cacheAnnotation.setCoordinationType(CacheCoordinationType.INVALIDATE_CHANGED_OBJECTS);
        EclipseLinkJavaCachingTests.assertEquals((Object)CacheCoordinationType.INVALIDATE_CHANGED_OBJECTS, (Object)cacheAnnotation.getCoordinationType());
        EclipseLinkJavaCachingTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.CacheCoordinationType.INVALIDATE_CHANGED_OBJECTS, (Object)entity.getCaching().getSpecifiedCoordinationType());
        EclipseLinkJavaCachingTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.CacheCoordinationType.INVALIDATE_CHANGED_OBJECTS, (Object)entity.getCaching().getCoordinationType());
    }

    public void testHasExistenceChecking() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.javaPersistentType().getMapping();
        JavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((boolean)false, (boolean)caching.hasExistenceChecking());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        typeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.ExistenceChecking");
        EclipseLinkJavaCachingTests.assertEquals((boolean)true, (boolean)caching.hasExistenceChecking());
        typeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.ExistenceChecking");
        EclipseLinkJavaCachingTests.assertEquals((boolean)false, (boolean)caching.hasExistenceChecking());
    }

    public void testSetExistenceChecking() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.javaPersistentType().getMapping();
        JavaCaching caching = entity.getCaching();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        EclipseLinkJavaCachingTests.assertEquals((boolean)false, (boolean)caching.hasExistenceChecking());
        EclipseLinkJavaCachingTests.assertNull((Object)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ExistenceChecking"));
        caching.setExistenceChecking(true);
        EclipseLinkJavaCachingTests.assertEquals((boolean)true, (boolean)caching.hasExistenceChecking());
        EclipseLinkJavaCachingTests.assertNotNull((Object)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ExistenceChecking"));
    }

    public void testGetDefaultExistenceType() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.javaPersistentType().getMapping();
        JavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((Object)ExistenceType.CHECK_DATABASE, (Object)caching.getDefaultExistenceType());
        caching.setExistenceChecking(true);
        EclipseLinkJavaCachingTests.assertEquals((Object)ExistenceType.CHECK_CACHE, (Object)caching.getDefaultExistenceType());
    }

    public void testGetSpecifiedExistenceType() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.javaPersistentType().getMapping();
        JavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((Object)ExistenceType.CHECK_DATABASE, (Object)caching.getExistenceType());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        ExistenceCheckingAnnotation existenceCheckingAnnotation = (ExistenceCheckingAnnotation)typeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.ExistenceChecking");
        existenceCheckingAnnotation.setValue(org.eclipse.jpt.eclipselink.core.resource.java.ExistenceType.ASSUME_NON_EXISTENCE);
        EclipseLinkJavaCachingTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.resource.java.ExistenceType.ASSUME_NON_EXISTENCE, (Object)existenceCheckingAnnotation.getValue());
        EclipseLinkJavaCachingTests.assertEquals((Object)ExistenceType.ASSUME_NON_EXISTENCE, (Object)entity.getCaching().getSpecifiedExistenceType());
        EclipseLinkJavaCachingTests.assertEquals((Object)ExistenceType.ASSUME_NON_EXISTENCE, (Object)entity.getCaching().getExistenceType());
    }

    public void testSetSpecifiedExistenceType() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.javaPersistentType().getMapping();
        JavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((Object)ExistenceType.CHECK_DATABASE, (Object)caching.getExistenceType());
        caching.setExistenceChecking(true);
        caching.setSpecifiedExistenceType(ExistenceType.ASSUME_NON_EXISTENCE);
        EclipseLinkJavaCachingTests.assertEquals((Object)ExistenceType.ASSUME_NON_EXISTENCE, (Object)entity.getCaching().getSpecifiedExistenceType());
        EclipseLinkJavaCachingTests.assertEquals((Object)ExistenceType.ASSUME_NON_EXISTENCE, (Object)entity.getCaching().getExistenceType());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        ExistenceCheckingAnnotation existenceCheckingAnnotation = (ExistenceCheckingAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ExistenceChecking");
        EclipseLinkJavaCachingTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.resource.java.ExistenceType.ASSUME_NON_EXISTENCE, (Object)existenceCheckingAnnotation.getValue());
        caching.setSpecifiedExistenceType(ExistenceType.CHECK_DATABASE);
        EclipseLinkJavaCachingTests.assertEquals((Object)ExistenceType.CHECK_DATABASE, (Object)caching.getSpecifiedExistenceType());
        EclipseLinkJavaCachingTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.resource.java.ExistenceType.CHECK_DATABASE, (Object)existenceCheckingAnnotation.getValue());
        caching.setSpecifiedExistenceType(null);
        EclipseLinkJavaCachingTests.assertNull((Object)caching.getSpecifiedExistenceType());
        EclipseLinkJavaCachingTests.assertEquals((Object)ExistenceType.CHECK_CACHE, (Object)caching.getExistenceType());
    }

    public void testGetExpiry() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.javaPersistentType().getMapping();
        EclipseLinkJavaCachingTests.assertNull((Object)entity.getCaching().getExpiry());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        CacheAnnotation cacheAnnotation = (CacheAnnotation)typeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.Cache");
        EclipseLinkJavaCachingTests.assertNull((Object)entity.getCaching().getExpiry());
        cacheAnnotation.setExpiry(Integer.valueOf(57));
        EclipseLinkJavaCachingTests.assertEquals((Object)57, (Object)entity.getCaching().getExpiry());
        typeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.Cache");
        EclipseLinkJavaCachingTests.assertNull((Object)entity.getCaching().getExpiry());
    }

    public void testSetExpiry() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.javaPersistentType().getMapping();
        JavaCaching caching = entity.getCaching();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        caching.setExpiry(Integer.valueOf(58));
        CacheAnnotation cacheAnnotation = (CacheAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Cache");
        EclipseLinkJavaCachingTests.assertEquals((Object)58, (Object)cacheAnnotation.getExpiry());
        caching.setExpiry(null);
        cacheAnnotation = (CacheAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Cache");
        EclipseLinkJavaCachingTests.assertNull((Object)cacheAnnotation);
    }

    public void testSetExpiryUnsetsExpiryTimeOfDay() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.javaPersistentType().getMapping();
        JavaCaching caching = entity.getCaching();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        caching.addExpiryTimeOfDay();
        caching.getExpiryTimeOfDay().setHour(Integer.valueOf(5));
        CacheAnnotation cacheAnnotation = (CacheAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Cache");
        EclipseLinkJavaCachingTests.assertEquals((Object)5, (Object)cacheAnnotation.getExpiryTimeOfDay().getHour());
        caching.setExpiry(Integer.valueOf(900));
        EclipseLinkJavaCachingTests.assertNull((Object)caching.getExpiryTimeOfDay());
        EclipseLinkJavaCachingTests.assertNull((Object)cacheAnnotation.getExpiryTimeOfDay());
        EclipseLinkJavaCachingTests.assertEquals((Object)900, (Object)cacheAnnotation.getExpiry());
        EclipseLinkJavaCachingTests.assertEquals((Object)900, (Object)caching.getExpiry());
    }

    public void testGetTimeOfDayExpiry() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.javaPersistentType().getMapping();
        JavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertNull((Object)caching.getExpiryTimeOfDay());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        CacheAnnotation cacheAnnotation = (CacheAnnotation)typeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.Cache");
        cacheAnnotation.addExpiryTimeOfDay();
        EclipseLinkJavaCachingTests.assertNotNull((Object)caching.getExpiryTimeOfDay());
    }

    public void testAddTimeOfDayExpiry() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.javaPersistentType().getMapping();
        JavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertNull((Object)caching.getExpiryTimeOfDay());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        ExpiryTimeOfDay timeOfDayExpiry = caching.addExpiryTimeOfDay();
        CacheAnnotation cacheAnnotation = (CacheAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Cache");
        EclipseLinkJavaCachingTests.assertNotNull((Object)cacheAnnotation.getExpiryTimeOfDay());
        EclipseLinkJavaCachingTests.assertNotNull((Object)caching.getExpiryTimeOfDay());
        EclipseLinkJavaCachingTests.assertEquals((Object)timeOfDayExpiry, (Object)caching.getExpiryTimeOfDay());
    }

    public void testRemoveTimeOfDayExpiry() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.javaPersistentType().getMapping();
        JavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertNull((Object)caching.getExpiryTimeOfDay());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        CacheAnnotation cacheAnnotation = (CacheAnnotation)typeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.Cache");
        cacheAnnotation.addExpiryTimeOfDay();
        EclipseLinkJavaCachingTests.assertNotNull((Object)caching.getExpiryTimeOfDay());
        caching.removeExpiryTimeOfDay();
        EclipseLinkJavaCachingTests.assertNull((Object)caching.getExpiryTimeOfDay());
        EclipseLinkJavaCachingTests.assertNull((Object)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Cache"));
    }

    public void testAddTimeOfDayExpiryUnsetsExpiry() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.javaPersistentType().getMapping();
        JavaCaching caching = entity.getCaching();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        caching.setExpiry(Integer.valueOf(800));
        CacheAnnotation cacheAnnotation = (CacheAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Cache");
        EclipseLinkJavaCachingTests.assertEquals((Object)800, (Object)cacheAnnotation.getExpiry());
        caching.addExpiryTimeOfDay();
        EclipseLinkJavaCachingTests.assertNull((Object)caching.getExpiry());
        EclipseLinkJavaCachingTests.assertNull((Object)cacheAnnotation.getExpiry());
        EclipseLinkJavaCachingTests.assertNotNull((Object)cacheAnnotation.getExpiryTimeOfDay());
    }

    public void testSetSpecifiedSize() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.javaPersistentType().getMapping();
        JavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((int)100, (int)caching.getSize());
        caching.setSpecifiedSize(new Integer(50));
        EclipseLinkJavaCachingTests.assertEquals((Object)new Integer(50), (Object)entity.getCaching().getSpecifiedSize());
        EclipseLinkJavaCachingTests.assertEquals((int)50, (int)entity.getCaching().getSize());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        CacheAnnotation cacheAnnotation = (CacheAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Cache");
        EclipseLinkJavaCachingTests.assertEquals((Object)new Integer(50), (Object)cacheAnnotation.getSize());
    }

    public void testGetSpecifiedSize() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.javaPersistentType().getMapping();
        JavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((int)100, (int)caching.getSize());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        CacheAnnotation cacheAnnotation = (CacheAnnotation)typeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.Cache");
        cacheAnnotation.setSize(new Integer(50));
        EclipseLinkJavaCachingTests.assertEquals((Object)new Integer(50), (Object)cacheAnnotation.getSize());
        EclipseLinkJavaCachingTests.assertEquals((Object)new Integer(50), (Object)entity.getCaching().getSpecifiedSize());
        EclipseLinkJavaCachingTests.assertEquals((int)50, (int)entity.getCaching().getSize());
    }
}

