/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jpt.eclipselink.core.context.CustomConverter;
import org.eclipse.jpt.eclipselink.core.context.ObjectTypeConverter;
import org.eclipse.jpt.eclipselink.core.context.StructConverter;
import org.eclipse.jpt.eclipselink.core.context.TypeConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.ConverterHolder;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.EclipseLinkEntityMappings;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.eclipselink.core.resource.orm.EclipseLinkOrmFactory;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlConverter;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlConverterImpl;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlEntityMappings;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlObjectTypeConverter;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlObjectTypeConverterImpl;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlStructConverter;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlStructConverterImpl;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlTypeConverter;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlTypeConverterImpl;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.orm.EclipseLinkOrmContextModelTestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;

public class EclipseLinkEntityMappingsTests
extends EclipseLinkOrmContextModelTestCase {
    public EclipseLinkEntityMappingsTests(String name) {
        super(name);
    }

    public void testUpdateCustomConverters() throws Exception {
        XmlEntityMappings resourceEntityMappings = this.ormResource().getEntityMappings();
        EclipseLinkPersistenceUnit persistenceUnit = this.persistenceUnit();
        EclipseLinkEntityMappings contextEntityMappings = this.entityMappings();
        ConverterHolder ormContextConverterHolder = contextEntityMappings.getConverterHolder();
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)ormContextConverterHolder.customConvertersSize());
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)resourceEntityMappings.getConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        XmlConverterImpl resourceConverter = EclipseLinkOrmFactory.eINSTANCE.createXmlConverterImpl();
        resourceEntityMappings.getConverters().add((Object)resourceConverter);
        resourceConverter.setClassName("Foo");
        resourceConverter.setName("myConverter");
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)ormContextConverterHolder.customConvertersSize());
        ListIterator ormContextConverters = ormContextConverterHolder.customConverters();
        CustomConverter ormContextConverter = (CustomConverter)ormContextConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo", (String)ormContextConverter.getConverterClass());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myConverter", (String)ormContextConverter.getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)resourceEntityMappings.getConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        XmlConverterImpl resourceConverter2 = EclipseLinkOrmFactory.eINSTANCE.createXmlConverterImpl();
        resourceEntityMappings.getConverters().add(0, (Object)resourceConverter2);
        resourceConverter2.setClassName("Foo2");
        resourceConverter2.setName("myConverter2");
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)ormContextConverterHolder.customConvertersSize());
        ormContextConverters = ormContextConverterHolder.customConverters();
        ormContextConverter = (CustomConverter)ormContextConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo2", (String)ormContextConverter.getConverterClass());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myConverter2", (String)ormContextConverter.getName());
        ormContextConverter = (CustomConverter)ormContextConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo", (String)ormContextConverter.getConverterClass());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myConverter", (String)ormContextConverter.getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)resourceEntityMappings.getConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        resourceEntityMappings.getConverters().move(0, 1);
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)ormContextConverterHolder.customConvertersSize());
        ormContextConverters = ormContextConverterHolder.customConverters();
        ormContextConverter = (CustomConverter)ormContextConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo", (String)ormContextConverter.getConverterClass());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myConverter", (String)ormContextConverter.getName());
        ormContextConverter = (CustomConverter)ormContextConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo2", (String)ormContextConverter.getConverterClass());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myConverter2", (String)ormContextConverter.getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)resourceEntityMappings.getConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        resourceEntityMappings.getConverters().remove(0);
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)ormContextConverterHolder.customConvertersSize());
        ormContextConverters = ormContextConverterHolder.customConverters();
        ormContextConverter = (CustomConverter)ormContextConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo2", (String)ormContextConverter.getConverterClass());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myConverter2", (String)ormContextConverter.getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)resourceEntityMappings.getConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        resourceEntityMappings.getConverters().remove((Object)resourceConverter2);
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)ormContextConverterHolder.customConvertersSize());
        EclipseLinkEntityMappingsTests.assertFalse((boolean)ormContextConverterHolder.customConverters().hasNext());
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)resourceEntityMappings.getConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
    }

    public void testModifyCustomConverters() throws Exception {
        XmlEntityMappings resourceEntityMappings = this.ormResource().getEntityMappings();
        EclipseLinkPersistenceUnit persistenceUnit = this.persistenceUnit();
        EclipseLinkEntityMappings contextEntityMappings = this.entityMappings();
        ConverterHolder ormContextConverterHolder = contextEntityMappings.getConverterHolder();
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)ormContextConverterHolder.customConvertersSize());
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)resourceEntityMappings.getConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        CustomConverter contextConverter = ormContextConverterHolder.addCustomConverter(0);
        contextConverter.setConverterClass("Foo");
        contextConverter.setName("myConverter");
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)resourceEntityMappings.getConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo", (String)((XmlConverter)resourceEntityMappings.getConverters().get(0)).getClassName());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myConverter", (String)((XmlConverter)resourceEntityMappings.getConverters().get(0)).getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)ormContextConverterHolder.customConvertersSize());
        ListIterator ormContextConverters = ormContextConverterHolder.customConverters();
        CustomConverter ormContextConverter = (CustomConverter)ormContextConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo", (String)ormContextConverter.getConverterClass());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myConverter", (String)ormContextConverter.getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        CustomConverter contextConverter2 = ormContextConverterHolder.addCustomConverter(0);
        contextConverter2.setConverterClass("Foo2");
        contextConverter2.setName("myConverter2");
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)resourceEntityMappings.getConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo2", (String)((XmlConverter)resourceEntityMappings.getConverters().get(0)).getClassName());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myConverter2", (String)((XmlConverter)resourceEntityMappings.getConverters().get(0)).getName());
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo", (String)((XmlConverter)resourceEntityMappings.getConverters().get(1)).getClassName());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myConverter", (String)((XmlConverter)resourceEntityMappings.getConverters().get(1)).getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)ormContextConverterHolder.customConvertersSize());
        ormContextConverters = ormContextConverterHolder.customConverters();
        ormContextConverter = (CustomConverter)ormContextConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo2", (String)ormContextConverter.getConverterClass());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myConverter2", (String)ormContextConverter.getName());
        ormContextConverter = (CustomConverter)ormContextConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo", (String)ormContextConverter.getConverterClass());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myConverter", (String)ormContextConverter.getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        ormContextConverterHolder.moveCustomConverter(0, 1);
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)resourceEntityMappings.getConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo", (String)((XmlConverter)resourceEntityMappings.getConverters().get(0)).getClassName());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myConverter", (String)((XmlConverter)resourceEntityMappings.getConverters().get(0)).getName());
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo2", (String)((XmlConverter)resourceEntityMappings.getConverters().get(1)).getClassName());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myConverter2", (String)((XmlConverter)resourceEntityMappings.getConverters().get(1)).getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)ormContextConverterHolder.customConvertersSize());
        ormContextConverters = ormContextConverterHolder.customConverters();
        ormContextConverter = (CustomConverter)ormContextConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo", (String)ormContextConverter.getConverterClass());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myConverter", (String)ormContextConverter.getName());
        ormContextConverter = (CustomConverter)ormContextConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo2", (String)ormContextConverter.getConverterClass());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myConverter2", (String)ormContextConverter.getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        ormContextConverterHolder.removeCustomConverter(0);
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)resourceEntityMappings.getConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo2", (String)((XmlConverter)resourceEntityMappings.getConverters().get(0)).getClassName());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myConverter2", (String)((XmlConverter)resourceEntityMappings.getConverters().get(0)).getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)ormContextConverterHolder.customConvertersSize());
        ormContextConverters = ormContextConverterHolder.customConverters();
        ormContextConverter = (CustomConverter)ormContextConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo2", (String)ormContextConverter.getConverterClass());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myConverter2", (String)ormContextConverter.getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        ormContextConverterHolder.removeCustomConverter(contextConverter2);
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)ormContextConverterHolder.customConvertersSize());
        EclipseLinkEntityMappingsTests.assertFalse((boolean)ormContextConverterHolder.customConverters().hasNext());
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)resourceEntityMappings.getConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
    }

    public void testUpdateTypeConverters() throws Exception {
        XmlEntityMappings resourceEntityMappings = this.ormResource().getEntityMappings();
        EclipseLinkPersistenceUnit persistenceUnit = this.persistenceUnit();
        EclipseLinkEntityMappings contextEntityMappings = this.entityMappings();
        ConverterHolder ormContextConverterHolder = contextEntityMappings.getConverterHolder();
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)ormContextConverterHolder.typeConvertersSize());
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)resourceEntityMappings.getTypeConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        XmlTypeConverterImpl resourceTypeConverter = EclipseLinkOrmFactory.eINSTANCE.createXmlTypeConverterImpl();
        resourceEntityMappings.getTypeConverters().add((Object)resourceTypeConverter);
        resourceTypeConverter.setDataType("Foo");
        resourceTypeConverter.setName("myTypeConverter");
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)ormContextConverterHolder.typeConvertersSize());
        ListIterator ormContextTypeConverters = ormContextConverterHolder.typeConverters();
        TypeConverter ormContextTypeConverter = (TypeConverter)ormContextTypeConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo", (String)ormContextTypeConverter.getDataType());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myTypeConverter", (String)ormContextTypeConverter.getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)resourceEntityMappings.getTypeConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        XmlTypeConverterImpl resourceTypeConverter2 = EclipseLinkOrmFactory.eINSTANCE.createXmlTypeConverterImpl();
        resourceEntityMappings.getTypeConverters().add(0, (Object)resourceTypeConverter2);
        resourceTypeConverter2.setDataType("Foo2");
        resourceTypeConverter2.setName("myTypeConverter2");
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)ormContextConverterHolder.typeConvertersSize());
        ormContextTypeConverters = ormContextConverterHolder.typeConverters();
        ormContextTypeConverter = (TypeConverter)ormContextTypeConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo2", (String)ormContextTypeConverter.getDataType());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myTypeConverter2", (String)ormContextTypeConverter.getName());
        ormContextTypeConverter = (TypeConverter)ormContextTypeConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo", (String)ormContextTypeConverter.getDataType());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myTypeConverter", (String)ormContextTypeConverter.getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)resourceEntityMappings.getTypeConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        resourceEntityMappings.getTypeConverters().move(0, 1);
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)ormContextConverterHolder.typeConvertersSize());
        ormContextTypeConverters = ormContextConverterHolder.typeConverters();
        ormContextTypeConverter = (TypeConverter)ormContextTypeConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo", (String)ormContextTypeConverter.getDataType());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myTypeConverter", (String)ormContextTypeConverter.getName());
        ormContextTypeConverter = (TypeConverter)ormContextTypeConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo2", (String)ormContextTypeConverter.getDataType());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myTypeConverter2", (String)ormContextTypeConverter.getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)resourceEntityMappings.getTypeConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        resourceEntityMappings.getTypeConverters().remove(0);
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)ormContextConverterHolder.typeConvertersSize());
        ormContextTypeConverters = ormContextConverterHolder.typeConverters();
        ormContextTypeConverter = (TypeConverter)ormContextTypeConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo2", (String)ormContextTypeConverter.getDataType());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myTypeConverter2", (String)ormContextTypeConverter.getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)resourceEntityMappings.getTypeConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        resourceEntityMappings.getTypeConverters().remove((Object)resourceTypeConverter2);
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)ormContextConverterHolder.typeConvertersSize());
        EclipseLinkEntityMappingsTests.assertFalse((boolean)ormContextConverterHolder.typeConverters().hasNext());
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)resourceEntityMappings.getTypeConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
    }

    public void testModifyTypeConverters() throws Exception {
        XmlEntityMappings resourceEntityMappings = this.ormResource().getEntityMappings();
        EclipseLinkPersistenceUnit persistenceUnit = this.persistenceUnit();
        EclipseLinkEntityMappings contextEntityMappings = this.entityMappings();
        ConverterHolder ormContextConverterHolder = contextEntityMappings.getConverterHolder();
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)ormContextConverterHolder.typeConvertersSize());
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)resourceEntityMappings.getTypeConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        TypeConverter contextTypeConverter = ormContextConverterHolder.addTypeConverter(0);
        contextTypeConverter.setDataType("Foo");
        contextTypeConverter.setName("myTypeConverter");
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)resourceEntityMappings.getTypeConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo", (String)((XmlTypeConverter)resourceEntityMappings.getTypeConverters().get(0)).getDataType());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myTypeConverter", (String)((XmlTypeConverter)resourceEntityMappings.getTypeConverters().get(0)).getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)ormContextConverterHolder.typeConvertersSize());
        ListIterator ormContextTypeConverters = ormContextConverterHolder.typeConverters();
        TypeConverter ormContextTypeConverter = (TypeConverter)ormContextTypeConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo", (String)ormContextTypeConverter.getDataType());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myTypeConverter", (String)ormContextTypeConverter.getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        TypeConverter contextTypeConverter2 = ormContextConverterHolder.addTypeConverter(0);
        contextTypeConverter2.setDataType("Foo2");
        contextTypeConverter2.setName("myTypeConverter2");
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)resourceEntityMappings.getTypeConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo2", (String)((XmlTypeConverter)resourceEntityMappings.getTypeConverters().get(0)).getDataType());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myTypeConverter2", (String)((XmlTypeConverter)resourceEntityMappings.getTypeConverters().get(0)).getName());
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo", (String)((XmlTypeConverter)resourceEntityMappings.getTypeConverters().get(1)).getDataType());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myTypeConverter", (String)((XmlTypeConverter)resourceEntityMappings.getTypeConverters().get(1)).getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)ormContextConverterHolder.typeConvertersSize());
        ormContextTypeConverters = ormContextConverterHolder.typeConverters();
        ormContextTypeConverter = (TypeConverter)ormContextTypeConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo2", (String)ormContextTypeConverter.getDataType());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myTypeConverter2", (String)ormContextTypeConverter.getName());
        ormContextTypeConverter = (TypeConverter)ormContextTypeConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo", (String)ormContextTypeConverter.getDataType());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myTypeConverter", (String)ormContextTypeConverter.getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        ormContextConverterHolder.moveTypeConverter(0, 1);
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)resourceEntityMappings.getTypeConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo", (String)((XmlTypeConverter)resourceEntityMappings.getTypeConverters().get(0)).getDataType());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myTypeConverter", (String)((XmlTypeConverter)resourceEntityMappings.getTypeConverters().get(0)).getName());
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo2", (String)((XmlTypeConverter)resourceEntityMappings.getTypeConverters().get(1)).getDataType());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myTypeConverter2", (String)((XmlTypeConverter)resourceEntityMappings.getTypeConverters().get(1)).getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)ormContextConverterHolder.typeConvertersSize());
        ormContextTypeConverters = ormContextConverterHolder.typeConverters();
        ormContextTypeConverter = (TypeConverter)ormContextTypeConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo", (String)ormContextTypeConverter.getDataType());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myTypeConverter", (String)ormContextTypeConverter.getName());
        ormContextTypeConverter = (TypeConverter)ormContextTypeConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo2", (String)ormContextTypeConverter.getDataType());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myTypeConverter2", (String)ormContextTypeConverter.getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        ormContextConverterHolder.removeTypeConverter(0);
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)resourceEntityMappings.getTypeConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo2", (String)((XmlTypeConverter)resourceEntityMappings.getTypeConverters().get(0)).getDataType());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myTypeConverter2", (String)((XmlTypeConverter)resourceEntityMappings.getTypeConverters().get(0)).getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)ormContextConverterHolder.typeConvertersSize());
        ormContextTypeConverters = ormContextConverterHolder.typeConverters();
        ormContextTypeConverter = (TypeConverter)ormContextTypeConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo2", (String)ormContextTypeConverter.getDataType());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myTypeConverter2", (String)ormContextTypeConverter.getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        ormContextConverterHolder.removeTypeConverter(contextTypeConverter2);
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)ormContextConverterHolder.typeConvertersSize());
        EclipseLinkEntityMappingsTests.assertFalse((boolean)ormContextConverterHolder.typeConverters().hasNext());
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)resourceEntityMappings.getTypeConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
    }

    public void testUpdateObjectTypeConverters() throws Exception {
        XmlEntityMappings resourceEntityMappings = this.ormResource().getEntityMappings();
        EclipseLinkPersistenceUnit persistenceUnit = this.persistenceUnit();
        EclipseLinkEntityMappings contextEntityMappings = this.entityMappings();
        ConverterHolder ormContextConverterHolder = contextEntityMappings.getConverterHolder();
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)ormContextConverterHolder.objectTypeConvertersSize());
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)resourceEntityMappings.getObjectTypeConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        XmlObjectTypeConverterImpl resourceObjectTypeConverter = EclipseLinkOrmFactory.eINSTANCE.createXmlObjectTypeConverterImpl();
        resourceEntityMappings.getObjectTypeConverters().add((Object)resourceObjectTypeConverter);
        resourceObjectTypeConverter.setDataType("Foo");
        resourceObjectTypeConverter.setName("myObjectTypeConverter");
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)ormContextConverterHolder.objectTypeConvertersSize());
        ListIterator ormContextObjectTypeConverters = ormContextConverterHolder.objectTypeConverters();
        ObjectTypeConverter ormContextObjectTypeConverter = (ObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myObjectTypeConverter", (String)ormContextObjectTypeConverter.getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)resourceEntityMappings.getObjectTypeConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        XmlObjectTypeConverterImpl resourceObjectTypeConverter2 = EclipseLinkOrmFactory.eINSTANCE.createXmlObjectTypeConverterImpl();
        resourceEntityMappings.getObjectTypeConverters().add(0, (Object)resourceObjectTypeConverter2);
        resourceObjectTypeConverter2.setDataType("Foo2");
        resourceObjectTypeConverter2.setName("myObjectTypeConverter2");
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)ormContextConverterHolder.objectTypeConvertersSize());
        ormContextObjectTypeConverters = ormContextConverterHolder.objectTypeConverters();
        ormContextObjectTypeConverter = (ObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo2", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myObjectTypeConverter2", (String)ormContextObjectTypeConverter.getName());
        ormContextObjectTypeConverter = (ObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myObjectTypeConverter", (String)ormContextObjectTypeConverter.getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)resourceEntityMappings.getObjectTypeConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        resourceEntityMappings.getObjectTypeConverters().move(0, 1);
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)ormContextConverterHolder.objectTypeConvertersSize());
        ormContextObjectTypeConverters = ormContextConverterHolder.objectTypeConverters();
        ormContextObjectTypeConverter = (ObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myObjectTypeConverter", (String)ormContextObjectTypeConverter.getName());
        ormContextObjectTypeConverter = (ObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo2", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myObjectTypeConverter2", (String)ormContextObjectTypeConverter.getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)resourceEntityMappings.getObjectTypeConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        resourceEntityMappings.getObjectTypeConverters().remove(0);
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)ormContextConverterHolder.objectTypeConvertersSize());
        ormContextObjectTypeConverters = ormContextConverterHolder.objectTypeConverters();
        ormContextObjectTypeConverter = (ObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo2", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myObjectTypeConverter2", (String)ormContextObjectTypeConverter.getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)resourceEntityMappings.getObjectTypeConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        resourceEntityMappings.getObjectTypeConverters().remove((Object)resourceObjectTypeConverter2);
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)ormContextConverterHolder.objectTypeConvertersSize());
        EclipseLinkEntityMappingsTests.assertFalse((boolean)ormContextConverterHolder.objectTypeConverters().hasNext());
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)resourceEntityMappings.getObjectTypeConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
    }

    public void testModifyObjectTypeConverters() throws Exception {
        XmlEntityMappings resourceEntityMappings = this.ormResource().getEntityMappings();
        EclipseLinkPersistenceUnit persistenceUnit = this.persistenceUnit();
        EclipseLinkEntityMappings contextEntityMappings = this.entityMappings();
        ConverterHolder ormContextConverterHolder = contextEntityMappings.getConverterHolder();
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)ormContextConverterHolder.objectTypeConvertersSize());
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)resourceEntityMappings.getObjectTypeConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        ObjectTypeConverter contextObjectTypeConverter = ormContextConverterHolder.addObjectTypeConverter(0);
        contextObjectTypeConverter.setDataType("Foo");
        contextObjectTypeConverter.setName("myObjectTypeConverter");
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)resourceEntityMappings.getObjectTypeConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo", (String)((XmlObjectTypeConverter)resourceEntityMappings.getObjectTypeConverters().get(0)).getDataType());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myObjectTypeConverter", (String)((XmlObjectTypeConverter)resourceEntityMappings.getObjectTypeConverters().get(0)).getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)ormContextConverterHolder.objectTypeConvertersSize());
        ListIterator ormContextObjectTypeConverters = ormContextConverterHolder.objectTypeConverters();
        ObjectTypeConverter ormContextObjectTypeConverter = (ObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myObjectTypeConverter", (String)ormContextObjectTypeConverter.getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        ObjectTypeConverter contextObjectTypeConverter2 = ormContextConverterHolder.addObjectTypeConverter(0);
        contextObjectTypeConverter2.setDataType("Foo2");
        contextObjectTypeConverter2.setName("myObjectTypeConverter2");
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)resourceEntityMappings.getObjectTypeConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo2", (String)((XmlObjectTypeConverter)resourceEntityMappings.getObjectTypeConverters().get(0)).getDataType());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myObjectTypeConverter2", (String)((XmlObjectTypeConverter)resourceEntityMappings.getObjectTypeConverters().get(0)).getName());
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo", (String)((XmlObjectTypeConverter)resourceEntityMappings.getObjectTypeConverters().get(1)).getDataType());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myObjectTypeConverter", (String)((XmlObjectTypeConverter)resourceEntityMappings.getObjectTypeConverters().get(1)).getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)ormContextConverterHolder.objectTypeConvertersSize());
        ormContextObjectTypeConverters = ormContextConverterHolder.objectTypeConverters();
        ormContextObjectTypeConverter = (ObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo2", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myObjectTypeConverter2", (String)ormContextObjectTypeConverter.getName());
        ormContextObjectTypeConverter = (ObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myObjectTypeConverter", (String)ormContextObjectTypeConverter.getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        ormContextConverterHolder.moveObjectTypeConverter(0, 1);
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)resourceEntityMappings.getObjectTypeConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo", (String)((XmlObjectTypeConverter)resourceEntityMappings.getObjectTypeConverters().get(0)).getDataType());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myObjectTypeConverter", (String)((XmlObjectTypeConverter)resourceEntityMappings.getObjectTypeConverters().get(0)).getName());
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo2", (String)((XmlObjectTypeConverter)resourceEntityMappings.getObjectTypeConverters().get(1)).getDataType());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myObjectTypeConverter2", (String)((XmlObjectTypeConverter)resourceEntityMappings.getObjectTypeConverters().get(1)).getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)ormContextConverterHolder.objectTypeConvertersSize());
        ormContextObjectTypeConverters = ormContextConverterHolder.objectTypeConverters();
        ormContextObjectTypeConverter = (ObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myObjectTypeConverter", (String)ormContextObjectTypeConverter.getName());
        ormContextObjectTypeConverter = (ObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo2", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myObjectTypeConverter2", (String)ormContextObjectTypeConverter.getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        ormContextConverterHolder.removeObjectTypeConverter(0);
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)resourceEntityMappings.getObjectTypeConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo2", (String)((XmlObjectTypeConverter)resourceEntityMappings.getObjectTypeConverters().get(0)).getDataType());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myObjectTypeConverter2", (String)((XmlObjectTypeConverter)resourceEntityMappings.getObjectTypeConverters().get(0)).getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)ormContextConverterHolder.objectTypeConvertersSize());
        ormContextObjectTypeConverters = ormContextConverterHolder.objectTypeConverters();
        ormContextObjectTypeConverter = (ObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo2", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myObjectTypeConverter2", (String)ormContextObjectTypeConverter.getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        ormContextConverterHolder.removeObjectTypeConverter(contextObjectTypeConverter2);
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)ormContextConverterHolder.objectTypeConvertersSize());
        EclipseLinkEntityMappingsTests.assertFalse((boolean)ormContextConverterHolder.objectTypeConverters().hasNext());
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)resourceEntityMappings.getObjectTypeConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
    }

    public void testUpdateStructConverters() throws Exception {
        XmlEntityMappings resourceEntityMappings = this.ormResource().getEntityMappings();
        EclipseLinkPersistenceUnit persistenceUnit = this.persistenceUnit();
        EclipseLinkEntityMappings contextEntityMappings = this.entityMappings();
        ConverterHolder ormContextConverterHolder = contextEntityMappings.getConverterHolder();
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)ormContextConverterHolder.structConvertersSize());
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)resourceEntityMappings.getStructConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        XmlStructConverterImpl resourceStructConverter = EclipseLinkOrmFactory.eINSTANCE.createXmlStructConverterImpl();
        resourceEntityMappings.getStructConverters().add((Object)resourceStructConverter);
        resourceStructConverter.setConverter("Foo");
        resourceStructConverter.setName("myStructConverter");
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)ormContextConverterHolder.structConvertersSize());
        ListIterator ormContextStructConverters = ormContextConverterHolder.structConverters();
        StructConverter ormContextStructConverter = (StructConverter)ormContextStructConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myStructConverter", (String)ormContextStructConverter.getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)resourceEntityMappings.getStructConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        XmlStructConverterImpl resourceStructConverter2 = EclipseLinkOrmFactory.eINSTANCE.createXmlStructConverterImpl();
        resourceEntityMappings.getStructConverters().add(0, (Object)resourceStructConverter2);
        resourceStructConverter2.setConverter("Foo2");
        resourceStructConverter2.setName("myStructConverter2");
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)ormContextConverterHolder.structConvertersSize());
        ormContextStructConverters = ormContextConverterHolder.structConverters();
        ormContextStructConverter = (StructConverter)ormContextStructConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo2", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myStructConverter2", (String)ormContextStructConverter.getName());
        ormContextStructConverter = (StructConverter)ormContextStructConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myStructConverter", (String)ormContextStructConverter.getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)resourceEntityMappings.getStructConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        resourceEntityMappings.getStructConverters().move(0, 1);
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)ormContextConverterHolder.structConvertersSize());
        ormContextStructConverters = ormContextConverterHolder.structConverters();
        ormContextStructConverter = (StructConverter)ormContextStructConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myStructConverter", (String)ormContextStructConverter.getName());
        ormContextStructConverter = (StructConverter)ormContextStructConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo2", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myStructConverter2", (String)ormContextStructConverter.getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)resourceEntityMappings.getStructConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        resourceEntityMappings.getStructConverters().remove(0);
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)ormContextConverterHolder.structConvertersSize());
        ormContextStructConverters = ormContextConverterHolder.structConverters();
        ormContextStructConverter = (StructConverter)ormContextStructConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo2", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myStructConverter2", (String)ormContextStructConverter.getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)resourceEntityMappings.getStructConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        resourceEntityMappings.getStructConverters().remove((Object)resourceStructConverter2);
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)ormContextConverterHolder.structConvertersSize());
        EclipseLinkEntityMappingsTests.assertFalse((boolean)ormContextConverterHolder.structConverters().hasNext());
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)resourceEntityMappings.getStructConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
    }

    public void testModifyStructConverters() throws Exception {
        XmlEntityMappings resourceEntityMappings = this.ormResource().getEntityMappings();
        EclipseLinkPersistenceUnit persistenceUnit = this.persistenceUnit();
        EclipseLinkEntityMappings contextEntityMappings = this.entityMappings();
        ConverterHolder ormContextConverterHolder = contextEntityMappings.getConverterHolder();
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)ormContextConverterHolder.structConvertersSize());
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)resourceEntityMappings.getStructConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        StructConverter contextStructConverter = ormContextConverterHolder.addStructConverter(0);
        contextStructConverter.setConverterClass("Foo");
        contextStructConverter.setName("myStructConverter");
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)resourceEntityMappings.getStructConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo", (String)((XmlStructConverter)resourceEntityMappings.getStructConverters().get(0)).getConverter());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myStructConverter", (String)((XmlStructConverter)resourceEntityMappings.getStructConverters().get(0)).getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)ormContextConverterHolder.structConvertersSize());
        ListIterator ormContextStructConverters = ormContextConverterHolder.structConverters();
        StructConverter ormContextStructConverter = (StructConverter)ormContextStructConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myStructConverter", (String)ormContextStructConverter.getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        StructConverter contextStructConverter2 = ormContextConverterHolder.addStructConverter(0);
        contextStructConverter2.setConverterClass("Foo2");
        contextStructConverter2.setName("myStructConverter2");
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)resourceEntityMappings.getStructConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo2", (String)((XmlStructConverter)resourceEntityMappings.getStructConverters().get(0)).getConverter());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myStructConverter2", (String)((XmlStructConverter)resourceEntityMappings.getStructConverters().get(0)).getName());
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo", (String)((XmlStructConverter)resourceEntityMappings.getStructConverters().get(1)).getConverter());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myStructConverter", (String)((XmlStructConverter)resourceEntityMappings.getStructConverters().get(1)).getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)ormContextConverterHolder.structConvertersSize());
        ormContextStructConverters = ormContextConverterHolder.structConverters();
        ormContextStructConverter = (StructConverter)ormContextStructConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo2", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myStructConverter2", (String)ormContextStructConverter.getName());
        ormContextStructConverter = (StructConverter)ormContextStructConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myStructConverter", (String)ormContextStructConverter.getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        ormContextConverterHolder.moveStructConverter(0, 1);
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)resourceEntityMappings.getStructConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo", (String)((XmlStructConverter)resourceEntityMappings.getStructConverters().get(0)).getConverter());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myStructConverter", (String)((XmlStructConverter)resourceEntityMappings.getStructConverters().get(0)).getName());
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo2", (String)((XmlStructConverter)resourceEntityMappings.getStructConverters().get(1)).getConverter());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myStructConverter2", (String)((XmlStructConverter)resourceEntityMappings.getStructConverters().get(1)).getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)ormContextConverterHolder.structConvertersSize());
        ormContextStructConverters = ormContextConverterHolder.structConverters();
        ormContextStructConverter = (StructConverter)ormContextStructConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myStructConverter", (String)ormContextStructConverter.getName());
        ormContextStructConverter = (StructConverter)ormContextStructConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo2", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myStructConverter2", (String)ormContextStructConverter.getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        ormContextConverterHolder.removeStructConverter(0);
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)resourceEntityMappings.getStructConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo2", (String)((XmlStructConverter)resourceEntityMappings.getStructConverters().get(0)).getConverter());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myStructConverter2", (String)((XmlStructConverter)resourceEntityMappings.getStructConverters().get(0)).getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)ormContextConverterHolder.structConvertersSize());
        ormContextStructConverters = ormContextConverterHolder.structConverters();
        ormContextStructConverter = (StructConverter)ormContextStructConverters.next();
        EclipseLinkEntityMappingsTests.assertEquals((String)"Foo2", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkEntityMappingsTests.assertEquals((String)"myStructConverter2", (String)ormContextStructConverter.getName());
        EclipseLinkEntityMappingsTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        ormContextConverterHolder.removeStructConverter(contextStructConverter2);
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)ormContextConverterHolder.structConvertersSize());
        EclipseLinkEntityMappingsTests.assertFalse((boolean)ormContextConverterHolder.structConverters().hasNext());
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)resourceEntityMappings.getStructConverters().size());
        EclipseLinkEntityMappingsTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
    }
}

