/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.java.JavaBasicMapping;
import org.eclipse.jpt.core.context.orm.OrmBasicMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.context.ConversionValue;
import org.eclipse.jpt.eclipselink.core.context.Convert;
import org.eclipse.jpt.eclipselink.core.context.ObjectTypeConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.java.EclipseLinkJavaConvert;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.EclipseLinkOrmObjectTypeConverter;
import org.eclipse.jpt.eclipselink.core.resource.orm.EclipseLinkOrmFactory;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlBasic;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlConversionValue;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlConversionValueImpl;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlObjectTypeConverter;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.orm.EclipseLinkOrmContextModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class EclipseLinkOrmObjectTypeConverterTests
extends EclipseLinkOrmContextModelTestCase {
    private void createConvertAnnotation() throws Exception {
        this.createAnnotationAndMembers("org.eclipse.persistence.annotations", "Convert", "String value() default \"none\";");
    }

    private void createObjectTypeConverterAnnotation() throws Exception {
        this.createConversionValueAnnotation();
        this.createAnnotationAndMembers("org.eclipse.persistence.annotations", "ObjectTypeConverter", "String name(); Class dataType() default void.class; Class objectType() default void.class; ConversionValue[] conversionValues();String defaultObjectValue() default \"\";");
    }

    private void createConversionValueAnnotation() throws Exception {
        this.createAnnotationAndMembers("org.eclipse.persistence.annotations", "ConversionValue", "String dataValue(); String objectValue();");
    }

    private ICompilationUnit createTestEntityWithBasicMapping() throws Exception {
        this.createConvertAnnotation();
        this.createObjectTypeConverterAnnotation();
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic", "org.eclipse.persistence.annotations.Convert", "org.eclipse.persistence.annotations.ObjectTypeConverter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic").append(CR);
                sb.append("    @Convert(name=\"foo\")").append(CR);
                sb.append("    @ObjectTypeConverter");
            }
        });
    }

    private ICompilationUnit createTestEntityWithConvertAndObjectTypeConverterConversionValue() throws Exception {
        this.createConvertAnnotation();
        this.createObjectTypeConverterAnnotation();
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.Convert", "org.eclipse.persistence.annotations.ObjectTypeConverter", "org.eclipse.persistence.annotations.ConversionValue"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Convert(\"foo\")").append(CR);
                sb.append("    @ObjectTypeConverter(name=\"foo\", defaultObjectValue=\"bar\", conversionValues = @ConversionValue(dataValue=\"f\", objectValue=\"female\"))");
            }
        });
    }

    public EclipseLinkOrmObjectTypeConverterTests(String name) {
        super(name);
    }

    public void testUpdateDataType() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "id");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormBasicMapping.setSpecifiedConverter("eclipseLinkConverter");
        ((Convert)ormBasicMapping.getConverter()).setConverter("objectTypeConverter");
        ObjectTypeConverter ormConverter = (ObjectTypeConverter)((Convert)ormBasicMapping.getConverter()).getConverter();
        XmlObjectTypeConverter converterResource = ((XmlBasic)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getObjectTypeConverter();
        JavaBasicMapping javaBasicMapping = (JavaBasicMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("id").getMapping();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)ormConverter.getDataType());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)converterResource.getDataType());
        converterResource.setDataType("myConvert");
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"myConvert", (String)ormConverter.getDataType());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"myConvert", (String)converterResource.getDataType());
        converterResource.setDataType(null);
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)ormConverter.getDataType());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)converterResource.getDataType());
        ormPersistentType.removeSpecifiedPersistentAttribute(ormPersistentAttribute);
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormConverter = (ObjectTypeConverter)((Convert)ormBasicMapping.getSpecifiedConverter()).getConverter();
        ObjectTypeConverter javaConverter = (ObjectTypeConverter)((Convert)javaBasicMapping.getSpecifiedConverter()).getConverter();
        javaConverter.setDataType("bar");
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar", (String)ormConverter.getDataType());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar", (String)javaConverter.getDataType());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (Object)ormBasicMapping.getSpecifiedConverter());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"noConverter", (String)ormBasicMapping.getConverter().getType());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar", (String)javaConverter.getDataType());
    }

    public void testModifyDataType() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormBasicMapping.setSpecifiedConverter("eclipseLinkConverter");
        ((Convert)ormBasicMapping.getConverter()).setConverter("objectTypeConverter");
        ObjectTypeConverter ormConverter = (ObjectTypeConverter)((Convert)ormBasicMapping.getConverter()).getConverter();
        XmlObjectTypeConverter converterResource = ((XmlBasic)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getObjectTypeConverter();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)ormConverter.getDataType());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)converterResource.getDataType());
        ormConverter.setDataType("foo");
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)ormConverter.getDataType());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)converterResource.getDataType());
        ormConverter.setDataType(null);
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)ormConverter.getDataType());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)converterResource.getDataType());
    }

    public void testUpdateObjectType() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "id");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormBasicMapping.setSpecifiedConverter("eclipseLinkConverter");
        ((Convert)ormBasicMapping.getConverter()).setConverter("objectTypeConverter");
        ObjectTypeConverter ormConverter = (ObjectTypeConverter)((Convert)ormBasicMapping.getConverter()).getConverter();
        XmlObjectTypeConverter converterResource = ((XmlBasic)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getObjectTypeConverter();
        JavaBasicMapping javaBasicMapping = (JavaBasicMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("id").getMapping();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)ormConverter.getObjectType());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)converterResource.getObjectType());
        converterResource.setObjectType("myConvert");
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"myConvert", (String)ormConverter.getObjectType());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"myConvert", (String)converterResource.getObjectType());
        converterResource.setObjectType(null);
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)ormConverter.getObjectType());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)converterResource.getObjectType());
        ormPersistentType.removeSpecifiedPersistentAttribute(ormPersistentAttribute);
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormConverter = (ObjectTypeConverter)((Convert)ormBasicMapping.getSpecifiedConverter()).getConverter();
        ObjectTypeConverter javaConverter = (ObjectTypeConverter)((Convert)javaBasicMapping.getSpecifiedConverter()).getConverter();
        javaConverter.setObjectType("bar");
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar", (String)ormConverter.getObjectType());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar", (String)javaConverter.getObjectType());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (Object)ormBasicMapping.getSpecifiedConverter());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"noConverter", (String)ormBasicMapping.getConverter().getType());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar", (String)javaConverter.getObjectType());
    }

    public void testModifyObjectType() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormBasicMapping.setSpecifiedConverter("eclipseLinkConverter");
        ((Convert)ormBasicMapping.getConverter()).setConverter("objectTypeConverter");
        ObjectTypeConverter ormConverter = (ObjectTypeConverter)((Convert)ormBasicMapping.getConverter()).getConverter();
        XmlObjectTypeConverter converterResource = ((XmlBasic)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getObjectTypeConverter();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)ormConverter.getObjectType());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)converterResource.getObjectType());
        ormConverter.setObjectType("foo");
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)ormConverter.getObjectType());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)converterResource.getObjectType());
        ormConverter.setObjectType(null);
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)ormConverter.getObjectType());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)converterResource.getObjectType());
    }

    public void testUpdateName() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "id");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormBasicMapping.setSpecifiedConverter("eclipseLinkConverter");
        ((Convert)ormBasicMapping.getConverter()).setConverter("objectTypeConverter");
        EclipseLinkOrmObjectTypeConverter ormConverter = (EclipseLinkOrmObjectTypeConverter)((Convert)ormBasicMapping.getConverter()).getConverter();
        XmlObjectTypeConverter converterResource = ((XmlBasic)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getObjectTypeConverter();
        JavaBasicMapping javaBasicMapping = (JavaBasicMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("id").getMapping();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)ormConverter.getName());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)converterResource.getName());
        converterResource.setName("myConvert");
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"myConvert", (String)ormConverter.getName());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"myConvert", (String)converterResource.getName());
        converterResource.setName(null);
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)ormConverter.getName());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)converterResource.getName());
        ormPersistentType.removeSpecifiedPersistentAttribute(ormPersistentAttribute);
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormConverter = (EclipseLinkOrmObjectTypeConverter)((Convert)ormBasicMapping.getSpecifiedConverter()).getConverter();
        ObjectTypeConverter javaConverter = (ObjectTypeConverter)((Convert)javaBasicMapping.getSpecifiedConverter()).getConverter();
        javaConverter.setName("bar");
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar", (String)ormConverter.getName());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar", (String)javaConverter.getName());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (Object)ormBasicMapping.getSpecifiedConverter());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"noConverter", (String)ormBasicMapping.getConverter().getType());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar", (String)javaConverter.getName());
    }

    public void testModifyName() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormBasicMapping.setSpecifiedConverter("eclipseLinkConverter");
        ((Convert)ormBasicMapping.getConverter()).setConverter("objectTypeConverter");
        EclipseLinkOrmObjectTypeConverter ormConverter = (EclipseLinkOrmObjectTypeConverter)((Convert)ormBasicMapping.getConverter()).getConverter();
        XmlObjectTypeConverter converterResource = ((XmlBasic)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getObjectTypeConverter();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)ormConverter.getName());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)converterResource.getName());
        ormConverter.setName("foo");
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)ormConverter.getName());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)converterResource.getName());
        ormConverter.setName(null);
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)ormConverter.getName());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)converterResource.getName());
    }

    public void testUpdateDefaultObjectValue() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "id");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormBasicMapping.setSpecifiedConverter("eclipseLinkConverter");
        ((Convert)ormBasicMapping.getConverter()).setConverter("objectTypeConverter");
        ObjectTypeConverter ormConverter = (ObjectTypeConverter)((Convert)ormBasicMapping.getConverter()).getConverter();
        XmlObjectTypeConverter converterResource = ((XmlBasic)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getObjectTypeConverter();
        JavaBasicMapping javaBasicMapping = (JavaBasicMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("id").getMapping();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)ormConverter.getDefaultObjectValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)converterResource.getDefaultObjectValue());
        converterResource.setDefaultObjectValue("myConvert");
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"myConvert", (String)ormConverter.getDefaultObjectValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"myConvert", (String)converterResource.getDefaultObjectValue());
        converterResource.setDefaultObjectValue(null);
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)ormConverter.getDefaultObjectValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)converterResource.getDefaultObjectValue());
        ormPersistentType.removeSpecifiedPersistentAttribute(ormPersistentAttribute);
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormConverter = (ObjectTypeConverter)((Convert)ormBasicMapping.getSpecifiedConverter()).getConverter();
        ObjectTypeConverter javaConverter = (ObjectTypeConverter)((Convert)javaBasicMapping.getSpecifiedConverter()).getConverter();
        javaConverter.setDefaultObjectValue("bar");
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar", (String)ormConverter.getDefaultObjectValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar", (String)javaConverter.getDefaultObjectValue());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (Object)ormBasicMapping.getSpecifiedConverter());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"noConverter", (String)ormBasicMapping.getConverter().getType());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar", (String)javaConverter.getDefaultObjectValue());
    }

    public void testModifyDefaultObjectValue() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormBasicMapping.setSpecifiedConverter("eclipseLinkConverter");
        ((Convert)ormBasicMapping.getConverter()).setConverter("objectTypeConverter");
        ObjectTypeConverter ormConverter = (ObjectTypeConverter)((Convert)ormBasicMapping.getConverter()).getConverter();
        XmlObjectTypeConverter converterResource = ((XmlBasic)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getObjectTypeConverter();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)ormConverter.getDefaultObjectValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)converterResource.getDefaultObjectValue());
        ormConverter.setDefaultObjectValue("foo");
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)ormConverter.getDefaultObjectValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)converterResource.getDefaultObjectValue());
        ormConverter.setDefaultObjectValue(null);
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)ormConverter.getDefaultObjectValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)converterResource.getDefaultObjectValue());
    }

    public void testUpdateConversionValues() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "id");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormBasicMapping.setSpecifiedConverter("eclipseLinkConverter");
        ((Convert)ormBasicMapping.getConverter()).setConverter("objectTypeConverter");
        ObjectTypeConverter ormConverter = (ObjectTypeConverter)((Convert)ormBasicMapping.getConverter()).getConverter();
        XmlObjectTypeConverter converterResource = ((XmlBasic)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getObjectTypeConverter();
        JavaBasicMapping javaBasicMapping = (JavaBasicMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("id").getMapping();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)0, (int)ormConverter.conversionValuesSize());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)0, (int)converterResource.getConversionValues().size());
        XmlConversionValueImpl resourceConversionValue = EclipseLinkOrmFactory.eINSTANCE.createXmlConversionValueImpl();
        converterResource.getConversionValues().add((Object)resourceConversionValue);
        resourceConversionValue.setDataValue("foo");
        resourceConversionValue.setObjectValue("bar");
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)1, (int)ormConverter.conversionValuesSize());
        ListIterator contextConversionValues = ormConverter.conversionValues();
        ConversionValue contextConversionValue = (ConversionValue)contextConversionValues.next();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)contextConversionValue.getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar", (String)contextConversionValue.getObjectValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)1, (int)converterResource.getConversionValues().size());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)((XmlConversionValue)converterResource.getConversionValues().get(0)).getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar", (String)((XmlConversionValue)converterResource.getConversionValues().get(0)).getObjectValue());
        XmlConversionValueImpl xmlConversionValue2 = EclipseLinkOrmFactory.eINSTANCE.createXmlConversionValueImpl();
        converterResource.getConversionValues().add(0, (Object)xmlConversionValue2);
        xmlConversionValue2.setDataValue("foo2");
        xmlConversionValue2.setObjectValue("bar2");
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)2, (int)ormConverter.conversionValuesSize());
        contextConversionValues = ormConverter.conversionValues();
        contextConversionValue = (ConversionValue)contextConversionValues.next();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo2", (String)contextConversionValue.getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar2", (String)contextConversionValue.getObjectValue());
        contextConversionValue = (ConversionValue)contextConversionValues.next();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)contextConversionValue.getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar", (String)contextConversionValue.getObjectValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)2, (int)converterResource.getConversionValues().size());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo2", (String)((XmlConversionValue)converterResource.getConversionValues().get(0)).getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar2", (String)((XmlConversionValue)converterResource.getConversionValues().get(0)).getObjectValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)((XmlConversionValue)converterResource.getConversionValues().get(1)).getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar", (String)((XmlConversionValue)converterResource.getConversionValues().get(1)).getObjectValue());
        converterResource.getConversionValues().move(0, 1);
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)2, (int)ormConverter.conversionValuesSize());
        contextConversionValues = ormConverter.conversionValues();
        contextConversionValue = (ConversionValue)contextConversionValues.next();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)contextConversionValue.getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar", (String)contextConversionValue.getObjectValue());
        contextConversionValue = (ConversionValue)contextConversionValues.next();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo2", (String)contextConversionValue.getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar2", (String)contextConversionValue.getObjectValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)2, (int)converterResource.getConversionValues().size());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)((XmlConversionValue)converterResource.getConversionValues().get(0)).getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar", (String)((XmlConversionValue)converterResource.getConversionValues().get(0)).getObjectValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo2", (String)((XmlConversionValue)converterResource.getConversionValues().get(1)).getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar2", (String)((XmlConversionValue)converterResource.getConversionValues().get(1)).getObjectValue());
        converterResource.getConversionValues().remove(0);
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)1, (int)ormConverter.conversionValuesSize());
        contextConversionValues = ormConverter.conversionValues();
        contextConversionValue = (ConversionValue)contextConversionValues.next();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo2", (String)contextConversionValue.getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar2", (String)contextConversionValue.getObjectValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)1, (int)converterResource.getConversionValues().size());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo2", (String)((XmlConversionValue)converterResource.getConversionValues().get(0)).getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar2", (String)((XmlConversionValue)converterResource.getConversionValues().get(0)).getObjectValue());
        converterResource.getConversionValues().clear();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)0, (int)ormConverter.conversionValuesSize());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)0, (int)converterResource.getConversionValues().size());
        ObjectTypeConverter javaConverter = (ObjectTypeConverter)((EclipseLinkJavaConvert)javaBasicMapping.getConverter()).getConverter();
        ConversionValue javaConversionValue = javaConverter.addConversionValue();
        javaConversionValue.setDataValue("baz");
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)0, (int)ormConverter.conversionValuesSize());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)0, (int)converterResource.getConversionValues().size());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)1, (int)javaConverter.conversionValuesSize());
        ormPersistentType.removeSpecifiedPersistentAttribute(ormPersistentAttribute);
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormConverter = (ObjectTypeConverter)((Convert)ormBasicMapping.getConverter()).getConverter();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)1, (int)ormConverter.conversionValuesSize());
        contextConversionValues = ormConverter.conversionValues();
        contextConversionValue = (ConversionValue)contextConversionValues.next();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"baz", (String)contextConversionValue.getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)0, (int)converterResource.getConversionValues().size());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)1, (int)javaConverter.conversionValuesSize());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"noConverter", (String)ormBasicMapping.getConverter().getType());
    }

    public void testModifyConversionValues() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "id");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormBasicMapping.setSpecifiedConverter("eclipseLinkConverter");
        ((Convert)ormBasicMapping.getConverter()).setConverter("objectTypeConverter");
        ObjectTypeConverter ormConverter = (ObjectTypeConverter)((Convert)ormBasicMapping.getConverter()).getConverter();
        XmlObjectTypeConverter converterResource = ((XmlBasic)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getObjectTypeConverter();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)0, (int)ormConverter.conversionValuesSize());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)0, (int)converterResource.getConversionValues().size());
        ConversionValue contextConversionValue = ormConverter.addConversionValue();
        contextConversionValue.setDataValue("foo");
        contextConversionValue.setObjectValue("bar");
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)1, (int)ormConverter.conversionValuesSize());
        ListIterator contextConversionValues = ormConverter.conversionValues();
        contextConversionValue = (ConversionValue)contextConversionValues.next();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)contextConversionValue.getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar", (String)contextConversionValue.getObjectValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)1, (int)converterResource.getConversionValues().size());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)((XmlConversionValue)converterResource.getConversionValues().get(0)).getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar", (String)((XmlConversionValue)converterResource.getConversionValues().get(0)).getObjectValue());
        ConversionValue contextConversionValue2 = ormConverter.addConversionValue(0);
        contextConversionValue2.setDataValue("foo2");
        contextConversionValue2.setObjectValue("bar2");
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)2, (int)ormConverter.conversionValuesSize());
        contextConversionValues = ormConverter.conversionValues();
        contextConversionValue = (ConversionValue)contextConversionValues.next();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo2", (String)contextConversionValue.getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar2", (String)contextConversionValue.getObjectValue());
        contextConversionValue = (ConversionValue)contextConversionValues.next();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)contextConversionValue.getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar", (String)contextConversionValue.getObjectValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)2, (int)converterResource.getConversionValues().size());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo2", (String)((XmlConversionValue)converterResource.getConversionValues().get(0)).getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar2", (String)((XmlConversionValue)converterResource.getConversionValues().get(0)).getObjectValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)((XmlConversionValue)converterResource.getConversionValues().get(1)).getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar", (String)((XmlConversionValue)converterResource.getConversionValues().get(1)).getObjectValue());
        ormConverter.moveConversionValue(0, 1);
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)2, (int)ormConverter.conversionValuesSize());
        contextConversionValues = ormConverter.conversionValues();
        contextConversionValue = (ConversionValue)contextConversionValues.next();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)contextConversionValue.getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar", (String)contextConversionValue.getObjectValue());
        contextConversionValue = (ConversionValue)contextConversionValues.next();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo2", (String)contextConversionValue.getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar2", (String)contextConversionValue.getObjectValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)2, (int)converterResource.getConversionValues().size());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)((XmlConversionValue)converterResource.getConversionValues().get(0)).getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar", (String)((XmlConversionValue)converterResource.getConversionValues().get(0)).getObjectValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo2", (String)((XmlConversionValue)converterResource.getConversionValues().get(1)).getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar2", (String)((XmlConversionValue)converterResource.getConversionValues().get(1)).getObjectValue());
        ormConverter.removeConversionValue(0);
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)1, (int)ormConverter.conversionValuesSize());
        contextConversionValues = ormConverter.conversionValues();
        contextConversionValue = (ConversionValue)contextConversionValues.next();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo2", (String)contextConversionValue.getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar2", (String)contextConversionValue.getObjectValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)1, (int)converterResource.getConversionValues().size());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo2", (String)((XmlConversionValue)converterResource.getConversionValues().get(0)).getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar2", (String)((XmlConversionValue)converterResource.getConversionValues().get(0)).getObjectValue());
        ormConverter.removeConversionValue(0);
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)0, (int)ormConverter.conversionValuesSize());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)0, (int)converterResource.getConversionValues().size());
    }

    public void testInitializeConversionValues() throws Exception {
        this.createTestEntityWithConvertAndObjectTypeConverterConversionValue();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        Convert eclipseLinkConvert = (Convert)ormBasicMapping.getConverter();
        ObjectTypeConverter converter = (ObjectTypeConverter)eclipseLinkConvert.getConverter();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)1, (int)converter.conversionValuesSize());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"f", (String)((ConversionValue)converter.conversionValues().next()).getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"female", (String)((ConversionValue)converter.conversionValues().next()).getObjectValue());
    }
}

