/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.java.JavaVersionMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmVersionMapping;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.context.Convert;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkVersionMapping;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.EclipseLinkOrmBasicMapping;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.EclipseLinkOrmVersionMapping;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlEntity;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlVersion;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.orm.EclipseLinkOrmContextModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class EclipseLinkOrmVersionMappingTests
extends EclipseLinkOrmContextModelTestCase {
    public EclipseLinkOrmVersionMappingTests(String name) {
        super(name);
    }

    private void createConvertAnnotation() throws Exception {
        this.createAnnotationAndMembers("org.eclipse.persistence.annotations", "Convert", "String value() default \"none\";");
    }

    private void createMutableAnnotation() throws Exception {
        this.createAnnotationAndMembers("org.eclipse.persistence.annotations", "Mutable", "boolean value() default true");
    }

    private ICompilationUnit createTestEntityWithVersionMapping() throws Exception {
        this.createConvertAnnotation();
        this.createMutableAnnotation();
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Version"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Version").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithMutableVersionDate() throws Exception {
        this.createMutableAnnotation();
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Version", "org.eclipse.persistence.annotations.Mutable", "java.util.Date"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Version").append(CR);
                sb.append("    @Mutable").append(CR);
                sb.append("    private Date myDate;").append(CR);
                sb.append(CR);
                sb.append("    ");
            }
        });
    }

    public void testUpdateMutable() throws Exception {
        this.createTestEntityWithVersionMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("version", "id");
        EclipseLinkOrmVersionMapping contextVersion = (EclipseLinkOrmVersionMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlVersion resourceVersion = (XmlVersion)resourceEntity.getAttributes().getVersions().get(0);
        EclipseLinkVersionMapping javaVersionMapping = (EclipseLinkVersionMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("id").getMapping();
        EclipseLinkOrmVersionMappingTests.assertNull((Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)contextVersion.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertNull((Object)contextVersion.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)contextVersion.getMutable().isMutable());
        resourceVersion.setMutable(Boolean.FALSE);
        EclipseLinkOrmVersionMappingTests.assertEquals((Object)Boolean.FALSE, (Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)contextVersion.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertEquals((Object)Boolean.FALSE, (Object)contextVersion.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isMutable());
        resourceVersion.setMutable(Boolean.TRUE);
        EclipseLinkOrmVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)contextVersion.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)contextVersion.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)contextVersion.getMutable().isMutable());
        resourceVersion.setMutable(null);
        EclipseLinkOrmVersionMappingTests.assertNull((Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)contextVersion.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertNull((Object)contextVersion.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)contextVersion.getMutable().isMutable());
        javaVersionMapping.getMutable().setSpecifiedMutable(Boolean.FALSE);
        EclipseLinkOrmVersionMappingTests.assertNull((Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)contextVersion.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertNull((Object)contextVersion.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)contextVersion.getMutable().isMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)javaVersionMapping.getMutable().isMutable());
        ormPersistentType.removeSpecifiedPersistentAttribute(ormPersistentAttribute);
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        contextVersion = (EclipseLinkOrmVersionMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmVersionMappingTests.assertNull((Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)contextVersion.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertEquals((Object)Boolean.FALSE, (Object)contextVersion.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)javaVersionMapping.getMutable().isMutable());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        EclipseLinkOrmBasicMapping contextBasic = (EclipseLinkOrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmVersionMappingTests.assertNull((Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)contextBasic.getMutable().isMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)javaVersionMapping.getMutable().isMutable());
    }

    public void testUpdateMutableDate() throws Exception {
        this.createTestEntityWithMutableVersionDate();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("version", "myDate");
        EclipseLinkOrmVersionMapping contextVersion = (EclipseLinkOrmVersionMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlVersion resourceVersion = (XmlVersion)resourceEntity.getAttributes().getVersions().get(0);
        EclipseLinkVersionMapping javaVersionMapping = (EclipseLinkVersionMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("myDate").getMapping();
        EclipseLinkOrmVersionMappingTests.assertNull((Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertNull((Object)contextVersion.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isMutable());
        resourceVersion.setMutable(Boolean.FALSE);
        EclipseLinkOrmVersionMappingTests.assertEquals((Object)Boolean.FALSE, (Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertEquals((Object)Boolean.FALSE, (Object)contextVersion.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isMutable());
        resourceVersion.setMutable(Boolean.TRUE);
        EclipseLinkOrmVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)contextVersion.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)contextVersion.getMutable().isMutable());
        resourceVersion.setMutable(null);
        EclipseLinkOrmVersionMappingTests.assertNull((Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertNull((Object)contextVersion.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isMutable());
        this.persistenceUnit().getOptions().setTemporalMutable(Boolean.TRUE);
        EclipseLinkOrmVersionMappingTests.assertNull((Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)contextVersion.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertNull((Object)contextVersion.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)contextVersion.getMutable().isMutable());
        this.persistenceUnit().getOptions().setTemporalMutable(Boolean.FALSE);
        EclipseLinkOrmVersionMappingTests.assertNull((Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertNull((Object)contextVersion.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isMutable());
        this.persistenceUnit().getOptions().setTemporalMutable(null);
        EclipseLinkOrmVersionMappingTests.assertNull((Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertNull((Object)contextVersion.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isMutable());
        javaVersionMapping.getMutable().setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkOrmVersionMappingTests.assertNull((Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertNull((Object)contextVersion.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)javaVersionMapping.getMutable().isMutable());
        ormPersistentType.removeSpecifiedPersistentAttribute(ormPersistentAttribute);
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        contextVersion = (EclipseLinkOrmVersionMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmVersionMappingTests.assertNull((Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)contextVersion.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)contextVersion.getMutable().isMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)javaVersionMapping.getMutable().isMutable());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        EclipseLinkOrmBasicMapping contextBasic = (EclipseLinkOrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmVersionMappingTests.assertNull((Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertEquals((Object)Boolean.FALSE, (Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextBasic.getMutable().isMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)javaVersionMapping.getMutable().isMutable());
    }

    public void testModifyMutable() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("version", "basic");
        EclipseLinkOrmVersionMapping contextVersion = (EclipseLinkOrmVersionMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlVersion resourceVersion = (XmlVersion)resourceEntity.getAttributes().getVersions().get(0);
        EclipseLinkOrmVersionMappingTests.assertNull((Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertNull((Object)contextVersion.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isMutable());
        contextVersion.getMutable().setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkOrmVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)contextVersion.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertTrue((boolean)contextVersion.getMutable().isMutable());
        contextVersion.getMutable().setSpecifiedMutable(Boolean.FALSE);
        EclipseLinkOrmVersionMappingTests.assertEquals((Object)Boolean.FALSE, (Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertEquals((Object)Boolean.FALSE, (Object)contextVersion.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isMutable());
        contextVersion.getMutable().setSpecifiedMutable(null);
        EclipseLinkOrmVersionMappingTests.assertNull((Object)resourceVersion.getMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isDefaultMutable());
        EclipseLinkOrmVersionMappingTests.assertNull((Object)contextVersion.getMutable().getSpecifiedMutable());
        EclipseLinkOrmVersionMappingTests.assertFalse((boolean)contextVersion.getMutable().isMutable());
    }

    public void testUpdateConvert() throws Exception {
        this.createTestEntityWithVersionMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("version", "id");
        OrmVersionMapping ormVersionMapping = (OrmVersionMapping)ormPersistentAttribute.getMapping();
        XmlVersion basicResource = (XmlVersion)((org.eclipse.jpt.core.resource.orm.XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getVersions().get(0);
        JavaVersionMapping javaVersionMapping = (JavaVersionMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("id").getMapping();
        EclipseLinkOrmVersionMappingTests.assertEquals(null, (Object)ormVersionMapping.getSpecifiedConverter());
        EclipseLinkOrmVersionMappingTests.assertEquals(null, (String)basicResource.getConvert());
        basicResource.setConvert("myConvert");
        EclipseLinkOrmVersionMappingTests.assertEquals((String)"eclipseLinkConverter", (String)ormVersionMapping.getConverter().getType());
        EclipseLinkOrmVersionMappingTests.assertEquals((String)"myConvert", (String)basicResource.getConvert());
        basicResource.setConvert(null);
        EclipseLinkOrmVersionMappingTests.assertEquals(null, (Object)ormVersionMapping.getSpecifiedConverter());
        EclipseLinkOrmVersionMappingTests.assertEquals(null, (String)basicResource.getConvert());
        javaVersionMapping.setSpecifiedConverter("eclipseLinkConverter");
        ((Convert)javaVersionMapping.getSpecifiedConverter()).setSpecifiedConverterName("foo");
        EclipseLinkOrmVersionMappingTests.assertEquals(null, (Object)ormVersionMapping.getSpecifiedConverter());
        EclipseLinkOrmVersionMappingTests.assertEquals(null, (String)basicResource.getConvert());
        EclipseLinkOrmVersionMappingTests.assertEquals((String)"foo", (String)((Convert)javaVersionMapping.getSpecifiedConverter()).getSpecifiedConverterName());
        ormPersistentType.removeSpecifiedPersistentAttribute(ormPersistentAttribute);
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        ormVersionMapping = (OrmVersionMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmVersionMappingTests.assertEquals((String)"eclipseLinkConverter", (String)ormVersionMapping.getSpecifiedConverter().getType());
        EclipseLinkOrmVersionMappingTests.assertEquals((String)"foo", (String)((Convert)ormVersionMapping.getSpecifiedConverter()).getSpecifiedConverterName());
        EclipseLinkOrmVersionMappingTests.assertEquals(null, (String)basicResource.getConvert());
        EclipseLinkOrmVersionMappingTests.assertEquals((String)"foo", (String)((Convert)javaVersionMapping.getSpecifiedConverter()).getSpecifiedConverterName());
        ((Convert)javaVersionMapping.getSpecifiedConverter()).setSpecifiedConverterName("bar");
        EclipseLinkOrmVersionMappingTests.assertEquals((String)"eclipseLinkConverter", (String)ormVersionMapping.getSpecifiedConverter().getType());
        EclipseLinkOrmVersionMappingTests.assertEquals((String)"bar", (String)((Convert)ormVersionMapping.getSpecifiedConverter()).getSpecifiedConverterName());
        EclipseLinkOrmVersionMappingTests.assertEquals(null, (String)basicResource.getConvert());
        EclipseLinkOrmVersionMappingTests.assertEquals((String)"bar", (String)((Convert)javaVersionMapping.getSpecifiedConverter()).getSpecifiedConverterName());
        javaVersionMapping.setSpecifiedConverter("noConverter");
        EclipseLinkOrmVersionMappingTests.assertEquals(null, (Object)ormVersionMapping.getSpecifiedConverter());
        EclipseLinkOrmVersionMappingTests.assertEquals(null, (String)basicResource.getConvert());
        EclipseLinkOrmVersionMappingTests.assertEquals(null, (Object)javaVersionMapping.getSpecifiedConverter());
    }

    public void testModifyConvert() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("version", "basicMapping");
        OrmVersionMapping ormVersionMapping = (OrmVersionMapping)ormPersistentAttribute.getMapping();
        XmlVersion basicResource = (XmlVersion)((org.eclipse.jpt.core.resource.orm.XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getVersions().get(0);
        EclipseLinkOrmVersionMappingTests.assertEquals(null, (Object)ormVersionMapping.getSpecifiedConverter());
        EclipseLinkOrmVersionMappingTests.assertEquals(null, (String)basicResource.getConvert());
        ormVersionMapping.setSpecifiedConverter("eclipseLinkConverter");
        EclipseLinkOrmVersionMappingTests.assertEquals((String)"", (String)basicResource.getConvert());
        EclipseLinkOrmVersionMappingTests.assertEquals((String)"eclipseLinkConverter", (String)ormVersionMapping.getConverter().getType());
        ((Convert)ormVersionMapping.getSpecifiedConverter()).setSpecifiedConverterName("bar");
        EclipseLinkOrmVersionMappingTests.assertEquals((String)"bar", (String)basicResource.getConvert());
        EclipseLinkOrmVersionMappingTests.assertEquals((String)"eclipseLinkConverter", (String)ormVersionMapping.getConverter().getType());
        EclipseLinkOrmVersionMappingTests.assertEquals((String)"bar", (String)((Convert)ormVersionMapping.getConverter()).getSpecifiedConverterName());
        ((Convert)ormVersionMapping.getSpecifiedConverter()).setSpecifiedConverterName(null);
        EclipseLinkOrmVersionMappingTests.assertEquals(null, (Object)ormVersionMapping.getSpecifiedConverter());
        EclipseLinkOrmVersionMappingTests.assertEquals(null, (String)basicResource.getConvert());
        ormVersionMapping.setSpecifiedConverter(null);
        EclipseLinkOrmVersionMappingTests.assertEquals(null, (Object)ormVersionMapping.getSpecifiedConverter());
        EclipseLinkOrmVersionMappingTests.assertEquals(null, (String)basicResource.getConvert());
    }
}

