/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.persistence;

import java.util.Iterator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jpt.core.internal.facet.JpaFacetDataModelProvider;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.jpt.core.tests.internal.projects.TestJpaProject;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.eclipselink.core.internal.operations.EclipseLinkOrmFileCreationDataModelProvider;
import org.eclipse.jpt.eclipselink.core.resource.orm.EclipseLinkOrmResource;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.orm.EclipseLinkOrmContextModelTestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class EclipseLinkPersistenceUnitTests
extends EclipseLinkOrmContextModelTestCase {
    public EclipseLinkPersistenceUnitTests(String name) {
        super(name);
    }

    protected IDataModel buildJpaConfigDataModel() {
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new JpaFacetDataModelProvider());
        dataModel.setProperty("JpaFacetDataModelProperties.PLATFORM_ID", (Object)"org.eclipse.eclipselink.platform");
        dataModel.setProperty("JpaFacetDataModelProperties.CREATE_ORM_XML", (Object)Boolean.TRUE);
        return dataModel;
    }

    protected IDataModel buildEclipseLinkOrmConfig(TestJpaProject testJpaProject) {
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new EclipseLinkOrmFileCreationDataModelProvider());
        dataModel.setProperty("OrmFileCreationDataModelProperties.PROJECT_NAME", (Object)testJpaProject.getProject().getName());
        dataModel.setProperty("OrmFileCreationDataModelProperties.ADD_TO_PERSISTENCE_UNIT", (Object)Boolean.FALSE);
        return dataModel;
    }

    public void testUpdateEclipseLinkImpliedMappingFileRef1() throws Exception {
        EclipseLinkPersistenceUnit persistenceUnit = this.persistenceUnit();
        EclipseLinkOrmResource eclipseLinkOrmResource = this.ormResource();
        EclipseLinkPersistenceUnitTests.assertTrue((boolean)eclipseLinkOrmResource.exists());
        EclipseLinkPersistenceUnitTests.assertNotNull((Object)persistenceUnit.getImpliedMappingFileRef());
        EclipseLinkPersistenceUnitTests.assertNotNull((Object)persistenceUnit.getImpliedEclipseLinkMappingFileRef());
        this.deleteResource((Resource)eclipseLinkOrmResource);
        EclipseLinkPersistenceUnitTests.assertFalse((boolean)eclipseLinkOrmResource.exists());
        EclipseLinkPersistenceUnitTests.assertNotNull((Object)persistenceUnit.getImpliedMappingFileRef());
        EclipseLinkPersistenceUnitTests.assertNull((Object)persistenceUnit.getImpliedEclipseLinkMappingFileRef());
    }

    public void testUpdateEclipseLinkImpliedMappingFileRef2() {
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        EclipseLinkPersistenceUnit persistenceUnit = this.persistenceUnit();
        EclipseLinkOrmResource eclipseLinkOrmResource = this.ormResource();
        EclipseLinkPersistenceUnitTests.assertTrue((boolean)eclipseLinkOrmResource.exists());
        EclipseLinkPersistenceUnitTests.assertNotNull((Object)persistenceUnit.getImpliedMappingFileRef());
        EclipseLinkPersistenceUnitTests.assertNotNull((Object)persistenceUnit.getImpliedEclipseLinkMappingFileRef());
        XmlMappingFileRef xmlMappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        xmlMappingFileRef.setFileName("META-INF/eclipselink-orm.xml");
        xmlPersistenceUnit.getMappingFiles().add((Object)xmlMappingFileRef);
        EclipseLinkPersistenceUnitTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.specifiedMappingFileRefs()));
        EclipseLinkPersistenceUnitTests.assertTrue((boolean)eclipseLinkOrmResource.exists());
        EclipseLinkPersistenceUnitTests.assertNotNull((Object)persistenceUnit.getImpliedMappingFileRef());
        EclipseLinkPersistenceUnitTests.assertNull((Object)persistenceUnit.getImpliedEclipseLinkMappingFileRef());
    }

    public void testUpdateEclipseLinkImpliedMappingFileRef3() {
        EclipseLinkPersistenceUnit persistenceUnit = this.persistenceUnit();
        EclipseLinkOrmResource eclipseLinkOrmResource = this.ormResource();
        EclipseLinkPersistenceUnitTests.assertTrue((boolean)eclipseLinkOrmResource.exists());
        EclipseLinkPersistenceUnitTests.assertNotNull((Object)persistenceUnit.getImpliedMappingFileRef());
        EclipseLinkPersistenceUnitTests.assertNotNull((Object)persistenceUnit.getImpliedEclipseLinkMappingFileRef());
        persistenceUnit.getGeneralProperties().setExcludeEclipselinkOrm(Boolean.TRUE);
        EclipseLinkPersistenceUnitTests.assertTrue((boolean)eclipseLinkOrmResource.exists());
        EclipseLinkPersistenceUnitTests.assertNotNull((Object)persistenceUnit.getImpliedMappingFileRef());
        EclipseLinkPersistenceUnitTests.assertNull((Object)persistenceUnit.getImpliedEclipseLinkMappingFileRef());
    }
}

