/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.persistence.connection;

import org.eclipse.jpt.core.context.persistence.PersistenceUnitTransactionType;
import org.eclipse.jpt.core.internal.context.persistence.GenericProperty;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.PersistenceUnitProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.PersistenceUnitPropertyListListener;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.connection.BatchWriting;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.connection.Connection;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.connection.EclipseLinkConnection;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.persistence.PersistenceUnitTestCase;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.ListValueModel;

public class ConnectionAdapterTests
extends PersistenceUnitTestCase {
    private Connection connection;
    public static final PersistenceUnitTransactionType TRANSACTION_TYPE_TEST_VALUE = PersistenceUnitTransactionType.RESOURCE_LOCAL;
    public static final PersistenceUnitTransactionType TRANSACTION_TYPE_TEST_VALUE_2 = PersistenceUnitTransactionType.JTA;
    public static final String JTA_DATA_SOURCE_TEST_VALUE = "Test_JTA";
    public static final String JTA_DATA_SOURCE_TEST_VALUE_2 = "Test_JTA_2";
    public static final String NON_JTA_DATA_SOURCE_TEST_VALUE = "Test_Non_JTA";
    public static final String NON_JTA_DATA_SOURCE_TEST_VALUE_2 = "Test_Non_JTA_2";
    public static final String NATIVE_SQL_KEY = "eclipselink.jdbc.native-sql";
    public static final Boolean NATIVE_SQL_TEST_VALUE = false;
    public static final Boolean NATIVE_SQL_TEST_VALUE_2 = NATIVE_SQL_TEST_VALUE == false;
    public static final String BATCH_WRITING_KEY = "eclipselink.jdbc.batch-writing";
    public static final BatchWriting BATCH_WRITING_TEST_VALUE = BatchWriting.oracle_jdbc;
    public static final BatchWriting BATCH_WRITING_TEST_VALUE_2 = BatchWriting.buffered;
    public static final String CACHE_STATEMENTS_KEY = "eclipselink.jdbc.cache-statements";
    public static final Boolean CACHE_STATEMENTS_TEST_VALUE = false;
    public static final Boolean CACHE_STATEMENTS_TEST_VALUE_2 = CACHE_STATEMENTS_TEST_VALUE == false;
    public static final String CACHE_STATEMENTS_SIZE_KEY = "eclipselink.jdbc.cache-statements.size";
    public static final Integer CACHE_STATEMENTS_SIZE_TEST_VALUE = 100;
    public static final Integer CACHE_STATEMENTS_SIZE_TEST_VALUE_2 = 200;
    public static final String DRIVER_KEY = "eclipselink.jdbc.driver";
    public static final String DRIVER_TEST_VALUE = "test";
    public static final String DRIVER_TEST_VALUE_2 = "test_2";
    public static final String URL_KEY = "eclipselink.jdbc.url";
    public static final String URL_TEST_VALUE = "test";
    public static final String URL_TEST_VALUE_2 = "test_2";
    public static final String USER_KEY = "eclipselink.jdbc.user";
    public static final String USER_TEST_VALUE = "test";
    public static final String USER_TEST_VALUE_2 = "test_2";
    public static final String PASSWORD_KEY = "eclipselink.jdbc.password";
    public static final String PASSWORD_TEST_VALUE = "test";
    public static final String PASSWORD_TEST_VALUE_2 = "test_2";
    public static final String BIND_PARAMETERS_KEY = "eclipselink.jdbc.bind-parameters";
    public static final Boolean BIND_PARAMETERS_TEST_VALUE = false;
    public static final Boolean BIND_PARAMETERS_TEST_VALUE_2 = BIND_PARAMETERS_TEST_VALUE == false;
    public static final String READ_CONNECTIONS_SHARED_KEY = "eclipselink.jdbc.read-connections.shared";
    public static final Boolean READ_CONNECTIONS_SHARED_TEST_VALUE = false;
    public static final Boolean READ_CONNECTIONS_SHARED_TEST_VALUE_2 = READ_CONNECTIONS_SHARED_TEST_VALUE == false;
    public static final String READ_CONNECTIONS_MIN_KEY = "eclipselink.jdbc.read-connections.min";
    public static final Integer READ_CONNECTIONS_MIN_TEST_VALUE = 100;
    public static final Integer READ_CONNECTIONS_MIN_TEST_VALUE_2 = 200;
    public static final String READ_CONNECTIONS_MAX_KEY = "eclipselink.jdbc.read-connections.max";
    public static final Integer READ_CONNECTIONS_MAX_TEST_VALUE = 100;
    public static final Integer READ_CONNECTIONS_MAX_TEST_VALUE_2 = 200;
    public static final String WRITE_CONNECTIONS_MIN_KEY = "eclipselink.jdbc.write-connections.min";
    public static final Integer WRITE_CONNECTIONS_MIN_TEST_VALUE = 100;
    public static final Integer WRITE_CONNECTIONS_MIN_TEST_VALUE_2 = 200;
    public static final String WRITE_CONNECTIONS_MAX_KEY = "eclipselink.jdbc.write-connections.max";
    public static final Integer WRITE_CONNECTIONS_MAX_TEST_VALUE = 100;
    public static final Integer WRITE_CONNECTIONS_MAX_TEST_VALUE_2 = 200;

    public ConnectionAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.connection = this.subject.getConnection();
        PropertyChangeListener propertyChangeListener = this.buildPropertyChangeListener();
        this.connection.addPropertyChangeListener("transactionTypeProperty", propertyChangeListener);
        this.connection.addPropertyChangeListener("jtaDataSourceProperty", propertyChangeListener);
        this.connection.addPropertyChangeListener("nonJtaDataSourceProperty", propertyChangeListener);
        this.connection.addPropertyChangeListener("nativeSqlProperty", propertyChangeListener);
        this.connection.addPropertyChangeListener("batchWritingProperty", propertyChangeListener);
        this.connection.addPropertyChangeListener("cacheStatementsProperty", propertyChangeListener);
        this.connection.addPropertyChangeListener("cacheStatementsSizeProperty", propertyChangeListener);
        this.connection.addPropertyChangeListener("driverProperty", propertyChangeListener);
        this.connection.addPropertyChangeListener("urlProperty", propertyChangeListener);
        this.connection.addPropertyChangeListener("userProperty", propertyChangeListener);
        this.connection.addPropertyChangeListener("passwordProperty", propertyChangeListener);
        this.connection.addPropertyChangeListener("bindParametersProperty", propertyChangeListener);
        this.connection.addPropertyChangeListener("readConnectionsSharedProperty", propertyChangeListener);
        this.connection.addPropertyChangeListener("readConnectionsMinProperty", propertyChangeListener);
        this.connection.addPropertyChangeListener("readConnectionsMaxProperty", propertyChangeListener);
        this.connection.addPropertyChangeListener("writeConnectionsMinProperty", propertyChangeListener);
        this.connection.addPropertyChangeListener("writeConnectionsMaxProperty", propertyChangeListener);
        this.clearEvent();
    }

    protected void populatePu() {
        this.modelPropertiesSizeOriginal = 14;
        this.propertiesTotal = this.modelPropertiesSizeOriginal + 4;
        this.modelPropertiesSize = this.modelPropertiesSizeOriginal;
        this.persistenceUnitPut("misc.property.1", "value.1");
        this.persistenceUnitPut(NATIVE_SQL_KEY, NATIVE_SQL_TEST_VALUE.toString());
        this.persistenceUnitPut(BATCH_WRITING_KEY, BATCH_WRITING_TEST_VALUE);
        this.persistenceUnitPut(CACHE_STATEMENTS_KEY, CACHE_STATEMENTS_TEST_VALUE.toString());
        this.persistenceUnitPut(CACHE_STATEMENTS_SIZE_KEY, CACHE_STATEMENTS_SIZE_TEST_VALUE.toString());
        this.persistenceUnitPut(DRIVER_KEY, "test".toString());
        this.persistenceUnitPut(URL_KEY, "test".toString());
        this.persistenceUnitPut(USER_KEY, "test".toString());
        this.persistenceUnitPut(PASSWORD_KEY, "test".toString());
        this.persistenceUnitPut(BIND_PARAMETERS_KEY, BIND_PARAMETERS_TEST_VALUE.toString());
        this.persistenceUnitPut("misc.property.2", "value.2");
        this.persistenceUnitPut("misc.property.3", "value.3");
        this.persistenceUnitPut(READ_CONNECTIONS_SHARED_KEY, READ_CONNECTIONS_SHARED_TEST_VALUE.toString());
        this.persistenceUnitPut(READ_CONNECTIONS_MIN_KEY, READ_CONNECTIONS_MIN_TEST_VALUE.toString());
        this.persistenceUnitPut(READ_CONNECTIONS_MAX_KEY, READ_CONNECTIONS_MAX_TEST_VALUE.toString());
        this.persistenceUnitPut(WRITE_CONNECTIONS_MIN_KEY, WRITE_CONNECTIONS_MIN_TEST_VALUE.toString());
        this.persistenceUnitPut(WRITE_CONNECTIONS_MAX_KEY, WRITE_CONNECTIONS_MAX_TEST_VALUE.toString());
        this.persistenceUnitPut("misc.property.4", "value.4");
        this.persistenceUnit().setSpecifiedTransactionType(TRANSACTION_TYPE_TEST_VALUE);
        this.persistenceUnit().setJtaDataSource(JTA_DATA_SOURCE_TEST_VALUE);
        this.persistenceUnit().setNonJtaDataSource(NON_JTA_DATA_SOURCE_TEST_VALUE);
    }

    public void testHasListeners() throws Exception {
        ListAspectAdapter propertiesAdapter = (ListAspectAdapter)this.subject.getPropertiesAdapter();
        GenericProperty ctdProperty = (GenericProperty)this.persistenceUnit().getProperty(NATIVE_SQL_KEY);
        ListValueModel propertyListAdapter = this.subject.getPropertyListAdapter();
        ConnectionAdapterTests.assertTrue((boolean)propertiesAdapter.hasAnyListChangeListeners("list values"));
        ConnectionAdapterTests.assertTrue((boolean)ctdProperty.hasAnyPropertyChangeListeners("value"));
        this.verifyHasListeners((PersistenceUnitProperties)this.connection, "nativeSqlProperty");
        this.verifyHasListeners((PersistenceUnitProperties)this.connection, "bindParametersProperty");
        this.verifyHasListeners((PersistenceUnitProperties)this.connection, "cacheStatementsProperty");
        this.verifyHasListeners((PersistenceUnitProperties)this.connection, "readConnectionsSharedProperty");
        this.verifyHasListeners((PersistenceUnitProperties)this.connection, "batchWritingProperty");
        this.verifyHasListeners((PersistenceUnitProperties)this.connection, "transactionTypeProperty");
        this.verifyHasListeners((PersistenceUnitProperties)this.connection, "jtaDataSourceProperty");
        this.verifyHasListeners((PersistenceUnitProperties)this.connection, "nonJtaDataSourceProperty");
        this.verifyHasListeners(propertyListAdapter);
        EclipseLinkConnection elConnection = (EclipseLinkConnection)this.connection;
        PersistenceUnitPropertyListListener propertyListListener = elConnection.propertyListListener();
        propertyListAdapter.removeListChangeListener("list values", (ListChangeListener)propertyListListener);
        ConnectionAdapterTests.assertTrue((boolean)propertiesAdapter.hasAnyListChangeListeners("list values"));
        this.verifyHasListeners((PersistenceUnitProperties)this.connection, "nativeSqlProperty");
        this.verifyHasListeners((PersistenceUnitProperties)this.connection, "bindParametersProperty");
        this.verifyHasListeners((PersistenceUnitProperties)this.connection, "cacheStatementsProperty");
        this.verifyHasListeners((PersistenceUnitProperties)this.connection, "readConnectionsSharedProperty");
        this.verifyHasListeners((PersistenceUnitProperties)this.connection, "batchWritingProperty");
        this.verifyHasListeners((PersistenceUnitProperties)this.connection, "transactionTypeProperty");
        this.verifyHasListeners((PersistenceUnitProperties)this.connection, "jtaDataSourceProperty");
        this.verifyHasListeners((PersistenceUnitProperties)this.connection, "nonJtaDataSourceProperty");
    }

    public void testSetTransactionType() throws Exception {
        this.verifySetPersistenceUnitProperty("transactionTypeProperty", TRANSACTION_TYPE_TEST_VALUE, TRANSACTION_TYPE_TEST_VALUE_2);
    }

    public void testSetJtaDataSource() throws Exception {
        this.verifySetPersistenceUnitProperty("jtaDataSourceProperty", JTA_DATA_SOURCE_TEST_VALUE, JTA_DATA_SOURCE_TEST_VALUE_2);
    }

    public void testSetNonJtaDataSource() throws Exception {
        this.verifySetPersistenceUnitProperty("nonJtaDataSourceProperty", NON_JTA_DATA_SOURCE_TEST_VALUE, NON_JTA_DATA_SOURCE_TEST_VALUE_2);
    }

    public void testSetNativeSql() throws Exception {
        this.verifyModelInitialized(NATIVE_SQL_KEY, NATIVE_SQL_TEST_VALUE);
        this.verifySetProperty(NATIVE_SQL_KEY, NATIVE_SQL_TEST_VALUE, NATIVE_SQL_TEST_VALUE_2);
    }

    public void testAddRemoveNativeSql() throws Exception {
        this.verifyAddRemoveProperty(NATIVE_SQL_KEY, NATIVE_SQL_TEST_VALUE, NATIVE_SQL_TEST_VALUE_2);
    }

    public void testSetBatchWriting() throws Exception {
        this.verifyModelInitialized(BATCH_WRITING_KEY, BATCH_WRITING_TEST_VALUE);
        this.verifySetProperty(BATCH_WRITING_KEY, BATCH_WRITING_TEST_VALUE, BATCH_WRITING_TEST_VALUE_2);
    }

    public void testAddRemoveBatchWriting() throws Exception {
        this.verifyAddRemoveProperty(BATCH_WRITING_KEY, BATCH_WRITING_TEST_VALUE, BATCH_WRITING_TEST_VALUE_2);
    }

    public void testSetCacheStatements() throws Exception {
        this.verifyModelInitialized(CACHE_STATEMENTS_KEY, CACHE_STATEMENTS_TEST_VALUE);
        this.verifySetProperty(CACHE_STATEMENTS_KEY, CACHE_STATEMENTS_TEST_VALUE, CACHE_STATEMENTS_TEST_VALUE_2);
    }

    public void testAddRemoveCacheStatements() throws Exception {
        this.verifyAddRemoveProperty(CACHE_STATEMENTS_KEY, CACHE_STATEMENTS_TEST_VALUE, CACHE_STATEMENTS_TEST_VALUE_2);
    }

    public void testSetCacheStatementsSize() throws Exception {
        this.verifyModelInitialized(CACHE_STATEMENTS_SIZE_KEY, CACHE_STATEMENTS_SIZE_TEST_VALUE);
        this.verifySetProperty(CACHE_STATEMENTS_SIZE_KEY, CACHE_STATEMENTS_SIZE_TEST_VALUE, CACHE_STATEMENTS_SIZE_TEST_VALUE_2);
    }

    public void testAddRemoveCacheStatementsSize() throws Exception {
        this.verifyAddRemoveProperty(CACHE_STATEMENTS_SIZE_KEY, CACHE_STATEMENTS_SIZE_TEST_VALUE, CACHE_STATEMENTS_SIZE_TEST_VALUE_2);
    }

    public void testSetDriver() throws Exception {
        this.verifyModelInitialized(DRIVER_KEY, "test");
        this.verifySetProperty(DRIVER_KEY, "test", "test_2");
    }

    public void testAddRemoveDriver() throws Exception {
        this.verifyAddRemoveProperty(DRIVER_KEY, "test", "test_2");
    }

    public void testSetUrl() throws Exception {
        this.verifyModelInitialized(URL_KEY, "test");
        this.verifySetProperty(URL_KEY, "test", "test_2");
    }

    public void testAddRemoveUrl() throws Exception {
        this.verifyAddRemoveProperty(URL_KEY, "test", "test_2");
    }

    public void testSetUser() throws Exception {
        this.verifyModelInitialized(USER_KEY, "test");
        this.verifySetProperty(USER_KEY, "test", "test_2");
    }

    public void testAddRemoveUser() throws Exception {
        this.verifyAddRemoveProperty(USER_KEY, "test", "test_2");
    }

    public void testSetPassword() throws Exception {
        this.verifyModelInitialized(PASSWORD_KEY, "test");
        this.verifySetProperty(PASSWORD_KEY, "test", "test_2");
    }

    public void testAddRemovePassword() throws Exception {
        this.verifyAddRemoveProperty(PASSWORD_KEY, "test", "test_2");
    }

    public void testSetBindParameters() throws Exception {
        this.verifyModelInitialized(BIND_PARAMETERS_KEY, BIND_PARAMETERS_TEST_VALUE);
        this.verifySetProperty(BIND_PARAMETERS_KEY, BIND_PARAMETERS_TEST_VALUE, BIND_PARAMETERS_TEST_VALUE_2);
    }

    public void testAddRemoveBindParameters() throws Exception {
        this.verifyAddRemoveProperty(BIND_PARAMETERS_KEY, BIND_PARAMETERS_TEST_VALUE, BIND_PARAMETERS_TEST_VALUE_2);
    }

    public void testSetReadConnectionsShared() throws Exception {
        this.verifyModelInitialized(READ_CONNECTIONS_SHARED_KEY, READ_CONNECTIONS_SHARED_TEST_VALUE);
        this.verifySetProperty(READ_CONNECTIONS_SHARED_KEY, READ_CONNECTIONS_SHARED_TEST_VALUE, READ_CONNECTIONS_SHARED_TEST_VALUE_2);
    }

    public void testAddRemoveReadConnectionsShared() throws Exception {
        this.verifyAddRemoveProperty(READ_CONNECTIONS_SHARED_KEY, READ_CONNECTIONS_SHARED_TEST_VALUE, READ_CONNECTIONS_SHARED_TEST_VALUE_2);
    }

    public void testSetReadConnectionsMin() throws Exception {
        this.verifyModelInitialized(READ_CONNECTIONS_MIN_KEY, READ_CONNECTIONS_MIN_TEST_VALUE);
        this.verifySetProperty(READ_CONNECTIONS_MIN_KEY, READ_CONNECTIONS_MIN_TEST_VALUE, READ_CONNECTIONS_MIN_TEST_VALUE_2);
    }

    public void testAddRemoveReadConnectionsMin() throws Exception {
        this.verifyAddRemoveProperty(READ_CONNECTIONS_MIN_KEY, READ_CONNECTIONS_MIN_TEST_VALUE, READ_CONNECTIONS_MIN_TEST_VALUE_2);
    }

    public void testSetReadConnectionsMax() throws Exception {
        this.verifyModelInitialized(READ_CONNECTIONS_MAX_KEY, READ_CONNECTIONS_MAX_TEST_VALUE);
        this.verifySetProperty(READ_CONNECTIONS_MAX_KEY, READ_CONNECTIONS_MAX_TEST_VALUE, READ_CONNECTIONS_MAX_TEST_VALUE_2);
    }

    public void testAddRemoveReadConnectionsMax() throws Exception {
        this.verifyAddRemoveProperty(READ_CONNECTIONS_MAX_KEY, READ_CONNECTIONS_MAX_TEST_VALUE, READ_CONNECTIONS_MAX_TEST_VALUE_2);
    }

    public void testSetWriteConnectionsMin() throws Exception {
        this.verifyModelInitialized(WRITE_CONNECTIONS_MIN_KEY, WRITE_CONNECTIONS_MIN_TEST_VALUE);
        this.verifySetProperty(WRITE_CONNECTIONS_MIN_KEY, WRITE_CONNECTIONS_MIN_TEST_VALUE, WRITE_CONNECTIONS_MIN_TEST_VALUE_2);
    }

    public void testAddRemoveWriteConnectionsMin() throws Exception {
        this.verifyAddRemoveProperty(WRITE_CONNECTIONS_MIN_KEY, WRITE_CONNECTIONS_MIN_TEST_VALUE, WRITE_CONNECTIONS_MIN_TEST_VALUE_2);
    }

    public void testSetWriteConnectionsMax() throws Exception {
        this.verifyModelInitialized(WRITE_CONNECTIONS_MAX_KEY, WRITE_CONNECTIONS_MAX_TEST_VALUE);
        this.verifySetProperty(WRITE_CONNECTIONS_MAX_KEY, WRITE_CONNECTIONS_MAX_TEST_VALUE, WRITE_CONNECTIONS_MAX_TEST_VALUE_2);
    }

    public void testAddRemoveWriteConnectionsMax() throws Exception {
        this.verifyAddRemoveProperty(WRITE_CONNECTIONS_MAX_KEY, WRITE_CONNECTIONS_MAX_TEST_VALUE, WRITE_CONNECTIONS_MAX_TEST_VALUE_2);
    }

    protected synchronized void setProperty(String propertyName, Object newValue) throws Exception {
        if (propertyName.equals("transactionTypeProperty")) {
            this.connection.setTransactionType((PersistenceUnitTransactionType)newValue);
        } else if (propertyName.equals("jtaDataSourceProperty")) {
            this.connection.setJtaDataSource((String)newValue);
        } else if (propertyName.equals("nonJtaDataSourceProperty")) {
            this.connection.setNonJtaDataSource((String)newValue);
        } else if (propertyName.equals("nativeSqlProperty")) {
            this.connection.setNativeSql((Boolean)newValue);
        } else if (propertyName.equals("batchWritingProperty")) {
            this.connection.setBatchWriting((BatchWriting)newValue);
        } else if (propertyName.equals("cacheStatementsProperty")) {
            this.connection.setCacheStatements((Boolean)newValue);
        } else if (propertyName.equals("cacheStatementsSizeProperty")) {
            this.connection.setCacheStatementsSize((Integer)newValue);
        } else if (propertyName.equals("driverProperty")) {
            this.connection.setDriver((String)newValue);
        } else if (propertyName.equals("urlProperty")) {
            this.connection.setUrl((String)newValue);
        } else if (propertyName.equals("userProperty")) {
            this.connection.setUser((String)newValue);
        } else if (propertyName.equals("passwordProperty")) {
            this.connection.setPassword((String)newValue);
        } else if (propertyName.equals("bindParametersProperty")) {
            this.connection.setBindParameters((Boolean)newValue);
        } else if (propertyName.equals("readConnectionsSharedProperty")) {
            this.connection.setReadConnectionsShared((Boolean)newValue);
        } else if (propertyName.equals("readConnectionsMinProperty")) {
            this.connection.setReadConnectionsMin((Integer)newValue);
        } else if (propertyName.equals("readConnectionsMaxProperty")) {
            this.connection.setReadConnectionsMax((Integer)newValue);
        } else if (propertyName.equals("writeConnectionsMinProperty")) {
            this.connection.setWriteConnectionsMin((Integer)newValue);
        } else if (propertyName.equals("writeConnectionsMaxProperty")) {
            this.connection.setWriteConnectionsMax((Integer)newValue);
        } else {
            this.throwMissingDefinition("setProperty", propertyName);
        }
    }

    protected Object getProperty(String propertyName) throws NoSuchFieldException {
        Object modelValue = null;
        if (propertyName.equals("transactionTypeProperty")) {
            modelValue = this.connection.getTransactionType();
        } else if (propertyName.equals("jtaDataSourceProperty")) {
            modelValue = this.connection.getJtaDataSource();
        } else if (propertyName.equals("nonJtaDataSourceProperty")) {
            modelValue = this.connection.getNonJtaDataSource();
        } else if (propertyName.equals("nativeSqlProperty")) {
            modelValue = this.connection.getNativeSql();
        } else if (propertyName.equals("batchWritingProperty")) {
            modelValue = this.connection.getBatchWriting();
        } else if (propertyName.equals("cacheStatementsProperty")) {
            modelValue = this.connection.getCacheStatements();
        } else if (propertyName.equals("cacheStatementsSizeProperty")) {
            modelValue = this.connection.getCacheStatementsSize();
        } else if (propertyName.equals("driverProperty")) {
            modelValue = this.connection.getDriver();
        } else if (propertyName.equals("urlProperty")) {
            modelValue = this.connection.getUrl();
        } else if (propertyName.equals("userProperty")) {
            modelValue = this.connection.getUser();
        } else if (propertyName.equals("passwordProperty")) {
            modelValue = this.connection.getPassword();
        } else if (propertyName.equals("bindParametersProperty")) {
            modelValue = this.connection.getBindParameters();
        } else if (propertyName.equals("readConnectionsSharedProperty")) {
            modelValue = this.connection.getReadConnectionsShared();
        } else if (propertyName.equals("readConnectionsMinProperty")) {
            modelValue = this.connection.getReadConnectionsMin();
        } else if (propertyName.equals("readConnectionsMaxProperty")) {
            modelValue = this.connection.getReadConnectionsMax();
        } else if (propertyName.equals("writeConnectionsMinProperty")) {
            modelValue = this.connection.getWriteConnectionsMin();
        } else if (propertyName.equals("writeConnectionsMaxProperty")) {
            modelValue = this.connection.getWriteConnectionsMax();
        } else {
            this.throwMissingDefinition("getProperty", propertyName);
        }
        return modelValue;
    }

    protected Object getPersistenceUnitProperty(String propertyName) throws NoSuchFieldException {
        if (propertyName.equals("transactionTypeProperty")) {
            return this.persistenceUnit().getSpecifiedTransactionType();
        }
        if (propertyName.equals("jtaDataSourceProperty")) {
            return this.persistenceUnit().getJtaDataSource();
        }
        if (propertyName.equals("nonJtaDataSourceProperty")) {
            return this.persistenceUnit().getNonJtaDataSource();
        }
        this.throwMissingDefinition("getPersistenceUnitProperty", propertyName);
        return null;
    }

    protected void setPersistenceUnitProperty(String propertyName, Object newValue) throws NoSuchFieldException {
        if (propertyName.equals("transactionTypeProperty")) {
            this.persistenceUnit().setSpecifiedTransactionType((PersistenceUnitTransactionType)newValue);
        } else if (propertyName.equals("jtaDataSourceProperty")) {
            this.persistenceUnit().setJtaDataSource((String)newValue);
        } else if (propertyName.equals("nonJtaDataSourceProperty")) {
            this.persistenceUnit().setNonJtaDataSource((String)newValue);
        } else {
            this.throwMissingDefinition("setPersistenceUnitProperty", propertyName);
        }
    }

    protected PersistenceUnitProperties model() {
        return this.connection;
    }
}

