/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.persistence.customization;

import java.util.ListIterator;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.context.persistence.Property;
import org.eclipse.jpt.core.internal.context.persistence.GenericProperty;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.PersistenceUnitProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.PersistenceUnitPropertyListListener;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.customization.Customization;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.customization.CustomizerProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.customization.EclipseLinkCustomization;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.customization.Profiler;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.customization.Weaving;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.persistence.PersistenceUnitTestCase;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.ListValueModel;

public class CustomizationAdapterTests
extends PersistenceUnitTestCase {
    private Customization customization;
    private ListChangeEvent entitiesEvent;
    private ListChangeEvent sessionCustomizersEvent;
    public static final String ENTITY_TEST = "Employee";
    public static final String ENTITY_TEST_2 = "Address";
    public static final String THROW_EXCEPTIONS_KEY = "eclipselink.orm.throw.exceptions";
    public static final Boolean THROW_EXCEPTIONS_TEST_VALUE = false;
    public static final Boolean THROW_EXCEPTIONS_TEST_VALUE_2 = THROW_EXCEPTIONS_TEST_VALUE == false;
    public static final String WEAVING_LAZY_KEY = "eclipselink.weaving.lazy";
    public static final Boolean WEAVING_LAZY_TEST_VALUE = false;
    public static final Boolean WEAVING_LAZY_TEST_VALUE_2 = WEAVING_LAZY_TEST_VALUE == false;
    public static final String WEAVING_CHANGE_TRACKING_KEY = "eclipselink.weaving.changetracking";
    public static final Boolean WEAVING_CHANGE_TRACKING_TEST_VALUE = false;
    public static final Boolean WEAVING_CHANGE_TRACKING_TEST_VALUE_2 = WEAVING_CHANGE_TRACKING_TEST_VALUE == false;
    public static final String WEAVING_FETCH_GROUPS_KEY = "eclipselink.weaving.fetchgroups";
    public static final Boolean WEAVING_FETCH_GROUPS_TEST_VALUE = false;
    public static final Boolean WEAVING_FETCH_GROUPS_TEST_VALUE_2 = WEAVING_FETCH_GROUPS_TEST_VALUE == false;
    public static final String WEAVING_INTERNAL_KEY = "eclipselink.weaving.internal";
    public static final Boolean WEAVING_INTERNAL_TEST_VALUE = false;
    public static final Boolean WEAVING_INTERNAL_TEST_VALUE_2 = WEAVING_INTERNAL_TEST_VALUE == false;
    public static final String WEAVING_EAGER_KEY = "eclipselink.weaving.eager";
    public static final Boolean WEAVING_EAGER_TEST_VALUE = true;
    public static final Boolean WEAVING_EAGER_TEST_VALUE_2 = WEAVING_EAGER_TEST_VALUE == false;
    private static final String SESSION_CUSTOMIZER_KEY = "eclipselink.session.customizer";
    private static final String SESSION_CUSTOMIZER_TEST_VALUE = "java.lang.String";
    private static final String SESSION_CUSTOMIZER_TEST_VALUE_2 = "java.lang.Boolean";
    public static final String WEAVING_KEY = "eclipselink.weaving";
    public static final Weaving WEAVING_TEST_VALUE = Weaving.false_;
    public static final Weaving WEAVING_TEST_VALUE_2 = Weaving.static_;
    public static final String CUSTOMIZER_KEY = "eclipselink.descriptor.customizer.Employee";
    public static final String CUSTOMIZER_TEST_VALUE = "acme.sessions.DescriptorCustomizer";
    public static final String CUSTOMIZER_TEST_VALUE_2 = "acme.sessions.Customizer";
    private static final String PROFILER_KEY = "eclipselink.profiler";
    private static final Profiler PROFILER_TEST_VALUE = Profiler.query_monitor;
    private static final String PROFILER_TEST_VALUE_2 = "custom.profiler.test";

    public CustomizationAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.customization = this.subject.getCustomization();
        PropertyChangeListener propertyChangeListener = this.buildPropertyChangeListener();
        this.customization.addPropertyChangeListener("throwExceptionsProperty", propertyChangeListener);
        this.customization.addPropertyChangeListener("weavingLazyProperty", propertyChangeListener);
        this.customization.addPropertyChangeListener("weavingChangeTrackingProperty", propertyChangeListener);
        this.customization.addPropertyChangeListener("weavingFetchGroupsProperty", propertyChangeListener);
        this.customization.addPropertyChangeListener("weavingInternalProperty", propertyChangeListener);
        this.customization.addPropertyChangeListener("weavingEagerProperty", propertyChangeListener);
        this.customization.addPropertyChangeListener("weavingProperty", propertyChangeListener);
        this.customization.addPropertyChangeListener("descriptorCustomizerProperty", propertyChangeListener);
        this.customization.addPropertyChangeListener("sessionCustomizerProperty", propertyChangeListener);
        this.customization.addPropertyChangeListener("profilerProperty", propertyChangeListener);
        ListChangeListener sessionCustomizersChangeListener = this.buildSessionCustomizersChangeListener();
        this.customization.addListChangeListener("sessionCustomizerListProperty", sessionCustomizersChangeListener);
        ListChangeListener entitiesChangeListener = this.buildEntitiesChangeListener();
        this.customization.addListChangeListener("entitiesListProperty", entitiesChangeListener);
        this.clearEvent();
    }

    protected void populatePu() {
        this.modelPropertiesSizeOriginal = 10;
        this.propertiesTotal = this.modelPropertiesSizeOriginal + 4;
        this.modelPropertiesSize = this.modelPropertiesSizeOriginal;
        this.persistenceUnitPut("misc.property.1", "value.1");
        this.persistenceUnitPut(THROW_EXCEPTIONS_KEY, THROW_EXCEPTIONS_TEST_VALUE.toString());
        this.persistenceUnitPut(WEAVING_LAZY_KEY, WEAVING_LAZY_TEST_VALUE.toString());
        this.persistenceUnitPut(WEAVING_CHANGE_TRACKING_KEY, WEAVING_CHANGE_TRACKING_TEST_VALUE.toString());
        this.persistenceUnitPut(WEAVING_FETCH_GROUPS_KEY, WEAVING_FETCH_GROUPS_TEST_VALUE.toString());
        this.persistenceUnitPut(WEAVING_INTERNAL_KEY, WEAVING_INTERNAL_TEST_VALUE.toString());
        this.persistenceUnitPut(WEAVING_EAGER_KEY, WEAVING_EAGER_TEST_VALUE.toString());
        this.persistenceUnitPut("misc.property.2", "value.2");
        this.persistenceUnitPut(SESSION_CUSTOMIZER_KEY, SESSION_CUSTOMIZER_TEST_VALUE.toString());
        this.persistenceUnitPut(WEAVING_KEY, WEAVING_TEST_VALUE);
        this.persistenceUnitPut("misc.property.3", "value.3");
        this.persistenceUnitPut("misc.property.4", "value.4");
        this.persistenceUnitPut(CUSTOMIZER_KEY, CUSTOMIZER_TEST_VALUE);
        this.persistenceUnitPut(PROFILER_KEY, PROFILER_TEST_VALUE);
    }

    private ListChangeListener buildEntitiesChangeListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent e) {
                CustomizationAdapterTests.this.throwUnsupportedOperationException(e);
            }

            public void itemsRemoved(ListChangeEvent e) {
                CustomizationAdapterTests.this.throwUnsupportedOperationException(e);
            }

            public void itemsReplaced(ListChangeEvent e) {
                CustomizationAdapterTests.this.throwUnsupportedOperationException(e);
            }

            public void itemsMoved(ListChangeEvent e) {
                CustomizationAdapterTests.this.throwUnsupportedOperationException(e);
            }

            public void listCleared(ListChangeEvent e) {
                CustomizationAdapterTests.this.throwUnsupportedOperationException(e);
            }

            public void listChanged(ListChangeEvent e) {
                CustomizationAdapterTests.this.entityChanged(e);
            }
        };
    }

    private ListChangeListener buildSessionCustomizersChangeListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent e) {
                CustomizationAdapterTests.this.throwUnsupportedOperationException(e);
            }

            public void itemsRemoved(ListChangeEvent e) {
                CustomizationAdapterTests.this.throwUnsupportedOperationException(e);
            }

            public void itemsReplaced(ListChangeEvent e) {
                CustomizationAdapterTests.this.throwUnsupportedOperationException(e);
            }

            public void itemsMoved(ListChangeEvent e) {
                CustomizationAdapterTests.this.throwUnsupportedOperationException(e);
            }

            public void listCleared(ListChangeEvent e) {
                CustomizationAdapterTests.this.throwUnsupportedOperationException(e);
            }

            public void listChanged(ListChangeEvent e) {
                CustomizationAdapterTests.this.sessionCustomizerChanged(e);
            }
        };
    }

    protected void clearEvent() {
        super.clearEvent();
        this.entitiesEvent = null;
        this.sessionCustomizersEvent = null;
    }

    void entityChanged(ListChangeEvent e) {
        this.entitiesEvent = e;
    }

    void sessionCustomizerChanged(ListChangeEvent e) {
        this.sessionCustomizersEvent = e;
    }

    public void testEntitiesList() throws Exception {
        this.clearEvent();
        this.customization.addEntity(ENTITY_TEST_2);
        CustomizationAdapterTests.assertNotNull((String)"No Event Fired.", (Object)this.entitiesEvent);
        CustomizationAdapterTests.assertEquals((String)"Wrong Event.", (String)this.entitiesEvent.getAspectName(), (String)"entitiesListProperty");
        this.clearEvent();
        this.customization.removeEntity(ENTITY_TEST_2);
        CustomizationAdapterTests.assertNotNull((String)"No Event Fired.", (Object)this.entitiesEvent);
        CustomizationAdapterTests.assertEquals((String)"Wrong Event.", (String)this.entitiesEvent.getAspectName(), (String)"entitiesListProperty");
    }

    public void testSessionCustomizersList() throws Exception {
        this.clearEvent();
        ClassRef classRef = this.customization.addSessionCustomizer(SESSION_CUSTOMIZER_TEST_VALUE_2);
        CustomizationAdapterTests.assertNotNull((String)"No Event Fired.", (Object)this.sessionCustomizersEvent);
        CustomizationAdapterTests.assertEquals((String)"Wrong Event.", (String)this.sessionCustomizersEvent.getAspectName(), (String)"sessionCustomizerListProperty");
        this.clearEvent();
        this.customization.removeSessionCustomizer(classRef);
        CustomizationAdapterTests.assertNotNull((String)"No Event Fired.", (Object)this.sessionCustomizersEvent);
        CustomizationAdapterTests.assertEquals((String)"Wrong Event.", (String)this.sessionCustomizersEvent.getAspectName(), (String)"sessionCustomizerListProperty");
    }

    public void testHasListeners() throws Exception {
        ListAspectAdapter propertiesAdapter = (ListAspectAdapter)this.subject.getPropertiesAdapter();
        GenericProperty ctdProperty = (GenericProperty)this.persistenceUnit().getProperty(THROW_EXCEPTIONS_KEY);
        ListValueModel propertyListAdapter = this.subject.getPropertyListAdapter();
        CustomizationAdapterTests.assertTrue((boolean)propertiesAdapter.hasAnyListChangeListeners("list values"));
        CustomizationAdapterTests.assertTrue((boolean)ctdProperty.hasAnyPropertyChangeListeners("value"));
        this.verifyHasListeners((PersistenceUnitProperties)this.customization, "throwExceptionsProperty");
        this.verifyHasListeners((PersistenceUnitProperties)this.customization, "weavingLazyProperty");
        this.verifyHasListeners((PersistenceUnitProperties)this.customization, "weavingChangeTrackingProperty");
        this.verifyHasListeners((PersistenceUnitProperties)this.customization, "weavingFetchGroupsProperty");
        this.verifyHasListeners(propertyListAdapter);
        EclipseLinkCustomization elCustomization = (EclipseLinkCustomization)this.customization;
        PersistenceUnitPropertyListListener propertyListListener = elCustomization.propertyListListener();
        propertyListAdapter.removeListChangeListener("list values", (ListChangeListener)propertyListListener);
        CustomizationAdapterTests.assertTrue((boolean)propertiesAdapter.hasAnyListChangeListeners("list values"));
        this.verifyHasListeners((PersistenceUnitProperties)this.customization, "throwExceptionsProperty");
        this.verifyHasListeners((PersistenceUnitProperties)this.customization, "weavingLazyProperty");
        this.verifyHasListeners((PersistenceUnitProperties)this.customization, "weavingChangeTrackingProperty");
        this.verifyHasListeners((PersistenceUnitProperties)this.customization, "weavingFetchGroupsProperty");
    }

    public void testSetThrowExceptions() throws Exception {
        this.verifyModelInitialized(THROW_EXCEPTIONS_KEY, THROW_EXCEPTIONS_TEST_VALUE);
        this.verifySetProperty(THROW_EXCEPTIONS_KEY, THROW_EXCEPTIONS_TEST_VALUE, THROW_EXCEPTIONS_TEST_VALUE_2);
    }

    public void testAddRemoveThrowExceptions() throws Exception {
        this.verifyAddRemoveProperty(THROW_EXCEPTIONS_KEY, THROW_EXCEPTIONS_TEST_VALUE, THROW_EXCEPTIONS_TEST_VALUE_2);
    }

    public void testSetWeavingLazy() throws Exception {
        this.verifyModelInitialized(WEAVING_LAZY_KEY, WEAVING_LAZY_TEST_VALUE);
        this.verifySetProperty(WEAVING_LAZY_KEY, WEAVING_LAZY_TEST_VALUE, WEAVING_LAZY_TEST_VALUE_2);
    }

    public void testAddRemoveWeavingLazy() throws Exception {
        this.verifyAddRemoveProperty(WEAVING_LAZY_KEY, WEAVING_LAZY_TEST_VALUE, WEAVING_LAZY_TEST_VALUE_2);
    }

    public void testSetWeavingChangeTracking() throws Exception {
        this.verifyModelInitialized(WEAVING_CHANGE_TRACKING_KEY, WEAVING_CHANGE_TRACKING_TEST_VALUE);
        this.verifySetProperty(WEAVING_CHANGE_TRACKING_KEY, WEAVING_CHANGE_TRACKING_TEST_VALUE, WEAVING_CHANGE_TRACKING_TEST_VALUE_2);
    }

    public void testAddRemoveWeavingChangeTracking() throws Exception {
        this.verifyAddRemoveProperty(WEAVING_CHANGE_TRACKING_KEY, WEAVING_CHANGE_TRACKING_TEST_VALUE, WEAVING_CHANGE_TRACKING_TEST_VALUE_2);
    }

    public void testSetWeavingFetchGroups() throws Exception {
        this.verifyModelInitialized(WEAVING_FETCH_GROUPS_KEY, WEAVING_FETCH_GROUPS_TEST_VALUE);
        this.verifySetProperty(WEAVING_FETCH_GROUPS_KEY, WEAVING_FETCH_GROUPS_TEST_VALUE, WEAVING_FETCH_GROUPS_TEST_VALUE_2);
    }

    public void testAddRemoveWeavingFetchGroups() throws Exception {
        this.verifyAddRemoveProperty(WEAVING_FETCH_GROUPS_KEY, WEAVING_FETCH_GROUPS_TEST_VALUE, WEAVING_FETCH_GROUPS_TEST_VALUE_2);
    }

    public void testSetWeavingInternal() throws Exception {
        this.verifyModelInitialized(WEAVING_INTERNAL_KEY, WEAVING_INTERNAL_TEST_VALUE);
        this.verifySetProperty(WEAVING_INTERNAL_KEY, WEAVING_INTERNAL_TEST_VALUE, WEAVING_INTERNAL_TEST_VALUE_2);
    }

    public void testAddRemoveWeavingInternal() throws Exception {
        this.verifyAddRemoveProperty(WEAVING_INTERNAL_KEY, WEAVING_INTERNAL_TEST_VALUE, WEAVING_INTERNAL_TEST_VALUE_2);
    }

    public void testSetWeavingEager() throws Exception {
        this.verifyModelInitialized(WEAVING_EAGER_KEY, WEAVING_EAGER_TEST_VALUE);
        this.verifySetProperty(WEAVING_EAGER_KEY, WEAVING_EAGER_TEST_VALUE, WEAVING_EAGER_TEST_VALUE_2);
    }

    public void testAddRemoveWeavingEager() throws Exception {
        this.verifyAddRemoveProperty(WEAVING_EAGER_KEY, WEAVING_EAGER_TEST_VALUE, WEAVING_EAGER_TEST_VALUE_2);
    }

    public void testSetSessionCustomizer() throws Exception {
        this.verifyModelInitialized(SESSION_CUSTOMIZER_KEY, SESSION_CUSTOMIZER_TEST_VALUE);
        this.verifySetSessionCustomizationProperty("sessionCustomizerProperty", SESSION_CUSTOMIZER_KEY, SESSION_CUSTOMIZER_TEST_VALUE, SESSION_CUSTOMIZER_TEST_VALUE_2);
    }

    public void testAddRemoveSessionCustomizer() throws Exception {
        this.verifyAddRemoveSessionCustomizationProperty("sessionCustomizerProperty", SESSION_CUSTOMIZER_KEY, SESSION_CUSTOMIZER_TEST_VALUE, SESSION_CUSTOMIZER_TEST_VALUE_2);
    }

    public void testSetWeaving() throws Exception {
        this.verifyModelInitialized(WEAVING_KEY, WEAVING_TEST_VALUE);
        this.verifySetProperty(WEAVING_KEY, WEAVING_TEST_VALUE, WEAVING_TEST_VALUE_2);
    }

    public void testAddRemoveWeaving() throws Exception {
        this.verifyAddRemoveProperty(WEAVING_KEY, WEAVING_TEST_VALUE, WEAVING_TEST_VALUE_2);
    }

    public void testSetCustomization() throws Exception {
        this.verifyModelInitialized(CUSTOMIZER_KEY, CUSTOMIZER_TEST_VALUE);
        this.verifySetCustomizationProperty("descriptorCustomizerProperty", CUSTOMIZER_KEY, CUSTOMIZER_TEST_VALUE, CUSTOMIZER_TEST_VALUE_2);
    }

    public void testAddRemoveCustomization() throws Exception {
        this.verifyAddRemoveCustomizationProperty("descriptorCustomizerProperty", CUSTOMIZER_KEY, CUSTOMIZER_TEST_VALUE, CUSTOMIZER_TEST_VALUE_2);
    }

    public void testSetProfiler() throws Exception {
        this.verifyModelInitialized(PROFILER_KEY, this.getEclipseLinkStringValueOf(PROFILER_TEST_VALUE));
        this.verifySetProperty(PROFILER_KEY, PROFILER_TEST_VALUE, PROFILER_TEST_VALUE_2);
        this.verifySetProfiler(PROFILER_KEY, PROFILER_TEST_VALUE, PROFILER_TEST_VALUE_2);
    }

    public void testAddRemoveProfiler() throws Exception {
        this.verifyAddRemoveProperty(PROFILER_KEY, PROFILER_TEST_VALUE, PROFILER_TEST_VALUE_2);
    }

    protected void verifySetProfiler(String elKey, Object testValue1, Object testValue2) throws Exception {
        Property property = this.persistenceUnit().getProperty(elKey);
        String propertyName = this.model().propertyIdFor(property);
        this.clearEvent();
        this.setProperty(propertyName, testValue2);
        this.verifyPutProperty(propertyName, testValue2);
        this.clearEvent();
        this.customization.setProfiler(null);
        CustomizationAdapterTests.assertFalse((boolean)this.persistenceUnit().containsProperty(elKey));
        this.verifyPutProperty(propertyName, null);
        this.clearEvent();
        this.setProperty(propertyName, testValue1.toString());
        CustomizationAdapterTests.assertTrue((boolean)this.persistenceUnit().containsProperty(elKey));
        this.verifyPutProperty(propertyName, this.getEclipseLinkStringValueOf(testValue1));
        this.clearEvent();
        this.customization.setProfiler(null);
        CustomizationAdapterTests.assertFalse((boolean)this.persistenceUnit().containsProperty(elKey));
        this.verifyPutProperty(propertyName, null);
    }

    protected void verifySetSessionCustomizationProperty(String propertyName, String key, Object testValue1, Object testValue2) throws Exception {
        ListValueModel propertyListAdapter = this.subject.getPropertyListAdapter();
        this.verifyInitialState(propertyName, key, (ListValueModel<Property>)propertyListAdapter);
        this.persistenceUnitPut(key, testValue2, true);
        ++this.propertiesTotal;
        CustomizationAdapterTests.assertEquals((int)this.propertiesTotal, (int)propertyListAdapter.size());
        this.verifyPutSessionCustomizerProperty(propertyName, testValue1);
    }

    protected void verifyAddRemoveSessionCustomizationProperty(String propertyName, String key, Object testValue1, Object testValue2) throws Exception {
        ListValueModel propertyListAdapter = this.subject.getPropertyListAdapter();
        this.clearEvent();
        --this.propertiesTotal;
        --this.modelPropertiesSize;
        this.persistenceUnit().removeProperty(key, (String)testValue1);
        CustomizationAdapterTests.assertFalse((boolean)this.customization.sessionCustomizerExists(key));
        CustomizationAdapterTests.assertEquals((int)this.modelPropertiesSize, (int)(this.modelPropertiesSizeOriginal - 1));
        CustomizationAdapterTests.assertEquals((int)this.propertiesTotal, (int)propertyListAdapter.size());
        ++this.propertiesTotal;
        ++this.modelPropertiesSize;
        this.persistenceUnitPut(key, testValue1, true);
        this.verifyPutSessionCustomizerProperty(propertyName, testValue1);
        CustomizationAdapterTests.assertEquals((int)this.propertiesTotal, (int)propertyListAdapter.size());
    }

    protected void verifyPutSessionCustomizerProperty(String propertyName, Object expectedValue) throws Exception {
        CustomizationAdapterTests.assertNotNull((String)"No Event Fired.", (Object)this.sessionCustomizersEvent);
        this.verifySessionCustomizerEvent(propertyName, expectedValue);
    }

    protected void verifySessionCustomizerEvent(String propertyName, Object expectedValue) throws Exception {
        EclipseLinkCustomization customization = (EclipseLinkCustomization)this.sessionCustomizersEvent.getSource();
        CustomizationAdapterTests.assertTrue((boolean)customization.sessionCustomizerExists((String)expectedValue));
    }

    protected void verifySetCustomizationProperty(String propertyName, String key, Object testValue1, Object testValue2) throws Exception {
        ListValueModel propertyListAdapter = this.subject.getPropertyListAdapter();
        this.verifyInitialState(propertyName, key, (ListValueModel<Property>)propertyListAdapter);
        this.persistenceUnitPut(key, testValue2);
        CustomizationAdapterTests.assertEquals((int)this.propertiesTotal, (int)propertyListAdapter.size());
        this.verifyPutCustomizationProperty(propertyName, ENTITY_TEST, testValue2);
        this.clearEvent();
        this.setCustomizationProperty(propertyName, ENTITY_TEST, testValue1);
        CustomizationAdapterTests.assertEquals((int)this.propertiesTotal, (int)propertyListAdapter.size());
        this.verifyPutCustomizationProperty(propertyName, ENTITY_TEST, testValue1);
    }

    protected void verifyAddRemoveCustomizationProperty(String propertyName, String key, Object testValue1, Object testValue2) throws Exception {
        ListValueModel propertyListAdapter = this.subject.getPropertyListAdapter();
        this.clearEvent();
        --this.propertiesTotal;
        --this.modelPropertiesSize;
        this.persistenceUnit().removeProperty(key);
        CustomizationAdapterTests.assertFalse((boolean)this.persistenceUnit().containsProperty(key));
        CustomizationAdapterTests.assertEquals((int)this.modelPropertiesSize, (int)(this.modelPropertiesSizeOriginal - 1));
        this.verifyPutCustomizationProperty(propertyName, ENTITY_TEST, null);
        CustomizationAdapterTests.assertEquals((int)this.propertiesTotal, (int)propertyListAdapter.size());
        ++this.propertiesTotal;
        ++this.modelPropertiesSize;
        this.persistenceUnitPut(key, testValue1);
        this.verifyPutCustomizationProperty(propertyName, ENTITY_TEST, testValue1);
        CustomizationAdapterTests.assertEquals((int)this.propertiesTotal, (int)propertyListAdapter.size());
        this.persistenceUnitPut(key, testValue2);
        this.verifyPutCustomizationProperty(propertyName, ENTITY_TEST, testValue2);
    }

    protected void verifyPutCustomizationProperty(String propertyName, String entityName, Object expectedValue) throws Exception {
        this.verifyEvent(propertyName);
        this.verifyCustomizationEvent(propertyName, entityName, expectedValue);
    }

    protected void verifyCustomizationEvent(String propertyName, String entityName, Object expectedValue) throws Exception {
        CustomizerProperties customizer = (CustomizerProperties)this.propertyChangedEvent.getNewValue();
        if (propertyName.equals("descriptorCustomizerProperty")) {
            CustomizationAdapterTests.assertEquals((Object)expectedValue, (Object)customizer.getClassName());
            CustomizationAdapterTests.assertEquals((Object)expectedValue, (Object)this.customization.getDescriptorCustomizer(entityName));
        } else {
            this.throwMissingDefinition("verifyCustomizationEvent", propertyName);
        }
    }

    protected void setCustomizationProperty(String propertyName, String entityName, Object newValue) throws NoSuchFieldException {
        if (propertyName.equals("descriptorCustomizerProperty")) {
            this.customization.setDescriptorCustomizer((String)newValue, entityName);
        } else {
            this.throwMissingDefinition("setCustomizationProperty", propertyName);
        }
    }

    protected void setProperty(String propertyName, Object newValue) throws Exception {
        if (propertyName.equals("throwExceptionsProperty")) {
            this.customization.setThrowExceptions((Boolean)newValue);
        } else if (propertyName.equals("weavingLazyProperty")) {
            this.customization.setWeavingLazy((Boolean)newValue);
        } else if (propertyName.equals("weavingChangeTrackingProperty")) {
            this.customization.setWeavingChangeTracking((Boolean)newValue);
        } else if (propertyName.equals("weavingFetchGroupsProperty")) {
            this.customization.setWeavingFetchGroups((Boolean)newValue);
        } else if (propertyName.equals("weavingInternalProperty")) {
            this.customization.setWeavingInternal((Boolean)newValue);
        } else if (propertyName.equals("weavingEagerProperty")) {
            this.customization.setWeavingEager((Boolean)newValue);
        } else if (propertyName.equals("sessionCustomizerProperty")) {
            this.customization.addSessionCustomizer((String)newValue);
        } else if (propertyName.equals("weavingProperty")) {
            this.customization.setWeaving((Weaving)newValue);
        } else if (propertyName.equals("profilerProperty")) {
            if (newValue.getClass().isEnum()) {
                this.customization.setProfiler((Profiler)newValue);
            } else {
                this.customization.setProfiler((String)newValue);
            }
        } else {
            this.throwMissingDefinition("setProperty", propertyName);
        }
    }

    protected Object getProperty(String propertyName) throws NoSuchFieldException {
        Object modelValue = null;
        if (propertyName.equals("throwExceptionsProperty")) {
            modelValue = this.customization.getThrowExceptions();
        } else if (propertyName.equals("weavingProperty")) {
            modelValue = this.customization.getWeaving();
        } else if (propertyName.equals("weavingLazyProperty")) {
            modelValue = this.customization.getWeavingLazy();
        } else if (propertyName.equals("weavingChangeTrackingProperty")) {
            modelValue = this.customization.getWeavingChangeTracking();
        } else if (propertyName.equals("weavingFetchGroupsProperty")) {
            modelValue = this.customization.getWeavingFetchGroups();
        } else if (propertyName.equals("weavingInternalProperty")) {
            modelValue = this.customization.getWeavingInternal();
        } else if (propertyName.equals("weavingEagerProperty")) {
            modelValue = this.customization.getWeavingEager();
        } else if (propertyName.equals("profilerProperty")) {
            modelValue = this.customization.getProfiler();
        } else if (propertyName.equals("sessionCustomizerProperty")) {
            ListIterator iterator = this.customization.sessionCustomizers();
            if (iterator.hasNext()) {
                modelValue = ((ClassRef)iterator.next()).getClassName();
            }
        } else if (propertyName.equals("descriptorCustomizerProperty")) {
            modelValue = this.customization.getDescriptorCustomizer(ENTITY_TEST);
        } else {
            this.throwMissingDefinition("getProperty", propertyName);
        }
        return modelValue;
    }

    protected void verifyPutProperty(String propertyName, Object expectedValue) throws Exception {
        Object expectedValue_ = expectedValue;
        if (propertyName.equals("profilerProperty")) {
            expectedValue_ = expectedValue != null && expectedValue.getClass().isEnum() ? this.getEclipseLinkStringValueOf(PROFILER_TEST_VALUE) : expectedValue;
        }
        super.verifyPutProperty(propertyName, expectedValue_);
    }

    protected PersistenceUnitProperties model() {
        return this.customization;
    }
}

