/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.persistence.customization;

import org.eclipse.jpt.eclipselink.core.internal.context.persistence.PersistenceUnitProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.customization.Customization;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.persistence.PersistenceUnitTestCase;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizationValueModelTests
extends PersistenceUnitTestCase {
    private Customization customization;
    private WritablePropertyValueModel<Boolean> throwExceptionsHolder;
    private PropertyChangeListener throwExceptionsListener;
    private PropertyChangeEvent throwExceptionsEvent;
    public static final String ENTITY_NAME_TEST_VALUE = "Employee";
    public static final Boolean THROW_EXCEPTIONS_TEST_VALUE = Boolean.FALSE;

    public CustomizationValueModelTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.customization = this.subject.getCustomization();
        SimplePropertyValueModel customizationHolder = new SimplePropertyValueModel((Object)this.customization);
        this.throwExceptionsHolder = this.buildThrowExceptionsAA((PropertyValueModel<Customization>)customizationHolder);
        this.throwExceptionsListener = this.buildThrowExceptionsChangeListener();
        this.throwExceptionsHolder.addPropertyChangeListener("value", this.throwExceptionsListener);
        this.throwExceptionsEvent = null;
    }

    public void testHasListeners() {
        AbstractModel subjectCustomization = (AbstractModel)this.customization;
        PropertyAspectAdapter throwExceptionsAA = (PropertyAspectAdapter)this.throwExceptionsHolder;
        CustomizationValueModelTests.assertTrue((boolean)throwExceptionsAA.hasAnyPropertyChangeListeners("value"));
        CustomizationValueModelTests.assertTrue((boolean)subjectCustomization.hasAnyPropertyChangeListeners("throwExceptionsProperty"));
        throwExceptionsAA.removePropertyChangeListener("value", this.throwExceptionsListener);
        CustomizationValueModelTests.assertFalse((boolean)subjectCustomization.hasAnyPropertyChangeListeners("throwExceptionsProperty"));
        CustomizationValueModelTests.assertFalse((boolean)throwExceptionsAA.hasAnyPropertyChangeListeners("value"));
    }

    @Override
    protected void populatePu() {
        this.persistenceUnitPut("eclipselink.orm.throw.exceptions", THROW_EXCEPTIONS_TEST_VALUE);
    }

    @Override
    protected PersistenceUnitProperties model() {
        return this.customization;
    }

    private WritablePropertyValueModel<Boolean> buildThrowExceptionsAA(PropertyValueModel<Customization> subjectHolder) {
        return new PropertyAspectAdapter<Customization, Boolean>(subjectHolder, new String[]{"throwExceptionsProperty"}){

            protected Boolean buildValue_() {
                return ((Customization)this.subject).getThrowExceptions();
            }

            protected void setValue_(Boolean enumValue) {
                ((Customization)this.subject).setThrowExceptions(enumValue);
            }
        };
    }

    private PropertyChangeListener buildThrowExceptionsChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                CustomizationValueModelTests.this.throwExceptionsEvent = e;
            }
        };
    }

    public void testValue() {
        this.verifyThrowExceptionsAAValue(THROW_EXCEPTIONS_TEST_VALUE);
        CustomizationValueModelTests.assertEquals((Object)Customization.DEFAULT_THROW_EXCEPTIONS, (Object)this.customization.getDefaultThrowExceptions());
    }

    public void testSetValue() throws Exception {
        this.throwExceptionsEvent = null;
        this.verifyHasListeners((PropertyValueModel)this.throwExceptionsHolder, "value");
        Boolean newThrowExceptions = THROW_EXCEPTIONS_TEST_VALUE == false;
        this.throwExceptionsHolder.setValue((Object)newThrowExceptions);
        this.verifyThrowExceptionsAAValue(newThrowExceptions);
        CustomizationValueModelTests.assertNotNull((Object)this.throwExceptionsEvent);
    }

    public void testSetNullValue() {
        String notDeleted = "Property not deleted";
        this.throwExceptionsEvent = null;
        this.throwExceptionsHolder.setValue(null);
        this.verifyThrowExceptionsAAValue(null);
        CustomizationValueModelTests.assertNotNull((Object)this.throwExceptionsEvent);
        this.verifyPuHasNotProperty("eclipselink.orm.throw.exceptions", notDeleted);
    }

    protected void verifyThrowExceptionsAAValue(Boolean testValue) {
        this.verifyAAValue(testValue, this.customization.getThrowExceptions(), this.throwExceptionsHolder, "eclipselink.orm.throw.exceptions");
    }

    @Override
    protected void setProperty(String propertyName, Object newValue) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Object getProperty(String propertyName) throws NoSuchFieldException {
        throw new UnsupportedOperationException();
    }
}

