/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.persistence.logging;

import org.eclipse.jpt.eclipselink.core.internal.context.persistence.PersistenceUnitProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.logging.Logging;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.persistence.PersistenceUnitTestCase;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingValueModelTests
extends PersistenceUnitTestCase {
    private Logging logging;
    private WritablePropertyValueModel<Boolean> timestampHolder;
    private PropertyChangeListener timestampListener;
    private PropertyChangeEvent timestampEvent;
    public static final Boolean TIMESTAMP_TEST_VALUE = Boolean.FALSE;

    public LoggingValueModelTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.logging = this.subject.getLogging();
        SimplePropertyValueModel loggingHolder = new SimplePropertyValueModel((Object)this.logging);
        this.timestampHolder = this.buildTimestampAA((PropertyValueModel<Logging>)loggingHolder);
        this.timestampListener = this.buildTimestampChangeListener();
        this.timestampHolder.addPropertyChangeListener("value", this.timestampListener);
        this.timestampEvent = null;
    }

    public void testHasListeners() {
        AbstractModel subjectLogging = (AbstractModel)this.logging;
        PropertyAspectAdapter timestampAA = (PropertyAspectAdapter)this.timestampHolder;
        LoggingValueModelTests.assertTrue((boolean)timestampAA.hasAnyPropertyChangeListeners("value"));
        LoggingValueModelTests.assertTrue((boolean)subjectLogging.hasAnyPropertyChangeListeners("timestampProperty"));
        timestampAA.removePropertyChangeListener("value", this.timestampListener);
        LoggingValueModelTests.assertFalse((boolean)subjectLogging.hasAnyPropertyChangeListeners("timestampProperty"));
        LoggingValueModelTests.assertFalse((boolean)timestampAA.hasAnyPropertyChangeListeners("value"));
    }

    @Override
    protected void populatePu() {
        this.persistenceUnitPut("eclipselink.logging.timestamp", TIMESTAMP_TEST_VALUE);
    }

    @Override
    protected PersistenceUnitProperties model() {
        return this.logging;
    }

    private WritablePropertyValueModel<Boolean> buildTimestampAA(PropertyValueModel<Logging> subjectHolder) {
        return new PropertyAspectAdapter<Logging, Boolean>(subjectHolder, new String[]{"timestampProperty"}){

            protected Boolean buildValue_() {
                return ((Logging)this.subject).getTimestamp();
            }

            protected void setValue_(Boolean enumValue) {
                ((Logging)this.subject).setTimestamp(enumValue);
            }
        };
    }

    private PropertyChangeListener buildTimestampChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                LoggingValueModelTests.this.timestampEvent = e;
            }
        };
    }

    public void testValue() {
        this.verifyTimestampAAValue(TIMESTAMP_TEST_VALUE);
        LoggingValueModelTests.assertEquals((Object)Logging.DEFAULT_TIMESTAMP, (Object)this.logging.getDefaultTimestamp());
    }

    public void testSetValue() throws Exception {
        this.timestampEvent = null;
        this.verifyHasListeners((PropertyValueModel)this.timestampHolder, "value");
        Boolean newTimestamp = TIMESTAMP_TEST_VALUE == false;
        this.timestampHolder.setValue((Object)newTimestamp);
        this.verifyTimestampAAValue(newTimestamp);
        LoggingValueModelTests.assertNotNull((Object)this.timestampEvent);
    }

    public void testSetNullValue() {
        String notDeleted = "Property not deleted";
        this.timestampEvent = null;
        this.timestampHolder.setValue(null);
        this.verifyTimestampAAValue(null);
        LoggingValueModelTests.assertNotNull((Object)this.timestampEvent);
        this.verifyPuHasNotProperty("eclipselink.logging.timestamp", notDeleted);
    }

    protected void verifyTimestampAAValue(Boolean testValue) {
        this.verifyAAValue(testValue, this.logging.getTimestamp(), this.timestampHolder, "eclipselink.logging.timestamp");
    }

    @Override
    protected void setProperty(String propertyName, Object newValue) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Object getProperty(String propertyName) throws NoSuchFieldException {
        throw new UnsupportedOperationException();
    }
}

