/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.resource.java.JoinFetchAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.JoinFetchType;
import org.eclipse.jpt.eclipselink.core.tests.internal.resource.java.EclipseLinkJavaResourceModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JoinFetchTests
extends EclipseLinkJavaResourceModelTestCase {
    public JoinFetchTests(String name) {
        super(name);
    }

    private void createJoinFetchTypeEnum() throws Exception {
        this.createEnumAndMembers("JoinFetchType", "INNER, OUTER;");
    }

    private void createJoinFetchAnnotation() throws Exception {
        this.createAnnotationAndMembers("JoinFetch", "JoinFetchType value() default INNER;");
        this.createJoinFetchTypeEnum();
    }

    private ICompilationUnit createTestJoinFetch() throws Exception {
        this.createJoinFetchAnnotation();
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.JoinFetch", "org.eclipse.persistence.annotations.JoinFetchType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@JoinFetch");
            }
        });
    }

    private ICompilationUnit createTestJoinFetchWithValue() throws Exception {
        this.createJoinFetchAnnotation();
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.JoinFetch", "org.eclipse.persistence.annotations.JoinFetchType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@JoinFetch(JoinFetchType.OUTER)");
            }
        });
    }

    public void testJoinFetch() throws Exception {
        ICompilationUnit cu = this.createTestJoinFetch();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinFetchAnnotation joinFetch = (JoinFetchAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.JoinFetch");
        JoinFetchTests.assertNotNull((Object)joinFetch);
    }

    public void testGetValue() throws Exception {
        ICompilationUnit cu = this.createTestJoinFetchWithValue();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinFetchAnnotation joinFetch = (JoinFetchAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.JoinFetch");
        JoinFetchTests.assertEquals((Object)JoinFetchType.OUTER, (Object)joinFetch.getValue());
    }

    public void testSetValue() throws Exception {
        ICompilationUnit cu = this.createTestJoinFetchWithValue();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinFetchAnnotation joinFetch = (JoinFetchAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.JoinFetch");
        JoinFetchTests.assertEquals((Object)JoinFetchType.OUTER, (Object)joinFetch.getValue());
        joinFetch.setValue(JoinFetchType.INNER);
        JoinFetchTests.assertEquals((Object)JoinFetchType.INNER, (Object)joinFetch.getValue());
        this.assertSourceContains("@JoinFetch(INNER)", cu);
        joinFetch.setValue(null);
        JoinFetchTests.assertNull((Object)joinFetch.getValue());
        this.assertSourceDoesNotContain("(INNER)", cu);
        this.assertSourceContains("@JoinFetch", cu);
        this.assertSourceDoesNotContain("@JoinFetch(", cu);
    }
}

