/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.resource.orm;

import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jpt.core.tests.internal.projects.TestJpaProject;
import org.eclipse.jpt.eclipselink.core.internal.resource.orm.EclipseLinkOrmResourceModelProvider;
import org.eclipse.jpt.eclipselink.core.resource.orm.EclipseLinkOrmResource;

public class EclipseLinkOrmResourceModelTests
extends TestCase {
    static final String BASE_PROJECT_NAME = EclipseLinkOrmResourceModelTests.class.getSimpleName();
    TestJpaProject jpaProject;

    public EclipseLinkOrmResourceModelTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.jpaProject = TestJpaProject.buildJpaProject((String)BASE_PROJECT_NAME, (boolean)false);
    }

    protected void createFile() throws CoreException {
        EclipseLinkOrmResourceModelProvider modelProvider = EclipseLinkOrmResourceModelProvider.getDefaultModelProvider((IProject)this.jpaProject.getProject());
        modelProvider.createResource();
    }

    protected void tearDown() throws Exception {
        this.jpaProject.getProject().delete(true, true, null);
        this.jpaProject = null;
        super.tearDown();
    }

    public void testModelLoad() {
        EclipseLinkOrmResourceModelProvider modelProvider = EclipseLinkOrmResourceModelProvider.getDefaultModelProvider((IProject)this.jpaProject.getProject());
        EclipseLinkOrmResourceModelTests.assertNotNull((Object)modelProvider);
        EclipseLinkOrmResource resource = (EclipseLinkOrmResource)modelProvider.getResource();
        EclipseLinkOrmResourceModelTests.assertNotNull((Object)resource);
    }

    public void testModelLoad2() {
        EclipseLinkOrmResourceModelProvider modelProvider = EclipseLinkOrmResourceModelProvider.getDefaultModelProvider((IProject)this.jpaProject.getProject());
        EclipseLinkOrmResourceModelTests.assertNotNull((Object)modelProvider);
        EclipseLinkOrmResource resource = (EclipseLinkOrmResource)modelProvider.getResource();
        EclipseLinkOrmResourceModelTests.assertNotNull((Object)resource);
    }

    public void testModelLoadForDifferentlyNamedOrmXml() {
        EclipseLinkOrmResourceModelProvider modelProvider = EclipseLinkOrmResourceModelProvider.getModelProvider((IProject)this.jpaProject.getProject(), (String)"META-INF/eclipselink-orm2.xml");
        EclipseLinkOrmResourceModelTests.assertNotNull((Object)modelProvider);
        EclipseLinkOrmResource resource = (EclipseLinkOrmResource)modelProvider.getResource();
        EclipseLinkOrmResourceModelTests.assertNotNull((Object)resource);
    }

    public void testCreateFile() throws CoreException {
        this.createFile();
        EclipseLinkOrmResourceModelProvider modelProvider = EclipseLinkOrmResourceModelProvider.getDefaultModelProvider((IProject)this.jpaProject.getProject());
        EclipseLinkOrmResourceModelTests.assertNotNull((Object)modelProvider);
        EclipseLinkOrmResource resource = (EclipseLinkOrmResource)modelProvider.getResource();
        EclipseLinkOrmResourceModelTests.assertNotNull((Object)resource);
        EclipseLinkOrmResourceModelTests.assertTrue((boolean)resource.exists());
    }
}

