/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.eclipselink.core.context.CacheCoordinationType;
import org.eclipse.jpt.eclipselink.core.context.CacheType;
import org.eclipse.jpt.eclipselink.core.context.ExistenceType;
import org.eclipse.jpt.eclipselink.core.context.ExpiryTimeOfDay;
import org.eclipse.jpt.eclipselink.core.context.java.JavaCaching;
import org.eclipse.jpt.eclipselink.core.internal.DefaultEclipseLinkJpaValidationMessages;
import org.eclipse.jpt.eclipselink.core.internal.context.java.EclipseLinkJavaExpiryTimeOfDay;
import org.eclipse.jpt.eclipselink.core.resource.java.CacheAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.ExistenceCheckingAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.TimeOfDayAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkJavaCaching
extends AbstractJavaJpaContextNode
implements JavaCaching {
    protected CacheType specifiedType;
    protected Integer specifiedSize;
    protected Boolean specifiedShared;
    protected Boolean specifiedAlwaysRefresh;
    protected Boolean specifiedRefreshOnlyIfNewer;
    protected Boolean specifiedDisableHits;
    protected boolean existenceChecking;
    protected ExistenceType specifiedExistenceType;
    protected ExistenceType defaultExistenceType;
    protected CacheCoordinationType specifiedCoordinationType;
    protected Integer expiry;
    protected EclipseLinkJavaExpiryTimeOfDay expiryTimeOfDay;
    protected JavaResourcePersistentType resourcePersistentType;

    public EclipseLinkJavaCaching(JavaTypeMapping parent) {
        super((JpaContextNode)parent);
    }

    public JavaTypeMapping getParent() {
        return (JavaTypeMapping)super.getParent();
    }

    protected CacheAnnotation getCacheAnnotation() {
        return (CacheAnnotation)this.resourcePersistentType.getNonNullSupportingAnnotation(this.getCacheAnnotationName());
    }

    protected ExistenceCheckingAnnotation getExistenceCheckingAnnotation() {
        return (ExistenceCheckingAnnotation)this.resourcePersistentType.getSupportingAnnotation(this.getExistenceCheckingAnnotationName());
    }

    protected String getCacheAnnotationName() {
        return "org.eclipse.persistence.annotations.Cache";
    }

    protected String getExistenceCheckingAnnotationName() {
        return "org.eclipse.persistence.annotations.ExistenceChecking";
    }

    @Override
    public CacheType getType() {
        return this.getSpecifiedType() == null ? this.getDefaultType() : this.getSpecifiedType();
    }

    @Override
    public CacheType getDefaultType() {
        return DEFAULT_TYPE;
    }

    @Override
    public CacheType getSpecifiedType() {
        return this.specifiedType;
    }

    @Override
    public void setSpecifiedType(CacheType newSpecifiedType) {
        CacheType oldSpecifiedType = this.specifiedType;
        this.specifiedType = newSpecifiedType;
        this.getCacheAnnotation().setType(CacheType.toJavaResourceModel(newSpecifiedType));
        this.firePropertyChanged("specifiedTypeProperty", (Object)oldSpecifiedType, (Object)newSpecifiedType);
    }

    protected void setSpecifiedType_(CacheType newSpecifiedType) {
        CacheType oldSpecifiedType = this.specifiedType;
        this.specifiedType = newSpecifiedType;
        this.firePropertyChanged("specifiedTypeProperty", (Object)oldSpecifiedType, (Object)newSpecifiedType);
    }

    @Override
    public int getSize() {
        return this.getSpecifiedSize() == null ? this.getDefaultSize() : this.getSpecifiedSize().intValue();
    }

    @Override
    public int getDefaultSize() {
        return 100;
    }

    @Override
    public Integer getSpecifiedSize() {
        return this.specifiedSize;
    }

    @Override
    public void setSpecifiedSize(Integer newSpecifiedSize) {
        Integer oldSpecifiedSize = this.specifiedSize;
        this.specifiedSize = newSpecifiedSize;
        this.getCacheAnnotation().setSize(newSpecifiedSize);
        this.firePropertyChanged("spcifiedSizeProperty", oldSpecifiedSize, newSpecifiedSize);
    }

    protected void setSpecifiedSize_(Integer newSpecifiedSize) {
        Integer oldSpecifiedSize = this.specifiedSize;
        this.specifiedSize = newSpecifiedSize;
        this.firePropertyChanged("spcifiedSizeProperty", oldSpecifiedSize, newSpecifiedSize);
    }

    @Override
    public boolean isShared() {
        return this.specifiedShared == null ? this.isDefaultShared() : this.specifiedShared.booleanValue();
    }

    @Override
    public boolean isDefaultShared() {
        return true;
    }

    @Override
    public Boolean getSpecifiedShared() {
        return this.specifiedShared;
    }

    @Override
    public void setSpecifiedShared(Boolean newSpecifiedShared) {
        Boolean oldShared = this.specifiedShared;
        this.specifiedShared = newSpecifiedShared;
        this.getCacheAnnotation().setShared(newSpecifiedShared);
        this.firePropertyChanged("specifiedSharedProperty", oldShared, newSpecifiedShared);
        if (newSpecifiedShared == Boolean.FALSE) {
            this.setSpecifiedType(null);
            this.setSpecifiedSize(null);
            this.setSpecifiedAlwaysRefresh(null);
            this.setSpecifiedRefreshOnlyIfNewer(null);
            this.setSpecifiedDisableHits(null);
            this.setSpecifiedCoordinationType(null);
            this.setExpiry(null);
            if (this.expiryTimeOfDay != null) {
                this.removeExpiryTimeOfDay();
            }
        }
    }

    protected void setSpecifiedShared_(Boolean newSpecifiedShared) {
        Boolean oldSpecifiedShared = this.specifiedShared;
        this.specifiedShared = newSpecifiedShared;
        this.firePropertyChanged("specifiedSharedProperty", oldSpecifiedShared, newSpecifiedShared);
    }

    @Override
    public boolean isAlwaysRefresh() {
        return this.specifiedAlwaysRefresh == null ? this.isDefaultAlwaysRefresh() : this.specifiedAlwaysRefresh.booleanValue();
    }

    @Override
    public boolean isDefaultAlwaysRefresh() {
        return false;
    }

    @Override
    public Boolean getSpecifiedAlwaysRefresh() {
        return this.specifiedAlwaysRefresh;
    }

    @Override
    public void setSpecifiedAlwaysRefresh(Boolean newSpecifiedAlwaysRefresh) {
        Boolean oldAlwaysRefresh = this.specifiedAlwaysRefresh;
        this.specifiedAlwaysRefresh = newSpecifiedAlwaysRefresh;
        this.getCacheAnnotation().setAlwaysRefresh(newSpecifiedAlwaysRefresh);
        this.firePropertyChanged("specifiedAlwaysRefreshProperty", oldAlwaysRefresh, newSpecifiedAlwaysRefresh);
    }

    protected void setSpecifiedAlwaysRefresh_(Boolean newSpecifiedAlwaysRefresh) {
        Boolean oldAlwaysRefresh = this.specifiedAlwaysRefresh;
        this.specifiedAlwaysRefresh = newSpecifiedAlwaysRefresh;
        this.firePropertyChanged("specifiedAlwaysRefreshProperty", oldAlwaysRefresh, newSpecifiedAlwaysRefresh);
    }

    @Override
    public boolean isRefreshOnlyIfNewer() {
        return this.specifiedRefreshOnlyIfNewer == null ? this.isDefaultRefreshOnlyIfNewer() : this.specifiedRefreshOnlyIfNewer.booleanValue();
    }

    @Override
    public boolean isDefaultRefreshOnlyIfNewer() {
        return false;
    }

    @Override
    public Boolean getSpecifiedRefreshOnlyIfNewer() {
        return this.specifiedRefreshOnlyIfNewer;
    }

    @Override
    public void setSpecifiedRefreshOnlyIfNewer(Boolean newSpecifiedRefreshOnlyIfNewer) {
        Boolean oldRefreshOnlyIfNewer = this.specifiedRefreshOnlyIfNewer;
        this.specifiedRefreshOnlyIfNewer = newSpecifiedRefreshOnlyIfNewer;
        this.getCacheAnnotation().setRefreshOnlyIfNewer(newSpecifiedRefreshOnlyIfNewer);
        this.firePropertyChanged("specifiedRefreshOnlyIfNewerProperty", oldRefreshOnlyIfNewer, newSpecifiedRefreshOnlyIfNewer);
    }

    protected void setSpecifiedRefreshOnlyIfNewer_(Boolean newSpecifiedRefreshOnlyIfNewer) {
        Boolean oldRefreshOnlyIfNewer = this.specifiedRefreshOnlyIfNewer;
        this.specifiedRefreshOnlyIfNewer = newSpecifiedRefreshOnlyIfNewer;
        this.firePropertyChanged("specifiedRefreshOnlyIfNewerProperty", oldRefreshOnlyIfNewer, newSpecifiedRefreshOnlyIfNewer);
    }

    @Override
    public boolean isDisableHits() {
        return this.specifiedDisableHits == null ? this.isDefaultDisableHits() : this.specifiedDisableHits.booleanValue();
    }

    @Override
    public boolean isDefaultDisableHits() {
        return false;
    }

    @Override
    public Boolean getSpecifiedDisableHits() {
        return this.specifiedDisableHits;
    }

    @Override
    public void setSpecifiedDisableHits(Boolean newSpecifiedDisableHits) {
        Boolean oldDisableHits = this.specifiedDisableHits;
        this.specifiedDisableHits = newSpecifiedDisableHits;
        this.getCacheAnnotation().setDisableHits(newSpecifiedDisableHits);
        this.firePropertyChanged("specifiedDisableHitsProperty", oldDisableHits, newSpecifiedDisableHits);
    }

    protected void setSpecifiedDisableHits_(Boolean newSpecifiedDisableHits) {
        Boolean oldDisableHits = this.specifiedDisableHits;
        this.specifiedDisableHits = newSpecifiedDisableHits;
        this.firePropertyChanged("specifiedDisableHitsProperty", oldDisableHits, newSpecifiedDisableHits);
    }

    @Override
    public CacheCoordinationType getCoordinationType() {
        return this.getSpecifiedCoordinationType() == null ? this.getDefaultCoordinationType() : this.getSpecifiedCoordinationType();
    }

    @Override
    public CacheCoordinationType getDefaultCoordinationType() {
        return DEFAULT_COORDINATION_TYPE;
    }

    @Override
    public CacheCoordinationType getSpecifiedCoordinationType() {
        return this.specifiedCoordinationType;
    }

    @Override
    public void setSpecifiedCoordinationType(CacheCoordinationType newSpecifiedCoordinationType) {
        CacheCoordinationType oldSpecifiedCoordinationType = this.specifiedCoordinationType;
        this.specifiedCoordinationType = newSpecifiedCoordinationType;
        this.getCacheAnnotation().setCoordinationType(CacheCoordinationType.toJavaResourceModel(newSpecifiedCoordinationType));
        this.firePropertyChanged("specifiedCoordinationTypeProperty", (Object)oldSpecifiedCoordinationType, (Object)newSpecifiedCoordinationType);
    }

    protected void setSpecifiedCoordinationType_(CacheCoordinationType newSpecifiedCoordinationType) {
        CacheCoordinationType oldSpecifiedCoordinationType = this.specifiedCoordinationType;
        this.specifiedCoordinationType = newSpecifiedCoordinationType;
        this.firePropertyChanged("specifiedCoordinationTypeProperty", (Object)oldSpecifiedCoordinationType, (Object)newSpecifiedCoordinationType);
    }

    @Override
    public boolean hasExistenceChecking() {
        return this.existenceChecking;
    }

    @Override
    public void setExistenceChecking(boolean newExistenceChecking) {
        boolean oldExistenceChecking = this.existenceChecking;
        this.existenceChecking = newExistenceChecking;
        if (newExistenceChecking) {
            this.resourcePersistentType.addSupportingAnnotation(this.getExistenceCheckingAnnotationName());
        } else {
            this.resourcePersistentType.removeSupportingAnnotation(this.getExistenceCheckingAnnotationName());
        }
        this.firePropertyChanged("existenceCheckingProperty", oldExistenceChecking, newExistenceChecking);
        this.setDefaultExistenceType(this.caclulateDefaultExistenceType());
    }

    protected void setExistenceChecking_(boolean newExistenceChecking) {
        boolean oldExistenceChecking = this.existenceChecking;
        this.existenceChecking = newExistenceChecking;
        this.firePropertyChanged("existenceCheckingProperty", oldExistenceChecking, newExistenceChecking);
    }

    protected ExistenceType caclulateDefaultExistenceType() {
        if (this.hasExistenceChecking()) {
            return ExistenceType.CHECK_CACHE;
        }
        return DEFAULT_EXISTENCE_TYPE;
    }

    @Override
    public ExistenceType getExistenceType() {
        return this.getSpecifiedExistenceType() == null ? this.getDefaultExistenceType() : this.getSpecifiedExistenceType();
    }

    @Override
    public ExistenceType getDefaultExistenceType() {
        return this.defaultExistenceType;
    }

    protected void setDefaultExistenceType(ExistenceType newDefaultExistenceType) {
        ExistenceType oldDefaultExistenceType = this.defaultExistenceType;
        this.defaultExistenceType = newDefaultExistenceType;
        this.firePropertyChanged("defaultExistenceTypeProperty", (Object)oldDefaultExistenceType, (Object)newDefaultExistenceType);
    }

    @Override
    public ExistenceType getSpecifiedExistenceType() {
        return this.specifiedExistenceType;
    }

    @Override
    public void setSpecifiedExistenceType(ExistenceType newSpecifiedExistenceType) {
        if (!this.hasExistenceChecking()) {
            if (newSpecifiedExistenceType != null) {
                this.setExistenceChecking(true);
            } else {
                return;
            }
        }
        ExistenceType oldSpecifiedExistenceType = this.specifiedExistenceType;
        this.specifiedExistenceType = newSpecifiedExistenceType;
        this.getExistenceCheckingAnnotation().setValue(ExistenceType.toJavaResourceModel(newSpecifiedExistenceType));
        this.firePropertyChanged("specifiedExistenceTypeProperty", (Object)oldSpecifiedExistenceType, (Object)newSpecifiedExistenceType);
    }

    protected void setSpecifiedExistenceType_(ExistenceType newSpecifiedExistenceType) {
        ExistenceType oldSpecifiedExistenceType = this.specifiedExistenceType;
        this.specifiedExistenceType = newSpecifiedExistenceType;
        this.firePropertyChanged("specifiedExistenceTypeProperty", (Object)oldSpecifiedExistenceType, (Object)newSpecifiedExistenceType);
    }

    @Override
    public Integer getExpiry() {
        return this.expiry;
    }

    @Override
    public void setExpiry(Integer newExpiry) {
        Integer oldExpiry = this.expiry;
        this.expiry = newExpiry;
        this.getCacheAnnotation().setExpiry(newExpiry);
        this.firePropertyChanged("expiryProperty", oldExpiry, newExpiry);
        if (newExpiry != null && this.expiryTimeOfDay != null) {
            this.removeExpiryTimeOfDay();
        }
    }

    protected void setExpiry_(Integer newExpiry) {
        Integer oldExpiry = this.expiry;
        this.expiry = newExpiry;
        this.firePropertyChanged("expiryProperty", oldExpiry, newExpiry);
    }

    @Override
    public ExpiryTimeOfDay getExpiryTimeOfDay() {
        return this.expiryTimeOfDay;
    }

    @Override
    public ExpiryTimeOfDay addExpiryTimeOfDay() {
        EclipseLinkJavaExpiryTimeOfDay newExpiryTimeOfDay;
        if (this.expiryTimeOfDay != null) {
            throw new IllegalStateException("expiryTimeOfDay already exists, use getExpiryTimeOfDay()");
        }
        if (this.resourcePersistentType.getSupportingAnnotation(this.getCacheAnnotationName()) == null) {
            this.resourcePersistentType.addSupportingAnnotation(this.getCacheAnnotationName());
        }
        this.expiryTimeOfDay = newExpiryTimeOfDay = new EclipseLinkJavaExpiryTimeOfDay(this);
        TimeOfDayAnnotation timeOfDayAnnotation = this.getCacheAnnotation().addExpiryTimeOfDay();
        newExpiryTimeOfDay.initialize(timeOfDayAnnotation);
        this.firePropertyChanged("expiryTimeOfDayProperty", null, newExpiryTimeOfDay);
        this.setExpiry(null);
        return newExpiryTimeOfDay;
    }

    @Override
    public void removeExpiryTimeOfDay() {
        if (this.expiryTimeOfDay == null) {
            throw new IllegalStateException("timeOfDayExpiry does not exist");
        }
        EclipseLinkJavaExpiryTimeOfDay oldExpiryTimeOfDay = this.expiryTimeOfDay;
        this.expiryTimeOfDay = null;
        this.getCacheAnnotation().removeExpiryTimeOfDay();
        this.firePropertyChanged("expiryTimeOfDayProperty", oldExpiryTimeOfDay, null);
    }

    protected void setExpiryTimeOfDay(EclipseLinkJavaExpiryTimeOfDay newExpiryTimeOfDay) {
        EclipseLinkJavaExpiryTimeOfDay oldExpiryTimeOfDay = this.expiryTimeOfDay;
        this.expiryTimeOfDay = newExpiryTimeOfDay;
        this.firePropertyChanged("expiryTimeOfDayProperty", oldExpiryTimeOfDay, newExpiryTimeOfDay);
    }

    @Override
    public void initialize(JavaResourcePersistentType resourcePersistentType) {
        this.resourcePersistentType = resourcePersistentType;
        this.initialize(this.getCacheAnnotation());
        this.initialize(this.getExistenceCheckingAnnotation());
    }

    protected void initialize(CacheAnnotation cache) {
        this.specifiedType = this.specifiedType(cache);
        this.specifiedSize = this.specifiedSize(cache);
        this.specifiedShared = this.specifiedShared(cache);
        this.specifiedAlwaysRefresh = this.specifiedAlwaysRefresh(cache);
        this.specifiedRefreshOnlyIfNewer = this.specifiedRefreshOnlyIfNewer(cache);
        this.specifiedDisableHits = this.specifiedDisableHits(cache);
        this.specifiedCoordinationType = this.specifiedCoordinationType(cache);
        this.initializeExpiry(cache);
    }

    protected void initialize(ExistenceCheckingAnnotation existenceChecking) {
        this.existenceChecking = existenceChecking != null;
        this.specifiedExistenceType = this.specifiedExistenceType(existenceChecking);
        this.defaultExistenceType = this.caclulateDefaultExistenceType();
    }

    protected void initializeExpiry(CacheAnnotation cache) {
        if (cache.getExpiryTimeOfDay() == null) {
            this.expiry = cache.getExpiry();
        } else if (cache.getExpiry() == null) {
            this.expiryTimeOfDay = new EclipseLinkJavaExpiryTimeOfDay(this);
            this.expiryTimeOfDay.initialize(cache.getExpiryTimeOfDay());
        }
    }

    @Override
    public void update(JavaResourcePersistentType resourcePersistentType) {
        this.resourcePersistentType = resourcePersistentType;
        this.update(this.getCacheAnnotation());
        this.update(this.getExistenceCheckingAnnotation());
        this.updateExpiry(this.getCacheAnnotation());
    }

    protected void update(CacheAnnotation cache) {
        this.setSpecifiedType_(this.specifiedType(cache));
        this.setSpecifiedSize_(this.specifiedSize(cache));
        this.setSpecifiedShared_(this.specifiedShared(cache));
        this.setSpecifiedAlwaysRefresh_(this.specifiedAlwaysRefresh(cache));
        this.setSpecifiedRefreshOnlyIfNewer_(this.specifiedRefreshOnlyIfNewer(cache));
        this.setSpecifiedDisableHits_(this.specifiedDisableHits(cache));
        this.setSpecifiedCoordinationType_(this.specifiedCoordinationType(cache));
    }

    protected void update(ExistenceCheckingAnnotation existenceChecking) {
        this.setExistenceChecking_(existenceChecking != null);
        this.setSpecifiedExistenceType_(this.specifiedExistenceType(existenceChecking));
        this.setDefaultExistenceType(this.caclulateDefaultExistenceType());
    }

    protected void updateExpiry(CacheAnnotation cache) {
        if (cache.getExpiryTimeOfDay() == null) {
            this.setExpiryTimeOfDay(null);
            this.setExpiry_(cache.getExpiry());
        } else if (this.expiryTimeOfDay != null) {
            this.expiryTimeOfDay.update(cache.getExpiryTimeOfDay());
        } else if (cache.getExpiry() == null) {
            this.setExpiryTimeOfDay(new EclipseLinkJavaExpiryTimeOfDay(this));
            this.expiryTimeOfDay.initialize(cache.getExpiryTimeOfDay());
        } else {
            this.setExpiryTimeOfDay(null);
        }
    }

    protected CacheType specifiedType(CacheAnnotation cache) {
        return CacheType.fromJavaResourceModel(cache.getType());
    }

    protected Integer specifiedSize(CacheAnnotation cache) {
        return cache.getSize();
    }

    protected Boolean specifiedShared(CacheAnnotation cache) {
        return cache.getShared();
    }

    protected Boolean specifiedAlwaysRefresh(CacheAnnotation cache) {
        return cache.getAlwaysRefresh();
    }

    protected Boolean specifiedRefreshOnlyIfNewer(CacheAnnotation cache) {
        return cache.getRefreshOnlyIfNewer();
    }

    protected Boolean specifiedDisableHits(CacheAnnotation cache) {
        return cache.getDisableHits();
    }

    protected CacheCoordinationType specifiedCoordinationType(CacheAnnotation cache) {
        return CacheCoordinationType.fromJavaResourceModel(cache.getCoordinationType());
    }

    protected Integer expiry(CacheAnnotation cache) {
        return cache.getExpiry();
    }

    protected ExistenceType specifiedExistenceType(ExistenceCheckingAnnotation existenceChecking) {
        if (existenceChecking == null) {
            return null;
        }
        return ExistenceType.fromJavaResourceModel(existenceChecking.getValue());
    }

    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getCacheAnnotation().getTextRange(astRoot);
        return textRange != null ? textRange : this.getParent().getValidationTextRange(astRoot);
    }

    public void validate(List<IMessage> messages, CompilationUnit astRoot) {
        super.validate(messages, astRoot);
        this.validateExpiry(messages, astRoot);
    }

    protected void validateExpiry(List<IMessage> messages, CompilationUnit astRoot) {
        CacheAnnotation cache = this.getCacheAnnotation();
        if (cache.getExpiry() != null && cache.getExpiryTimeOfDay() != null) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "CACHE_EXPIRY_AND_EXPIRY_TIME_OF_DAY_BOTH_SPECIFIED", new String[]{this.getParent().getPersistentType().getName()}, this, this.getValidationTextRange(astRoot)));
        }
    }
}

