/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.core.context.java.JavaConverter;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.eclipselink.core.context.Convert;
import org.eclipse.jpt.eclipselink.core.internal.context.java.EclipseLinkJavaConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.java.EclipseLinkJavaCustomConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.java.EclipseLinkJavaObjectTypeConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.java.EclipseLinkJavaStructConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.java.EclipseLinkJavaTypeConverter;
import org.eclipse.jpt.eclipselink.core.resource.java.ConvertAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkJavaConvert
extends AbstractJavaJpaContextNode
implements Convert,
JavaConverter {
    private String specifiedConverterName;
    private JavaResourcePersistentAttribute resourcePersistentAttribute;
    private EclipseLinkJavaConverter converter;

    public EclipseLinkJavaConvert(JavaAttributeMapping parent, JavaResourcePersistentAttribute jrpa) {
        super((JpaContextNode)parent);
        this.initialize(jrpa);
    }

    public JavaAttributeMapping getParent() {
        return (JavaAttributeMapping)super.getParent();
    }

    public String getType() {
        return "eclipseLinkConverter";
    }

    protected String getAnnotationName() {
        return "org.eclipse.persistence.annotations.Convert";
    }

    public void addToResourceModel() {
        this.resourcePersistentAttribute.addSupportingAnnotation(this.getAnnotationName());
    }

    public void removeFromResourceModel() {
        this.resourcePersistentAttribute.removeSupportingAnnotation(this.getAnnotationName());
        if (this.getConverter() != null) {
            this.resourcePersistentAttribute.removeSupportingAnnotation(this.getConverter().getAnnotationName());
        }
    }

    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getResourceConvert().getTextRange(astRoot);
    }

    protected ConvertAnnotation getResourceConvert() {
        return (ConvertAnnotation)this.resourcePersistentAttribute.getSupportingAnnotation(this.getAnnotationName());
    }

    @Override
    public String getConverterName() {
        return this.getSpecifiedConverterName() == null ? this.getDefaultConverterName() : this.getSpecifiedConverterName();
    }

    @Override
    public String getDefaultConverterName() {
        return "none";
    }

    @Override
    public String getSpecifiedConverterName() {
        return this.specifiedConverterName;
    }

    @Override
    public void setSpecifiedConverterName(String newSpecifiedConverterName) {
        String oldSpecifiedConverterName = this.specifiedConverterName;
        this.specifiedConverterName = newSpecifiedConverterName;
        this.getResourceConvert().setValue(newSpecifiedConverterName);
        this.firePropertyChanged("specifiedConverterNameProperty", oldSpecifiedConverterName, newSpecifiedConverterName);
    }

    protected void setSpecifiedConverterName_(String newSpecifiedConverterName) {
        String oldSpecifiedConverterName = this.specifiedConverterName;
        this.specifiedConverterName = newSpecifiedConverterName;
        this.firePropertyChanged("specifiedConverterNameProperty", oldSpecifiedConverterName, newSpecifiedConverterName);
    }

    @Override
    public EclipseLinkJavaConverter getConverter() {
        return this.converter;
    }

    protected String getConverterType() {
        if (this.converter == null) {
            return "noConverter";
        }
        return this.converter.getType();
    }

    @Override
    public void setConverter(String converterType) {
        if (this.getConverterType() == converterType) {
            return;
        }
        EclipseLinkJavaConverter oldConverter = this.converter;
        EclipseLinkJavaConverter newConverter = this.buildConverter(converterType);
        this.converter = null;
        if (oldConverter != null) {
            this.resourcePersistentAttribute.removeSupportingAnnotation(oldConverter.getAnnotationName());
        }
        this.converter = newConverter;
        if (newConverter != null) {
            this.resourcePersistentAttribute.addSupportingAnnotation(newConverter.getAnnotationName());
        }
        this.firePropertyChanged("converterProperty", oldConverter, newConverter);
    }

    protected void setConverter(EclipseLinkJavaConverter newConverter) {
        EclipseLinkJavaConverter oldConverter = this.converter;
        this.converter = newConverter;
        this.firePropertyChanged("converterProperty", oldConverter, newConverter);
    }

    protected void initialize(JavaResourcePersistentAttribute jrpa) {
        this.resourcePersistentAttribute = jrpa;
        this.specifiedConverterName = this.specifiedConverterName(this.getResourceConvert());
        this.converter = this.buildConverter(this.converterType(jrpa));
    }

    public void update(JavaResourcePersistentAttribute jrpa) {
        this.resourcePersistentAttribute = jrpa;
        this.setSpecifiedConverterName_(this.specifiedConverterName(this.getResourceConvert()));
        if (this.converterType(jrpa) == this.getConverterType()) {
            this.getConverter().update((JavaResourcePersistentMember)jrpa);
        } else {
            EclipseLinkJavaConverter javaConverter = this.buildConverter(this.converterType(jrpa));
            this.setConverter(javaConverter);
        }
    }

    protected String specifiedConverterName(ConvertAnnotation resourceConvert) {
        return resourceConvert == null ? null : resourceConvert.getValue();
    }

    protected EclipseLinkJavaConverter buildConverter(String converterType) {
        if (converterType == "noConverter") {
            return null;
        }
        if (converterType == "customConverter") {
            return new EclipseLinkJavaCustomConverter((JavaJpaContextNode)this, (JavaResourcePersistentMember)this.resourcePersistentAttribute);
        }
        if (converterType == "typeConverter") {
            return new EclipseLinkJavaTypeConverter((JavaJpaContextNode)this, (JavaResourcePersistentMember)this.resourcePersistentAttribute);
        }
        if (converterType == "objectTypeConverter") {
            return new EclipseLinkJavaObjectTypeConverter((JavaJpaContextNode)this, (JavaResourcePersistentMember)this.resourcePersistentAttribute);
        }
        if (converterType == "structConverter") {
            return new EclipseLinkJavaStructConverter((JavaJpaContextNode)this, (JavaResourcePersistentMember)this.resourcePersistentAttribute);
        }
        return null;
    }

    protected String converterType(JavaResourcePersistentAttribute jrpa) {
        if (jrpa.getSupportingAnnotation("org.eclipse.persistence.annotations.Converter") != null) {
            return "customConverter";
        }
        if (jrpa.getSupportingAnnotation("org.eclipse.persistence.annotations.TypeConverter") != null) {
            return "typeConverter";
        }
        if (jrpa.getSupportingAnnotation("org.eclipse.persistence.annotations.ObjectTypeConverter") != null) {
            return "objectTypeConverter";
        }
        if (jrpa.getSupportingAnnotation("org.eclipse.persistence.annotations.StructConverter") != null) {
            return "structConverter";
        }
        return null;
    }

    public void validate(List<IMessage> messages, CompilationUnit astRoot) {
        super.validate(messages, astRoot);
        if (this.getConverter() != null) {
            this.getConverter().validate(messages, astRoot);
        }
    }
}

