/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.eclipselink.core.context.JoinFetch;
import org.eclipse.jpt.eclipselink.core.context.JoinFetchType;
import org.eclipse.jpt.eclipselink.core.resource.java.JoinFetchAnnotation;

public class EclipseLinkJavaJoinFetch
extends AbstractJavaJpaContextNode
implements JoinFetch {
    protected JoinFetchType joinFetchValue;
    protected JavaResourcePersistentAttribute resourcePersistentAttribute;

    public EclipseLinkJavaJoinFetch(JavaAttributeMapping parent) {
        super((JpaContextNode)parent);
    }

    protected String getJoinFetchAnnotationName() {
        return "org.eclipse.persistence.annotations.JoinFetch";
    }

    protected JoinFetchAnnotation getResourceJoinFetch() {
        return (JoinFetchAnnotation)this.resourcePersistentAttribute.getSupportingAnnotation(this.getJoinFetchAnnotationName());
    }

    protected void addResourceJoinFetch() {
        this.resourcePersistentAttribute.addSupportingAnnotation(this.getJoinFetchAnnotationName());
    }

    protected void removeResourceJoinFetch() {
        this.resourcePersistentAttribute.removeSupportingAnnotation(this.getJoinFetchAnnotationName());
    }

    public JoinFetchType getValue() {
        return this.joinFetchValue;
    }

    protected JoinFetchType getDefaultValue() {
        return JoinFetch.DEFAULT_VALUE;
    }

    public void setValue(JoinFetchType newJoinFetchValue) {
        if (this.joinFetchValue == newJoinFetchValue) {
            return;
        }
        JoinFetchType oldJoinFetchValue = this.joinFetchValue;
        this.joinFetchValue = newJoinFetchValue;
        if (newJoinFetchValue != null) {
            if (this.getResourceJoinFetch() == null) {
                this.addResourceJoinFetch();
            }
            this.getResourceJoinFetch().setValue(JoinFetchType.toJavaResourceModel(newJoinFetchValue));
        } else if (this.getResourceJoinFetch() != null) {
            this.removeResourceJoinFetch();
        }
        this.firePropertyChanged("JoinFetch.valueProperty", (Object)oldJoinFetchValue, (Object)newJoinFetchValue);
    }

    protected void setValue_(JoinFetchType newJoinFetchValue) {
        JoinFetchType oldJoinFetchValue = this.joinFetchValue;
        this.joinFetchValue = newJoinFetchValue;
        this.firePropertyChanged("JoinFetch.valueProperty", (Object)oldJoinFetchValue, (Object)newJoinFetchValue);
    }

    public void initialize(JavaResourcePersistentAttribute jrpa) {
        this.resourcePersistentAttribute = jrpa;
        JoinFetchAnnotation resourceJoinFetch = this.getResourceJoinFetch();
        this.joinFetchValue = this.joinFetch(resourceJoinFetch);
    }

    public void update(JavaResourcePersistentAttribute jrpa) {
        this.resourcePersistentAttribute = jrpa;
        JoinFetchAnnotation resourceJoinFetch = this.getResourceJoinFetch();
        this.setValue_(this.joinFetch(resourceJoinFetch));
    }

    private JoinFetchType joinFetch(JoinFetchAnnotation resourceJoinFetch) {
        if (resourceJoinFetch == null) {
            return null;
        }
        if (resourceJoinFetch.getValue() == null) {
            return this.getDefaultValue();
        }
        return JoinFetchType.fromJavaResourceModel(resourceJoinFetch.getValue());
    }

    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        JoinFetchAnnotation resourceJoinFetch = this.getResourceJoinFetch();
        return resourceJoinFetch == null ? null : resourceJoinFetch.getTextRange(astRoot);
    }
}

