/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.orm;

import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.core.internal.context.AbstractXmlContextNode;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.eclipselink.core.context.ChangeTracking;
import org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType;
import org.eclipse.jpt.eclipselink.core.resource.orm.EclipseLinkOrmFactory;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlChangeTracking;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlChangeTrackingHolder;

public class EclipseLinkOrmChangeTracking
extends AbstractXmlContextNode
implements ChangeTracking {
    protected XmlChangeTrackingHolder resource;
    protected ChangeTrackingType defaultType;
    protected ChangeTrackingType specifiedType;

    public EclipseLinkOrmChangeTracking(OrmTypeMapping parent) {
        super((JpaContextNode)parent);
    }

    public ChangeTrackingType getType() {
        return this.getSpecifiedType() != null ? this.getSpecifiedType() : this.getDefaultType();
    }

    public ChangeTrackingType getDefaultType() {
        return this.defaultType;
    }

    protected void setDefaultType_(ChangeTrackingType newDefaultType) {
        ChangeTrackingType oldDefaultType = this.defaultType;
        this.defaultType = newDefaultType;
        this.firePropertyChanged("defaultTypeProperty", (Object)oldDefaultType, (Object)newDefaultType);
    }

    public ChangeTrackingType getSpecifiedType() {
        return this.specifiedType;
    }

    public void setSpecifiedType(ChangeTrackingType newSpecifiedType) {
        ChangeTrackingType oldSpecifiedType = this.specifiedType;
        this.specifiedType = newSpecifiedType;
        if (newSpecifiedType == null) {
            this.resource.setChangeTracking(null);
        } else {
            if (this.resource.getChangeTracking() == null) {
                this.resource.setChangeTracking(EclipseLinkOrmFactory.eINSTANCE.createXmlChangeTracking());
            }
            this.resource.getChangeTracking().setType(ChangeTrackingType.toOrmResourceModel(newSpecifiedType));
        }
        this.firePropertyChanged("specifiedTypeProperty", (Object)oldSpecifiedType, (Object)newSpecifiedType);
    }

    protected void setSpecifiedType_(ChangeTrackingType newSpecifiedType) {
        ChangeTrackingType oldSpecifiedType = this.specifiedType;
        this.specifiedType = newSpecifiedType;
        this.firePropertyChanged("specifiedTypeProperty", (Object)oldSpecifiedType, (Object)newSpecifiedType);
    }

    protected void initialize(XmlChangeTrackingHolder xmlChangeTrackingHolder, ChangeTracking javaChangeTracking) {
        this.resource = xmlChangeTrackingHolder;
        this.defaultType = this.calculateDefaultType(javaChangeTracking);
        this.specifiedType = this.calculateSpecifiedType(xmlChangeTrackingHolder);
    }

    protected void update(XmlChangeTrackingHolder xmlChangeTrackingHolder, ChangeTracking javaChangeTracking) {
        this.setDefaultType_(this.calculateDefaultType(javaChangeTracking));
        this.setSpecifiedType_(this.calculateSpecifiedType(xmlChangeTrackingHolder));
    }

    protected ChangeTrackingType calculateDefaultType(ChangeTracking javaChangeTracking) {
        return javaChangeTracking != null ? javaChangeTracking.getType() : ChangeTracking.DEFAULT_TYPE;
    }

    protected ChangeTrackingType calculateSpecifiedType(XmlChangeTrackingHolder xmlChangeTrackingHolder) {
        XmlChangeTracking xmlChangeTracking = xmlChangeTrackingHolder.getChangeTracking();
        return xmlChangeTracking != null ? ChangeTrackingType.fromOrmResourceModel(xmlChangeTracking.getType()) : null;
    }

    public TextRange getValidationTextRange() {
        return this.resource.getValidationTextRange();
    }
}

