/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.persistence.options;

import java.util.Map;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.Property;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.EclipseLinkPersistenceUnitProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.options.Options;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.options.TargetDatabase;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.options.TargetServer;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.value.ListValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkOptions
extends EclipseLinkPersistenceUnitProperties
implements Options {
    private String sessionName;
    private String sessionsXml;
    private Boolean includeDescriptorQueries;
    private String targetDatabase;
    private String targetServer;
    private String eventListener;
    private Boolean temporalMutable;

    public EclipseLinkOptions(PersistenceUnit parent, ListValueModel<Property> propertyListAdapter) {
        super(parent, propertyListAdapter);
    }

    @Override
    protected void initializeProperties() {
        this.sessionName = this.getStringValue("eclipselink.session-name");
        this.sessionsXml = this.getStringValue("eclipselink.sessions-xml");
        this.includeDescriptorQueries = this.getBooleanValue("eclipselink.session.include.descriptor.queries");
        this.targetDatabase = this.getTargetDatabaseFromPersistenceXml();
        this.targetServer = this.getTargetServerFromPersistenceXml();
        this.eventListener = this.getStringValue("eclipselink.session-event-listener");
        this.temporalMutable = this.getBooleanValue("eclipselink.temporal.mutable");
    }

    protected String getTargetDatabaseFromPersistenceXml() {
        TargetDatabase standardTargetDatabase = (TargetDatabase)this.getEnumValue("eclipselink.target-database", TargetDatabase.values());
        if (!this.getPersistenceUnit().containsProperty("eclipselink.target-database")) {
            return null;
        }
        if (standardTargetDatabase == null) {
            return this.getStringValue("eclipselink.target-database");
        }
        return EclipseLinkOptions.getEclipseLinkStringValueOf((Object)standardTargetDatabase);
    }

    protected String getTargetServerFromPersistenceXml() {
        TargetServer standardTargetServer = (TargetServer)this.getEnumValue("eclipselink.target-server", TargetServer.values());
        if (!this.getPersistenceUnit().containsProperty("eclipselink.target-server")) {
            return null;
        }
        if (standardTargetServer == null) {
            return this.getStringValue("eclipselink.target-server");
        }
        return EclipseLinkOptions.getEclipseLinkStringValueOf((Object)standardTargetServer);
    }

    @Override
    protected void addPropertyNames(Map<String, String> propertyNames) {
        propertyNames.put("eclipselink.session-name", "sessionNameProperty");
        propertyNames.put("eclipselink.sessions-xml", "sessionsXmlProperty");
        propertyNames.put("eclipselink.session.include.descriptor.queries", "includeDescriptorQueriesProperty");
        propertyNames.put("eclipselink.target-database", "targetDatabaseProperty");
        propertyNames.put("eclipselink.target-server", "targetServerProperty");
        propertyNames.put("eclipselink.session-event-listener", "eventListenerProperty");
        propertyNames.put("eclipselink.temporal.mutable", "temporalMutableProperty");
    }

    public void propertyChanged(PropertyChangeEvent event) {
        String aspectName = event.getAspectName();
        if (aspectName.equals("sessionNameProperty")) {
            this.sessionNameChanged(event);
        } else if (aspectName.equals("sessionsXmlProperty")) {
            this.sessionsXmlChanged(event);
        } else if (aspectName.equals("targetDatabaseProperty")) {
            this.targetDatabaseChanged(event);
        } else if (aspectName.equals("targetServerProperty")) {
            this.targetServerChanged(event);
        } else if (aspectName.equals("includeDescriptorQueriesProperty")) {
            this.includeDescriptorQueriesChanged(event);
        } else if (aspectName.equals("eventListenerProperty")) {
            this.eventListenerChanged(event);
        } else if (aspectName.equals("temporalMutableProperty")) {
            this.temporalMutableChanged(event);
        } else {
            throw new IllegalArgumentException("Illegal event received - property not applicable: " + aspectName);
        }
    }

    @Override
    public String getSessionName() {
        return this.sessionName;
    }

    @Override
    public void setSessionName(String newSessionName) {
        String old = this.sessionName;
        this.sessionName = newSessionName;
        this.putProperty("sessionNameProperty", newSessionName);
        this.firePropertyChanged("sessionNameProperty", old, newSessionName);
    }

    private void sessionNameChanged(PropertyChangeEvent event) {
        String newValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        String old = this.sessionName;
        this.sessionName = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public String getDefaultSessionName() {
        return "";
    }

    @Override
    public String getSessionsXml() {
        return this.sessionsXml;
    }

    @Override
    public void setSessionsXml(String newSessionsXml) {
        String old = this.sessionsXml;
        this.sessionsXml = newSessionsXml;
        this.putProperty("sessionsXmlProperty", newSessionsXml);
        this.firePropertyChanged("sessionsXmlProperty", old, newSessionsXml);
    }

    private void sessionsXmlChanged(PropertyChangeEvent event) {
        String newValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        String old = this.sessionsXml;
        this.sessionsXml = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public String getDefaultSessionsXml() {
        return "";
    }

    @Override
    public Boolean getIncludeDescriptorQueries() {
        return this.includeDescriptorQueries;
    }

    @Override
    public void setIncludeDescriptorQueries(Boolean newIncludeDescriptorQueries) {
        Boolean old = this.includeDescriptorQueries;
        this.includeDescriptorQueries = newIncludeDescriptorQueries;
        this.putProperty("includeDescriptorQueriesProperty", newIncludeDescriptorQueries);
        this.firePropertyChanged("includeDescriptorQueriesProperty", old, newIncludeDescriptorQueries);
    }

    private void includeDescriptorQueriesChanged(PropertyChangeEvent event) {
        String stringValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        Boolean newValue = EclipseLinkOptions.getBooleanValueOf(stringValue);
        Boolean old = this.includeDescriptorQueries;
        this.includeDescriptorQueries = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public Boolean getDefaultIncludeDescriptorQueries() {
        return DEFAULT_SESSION_INCLUDE_DESCRIPTOR_QUERIES;
    }

    @Override
    public String getTargetDatabase() {
        return this.targetDatabase;
    }

    @Override
    public void setTargetDatabase(TargetDatabase newTargetDatabase) {
        if (newTargetDatabase == null) {
            this.setTargetDatabase_(null);
            return;
        }
        this.setTargetDatabase_(EclipseLinkOptions.getEclipseLinkStringValueOf((Object)newTargetDatabase));
    }

    @Override
    public void setTargetDatabase(String newTargetDatabase) {
        if (newTargetDatabase == null) {
            this.setTargetDatabase_(null);
            return;
        }
        TargetDatabase customTargetDatabase = TargetDatabase.getTargetDatabaseFor(newTargetDatabase);
        if (customTargetDatabase == null) {
            this.setTargetDatabase_(newTargetDatabase);
        } else {
            this.setTargetDatabase(customTargetDatabase);
        }
    }

    private void setTargetDatabase_(String newTargetDatabase) {
        String old = this.targetDatabase;
        this.targetDatabase = newTargetDatabase;
        this.putProperty("targetDatabaseProperty", newTargetDatabase);
        this.firePropertyChanged("targetDatabaseProperty", old, newTargetDatabase);
    }

    private void targetDatabaseChanged(PropertyChangeEvent event) {
        String newValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        String old = this.targetDatabase;
        this.targetDatabase = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public String getDefaultTargetDatabase() {
        return DEFAULT_TARGET_DATABASE;
    }

    @Override
    public String getTargetServer() {
        return this.targetServer;
    }

    @Override
    public void setTargetServer(TargetServer newTargetServer) {
        if (newTargetServer == null) {
            this.setTargetServer_(null);
            return;
        }
        this.setTargetServer_(EclipseLinkOptions.getEclipseLinkStringValueOf((Object)newTargetServer));
    }

    @Override
    public void setTargetServer(String newTargetServer) {
        if (newTargetServer == null) {
            this.setTargetServer_(null);
            return;
        }
        TargetServer customTargetServer = TargetServer.getTargetServerFor(newTargetServer);
        if (customTargetServer == null) {
            this.setTargetServer_(newTargetServer);
        } else {
            this.setTargetServer(customTargetServer);
        }
    }

    private void setTargetServer_(String newTargetServer) {
        String old = this.targetServer;
        this.targetServer = newTargetServer;
        this.putProperty("targetServerProperty", newTargetServer);
        this.firePropertyChanged("targetServerProperty", old, newTargetServer);
    }

    private void targetServerChanged(PropertyChangeEvent event) {
        String newValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        String old = this.targetServer;
        this.targetServer = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public String getDefaultTargetServer() {
        return DEFAULT_TARGET_SERVER;
    }

    @Override
    public String getEventListener() {
        return this.eventListener;
    }

    @Override
    public void setEventListener(String newEventListener) {
        String old = this.eventListener;
        this.eventListener = newEventListener;
        this.putProperty("eventListenerProperty", newEventListener);
        this.firePropertyChanged("eventListenerProperty", old, newEventListener);
    }

    private void eventListenerChanged(PropertyChangeEvent event) {
        String newValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        String old = this.eventListener;
        this.eventListener = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public String getDefaultEventListener() {
        return DEFAULT_SESSION_EVENT_LISTENER;
    }

    @Override
    public Boolean getTemporalMutable() {
        return this.temporalMutable;
    }

    @Override
    public void setTemporalMutable(Boolean newTemporalMutable) {
        Boolean old = this.temporalMutable;
        this.temporalMutable = newTemporalMutable;
        this.putProperty("temporalMutableProperty", newTemporalMutable);
        this.firePropertyChanged("temporalMutableProperty", old, newTemporalMutable);
    }

    private void temporalMutableChanged(PropertyChangeEvent event) {
        String stringValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        Boolean newValue = EclipseLinkOptions.getBooleanValueOf(stringValue);
        Boolean old = this.temporalMutable;
        this.temporalMutable = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public Boolean getDefaultTemporalMutable() {
        return DEFAULT_TEMPORAL_MUTABLE;
    }
}

