/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.resource.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractResourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.BooleanExpressionConverter;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.NestedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.NumberIntegerExpressionConverter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.core.utility.jdt.Type;
import org.eclipse.jpt.eclipselink.core.internal.resource.java.NullCacheAnnotation;
import org.eclipse.jpt.eclipselink.core.internal.resource.java.TimeOfDayImpl;
import org.eclipse.jpt.eclipselink.core.resource.java.CacheAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.CacheCoordinationType;
import org.eclipse.jpt.eclipselink.core.resource.java.CacheType;
import org.eclipse.jpt.eclipselink.core.resource.java.TimeOfDayAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheImpl
extends AbstractResourceAnnotation<Type>
implements CacheAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.eclipse.persistence.annotations.Cache");
    private final AnnotationElementAdapter<String> typeAdapter;
    private final AnnotationElementAdapter<Integer> sizeAdapter;
    private final AnnotationElementAdapter<Boolean> sharedAdapter;
    private final AnnotationElementAdapter<Integer> expiryAdapter;
    private final AnnotationElementAdapter<Boolean> alwaysRefreshAdapter;
    private final AnnotationElementAdapter<Boolean> refreshOnlyIfNewerAdapter;
    private final AnnotationElementAdapter<Boolean> disableHitsAdapter;
    private final AnnotationElementAdapter<String> coordinationTypeAdapter;
    private final MemberAnnotationAdapter expiryTimeOfDayAdapter;
    private static final DeclarationAnnotationElementAdapter<String> TYPE_ADAPTER = CacheImpl.buildTypeAdapter();
    private static final DeclarationAnnotationElementAdapter<Integer> SIZE_ADAPTER = CacheImpl.buildSizeAdapter();
    private static final DeclarationAnnotationElementAdapter<Boolean> SHARED_ADAPTER = CacheImpl.buildSharedAdapter();
    private static final DeclarationAnnotationElementAdapter<Integer> EXPIRY_ADAPTER = CacheImpl.buildExpiryAdapter();
    private static final DeclarationAnnotationElementAdapter<Boolean> ALWAYS_REFRESH_ADAPTER = CacheImpl.buildAlwaysRefreshAdapter();
    private static final DeclarationAnnotationElementAdapter<Boolean> REFRESH_ONLY_IF_NEWER_ADAPTER = CacheImpl.buildRefreshOnlyIfNewerAdapter();
    private static final DeclarationAnnotationElementAdapter<Boolean> DISABLE_HITS_ADAPTER = CacheImpl.buildDisableHitsAdapter();
    private static final DeclarationAnnotationElementAdapter<String> COORDINATION_TYPE_ADAPTER = CacheImpl.buildCoordinationTypeAdapter();
    private static final NestedDeclarationAnnotationAdapter EXPIRY_TIME_OF_DAY_ADAPTER = CacheImpl.buildExpiryTimeOfDayAnnotationAdapter();
    private CacheType type;
    private Integer size;
    private Boolean shared;
    private Integer expiry;
    private TimeOfDayAnnotation expiryTimeOfDay;
    private Boolean alwaysRefresh;
    private Boolean refreshOnlyIfNewer;
    private Boolean disableHits;
    private CacheCoordinationType coordinationType;

    protected CacheImpl(JavaResourcePersistentType parent, Type type) {
        super((JavaResourceNode)parent, (Member)type, DECLARATION_ANNOTATION_ADAPTER);
        this.typeAdapter = new ShortCircuitAnnotationElementAdapter((Member)type, TYPE_ADAPTER);
        this.sizeAdapter = new ShortCircuitAnnotationElementAdapter((Member)type, SIZE_ADAPTER);
        this.sharedAdapter = new ShortCircuitAnnotationElementAdapter((Member)type, SHARED_ADAPTER);
        this.expiryAdapter = new ShortCircuitAnnotationElementAdapter((Member)type, EXPIRY_ADAPTER);
        this.alwaysRefreshAdapter = new ShortCircuitAnnotationElementAdapter((Member)type, ALWAYS_REFRESH_ADAPTER);
        this.refreshOnlyIfNewerAdapter = new ShortCircuitAnnotationElementAdapter((Member)type, REFRESH_ONLY_IF_NEWER_ADAPTER);
        this.disableHitsAdapter = new ShortCircuitAnnotationElementAdapter((Member)type, DISABLE_HITS_ADAPTER);
        this.coordinationTypeAdapter = new ShortCircuitAnnotationElementAdapter((Member)type, COORDINATION_TYPE_ADAPTER);
        this.expiryTimeOfDayAdapter = new MemberAnnotationAdapter((Member)type, (DeclarationAnnotationAdapter)EXPIRY_TIME_OF_DAY_ADAPTER);
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.Cache";
    }

    @Override
    public CacheType getType() {
        return this.type;
    }

    @Override
    public void setType(CacheType newType) {
        if (this.attributeValueHasNotChanged((Object)this.type, (Object)newType)) {
            return;
        }
        CacheType oldType = this.type;
        this.type = newType;
        this.typeAdapter.setValue((Object)CacheType.toJavaAnnotationValue(newType));
        this.firePropertyChanged("typeProperty", (Object)oldType, (Object)newType);
    }

    @Override
    public Integer getSize() {
        return this.size;
    }

    @Override
    public void setSize(Integer newSize) {
        if (this.attributeValueHasNotChanged(this.size, newSize)) {
            return;
        }
        Integer oldSize = this.size;
        this.size = newSize;
        this.sizeAdapter.setValue((Object)newSize);
        this.firePropertyChanged("sizeProperty", oldSize, newSize);
    }

    @Override
    public Boolean getShared() {
        return this.shared;
    }

    @Override
    public void setShared(Boolean newShared) {
        if (this.attributeValueHasNotChanged(this.shared, newShared)) {
            return;
        }
        Boolean oldShared = this.shared;
        this.shared = newShared;
        this.sharedAdapter.setValue((Object)newShared);
        this.firePropertyChanged("sharedProperty", oldShared, newShared);
    }

    @Override
    public Integer getExpiry() {
        return this.expiry;
    }

    @Override
    public void setExpiry(Integer newExpiry) {
        if (this.attributeValueHasNotChanged(this.expiry, newExpiry)) {
            return;
        }
        Integer oldExpiry = this.expiry;
        this.expiry = newExpiry;
        this.expiryAdapter.setValue((Object)newExpiry);
        this.firePropertyChanged("expiryProperty", oldExpiry, newExpiry);
    }

    @Override
    public TimeOfDayAnnotation getExpiryTimeOfDay() {
        return this.expiryTimeOfDay;
    }

    @Override
    public TimeOfDayAnnotation addExpiryTimeOfDay() {
        if (this.expiryTimeOfDay != null) {
            throw new IllegalStateException("ExpiryTimeOfDay element already exists");
        }
        this.expiryTimeOfDay = this.createTimeOfDayAnnotation();
        this.expiryTimeOfDayAdapter.newMarkerAnnotation();
        this.firePropertyChanged("expiryTimeOfDayProperty", null, this.expiryTimeOfDay);
        return this.expiryTimeOfDay;
    }

    @Override
    public void removeExpiryTimeOfDay() {
        if (this.expiryTimeOfDay == null) {
            throw new IllegalStateException("No expiryTimeOfDay element exists");
        }
        this.expiryTimeOfDay = null;
        this.expiryTimeOfDayAdapter.removeAnnotation();
        this.firePropertyChanged("expiryTimeOfDayProperty", this.expiryTimeOfDay, null);
    }

    protected void setExpiryTimeOfDay(TimeOfDayAnnotation newExpiryTimeOfDay) {
        TimeOfDayAnnotation oldExpiryTimeOfDay = this.expiryTimeOfDay;
        this.expiryTimeOfDay = newExpiryTimeOfDay;
        this.firePropertyChanged("expiryTimeOfDayProperty", oldExpiryTimeOfDay, newExpiryTimeOfDay);
    }

    @Override
    public Boolean getAlwaysRefresh() {
        return this.alwaysRefresh;
    }

    @Override
    public void setAlwaysRefresh(Boolean newAlwaysRefresh) {
        if (this.attributeValueHasNotChanged(this.alwaysRefresh, newAlwaysRefresh)) {
            return;
        }
        Boolean oldAlwaysRefresh = this.alwaysRefresh;
        this.alwaysRefresh = newAlwaysRefresh;
        this.alwaysRefreshAdapter.setValue((Object)newAlwaysRefresh);
        this.firePropertyChanged("alwaysRefreshProperty", oldAlwaysRefresh, newAlwaysRefresh);
    }

    @Override
    public Boolean getRefreshOnlyIfNewer() {
        return this.refreshOnlyIfNewer;
    }

    @Override
    public void setRefreshOnlyIfNewer(Boolean newRefreshOnlyIfNewer) {
        if (this.attributeValueHasNotChanged(this.refreshOnlyIfNewer, newRefreshOnlyIfNewer)) {
            return;
        }
        Boolean oldRefreshOnlyIfNewer = this.refreshOnlyIfNewer;
        this.refreshOnlyIfNewer = newRefreshOnlyIfNewer;
        this.refreshOnlyIfNewerAdapter.setValue((Object)newRefreshOnlyIfNewer);
        this.firePropertyChanged("refreshOnlyIfNewerProperty", oldRefreshOnlyIfNewer, newRefreshOnlyIfNewer);
    }

    @Override
    public Boolean getDisableHits() {
        return this.disableHits;
    }

    @Override
    public void setDisableHits(Boolean newDisableHits) {
        if (this.attributeValueHasNotChanged(this.disableHits, newDisableHits)) {
            return;
        }
        Boolean oldDisableHits = this.disableHits;
        this.disableHits = newDisableHits;
        this.disableHitsAdapter.setValue((Object)newDisableHits);
        this.firePropertyChanged("disableHitsProperty", oldDisableHits, newDisableHits);
    }

    @Override
    public CacheCoordinationType getCoordinationType() {
        return this.coordinationType;
    }

    @Override
    public void setCoordinationType(CacheCoordinationType newCoordinationType) {
        if (this.attributeValueHasNotChanged((Object)this.coordinationType, (Object)newCoordinationType)) {
            return;
        }
        CacheCoordinationType oldCoordinationType = this.coordinationType;
        this.coordinationType = newCoordinationType;
        this.coordinationTypeAdapter.setValue((Object)CacheCoordinationType.toJavaAnnotationValue(newCoordinationType));
        this.firePropertyChanged("typeProperty", (Object)oldCoordinationType, (Object)newCoordinationType);
    }

    @Override
    public TextRange getTypeTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(TYPE_ADAPTER, astRoot);
    }

    @Override
    public TextRange getSizeTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(SIZE_ADAPTER, astRoot);
    }

    @Override
    public TextRange getSharedTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(SHARED_ADAPTER, astRoot);
    }

    @Override
    public TextRange getExpiryTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(EXPIRY_ADAPTER, astRoot);
    }

    @Override
    public TextRange getExpiryTimeOfDayTextRange(CompilationUnit astRoot) {
        return null;
    }

    @Override
    public TextRange getAlwaysRefreshTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(ALWAYS_REFRESH_ADAPTER, astRoot);
    }

    @Override
    public TextRange getRefreshOnlyIfNewerTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(REFRESH_ONLY_IF_NEWER_ADAPTER, astRoot);
    }

    @Override
    public TextRange getDisablesHitsTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(DISABLE_HITS_ADAPTER, astRoot);
    }

    @Override
    public TextRange getCoordinationTypeTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(COORDINATION_TYPE_ADAPTER, astRoot);
    }

    public void initialize(CompilationUnit astRoot) {
        this.type = this.type(astRoot);
        this.size = this.size(astRoot);
        this.shared = this.shared(astRoot);
        this.expiry = this.expiry(astRoot);
        this.initializeExpiryTimeOfDay(astRoot);
        this.alwaysRefresh = this.alwaysRefresh(astRoot);
        this.refreshOnlyIfNewer = this.refreshOnlyIfNewer(astRoot);
        this.disableHits = this.disableHits(astRoot);
        this.coordinationType = this.coordinationType(astRoot);
    }

    protected void initializeExpiryTimeOfDay(CompilationUnit astRoot) {
        if (this.expiryTimeOfDayAdapter.getAnnotation(astRoot) != null) {
            this.expiryTimeOfDay = this.createTimeOfDayAnnotation();
            this.expiryTimeOfDay.initialize(astRoot);
        }
    }

    public void update(CompilationUnit astRoot) {
        this.setType(this.type(astRoot));
        this.setSize(this.size(astRoot));
        this.setShared(this.shared(astRoot));
        this.setExpiry(this.expiry(astRoot));
        this.updateExpiryTimeOfDay(astRoot);
        this.setAlwaysRefresh(this.alwaysRefresh(astRoot));
        this.setRefreshOnlyIfNewer(this.refreshOnlyIfNewer(astRoot));
        this.setDisableHits(this.disableHits(astRoot));
        this.setCoordinationType(this.coordinationType(astRoot));
    }

    protected void updateExpiryTimeOfDay(CompilationUnit astRoot) {
        if (this.expiryTimeOfDayAdapter.getAnnotation(astRoot) == null) {
            this.setExpiryTimeOfDay(null);
        } else if (this.getExpiryTimeOfDay() != null) {
            this.getExpiryTimeOfDay().update(astRoot);
        } else {
            TimeOfDayAnnotation expiryTimeOfDay = this.createTimeOfDayAnnotation();
            expiryTimeOfDay.initialize(astRoot);
            this.setExpiryTimeOfDay(expiryTimeOfDay);
        }
    }

    protected CacheType type(CompilationUnit astRoot) {
        return CacheType.fromJavaAnnotationValue(this.typeAdapter.getValue(astRoot));
    }

    protected Integer size(CompilationUnit astRoot) {
        return (Integer)this.sizeAdapter.getValue(astRoot);
    }

    protected Boolean shared(CompilationUnit astRoot) {
        return (Boolean)this.sharedAdapter.getValue(astRoot);
    }

    protected Integer expiry(CompilationUnit astRoot) {
        return (Integer)this.expiryAdapter.getValue(astRoot);
    }

    protected TimeOfDayAnnotation createTimeOfDayAnnotation() {
        return new TimeOfDayImpl(this, (Type)this.getMember(), (DeclarationAnnotationAdapter)EXPIRY_TIME_OF_DAY_ADAPTER);
    }

    protected Boolean alwaysRefresh(CompilationUnit astRoot) {
        return (Boolean)this.alwaysRefreshAdapter.getValue(astRoot);
    }

    protected Boolean refreshOnlyIfNewer(CompilationUnit astRoot) {
        return (Boolean)this.refreshOnlyIfNewerAdapter.getValue(astRoot);
    }

    protected Boolean disableHits(CompilationUnit astRoot) {
        return (Boolean)this.disableHitsAdapter.getValue(astRoot);
    }

    protected CacheCoordinationType coordinationType(CompilationUnit astRoot) {
        return CacheCoordinationType.fromJavaAnnotationValue(this.coordinationTypeAdapter.getValue(astRoot));
    }

    private static DeclarationAnnotationElementAdapter<String> buildTypeAdapter() {
        return new EnumDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "type");
    }

    private static DeclarationAnnotationElementAdapter<Integer> buildSizeAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "size", NumberIntegerExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildSharedAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "shared", BooleanExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<Integer> buildExpiryAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "expiry", NumberIntegerExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildAlwaysRefreshAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "alwaysRefresh", BooleanExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildRefreshOnlyIfNewerAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "refreshOnlyIfNewer", BooleanExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildDisableHitsAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "disableHits", BooleanExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<String> buildCoordinationTypeAdapter() {
        return new EnumDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "coordinationType");
    }

    private static NestedDeclarationAnnotationAdapter buildExpiryTimeOfDayAnnotationAdapter() {
        return new NestedDeclarationAnnotationAdapter(DECLARATION_ANNOTATION_ADAPTER, "expiryTimeOfDay", "org.eclipse.persistence.annotations.TimeOfDay");
    }

    public static class CacheAnnotationDefinition
    implements AnnotationDefinition {
        private static final CacheAnnotationDefinition INSTANCE = new CacheAnnotationDefinition();

        public static CacheAnnotationDefinition instance() {
            return INSTANCE;
        }

        private CacheAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new CacheImpl((JavaResourcePersistentType)parent, (Type)member);
        }

        public Annotation buildNullAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new NullCacheAnnotation((JavaResourcePersistentType)parent);
        }

        public String getAnnotationName() {
            return "org.eclipse.persistence.annotations.Cache";
        }
    }
}

