/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.resource.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractResourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberIndexedAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.eclipselink.core.resource.java.ConversionValueAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.NestableConversionValue;
import org.eclipse.jpt.eclipselink.core.resource.java.ObjectTypeConverterAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversionValueImpl
extends AbstractResourceAnnotation<Member>
implements ConversionValueAnnotation,
NestableConversionValue {
    private final DeclarationAnnotationElementAdapter<String> dataValueDeclarationAdapter;
    private final DeclarationAnnotationElementAdapter<String> objectValueDeclarationAdapter;
    private final AnnotationElementAdapter<String> dataValueAdapter;
    private final AnnotationElementAdapter<String> objectValueAdapter;
    private String dataValue;
    private String objectValue;

    public ConversionValueImpl(ObjectTypeConverterAnnotation parent, Member member, IndexedDeclarationAnnotationAdapter idaa) {
        super((JavaResourceNode)parent, member, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)new MemberIndexedAnnotationAdapter(member, idaa));
        this.dataValueDeclarationAdapter = this.dataValueAdapter((DeclarationAnnotationAdapter)idaa);
        this.dataValueAdapter = this.buildAdapter(this.dataValueDeclarationAdapter);
        this.objectValueDeclarationAdapter = this.objectValueAdapter((DeclarationAnnotationAdapter)idaa);
        this.objectValueAdapter = this.buildAdapter(this.objectValueDeclarationAdapter);
    }

    protected AnnotationElementAdapter<String> buildAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new ShortCircuitAnnotationElementAdapter(this.getMember(), daea);
    }

    protected DeclarationAnnotationElementAdapter<String> dataValueAdapter(DeclarationAnnotationAdapter daa) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"dataValue", (boolean)false);
    }

    protected DeclarationAnnotationElementAdapter<String> objectValueAdapter(DeclarationAnnotationAdapter daa) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"objectValue", (boolean)false);
    }

    public void initialize(CompilationUnit astRoot) {
        this.dataValue = this.dataValue(astRoot);
        this.objectValue = this.objectValue(astRoot);
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.ConversionValue";
    }

    public IndexedAnnotationAdapter getAnnotationAdapter() {
        return (IndexedAnnotationAdapter)super.getAnnotationAdapter();
    }

    @Override
    public String getDataValue() {
        return this.dataValue;
    }

    @Override
    public void setDataValue(String newDataValue) {
        if (this.attributeValueHasNotChanged(this.dataValue, newDataValue)) {
            return;
        }
        String oldDataValue = this.dataValue;
        this.dataValue = newDataValue;
        this.dataValueAdapter.setValue((Object)newDataValue);
        this.firePropertyChanged("dataValueProperty", oldDataValue, newDataValue);
    }

    @Override
    public String getObjectValue() {
        return this.objectValue;
    }

    @Override
    public void setObjectValue(String newObjectValue) {
        if (this.attributeValueHasNotChanged(this.objectValue, newObjectValue)) {
            return;
        }
        String oldObjectValue = this.objectValue;
        this.objectValue = newObjectValue;
        this.objectValueAdapter.setValue((Object)newObjectValue);
        this.firePropertyChanged("objectValueProperty", oldObjectValue, newObjectValue);
    }

    @Override
    public TextRange getDataValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.dataValueDeclarationAdapter, astRoot);
    }

    @Override
    public TextRange getObjectValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.objectValueDeclarationAdapter, astRoot);
    }

    public void update(CompilationUnit astRoot) {
        this.setDataValue(this.dataValue(astRoot));
        this.setObjectValue(this.objectValue(astRoot));
    }

    protected String dataValue(CompilationUnit astRoot) {
        return (String)this.dataValueAdapter.getValue(astRoot);
    }

    protected String objectValue(CompilationUnit astRoot) {
        return (String)this.objectValueAdapter.getValue(astRoot);
    }

    public void moveAnnotation(int newIndex) {
        this.getAnnotationAdapter().moveAnnotation(newIndex);
    }

    public void initializeFrom(NestableAnnotation oldAnnotation) {
        ConversionValueAnnotation oldConversionValue = (ConversionValueAnnotation)oldAnnotation;
        this.setDataValue(oldConversionValue.getDataValue());
        this.setObjectValue(oldConversionValue.getObjectValue());
    }

    static ConversionValueImpl createConversionValue(ObjectTypeConverterAnnotation parent, Member member, DeclarationAnnotationAdapter daa, int index) {
        return new ConversionValueImpl(parent, member, ConversionValueImpl.buildConversionValueAnnotationAdapter(daa, index));
    }

    private static IndexedDeclarationAnnotationAdapter buildConversionValueAnnotationAdapter(DeclarationAnnotationAdapter daa, int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(daa, "conversionValues", index, "org.eclipse.persistence.annotations.ConversionValue", false);
    }
}

