/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.resource.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractResourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.StringExpressionConverter;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Attribute;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.eclipselink.core.resource.java.ConvertAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertImpl
extends AbstractResourceAnnotation<Attribute>
implements ConvertAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.eclipse.persistence.annotations.Convert");
    private final AnnotationElementAdapter<String> valueAdapter;
    private static final DeclarationAnnotationElementAdapter<String> VALUE_ADAPTER = ConvertImpl.buildValueAdapter();
    private String value;

    protected ConvertImpl(JavaResourcePersistentAttribute parent, Attribute attribute) {
        super((JavaResourceNode)parent, (Member)attribute, DECLARATION_ANNOTATION_ADAPTER);
        this.valueAdapter = new ShortCircuitAnnotationElementAdapter((Member)attribute, VALUE_ADAPTER);
    }

    public void initialize(CompilationUnit astRoot) {
        this.value = this.value(astRoot);
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.Convert";
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String newValue) {
        if (this.attributeValueHasNotChanged(this.value, newValue)) {
            return;
        }
        String oldValue = this.value;
        this.value = newValue;
        this.valueAdapter.setValue((Object)newValue);
        this.firePropertyChanged("valueProperty", oldValue, newValue);
    }

    @Override
    public TextRange getValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(VALUE_ADAPTER, astRoot);
    }

    public void update(CompilationUnit astRoot) {
        this.setValue(this.value(astRoot));
    }

    protected String value(CompilationUnit astRoot) {
        return (String)this.valueAdapter.getValue(astRoot);
    }

    private static DeclarationAnnotationElementAdapter<String> buildValueAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "value", false, StringExpressionConverter.instance());
    }

    public static class ConvertAnnotationDefinition
    implements AnnotationDefinition {
        private static final ConvertAnnotationDefinition INSTANCE = new ConvertAnnotationDefinition();

        public static ConvertAnnotationDefinition instance() {
            return INSTANCE;
        }

        private ConvertAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new ConvertImpl((JavaResourcePersistentAttribute)parent, (Attribute)member);
        }

        public Annotation buildNullAnnotation(JavaResourcePersistentMember parent, Member member) {
            return null;
        }

        public String getAnnotationName() {
            return "org.eclipse.persistence.annotations.Convert";
        }
    }
}

