/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.resource.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractResourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Attribute;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.eclipselink.core.resource.java.ReadTransformerAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadTransformerImpl
extends AbstractResourceAnnotation<Attribute>
implements ReadTransformerAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.eclipse.persistence.annotations.ReadTransformer");
    private final AnnotationElementAdapter<String> transformerClassAdapter;
    private final AnnotationElementAdapter<String> methodAdapter;
    private static final DeclarationAnnotationElementAdapter<String> TRANSFORMER_CLASS_ADAPTER = ReadTransformerImpl.buildTransformerClassAdapter();
    private static final DeclarationAnnotationElementAdapter<String> METHOD_ADAPTER = ReadTransformerImpl.buildMethodAdapter();
    private String transformerClass;
    private String method;

    protected ReadTransformerImpl(JavaResourcePersistentAttribute parent, Attribute attribute) {
        super((JavaResourceNode)parent, (Member)attribute, DECLARATION_ANNOTATION_ADAPTER);
        this.transformerClassAdapter = new ShortCircuitAnnotationElementAdapter((Member)attribute, TRANSFORMER_CLASS_ADAPTER);
        this.methodAdapter = new ShortCircuitAnnotationElementAdapter((Member)attribute, METHOD_ADAPTER);
    }

    public void initialize(CompilationUnit astRoot) {
        this.transformerClass = this.transformerClass(astRoot);
        this.method = this.method(astRoot);
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.ReadTransformer";
    }

    @Override
    public String getTransformerClass() {
        return this.transformerClass;
    }

    @Override
    public void setTransformerClass(String newTransformerClass) {
        if (this.attributeValueHasNotChanged(this.transformerClass, newTransformerClass)) {
            return;
        }
        String oldTransformerClass = this.transformerClass;
        this.transformerClass = newTransformerClass;
        this.transformerClassAdapter.setValue((Object)newTransformerClass);
        this.firePropertyChanged("transformerClassProperty", oldTransformerClass, newTransformerClass);
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public void setMethod(String newMethod) {
        if (this.attributeValueHasNotChanged(this.method, newMethod)) {
            return;
        }
        String oldMethod = this.method;
        this.method = newMethod;
        this.methodAdapter.setValue((Object)newMethod);
        this.firePropertyChanged("methodProperty", oldMethod, newMethod);
    }

    @Override
    public TextRange getTransformerClassTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(TRANSFORMER_CLASS_ADAPTER, astRoot);
    }

    @Override
    public TextRange getMethodTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(METHOD_ADAPTER, astRoot);
    }

    public void update(CompilationUnit astRoot) {
        this.setTransformerClass(this.transformerClass(astRoot));
        this.setMethod(this.method(astRoot));
    }

    protected String transformerClass(CompilationUnit astRoot) {
        return (String)this.transformerClassAdapter.getValue(astRoot);
    }

    protected String method(CompilationUnit astRoot) {
        return (String)this.methodAdapter.getValue(astRoot);
    }

    private static DeclarationAnnotationElementAdapter<String> buildTransformerClassAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "transformerClass", false, SimpleTypeStringExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<String> buildMethodAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)DECLARATION_ANNOTATION_ADAPTER, (String)"method", (boolean)false);
    }

    public static class ReadTransformerAnnotationDefinition
    implements AnnotationDefinition {
        private static final ReadTransformerAnnotationDefinition INSTANCE = new ReadTransformerAnnotationDefinition();

        public static ReadTransformerAnnotationDefinition instance() {
            return INSTANCE;
        }

        private ReadTransformerAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new ReadTransformerImpl((JavaResourcePersistentAttribute)parent, (Attribute)member);
        }

        public Annotation buildNullAnnotation(JavaResourcePersistentMember parent, Member member) {
            return null;
        }

        public String getAnnotationName() {
            return "org.eclipse.persistence.annotations.ReadTransformer";
        }
    }
}

