/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.resource.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractResourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.StringExpressionConverter;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.eclipselink.core.resource.java.StructConverterAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructConverterImpl
extends AbstractResourceAnnotation<Member>
implements StructConverterAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.eclipse.persistence.annotations.StructConverter");
    private final AnnotationElementAdapter<String> nameAdapter;
    private final AnnotationElementAdapter<String> converterAdapter;
    private static final DeclarationAnnotationElementAdapter<String> NAME_ADAPTER = StructConverterImpl.buildNameAdapter();
    private static final DeclarationAnnotationElementAdapter<String> CONVERTER_ADAPTER = StructConverterImpl.buildConverterAdapter();
    private String name;
    private String converter;

    protected StructConverterImpl(JavaResourcePersistentMember parent, Member member) {
        super((JavaResourceNode)parent, member, DECLARATION_ANNOTATION_ADAPTER);
        this.nameAdapter = new ShortCircuitAnnotationElementAdapter(member, NAME_ADAPTER);
        this.converterAdapter = new ShortCircuitAnnotationElementAdapter(member, CONVERTER_ADAPTER);
    }

    public void initialize(CompilationUnit astRoot) {
        this.name = this.name(astRoot);
        this.converter = this.converter(astRoot);
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.StructConverter";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        if (this.attributeValueHasNotChanged(this.name, newName)) {
            return;
        }
        String oldName = this.name;
        this.name = newName;
        this.nameAdapter.setValue((Object)newName);
        this.firePropertyChanged("nameProperty", oldName, newName);
    }

    @Override
    public String getConverter() {
        return this.converter;
    }

    @Override
    public void setConverter(String newConverter) {
        if (this.attributeValueHasNotChanged(this.converter, newConverter)) {
            return;
        }
        String oldConverter = this.converter;
        this.converter = newConverter;
        this.converterAdapter.setValue((Object)newConverter);
        this.firePropertyChanged("converterProperty", oldConverter, newConverter);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(NAME_ADAPTER, astRoot);
    }

    @Override
    public TextRange getConverterTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(CONVERTER_ADAPTER, astRoot);
    }

    public void update(CompilationUnit astRoot) {
        this.setName(this.name(astRoot));
        this.setConverter(this.converter(astRoot));
    }

    protected String name(CompilationUnit astRoot) {
        return (String)this.nameAdapter.getValue(astRoot);
    }

    protected String converter(CompilationUnit astRoot) {
        return (String)this.converterAdapter.getValue(astRoot);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    private static DeclarationAnnotationElementAdapter<String> buildNameAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "name", false, StringExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<String> buildConverterAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "converter", false, StringExpressionConverter.instance());
    }

    public static class StructConverterAnnotationDefinition
    implements AnnotationDefinition {
        private static final StructConverterAnnotationDefinition INSTANCE = new StructConverterAnnotationDefinition();

        public static StructConverterAnnotationDefinition instance() {
            return INSTANCE;
        }

        private StructConverterAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new StructConverterImpl(parent, member);
        }

        public Annotation buildNullAnnotation(JavaResourcePersistentMember parent, Member member) {
            return null;
        }

        public String getAnnotationName() {
            return "org.eclipse.persistence.annotations.StructConverter";
        }
    }
}

