/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.resource.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractResourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.BooleanExpressionConverter;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.FetchType;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Attribute;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.eclipselink.core.internal.resource.java.NullTransformation;
import org.eclipse.jpt.eclipselink.core.resource.java.TransformationAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationImpl
extends AbstractResourceAnnotation<Attribute>
implements TransformationAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.eclipse.persistence.annotations.Transformation");
    private final AnnotationElementAdapter<Boolean> optionalAdapter;
    private final AnnotationElementAdapter<String> fetchAdapter;
    private static final DeclarationAnnotationElementAdapter<Boolean> OPTIONAL_ADAPTER = TransformationImpl.buildOptionalAdapter();
    private static final DeclarationAnnotationElementAdapter<String> FETCH_ADAPTER = TransformationImpl.buildFetchAdapter();
    private Boolean optional;
    private FetchType fetch;

    protected TransformationImpl(JavaResourcePersistentAttribute parent, Attribute attribute) {
        super((JavaResourceNode)parent, (Member)attribute, DECLARATION_ANNOTATION_ADAPTER);
        this.optionalAdapter = new ShortCircuitAnnotationElementAdapter((Member)attribute, OPTIONAL_ADAPTER);
        this.fetchAdapter = new ShortCircuitAnnotationElementAdapter((Member)attribute, FETCH_ADAPTER);
    }

    public void initialize(CompilationUnit astRoot) {
        this.optional = this.optional(astRoot);
        this.fetch = this.fetch(astRoot);
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.Transformation";
    }

    @Override
    public Boolean getOptional() {
        return this.optional;
    }

    @Override
    public void setOptional(Boolean newOptional) {
        if (this.attributeValueHasNotChanged(this.optional, newOptional)) {
            return;
        }
        Boolean oldOptional = this.optional;
        this.optional = newOptional;
        this.optionalAdapter.setValue((Object)newOptional);
        this.firePropertyChanged("optionalProperty", oldOptional, newOptional);
    }

    @Override
    public FetchType getFetch() {
        return this.fetch;
    }

    @Override
    public void setFetch(FetchType newFetch) {
        if (this.attributeValueHasNotChanged(this.fetch, newFetch)) {
            return;
        }
        FetchType oldFetch = this.fetch;
        this.fetch = newFetch;
        this.fetchAdapter.setValue((Object)FetchType.toJavaAnnotationValue((FetchType)newFetch));
        this.firePropertyChanged("fetchProperty", oldFetch, newFetch);
    }

    @Override
    public TextRange getFetchTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(FETCH_ADAPTER, astRoot);
    }

    @Override
    public TextRange getOptionalTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(OPTIONAL_ADAPTER, astRoot);
    }

    public void update(CompilationUnit astRoot) {
        this.setOptional(this.optional(astRoot));
        this.setFetch(this.fetch(astRoot));
    }

    protected FetchType fetch(CompilationUnit astRoot) {
        return FetchType.fromJavaAnnotationValue((Object)this.fetchAdapter.getValue(astRoot));
    }

    protected Boolean optional(CompilationUnit astRoot) {
        return (Boolean)this.optionalAdapter.getValue(astRoot);
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildOptionalAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "optional", false, BooleanExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<String> buildFetchAdapter() {
        return new EnumDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "fetch", false);
    }

    public static class TransformationAnnotationDefinition
    implements AnnotationDefinition {
        private static final TransformationAnnotationDefinition INSTANCE = new TransformationAnnotationDefinition();

        public static TransformationAnnotationDefinition instance() {
            return INSTANCE;
        }

        private TransformationAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new TransformationImpl((JavaResourcePersistentAttribute)parent, (Attribute)member);
        }

        public Annotation buildNullAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new NullTransformation(parent);
        }

        public String getAnnotationName() {
            return "org.eclipse.persistence.annotations.Transformation";
        }
    }
}

