/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.ui.internal.mappings.details;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.eclipselink.core.context.Convert;
import org.eclipse.jpt.eclipselink.core.context.CustomConverter;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkConverter;
import org.eclipse.jpt.eclipselink.core.context.ObjectTypeConverter;
import org.eclipse.jpt.eclipselink.core.context.StructConverter;
import org.eclipse.jpt.eclipselink.core.context.TypeConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.eclipselink.ui.internal.mappings.EclipseLinkUiMappingsMessages;
import org.eclipse.jpt.eclipselink.ui.internal.mappings.details.CustomConverterComposite;
import org.eclipse.jpt.eclipselink.ui.internal.mappings.details.ObjectTypeConverterComposite;
import org.eclipse.jpt.eclipselink.ui.internal.mappings.details.StructConverterComposite;
import org.eclipse.jpt.eclipselink.ui.internal.mappings.details.TypeConverterComposite;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.util.PaneEnabler;
import org.eclipse.jpt.ui.internal.util.SWTUtil;
import org.eclipse.jpt.ui.internal.widgets.FormPane;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringConverter;
import org.eclipse.jpt.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.PropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.StaticListValueModel;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertComposite
extends FormPane<Convert> {
    protected static String DEFAULT_KEY = "?!#!?#?#?default?#?!#?!#?";

    public ConvertComposite(PropertyValueModel<? extends Convert> subjectHolder, Composite parent, WidgetFactory widgetFactory) {
        super(subjectHolder, parent, widgetFactory);
    }

    protected void initializeLayout(Composite container) {
        CCombo combo = this.addLabeledEditableCCombo(container, EclipseLinkUiMappingsMessages.ConvertComposite_converterNameLabel, this.buildConvertNameListHolder(), this.buildConvertNameHolder(), this.buildNameConverter(), null);
        SWTUtil.attachDefaultValueHandler((CCombo)combo);
        Composite subSection = this.addCollapsableSubSection(container, EclipseLinkUiMappingsMessages.ConvertComposite_defineConverterSection, (PropertyValueModel)new SimplePropertyValueModel((Object)Boolean.FALSE));
        this.addRadioButton(subSection, EclipseLinkUiMappingsMessages.ConvertComposite_default, this.buildNoConverterHolder(), null);
        PropertyValueModel<EclipseLinkConverter> converterHolder = this.buildConverterHolder();
        this.addRadioButton(subSection, EclipseLinkUiMappingsMessages.ConvertComposite_custom, this.buildConverterHolder("customConverter"), null);
        CustomConverterComposite converterComposite = new CustomConverterComposite(this.buildCustomConverterHolder(converterHolder), subSection, this.getWidgetFactory());
        GridData gridData = (GridData)converterComposite.getControl().getLayoutData();
        gridData.horizontalIndent = 20;
        this.registerSubPane((Pane)converterComposite);
        this.addRadioButton(subSection, EclipseLinkUiMappingsMessages.ConvertComposite_type, this.buildConverterHolder("typeConverter"), null);
        TypeConverterComposite typeConverterComposite = new TypeConverterComposite(this.buildTypeConverterHolder(converterHolder), subSection, this.getWidgetFactory());
        gridData = (GridData)typeConverterComposite.getControl().getLayoutData();
        gridData.horizontalIndent = 20;
        this.registerSubPane((Pane)typeConverterComposite);
        this.addRadioButton(subSection, EclipseLinkUiMappingsMessages.ConvertComposite_objectType, this.buildConverterHolder("objectTypeConverter"), null);
        ObjectTypeConverterComposite objectTypeConverterComposite = new ObjectTypeConverterComposite(this.buildObjectTypeConverterHolder(converterHolder), subSection, this.getWidgetFactory());
        gridData = (GridData)objectTypeConverterComposite.getControl().getLayoutData();
        gridData.horizontalIndent = 20;
        this.registerSubPane((Pane)objectTypeConverterComposite);
        this.addRadioButton(subSection, EclipseLinkUiMappingsMessages.ConvertComposite_struct, this.buildConverterHolder("structConverter"), null);
        StructConverterComposite structConverterComposite = new StructConverterComposite(this.buildStructConverterHolder(converterHolder), subSection, this.getWidgetFactory());
        gridData = (GridData)structConverterComposite.getControl().getLayoutData();
        gridData.horizontalIndent = 20;
        this.registerSubPane((Pane)structConverterComposite);
        new PaneEnabler(this.buildBooleanHolder(), (Pane)this);
    }

    protected final WritablePropertyValueModel<String> buildConvertNameHolder() {
        return new PropertyAspectAdapter<Convert, String>(this.getSubjectHolder(), new String[]{"specifiedConverterNameProperty"}){

            protected String buildValue_() {
                return ((Convert)this.subject).getSpecifiedConverterName();
            }

            protected void setValue_(String value) {
                if (value != null && (value.length() == 0 || value.startsWith(DEFAULT_KEY))) {
                    value = null;
                }
                ((Convert)this.subject).setSpecifiedConverterName(value);
            }
        };
    }

    private ListValueModel<String> buildConvertNameListHolder() {
        ArrayList<ListValueModel<String>> list = new ArrayList<ListValueModel<String>>();
        list.add(this.buildDefaultNameListHolder());
        list.add(this.buildReservedConverterNameListHolder());
        list.add(this.buildConverterNameListHolder());
        return new CompositeListValueModel(list);
    }

    protected ListValueModel<String> buildDefaultNameListHolder() {
        return new PropertyListValueModelAdapter(this.buildDefaultNameHolder());
    }

    private WritablePropertyValueModel<String> buildDefaultNameHolder() {
        return new PropertyAspectAdapter<Convert, String>(this.getSubjectHolder(), new String[]{"defaultConverterNameProperty"}){

            protected String buildValue_() {
                String name = ((Convert)this.subject).getDefaultConverterName();
                name = name == null ? DEFAULT_KEY : String.valueOf(DEFAULT_KEY) + name;
                return name;
            }
        };
    }

    private StringConverter<String> buildNameConverter() {
        return new StringConverter<String>(){

            public String convertToString(String value) {
                if (ConvertComposite.this.getSubject() == null) {
                    return value;
                }
                if (value == null) {
                    value = ((Convert)ConvertComposite.this.getSubject()).getDefaultConverterName();
                    value = value != null ? String.valueOf(DEFAULT_KEY) + value : DEFAULT_KEY;
                }
                if (value.startsWith(DEFAULT_KEY)) {
                    String defaultName = value.substring(DEFAULT_KEY.length());
                    value = defaultName.length() > 0 ? NLS.bind((String)JptUiMappingsMessages.DefaultWithValue, (Object)defaultName) : JptUiMappingsMessages.DefaultWithoutValue;
                }
                return value;
            }
        };
    }

    protected ListValueModel<String> buildReservedConverterNameListHolder() {
        return new StaticListValueModel((List)CollectionTools.list((Object[])Convert.RESERVED_CONVERTER_NAMES));
    }

    protected ListValueModel<String> buildConverterNameListHolder() {
        return new ListAspectAdapter<EclipseLinkPersistenceUnit, String>(this.buildPersistenceUnitHolder(), new String[]{"converters"}){

            protected ListIterator<String> listIterator_() {
                return CollectionTools.listIterator((Object[])((String[])CollectionTools.sort((Object[])((EclipseLinkPersistenceUnit)this.subject).uniqueConverterNames())));
            }
        };
    }

    protected PropertyValueModel<EclipseLinkPersistenceUnit> buildPersistenceUnitHolder() {
        return new PropertyAspectAdapter<Convert, EclipseLinkPersistenceUnit>(this.getSubjectHolder()){

            protected EclipseLinkPersistenceUnit buildValue_() {
                return (EclipseLinkPersistenceUnit)((Convert)ConvertComposite.this.getSubject()).getPersistenceUnit();
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildNoConverterHolder() {
        return new PropertyAspectAdapter<Convert, Boolean>(this.getSubjectHolder(), new String[]{"converterProperty"}){

            protected Boolean buildValue_() {
                return ((Convert)this.subject).getConverter() == null;
            }

            protected void setValue_(Boolean value) {
                if (value.booleanValue()) {
                    ((Convert)this.subject).setConverter("noConverter");
                }
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildConverterHolder(final String converterType) {
        return new PropertyAspectAdapter<Convert, Boolean>(this.getSubjectHolder(), new String[]{"converterProperty"}){

            protected Boolean buildValue_() {
                EclipseLinkConverter converter = ((Convert)this.subject).getConverter();
                if (converter == null) {
                    return Boolean.FALSE;
                }
                return converter.getType() == converterType;
            }

            protected void setValue_(Boolean value) {
                if (value.booleanValue()) {
                    ((Convert)this.subject).setConverter(converterType);
                }
            }
        };
    }

    private PropertyValueModel<EclipseLinkConverter> buildConverterHolder() {
        return new PropertyAspectAdapter<Convert, EclipseLinkConverter>(this.getSubjectHolder(), new String[]{"converterProperty"}){

            protected EclipseLinkConverter buildValue_() {
                return ((Convert)this.subject).getConverter();
            }
        };
    }

    private PropertyValueModel<CustomConverter> buildCustomConverterHolder(PropertyValueModel<EclipseLinkConverter> converterHolder) {
        return new TransformationPropertyValueModel<EclipseLinkConverter, CustomConverter>(converterHolder){

            protected CustomConverter transform_(EclipseLinkConverter converter) {
                return converter != null && converter.getType() == "customConverter" ? (CustomConverter)converter : null;
            }
        };
    }

    private PropertyValueModel<TypeConverter> buildTypeConverterHolder(PropertyValueModel<EclipseLinkConverter> converterHolder) {
        return new TransformationPropertyValueModel<EclipseLinkConverter, TypeConverter>(converterHolder){

            protected TypeConverter transform_(EclipseLinkConverter converter) {
                return converter != null && converter.getType() == "typeConverter" ? (TypeConverter)converter : null;
            }
        };
    }

    private PropertyValueModel<ObjectTypeConverter> buildObjectTypeConverterHolder(PropertyValueModel<EclipseLinkConverter> converterHolder) {
        return new TransformationPropertyValueModel<EclipseLinkConverter, ObjectTypeConverter>(converterHolder){

            protected ObjectTypeConverter transform_(EclipseLinkConverter converter) {
                return converter != null && converter.getType() == "objectTypeConverter" ? (ObjectTypeConverter)converter : null;
            }
        };
    }

    private PropertyValueModel<StructConverter> buildStructConverterHolder(PropertyValueModel<EclipseLinkConverter> converterHolder) {
        return new TransformationPropertyValueModel<EclipseLinkConverter, StructConverter>(converterHolder){

            protected StructConverter transform_(EclipseLinkConverter converter) {
                return converter != null && converter.getType() == "structConverter" ? (StructConverter)converter : null;
            }
        };
    }

    protected PropertyValueModel<Boolean> buildBooleanHolder() {
        return new TransformationPropertyValueModel<Convert, Boolean>(this.getSubjectHolder()){

            protected Boolean transform(Convert value) {
                if (ConvertComposite.this.getSubject() != null && ((Convert)ConvertComposite.this.getSubject()).getParent().getPersistentAttribute().isVirtual()) {
                    return Boolean.FALSE;
                }
                return value != null;
            }
        };
    }
}

