/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.ui.internal.orm.details;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.eclipselink.core.context.CustomConverter;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkConverter;
import org.eclipse.jpt.eclipselink.core.context.ObjectTypeConverter;
import org.eclipse.jpt.eclipselink.core.context.StructConverter;
import org.eclipse.jpt.eclipselink.core.context.TypeConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.ConverterHolder;
import org.eclipse.jpt.eclipselink.ui.internal.mappings.details.CustomConverterComposite;
import org.eclipse.jpt.eclipselink.ui.internal.mappings.details.ObjectTypeConverterComposite;
import org.eclipse.jpt.eclipselink.ui.internal.mappings.details.StructConverterComposite;
import org.eclipse.jpt.eclipselink.ui.internal.mappings.details.TypeConverterComposite;
import org.eclipse.jpt.eclipselink.ui.internal.orm.details.EclipseLinkConverterDialog;
import org.eclipse.jpt.ui.internal.util.ControlSwitcher;
import org.eclipse.jpt.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.ui.internal.widgets.FormPane;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.Transformer;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.jpt.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.PageBook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertersComposite
extends Pane<ConverterHolder> {
    private AddRemoveListPane<ConverterHolder> listPane;
    private CustomConverterComposite converterComposite;
    private ObjectTypeConverterComposite objectTypeConverterComposite;
    private StructConverterComposite structConverterComposite;
    private TypeConverterComposite typeConverterComposite;
    private WritablePropertyValueModel<EclipseLinkConverter> selectedConverterHolder;

    public ConvertersComposite(FormPane<?> parentPane, PropertyValueModel<? extends ConverterHolder> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent);
    }

    protected void initialize() {
        super.initialize();
        this.selectedConverterHolder = this.buildSelectedConverterHolder();
    }

    private WritablePropertyValueModel<EclipseLinkConverter> buildSelectedConverterHolder() {
        return new SimplePropertyValueModel();
    }

    protected void initializeLayout(Composite container) {
        this.listPane = this.addListPane(container);
        PageBook pageBook = new PageBook(container, 0);
        pageBook.setLayoutData((Object)new GridData(768));
        this.converterComposite = new CustomConverterComposite(this.buildCustomConverterHolder(), (Composite)pageBook, this.getWidgetFactory());
        this.objectTypeConverterComposite = new ObjectTypeConverterComposite(this.buildObjectTypeConverterHolder(), (Composite)pageBook, this.getWidgetFactory());
        this.structConverterComposite = new StructConverterComposite(this.buildStructConverterHolder(), (Composite)pageBook, this.getWidgetFactory());
        this.typeConverterComposite = new TypeConverterComposite(this.buildTypeConverterHolder(), (Composite)pageBook, this.getWidgetFactory());
        this.installPaneSwitcher(pageBook);
    }

    private AddRemoveListPane<ConverterHolder> addListPane(Composite container) {
        return new AddRemoveListPane<ConverterHolder>((Pane)this, container, this.buildConvertersAdapter(), this.buildDisplayableConvertersListHolder(), this.selectedConverterHolder, this.buildConvertersListLabelProvider(), null){

            public void enableWidgets(boolean enabled) {
                super.enableWidgets(true);
            }
        };
    }

    private void installPaneSwitcher(PageBook pageBook) {
        new ControlSwitcher(this.selectedConverterHolder, this.buildPaneTransformer(), pageBook);
    }

    private AddRemovePane.Adapter buildConvertersAdapter() {
        return new AddRemovePane.AbstractAdapter(){

            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                ConvertersComposite.this.addConverter();
            }

            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                Object[] objectArray = listSelectionModel.selectedValues();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    if (((EclipseLinkConverter)item).getType() == "customConverter") {
                        ((ConverterHolder)ConvertersComposite.this.getSubject()).removeCustomConverter((CustomConverter)item);
                    } else if (((EclipseLinkConverter)item).getType() == "objectTypeConverter") {
                        ((ConverterHolder)ConvertersComposite.this.getSubject()).removeObjectTypeConverter((ObjectTypeConverter)item);
                    } else if (((EclipseLinkConverter)item).getType() == "structConverter") {
                        ((ConverterHolder)ConvertersComposite.this.getSubject()).removeStructConverter((StructConverter)item);
                    } else if (((EclipseLinkConverter)item).getType() == "typeConverter") {
                        ((ConverterHolder)ConvertersComposite.this.getSubject()).removeTypeConverter((TypeConverter)item);
                    }
                    ++n2;
                }
            }
        };
    }

    private void addConverter() {
        this.addEclipseLinkConverterFromDialog(this.buildEclipseLinkConverterDialog());
    }

    protected EclipseLinkConverterDialog buildEclipseLinkConverterDialog() {
        return new EclipseLinkConverterDialog(this.getControl().getShell());
    }

    protected void addEclipseLinkConverterFromDialog(EclipseLinkConverterDialog dialog) {
        CustomConverter converter;
        if (dialog.open() != 0) {
            return;
        }
        String converterType = dialog.getConverterType();
        if (converterType == "customConverter") {
            converter = ((ConverterHolder)this.getSubject()).addCustomConverter(((ConverterHolder)this.getSubject()).customConvertersSize());
        } else if (converterType == "objectTypeConverter") {
            converter = ((ConverterHolder)this.getSubject()).addObjectTypeConverter(((ConverterHolder)this.getSubject()).objectTypeConvertersSize());
        } else if (converterType == "structConverter") {
            converter = ((ConverterHolder)this.getSubject()).addStructConverter(((ConverterHolder)this.getSubject()).structConvertersSize());
        } else if (converterType == "typeConverter") {
            converter = ((ConverterHolder)this.getSubject()).addTypeConverter(((ConverterHolder)this.getSubject()).typeConvertersSize());
        } else {
            throw new IllegalArgumentException();
        }
        converter.setName(dialog.getName());
        this.selectedConverterHolder.setValue((Object)converter);
    }

    private Transformer<EclipseLinkConverter, Control> buildPaneTransformer() {
        return new Transformer<EclipseLinkConverter, Control>(){

            public Control transform(EclipseLinkConverter converter) {
                if (converter == null) {
                    return null;
                }
                if (converter.getType() == "customConverter") {
                    return ConvertersComposite.this.converterComposite.getControl();
                }
                if (converter.getType() == "objectTypeConverter") {
                    return ConvertersComposite.this.objectTypeConverterComposite.getControl();
                }
                if (converter.getType() == "structConverter") {
                    return ConvertersComposite.this.structConverterComposite.getControl();
                }
                if (converter.getType() == "typeConverter") {
                    return ConvertersComposite.this.typeConverterComposite.getControl();
                }
                return null;
            }
        };
    }

    private ListValueModel<EclipseLinkConverter> buildDisplayableConvertersListHolder() {
        return new ItemPropertyListValueModelAdapter(this.buildEclipseLinkConvertersHolder(), new String[]{"nameProperty"});
    }

    private ListValueModel<EclipseLinkConverter> buildEclipseLinkConvertersHolder() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.buildCustomConvertersListHolder());
        list.add(this.buildObjectTypeConvertersListHolder());
        list.add(this.buildStructConvertersListHolder());
        list.add(this.buildTypeConvertersListHolder());
        return new CompositeListValueModel(list);
    }

    private ListValueModel<CustomConverter> buildCustomConvertersListHolder() {
        return new ListAspectAdapter<ConverterHolder, CustomConverter>(this.getSubjectHolder(), new String[]{"customConvertersList"}){

            protected ListIterator<CustomConverter> listIterator_() {
                return ((ConverterHolder)this.subject).customConverters();
            }

            protected int size_() {
                return ((ConverterHolder)this.subject).customConvertersSize();
            }
        };
    }

    private ListValueModel<ObjectTypeConverter> buildObjectTypeConvertersListHolder() {
        return new ListAspectAdapter<ConverterHolder, ObjectTypeConverter>(this.getSubjectHolder(), new String[]{"objectTypeConvertersList"}){

            protected ListIterator<ObjectTypeConverter> listIterator_() {
                return ((ConverterHolder)this.subject).objectTypeConverters();
            }

            protected int size_() {
                return ((ConverterHolder)this.subject).objectTypeConvertersSize();
            }
        };
    }

    private ListValueModel<StructConverter> buildStructConvertersListHolder() {
        return new ListAspectAdapter<ConverterHolder, StructConverter>(this.getSubjectHolder(), new String[]{"structConvertersList"}){

            protected ListIterator<StructConverter> listIterator_() {
                return ((ConverterHolder)this.subject).structConverters();
            }

            protected int size_() {
                return ((ConverterHolder)this.subject).structConvertersSize();
            }
        };
    }

    private ListValueModel<TypeConverter> buildTypeConvertersListHolder() {
        return new ListAspectAdapter<ConverterHolder, TypeConverter>(this.getSubjectHolder(), new String[]{"typeConvertersList"}){

            protected ListIterator<TypeConverter> listIterator_() {
                return ((ConverterHolder)this.subject).typeConverters();
            }

            protected int size_() {
                return ((ConverterHolder)this.subject).typeConvertersSize();
            }
        };
    }

    private PropertyValueModel<CustomConverter> buildCustomConverterHolder() {
        return new TransformationPropertyValueModel<EclipseLinkConverter, CustomConverter>(this.selectedConverterHolder){

            protected CustomConverter transform_(EclipseLinkConverter value) {
                return value.getType() == "customConverter" ? (CustomConverter)value : null;
            }
        };
    }

    private PropertyValueModel<ObjectTypeConverter> buildObjectTypeConverterHolder() {
        return new TransformationPropertyValueModel<EclipseLinkConverter, ObjectTypeConverter>(this.selectedConverterHolder){

            protected ObjectTypeConverter transform_(EclipseLinkConverter value) {
                return value.getType() == "objectTypeConverter" ? (ObjectTypeConverter)value : null;
            }
        };
    }

    private PropertyValueModel<StructConverter> buildStructConverterHolder() {
        return new TransformationPropertyValueModel<EclipseLinkConverter, StructConverter>(this.selectedConverterHolder){

            protected StructConverter transform_(EclipseLinkConverter value) {
                return value.getType() == "structConverter" ? (StructConverter)value : null;
            }
        };
    }

    private PropertyValueModel<TypeConverter> buildTypeConverterHolder() {
        return new TransformationPropertyValueModel<EclipseLinkConverter, TypeConverter>(this.selectedConverterHolder){

            protected TypeConverter transform_(EclipseLinkConverter value) {
                return value.getType() == "typeConverter" ? (TypeConverter)value : null;
            }
        };
    }

    private ILabelProvider buildConvertersListLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                return ((EclipseLinkConverter)element).getName();
            }
        };
    }

    public void enableWidgets(boolean enabled) {
        super.enableWidgets(enabled);
        this.listPane.enableWidgets(enabled);
    }

    private Iterator<String> converterNames() {
        return new TransformationIterator<CustomConverter, String>((Iterator)((ConverterHolder)this.getSubject()).customConverters()){

            protected String transform(CustomConverter next) {
                return next.getName();
            }
        };
    }
}

