/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.ui.internal.persistence.caching;

import java.util.ArrayList;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching.Caching;
import org.eclipse.jpt.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.jpt.eclipselink.ui.internal.persistence.caching.EntityCacheProperties;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.ui.internal.widgets.TriStateCheckBox;
import org.eclipse.jpt.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.utility.internal.model.value.ListPropertyValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.PropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedCacheComposite
extends Pane<EntityCacheProperties> {
    private TriStateCheckBox sharedCacheCheckBox;

    public SharedCacheComposite(Pane<EntityCacheProperties> parentComposite, Composite parent) {
        super(parentComposite, parent);
    }

    private PropertyValueModel<Caching> buildCachingHolder() {
        return new TransformationPropertyValueModel<EntityCacheProperties, Caching>(this.getSubjectHolder()){

            protected Caching transform_(EntityCacheProperties value) {
                return value.getCaching();
            }
        };
    }

    private PropertyValueModel<Boolean> buildDefaultAndNonDefaultSharedCacheHolder() {
        return new ListPropertyValueModelAdapter<Boolean>(this.buildDefaultAndNonDefaultSharedCacheListHolder()){

            protected Boolean buildValue() {
                if (this.listHolder.size() == 1) {
                    return (Boolean)this.listHolder.listIterator().next();
                }
                return null;
            }
        };
    }

    private ListValueModel<Boolean> buildDefaultAndNonDefaultSharedCacheListHolder() {
        ArrayList<ListValueModel<Boolean>> holders = new ArrayList<ListValueModel<Boolean>>(2);
        holders.add(this.buildSharedCacheListHolder());
        holders.add(this.buildDefaultSharedCacheListHolder());
        return new CompositeListValueModel(holders);
    }

    private PropertyValueModel<Boolean> buildDefaultSharedCacheHolder() {
        return new PropertyAspectAdapter<Caching, Boolean>(this.buildCachingHolder(), new String[]{"sharedCacheDefaultProperty"}){

            protected Boolean buildValue_() {
                Boolean value = ((Caching)this.subject).getSharedCacheDefault();
                if (value == null) {
                    value = ((Caching)this.subject).getDefaultSharedCacheDefault();
                }
                return value;
            }
        };
    }

    private ListValueModel<Boolean> buildDefaultSharedCacheListHolder() {
        return new PropertyListValueModelAdapter(this.buildDefaultSharedCacheHolder());
    }

    private WritablePropertyValueModel<Boolean> buildSharedCacheHolder() {
        return new PropertyAspectAdapter<EntityCacheProperties, Boolean>(this.getSubjectHolder(), new String[]{"sharedCacheProperty"}){

            protected Boolean buildValue_() {
                return ((EntityCacheProperties)((Object)this.subject)).getSharedCache();
            }

            protected void setValue_(Boolean value) {
                ((EntityCacheProperties)((Object)this.subject)).setSharedCache(value);
            }
        };
    }

    private ListValueModel<Boolean> buildSharedCacheListHolder() {
        return new PropertyListValueModelAdapter(this.buildSharedCacheHolder());
    }

    private PropertyValueModel<String> buildSharedCacheStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildDefaultAndNonDefaultSharedCacheHolder()){

            protected String transform(Boolean value) {
                if (value != null) {
                    String defaultStringValue = value != false ? EclipseLinkUiMessages.Boolean_True : EclipseLinkUiMessages.Boolean_False;
                    return NLS.bind((String)EclipseLinkUiMessages.PersistenceXmlCachingTab_defaultSharedCacheLabel, (Object)defaultStringValue);
                }
                return EclipseLinkUiMessages.PersistenceXmlCachingTab_sharedCacheLabel;
            }
        };
    }

    public void enableWidgets(boolean enabled) {
        super.enableWidgets(enabled);
        this.sharedCacheCheckBox.setEnabled(enabled);
    }

    protected void initializeLayout(Composite container) {
        this.sharedCacheCheckBox = this.addTriStateCheckBoxWithDefault(container, EclipseLinkUiMessages.PersistenceXmlCachingTab_sharedCacheLabel, this.buildSharedCacheHolder(), this.buildSharedCacheStringHolder(), null);
    }
}

