/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.ui.internal.persistence.options;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.options.Options;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.options.TargetServer;
import org.eclipse.jpt.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.jpt.ui.internal.util.SWTUtil;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringConverter;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.jpt.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.PropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.utility.internal.model.value.SortedListValueModelAdapter;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetServerComposite
extends Pane<Options> {
    public TargetServerComposite(Pane<? extends Options> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    private PropertyValueModel<String> buildDefaultTargetServerHolder() {
        return new PropertyAspectAdapter<Options, String>(this.getSubjectHolder(), new String[]{Options.DEFAULT_TARGET_SERVER}){

            protected String buildValue_() {
                return TargetServerComposite.this.getDefaultValue((Options)this.subject);
            }
        };
    }

    private ListValueModel<String> buildDefaultTargetServerListHolder() {
        return new PropertyListValueModelAdapter(this.buildDefaultTargetServerHolder());
    }

    private String buildDisplayString(String targetServerName) {
        return SWTUtil.buildDisplayString(EclipseLinkUiMessages.class, ((Object)((Object)this)).getClass(), (Object)TargetServer.valueOf((String)targetServerName));
    }

    private Comparator<String> buildTargetServerComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String targetServer1, String targetServer2) {
                targetServer1 = TargetServerComposite.this.buildDisplayString(targetServer1);
                targetServer2 = TargetServerComposite.this.buildDisplayString(targetServer2);
                return Collator.getInstance().compare(targetServer1, targetServer2);
            }
        };
    }

    private StringConverter<String> buildTargetServerConverter() {
        return new StringConverter<String>(){

            public String convertToString(String value) {
                try {
                    TargetServer.valueOf((String)value);
                    value = TargetServerComposite.this.buildDisplayString(value);
                }
                catch (Exception exception) {}
                return value;
            }
        };
    }

    private WritablePropertyValueModel<String> buildTargetServerHolder() {
        return new PropertyAspectAdapter<Options, String>(this.getSubjectHolder(), new String[]{"targetServerProperty"}){

            protected String buildValue_() {
                String name = ((Options)this.subject).getTargetServer();
                if (name == null) {
                    name = TargetServerComposite.this.getDefaultValue((Options)this.subject);
                }
                return name;
            }

            protected void setValue_(String value) {
                if (TargetServerComposite.this.getDefaultValue((Options)this.subject).equals(value)) {
                    value = null;
                }
                ((Options)this.subject).setTargetServer(value);
            }
        };
    }

    private ListValueModel<String> buildTargetServerListHolder() {
        ArrayList<ListValueModel<String>> holders = new ArrayList<ListValueModel<String>>(2);
        holders.add(this.buildDefaultTargetServerListHolder());
        holders.add(this.buildTargetServersListHolder());
        return new CompositeListValueModel(holders);
    }

    private Iterator<String> buildTargetServers() {
        return new TransformationIterator<TargetServer, String>(CollectionTools.iterator((Object[])TargetServer.values())){

            protected String transform(TargetServer next) {
                return next.name();
            }
        };
    }

    private CollectionValueModel<String> buildTargetServersCollectionHolder() {
        return new SimpleCollectionValueModel((Collection)CollectionTools.collection(this.buildTargetServers()));
    }

    private ListValueModel<String> buildTargetServersListHolder() {
        return new SortedListValueModelAdapter(this.buildTargetServersCollectionHolder(), this.buildTargetServerComparator());
    }

    private String getDefaultValue(Options subject) {
        String defaultValue = subject.getDefaultTargetServer();
        if (defaultValue != null) {
            return NLS.bind((String)EclipseLinkUiMessages.PersistenceXmlOptionsTab_defaultWithOneParam, (Object)defaultValue);
        }
        return EclipseLinkUiMessages.PersistenceXmlOptionsTab_defaultEmpty;
    }

    protected void initializeLayout(Composite container) {
        CCombo combo = this.addLabeledEditableCCombo(container, EclipseLinkUiMessages.PersistenceXmlOptionsTab_targetServerLabel, this.buildTargetServerListHolder(), this.buildTargetServerHolder(), this.buildTargetServerConverter(), null);
        SWTUtil.attachDefaultValueHandler((CCombo)combo);
    }
}

