/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jpt.core.context.TemporalConverter;
import org.eclipse.jpt.core.context.TemporalType;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.util.ControlEnabler;
import org.eclipse.jpt.ui.internal.util.SWTUtil;
import org.eclipse.jpt.ui.internal.widgets.FormPane;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringConverter;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimpleListValueModel;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemporalTypeComposite
extends FormPane<TemporalConverter> {
    public TemporalTypeComposite(PropertyValueModel<? extends TemporalConverter> subjectHolder, Composite parent, WidgetFactory widgetFactory) {
        super(subjectHolder, parent, widgetFactory);
    }

    @Override
    protected void initializeLayout(Composite container) {
        CCombo combo = this.addCCombo(container, this.buildTemporalTypeListHolder(), this.buildTemporalTypeHolder(), this.buildTemporalTypeConverter());
        new ControlEnabler(this.buildBooleanHolder(), (Control)combo);
    }

    private WritablePropertyValueModel<TemporalType> buildTemporalTypeHolder() {
        return new PropertyAspectAdapter<TemporalConverter, TemporalType>(this.getSubjectHolder(), new String[]{"temporalTypeProperty"}){

            protected TemporalType buildValue_() {
                return ((TemporalConverter)this.subject).getTemporalType();
            }

            protected void setValue_(TemporalType value) {
                ((TemporalConverter)this.subject).setTemporalType(value);
            }
        };
    }

    private ListValueModel<TemporalType> buildTemporalTypeListHolder() {
        return new SimpleListValueModel(this.buildSortedTemporalTypeList());
    }

    private List<TemporalType> buildSortedTemporalTypeList() {
        ArrayList types = CollectionTools.list((Object[])TemporalType.values());
        Collections.sort(types, this.buildTemporalTypeComparator());
        return types;
    }

    private Comparator<TemporalType> buildTemporalTypeComparator() {
        return new Comparator<TemporalType>(){

            @Override
            public int compare(TemporalType type1, TemporalType type2) {
                String displayString1 = TemporalTypeComposite.this.displayString(type1);
                String displayString2 = TemporalTypeComposite.this.displayString(type2);
                return Collator.getInstance().compare(displayString1, displayString2);
            }
        };
    }

    private StringConverter<TemporalType> buildTemporalTypeConverter() {
        return new StringConverter<TemporalType>(){

            public String convertToString(TemporalType value) {
                if (value == null) {
                    return null;
                }
                return TemporalTypeComposite.this.displayString(value);
            }
        };
    }

    private String displayString(TemporalType temporalType) {
        return SWTUtil.buildDisplayString(JptUiMappingsMessages.class, this, (Object)temporalType.name());
    }

    protected PropertyValueModel<Boolean> buildBooleanHolder() {
        return new TransformationPropertyValueModel<TemporalConverter, Boolean>(this.getSubjectHolder()){

            protected Boolean transform(TemporalConverter value) {
                if (TemporalTypeComposite.this.getSubject() != null && ((TemporalConverter)TemporalTypeComposite.this.getSubject()).getParent().getPersistentAttribute().isVirtual()) {
                    return Boolean.FALSE;
                }
                return value != null;
            }
        };
    }
}

