/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.SortedSet;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NameTools {
    public static final String[] JAVA_RESERVED_WORDS = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    public static final SortedSet<String> JAVA_RESERVED_WORDS_SET = Collections.unmodifiableSortedSet(CollectionTools.sortedSet((Comparable[])JAVA_RESERVED_WORDS));

    public static String uniqueNameFor(String rootName, Iterator<String> existingNames) {
        return NameTools.uniqueNameFor(rootName, CollectionTools.set(existingNames));
    }

    public static String uniqueNameFor(String rootName, Collection<String> existingNames) {
        return NameTools.uniqueNameFor(rootName, existingNames, rootName);
    }

    public static String uniqueNameForIgnoreCase(String rootName, Iterator<String> existingNames) {
        return NameTools.uniqueNameForIgnoreCase(rootName, CollectionTools.set(existingNames));
    }

    public static String uniqueNameForIgnoreCase(String rootName, Collection<String> existingNames) {
        return NameTools.uniqueNameFor(rootName, NameTools.convertToLowerCase(existingNames), rootName.toLowerCase());
    }

    private static String uniqueNameFor(String rootName, Collection<String> existingNames, String templateName) {
        if (!existingNames.contains(templateName)) {
            return rootName;
        }
        String uniqueName = templateName;
        int suffix = 2;
        while (existingNames.contains(String.valueOf(uniqueName) + suffix)) {
            ++suffix;
        }
        return rootName.concat(String.valueOf(suffix));
    }

    private static HashSet<String> convertToLowerCase(Collection<String> strings) {
        HashSet<String> result = new HashSet<String>(strings.size());
        for (String string : strings) {
            result.add(string.toLowerCase());
        }
        return result;
    }

    public static String buildQualifiedDatabaseObjectName(String catalog, String schema, String name) {
        if (name == null) {
            return null;
        }
        if (catalog == null && schema == null) {
            return name;
        }
        StringBuilder sb = new StringBuilder(100);
        if (catalog != null) {
            sb.append(catalog);
            sb.append('.');
        }
        if (schema != null) {
            sb.append(schema);
        }
        sb.append('.');
        sb.append(name);
        return sb.toString();
    }

    public static Iterator<String> javaReservedWords() {
        return new ArrayIterator<String>(JAVA_RESERVED_WORDS);
    }

    public static boolean stringConsistsOfJavaIdentifierCharacters(String string) {
        if (string.length() == 0) {
            return false;
        }
        return NameTools.stringConsistsOfJavaIdentifierCharacters_(string.toCharArray());
    }

    public static boolean stringConsistsOfJavaIdentifierCharacters(char[] string) {
        if (string.length == 0) {
            return false;
        }
        return NameTools.stringConsistsOfJavaIdentifierCharacters_(string);
    }

    private static boolean stringConsistsOfJavaIdentifierCharacters_(char[] string) {
        if (!Character.isJavaIdentifierStart(string[0])) {
            return false;
        }
        int i = string.length;
        while (i-- > 1) {
            if (Character.isJavaIdentifierPart(string[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean stringIsLegalJavaIdentifier(String string) {
        return NameTools.stringConsistsOfJavaIdentifierCharacters(string) && !JAVA_RESERVED_WORDS_SET.contains(string);
    }

    public static boolean stringIsLegalJavaIdentifier(char[] string) {
        return NameTools.stringConsistsOfJavaIdentifierCharacters(string) && !JAVA_RESERVED_WORDS_SET.contains(new String(string));
    }

    public static String convertToJavaIdentifier(String string) {
        return NameTools.convertToJavaIdentifier(string, '_');
    }

    public static String convertToJavaIdentifier(String string, char c) {
        if (string.length() == 0) {
            return string;
        }
        if (JAVA_RESERVED_WORDS_SET.contains(string)) {
            NameTools.checkCharIsJavaIdentifierPart(c);
            return NameTools.convertToJavaIdentifier(String.valueOf(string) + c, c);
        }
        char[] array = string.toCharArray();
        return NameTools.convertToJavaIdentifier_(array, c) ? new String(array) : string;
    }

    public static char[] convertToJavaIdentifier(char[] string) {
        return NameTools.convertToJavaIdentifier(string, '_');
    }

    public static char[] convertToJavaIdentifier(char[] string, char c) {
        if (string.length == 0) {
            return string;
        }
        if (JAVA_RESERVED_WORDS_SET.contains(new String(string))) {
            NameTools.checkCharIsJavaIdentifierPart(c);
            return NameTools.convertToJavaIdentifier(CollectionTools.add(string, c), c);
        }
        NameTools.convertToJavaIdentifier_(string, c);
        return string;
    }

    private static boolean convertToJavaIdentifier_(char[] string, char c) {
        boolean mod = false;
        if (!Character.isJavaIdentifierStart(string[0])) {
            NameTools.checkCharIsJavaIdentifierStart(c);
            string[0] = c;
            mod = true;
        }
        NameTools.checkCharIsJavaIdentifierPart(c);
        int i = string.length;
        while (i-- > 1) {
            if (Character.isJavaIdentifierPart(string[i])) continue;
            string[i] = c;
            mod = true;
        }
        return mod;
    }

    private static void checkCharIsJavaIdentifierStart(char c) {
        if (!Character.isJavaIdentifierStart(c)) {
            throw new IllegalArgumentException("invalid Java identifier start char: '" + c + '\'');
        }
    }

    private static void checkCharIsJavaIdentifierPart(char c) {
        if (!Character.isJavaIdentifierPart(c)) {
            throw new IllegalArgumentException("invalid Java identifier part char: '" + c + '\'');
        }
    }

    private NameTools() {
        throw new UnsupportedOperationException();
    }
}

