/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.orm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.context.XmlContextNode;
import org.eclipse.jpt.core.internal.context.AbstractXmlContextNode;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.eclipselink.core.context.CustomConverter;
import org.eclipse.jpt.eclipselink.core.context.ObjectTypeConverter;
import org.eclipse.jpt.eclipselink.core.context.StructConverter;
import org.eclipse.jpt.eclipselink.core.context.TypeConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.ConverterHolder;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.EclipseLinkOrmCustomConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.EclipseLinkOrmObjectTypeConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.EclipseLinkOrmStructConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.EclipseLinkOrmTypeConverter;
import org.eclipse.jpt.eclipselink.core.resource.orm.EclipseLinkOrmFactory;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlConverter;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlConverterImpl;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlConvertersHolder;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlObjectTypeConverter;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlObjectTypeConverterImpl;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlStructConverter;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlStructConverterImpl;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlTypeConverter;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlTypeConverterImpl;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkOrmConverterHolder
extends AbstractXmlContextNode
implements ConverterHolder {
    private XmlConvertersHolder resourceConvertersHolder;
    protected final List<EclipseLinkOrmCustomConverter> customConverters = new ArrayList<EclipseLinkOrmCustomConverter>();
    protected final List<EclipseLinkOrmObjectTypeConverter> objectTypeConverters = new ArrayList<EclipseLinkOrmObjectTypeConverter>();
    protected final List<EclipseLinkOrmStructConverter> structConverters = new ArrayList<EclipseLinkOrmStructConverter>();
    protected final List<EclipseLinkOrmTypeConverter> typeConverters = new ArrayList<EclipseLinkOrmTypeConverter>();

    public EclipseLinkOrmConverterHolder(XmlContextNode parent) {
        super((JpaContextNode)parent);
    }

    public ListIterator<EclipseLinkOrmCustomConverter> customConverters() {
        return this.customConverters.listIterator();
    }

    @Override
    public int customConvertersSize() {
        return this.customConverters.size();
    }

    @Override
    public CustomConverter addCustomConverter(int index) {
        XmlConverterImpl resourceConverter = EclipseLinkOrmFactory.eINSTANCE.createXmlConverterImpl();
        EclipseLinkOrmCustomConverter contextConverter = new EclipseLinkOrmCustomConverter((XmlContextNode)this, resourceConverter);
        this.customConverters.add(index, contextConverter);
        this.resourceConvertersHolder.getConverters().add(index, (Object)resourceConverter);
        this.fireItemAdded("customConvertersList", index, contextConverter);
        return contextConverter;
    }

    protected void addCustomConverter(int index, EclipseLinkOrmCustomConverter converter) {
        this.addItemToList(index, converter, this.customConverters, "customConvertersList");
    }

    protected void addCustomConverter(EclipseLinkOrmCustomConverter converter) {
        this.addCustomConverter(this.customConverters.size(), converter);
    }

    @Override
    public void removeCustomConverter(int index) {
        EclipseLinkOrmCustomConverter removedConverter = this.customConverters.remove(index);
        this.resourceConvertersHolder.getConverters().remove(index);
        this.fireItemRemoved("customConvertersList", index, removedConverter);
    }

    @Override
    public void removeCustomConverter(CustomConverter converter) {
        this.removeCustomConverter(this.customConverters.indexOf(converter));
    }

    protected void removeConverter_(CustomConverter converter) {
        this.removeItemFromList(converter, this.customConverters, "customConvertersList");
    }

    @Override
    public void moveCustomConverter(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.customConverters, (int)targetIndex, (int)sourceIndex);
        this.resourceConvertersHolder.getConverters().move(targetIndex, sourceIndex);
        this.fireItemMoved("customConvertersList", targetIndex, sourceIndex);
    }

    protected void moveCustomConverter_(int index, EclipseLinkOrmCustomConverter converter) {
        this.moveItemInList(index, this.customConverters.indexOf(converter), this.customConverters, "customConvertersList");
    }

    public ListIterator<EclipseLinkOrmObjectTypeConverter> objectTypeConverters() {
        return this.objectTypeConverters.listIterator();
    }

    @Override
    public int objectTypeConvertersSize() {
        return this.objectTypeConverters.size();
    }

    @Override
    public ObjectTypeConverter addObjectTypeConverter(int index) {
        XmlObjectTypeConverterImpl resourceObjectTypeConverter = EclipseLinkOrmFactory.eINSTANCE.createXmlObjectTypeConverterImpl();
        EclipseLinkOrmObjectTypeConverter contextObjectTypeConverter = new EclipseLinkOrmObjectTypeConverter((XmlContextNode)this, resourceObjectTypeConverter);
        this.objectTypeConverters.add(index, contextObjectTypeConverter);
        this.resourceConvertersHolder.getObjectTypeConverters().add(index, (Object)resourceObjectTypeConverter);
        this.fireItemAdded("objectTypeConvertersList", index, contextObjectTypeConverter);
        return contextObjectTypeConverter;
    }

    protected void addObjectTypeConverter(int index, EclipseLinkOrmObjectTypeConverter converter) {
        this.addItemToList(index, converter, this.objectTypeConverters, "objectTypeConvertersList");
    }

    protected void addObjectTypeConverter(EclipseLinkOrmObjectTypeConverter converter) {
        this.addObjectTypeConverter(this.objectTypeConverters.size(), converter);
    }

    @Override
    public void removeObjectTypeConverter(int index) {
        EclipseLinkOrmObjectTypeConverter removedObjectTypeConverter = this.objectTypeConverters.remove(index);
        this.resourceConvertersHolder.getObjectTypeConverters().remove(index);
        this.fireItemRemoved("objectTypeConvertersList", index, removedObjectTypeConverter);
    }

    @Override
    public void removeObjectTypeConverter(ObjectTypeConverter converter) {
        this.removeObjectTypeConverter(this.objectTypeConverters.indexOf(converter));
    }

    protected void removeObjectTypeConverter_(ObjectTypeConverter converter) {
        this.removeItemFromList(converter, this.objectTypeConverters, "objectTypeConvertersList");
    }

    @Override
    public void moveObjectTypeConverter(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.objectTypeConverters, (int)targetIndex, (int)sourceIndex);
        this.resourceConvertersHolder.getObjectTypeConverters().move(targetIndex, sourceIndex);
        this.fireItemMoved("objectTypeConvertersList", targetIndex, sourceIndex);
    }

    protected void moveObjectTypeConverter_(int index, EclipseLinkOrmObjectTypeConverter converter) {
        this.moveItemInList(index, this.objectTypeConverters.indexOf(converter), this.objectTypeConverters, "objectTypeConvertersList");
    }

    public ListIterator<EclipseLinkOrmStructConverter> structConverters() {
        return this.structConverters.listIterator();
    }

    @Override
    public int structConvertersSize() {
        return this.structConverters.size();
    }

    @Override
    public StructConverter addStructConverter(int index) {
        XmlStructConverterImpl resourceStructConverter = EclipseLinkOrmFactory.eINSTANCE.createXmlStructConverterImpl();
        EclipseLinkOrmStructConverter contextStructConverter = new EclipseLinkOrmStructConverter((XmlContextNode)this, resourceStructConverter);
        this.structConverters.add(index, contextStructConverter);
        this.resourceConvertersHolder.getStructConverters().add(index, (Object)resourceStructConverter);
        this.fireItemAdded("structConvertersList", index, contextStructConverter);
        return contextStructConverter;
    }

    protected void addStructConverter(int index, EclipseLinkOrmStructConverter converter) {
        this.addItemToList(index, converter, this.structConverters, "structConvertersList");
    }

    protected void addStructConverter(EclipseLinkOrmStructConverter converter) {
        this.addStructConverter(this.structConverters.size(), converter);
    }

    @Override
    public void removeStructConverter(int index) {
        EclipseLinkOrmStructConverter removedStructConverter = this.structConverters.remove(index);
        this.resourceConvertersHolder.getStructConverters().remove(index);
        this.fireItemRemoved("structConvertersList", index, removedStructConverter);
    }

    @Override
    public void removeStructConverter(StructConverter converter) {
        this.removeStructConverter(this.structConverters.indexOf(converter));
    }

    protected void removeStructConverter_(StructConverter converter) {
        this.removeItemFromList(converter, this.structConverters, "structConvertersList");
    }

    @Override
    public void moveStructConverter(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.structConverters, (int)targetIndex, (int)sourceIndex);
        this.resourceConvertersHolder.getStructConverters().move(targetIndex, sourceIndex);
        this.fireItemMoved("structConvertersList", targetIndex, sourceIndex);
    }

    protected void moveStructConverter_(int index, EclipseLinkOrmStructConverter converter) {
        this.moveItemInList(index, this.structConverters.indexOf(converter), this.structConverters, "structConvertersList");
    }

    public ListIterator<EclipseLinkOrmTypeConverter> typeConverters() {
        return this.typeConverters.listIterator();
    }

    @Override
    public int typeConvertersSize() {
        return this.typeConverters.size();
    }

    @Override
    public TypeConverter addTypeConverter(int index) {
        XmlTypeConverterImpl resourceTypeConverter = EclipseLinkOrmFactory.eINSTANCE.createXmlTypeConverterImpl();
        EclipseLinkOrmTypeConverter contextTypeConverter = new EclipseLinkOrmTypeConverter((XmlContextNode)this, resourceTypeConverter);
        this.typeConverters.add(index, contextTypeConverter);
        this.resourceConvertersHolder.getTypeConverters().add(index, (Object)resourceTypeConverter);
        this.fireItemAdded("typeConvertersList", index, contextTypeConverter);
        return contextTypeConverter;
    }

    protected void addTypeConverter(int index, EclipseLinkOrmTypeConverter converter) {
        this.addItemToList(index, converter, this.typeConverters, "typeConvertersList");
    }

    protected void addTypeConverter(EclipseLinkOrmTypeConverter converter) {
        this.addTypeConverter(this.typeConverters.size(), converter);
    }

    @Override
    public void removeTypeConverter(int index) {
        EclipseLinkOrmTypeConverter removedTypeConverter = this.typeConverters.remove(index);
        this.resourceConvertersHolder.getTypeConverters().remove(index);
        this.fireItemRemoved("typeConvertersList", index, removedTypeConverter);
    }

    @Override
    public void removeTypeConverter(TypeConverter converter) {
        this.removeTypeConverter(this.typeConverters.indexOf(converter));
    }

    protected void removeTypeConverter_(TypeConverter converter) {
        this.removeItemFromList(converter, this.typeConverters, "typeConvertersList");
    }

    @Override
    public void moveTypeConverter(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.typeConverters, (int)targetIndex, (int)sourceIndex);
        this.resourceConvertersHolder.getTypeConverters().move(targetIndex, sourceIndex);
        this.fireItemMoved("typeConvertersList", targetIndex, sourceIndex);
    }

    protected void moveTypeConverter_(int index, EclipseLinkOrmTypeConverter converter) {
        this.moveItemInList(index, this.typeConverters.indexOf(converter), this.typeConverters, "typeConvertersList");
    }

    public void initialize(XmlConvertersHolder resourceConvertersHolder) {
        this.resourceConvertersHolder = resourceConvertersHolder;
        this.initializeCustomConverters();
        this.initializeObjectTypeConverters();
        this.initializeStructConverters();
        this.initializeTypeConverters();
    }

    protected void initializeCustomConverters() {
        for (XmlConverter resourceConverter : this.resourceConvertersHolder.getConverters()) {
            this.customConverters.add(new EclipseLinkOrmCustomConverter((XmlContextNode)this, resourceConverter));
        }
    }

    protected void initializeObjectTypeConverters() {
        for (XmlObjectTypeConverter resourceConverter : this.resourceConvertersHolder.getObjectTypeConverters()) {
            this.objectTypeConverters.add(new EclipseLinkOrmObjectTypeConverter((XmlContextNode)this, resourceConverter));
        }
    }

    protected void initializeStructConverters() {
        for (XmlStructConverter resourceConverter : this.resourceConvertersHolder.getStructConverters()) {
            this.structConverters.add(new EclipseLinkOrmStructConverter((XmlContextNode)this, resourceConverter));
        }
    }

    protected void initializeTypeConverters() {
        for (XmlTypeConverter resourceConverter : this.resourceConvertersHolder.getTypeConverters()) {
            this.typeConverters.add(new EclipseLinkOrmTypeConverter((XmlContextNode)this, resourceConverter));
        }
    }

    public void update(XmlConvertersHolder resourceConvertersHolder) {
        this.resourceConvertersHolder = resourceConvertersHolder;
        this.updateCustomConverters();
        this.updateObjectTypeConverters();
        this.updateStructConverters();
        this.updateTypeConverters();
    }

    protected void updateCustomConverters() {
        HashBag contextConvertersToRemove = CollectionTools.collection(this.customConverters());
        ArrayList<EclipseLinkOrmCustomConverter> contextConvertersToUpdate = new ArrayList<EclipseLinkOrmCustomConverter>();
        CloneListIterator resourceConverters = new CloneListIterator(this.resourceConvertersHolder.getConverters());
        int resourceIndex = 0;
        for (XmlConverter resourceConverter : CollectionTools.iterable((Iterator)resourceConverters)) {
            boolean contextConverterFound = false;
            for (EclipseLinkOrmCustomConverter contextConverter : contextConvertersToRemove) {
                if (contextConverter.getXmlResource() != resourceConverter) continue;
                this.moveCustomConverter_(resourceIndex, contextConverter);
                contextConvertersToRemove.remove(contextConverter);
                contextConvertersToUpdate.add(contextConverter);
                contextConverterFound = true;
                break;
            }
            if (!contextConverterFound) {
                this.addCustomConverter(new EclipseLinkOrmCustomConverter((XmlContextNode)this, resourceConverter));
            }
            ++resourceIndex;
        }
        for (EclipseLinkOrmCustomConverter contextConverter : contextConvertersToRemove) {
            this.removeConverter_(contextConverter);
        }
        for (EclipseLinkOrmCustomConverter contextConverter : contextConvertersToUpdate) {
            contextConverter.update();
        }
    }

    protected void updateObjectTypeConverters() {
        HashBag contextObjectTypeConvertersToRemove = CollectionTools.collection(this.objectTypeConverters());
        ArrayList<EclipseLinkOrmObjectTypeConverter> contextObjectTypeConvertersToUpdate = new ArrayList<EclipseLinkOrmObjectTypeConverter>();
        CloneListIterator resourceObjectTypeConverters = new CloneListIterator(this.resourceConvertersHolder.getObjectTypeConverters());
        int resourceIndex = 0;
        for (XmlObjectTypeConverter resourceObjectTypeConverter : CollectionTools.iterable((Iterator)resourceObjectTypeConverters)) {
            boolean contextObjectTypeConverterFound = false;
            for (EclipseLinkOrmObjectTypeConverter contextObjectTypeConverter : contextObjectTypeConvertersToRemove) {
                if (contextObjectTypeConverter.getXmlResource() != resourceObjectTypeConverter) continue;
                this.moveObjectTypeConverter_(resourceIndex, contextObjectTypeConverter);
                contextObjectTypeConvertersToRemove.remove(contextObjectTypeConverter);
                contextObjectTypeConvertersToUpdate.add(contextObjectTypeConverter);
                contextObjectTypeConverterFound = true;
                break;
            }
            if (!contextObjectTypeConverterFound) {
                this.addObjectTypeConverter(new EclipseLinkOrmObjectTypeConverter((XmlContextNode)this, resourceObjectTypeConverter));
            }
            ++resourceIndex;
        }
        for (EclipseLinkOrmObjectTypeConverter contextObjectTypeConverter : contextObjectTypeConvertersToRemove) {
            this.removeObjectTypeConverter_(contextObjectTypeConverter);
        }
        for (EclipseLinkOrmObjectTypeConverter contextObjectTypeConverter : contextObjectTypeConvertersToUpdate) {
            contextObjectTypeConverter.update();
        }
    }

    protected void updateTypeConverters() {
        HashBag contextTypeConvertersToRemove = CollectionTools.collection(this.typeConverters());
        ArrayList<EclipseLinkOrmTypeConverter> contextTypeConvertersToUpdate = new ArrayList<EclipseLinkOrmTypeConverter>();
        CloneListIterator resourceTypeConverters = new CloneListIterator(this.resourceConvertersHolder.getTypeConverters());
        int resourceIndex = 0;
        for (XmlTypeConverter resourceTypeConverter : CollectionTools.iterable((Iterator)resourceTypeConverters)) {
            boolean contextTypeConverterFound = false;
            for (EclipseLinkOrmTypeConverter contextTypeConverter : contextTypeConvertersToRemove) {
                if (contextTypeConverter.getXmlResource() != resourceTypeConverter) continue;
                this.moveTypeConverter_(resourceIndex, contextTypeConverter);
                contextTypeConvertersToRemove.remove(contextTypeConverter);
                contextTypeConvertersToUpdate.add(contextTypeConverter);
                contextTypeConverterFound = true;
                break;
            }
            if (!contextTypeConverterFound) {
                this.addTypeConverter(new EclipseLinkOrmTypeConverter((XmlContextNode)this, resourceTypeConverter));
            }
            ++resourceIndex;
        }
        for (EclipseLinkOrmTypeConverter contextTypeConverter : contextTypeConvertersToRemove) {
            this.removeTypeConverter_(contextTypeConverter);
        }
        for (EclipseLinkOrmTypeConverter contextTypeConverter : contextTypeConvertersToUpdate) {
            contextTypeConverter.update();
        }
    }

    protected void updateStructConverters() {
        HashBag contextStructConvertersToRemove = CollectionTools.collection(this.structConverters());
        ArrayList<EclipseLinkOrmStructConverter> contextStructConvertersToUpdate = new ArrayList<EclipseLinkOrmStructConverter>();
        CloneListIterator resourceStructConverters = new CloneListIterator(this.resourceConvertersHolder.getStructConverters());
        int resourceIndex = 0;
        for (XmlStructConverter resourceStructConverter : CollectionTools.iterable((Iterator)resourceStructConverters)) {
            boolean contextStructConverterFound = false;
            for (EclipseLinkOrmStructConverter contextStructConverter : contextStructConvertersToRemove) {
                if (contextStructConverter.getXmlResource() != resourceStructConverter) continue;
                this.moveStructConverter_(resourceIndex, contextStructConverter);
                contextStructConvertersToRemove.remove(contextStructConverter);
                contextStructConvertersToUpdate.add(contextStructConverter);
                contextStructConverterFound = true;
                break;
            }
            if (!contextStructConverterFound) {
                this.addStructConverter(new EclipseLinkOrmStructConverter((XmlContextNode)this, resourceStructConverter));
            }
            ++resourceIndex;
        }
        for (EclipseLinkOrmStructConverter contextStructConverter : contextStructConvertersToRemove) {
            this.removeStructConverter_(contextStructConverter);
        }
        for (EclipseLinkOrmStructConverter contextStructConverter : contextStructConvertersToUpdate) {
            contextStructConverter.update();
        }
    }

    public void validate(List<IMessage> messages) {
        super.validate(messages);
    }

    public TextRange getValidationTextRange() {
        return this.resourceConvertersHolder.getValidationTextRange();
    }
}

