/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.orm;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.XmlContextNode;
import org.eclipse.jpt.eclipselink.core.context.ConversionValue;
import org.eclipse.jpt.eclipselink.core.context.ObjectTypeConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.EclipseLinkOrmConversionValue;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.EclipseLinkOrmConverter;
import org.eclipse.jpt.eclipselink.core.resource.orm.EclipseLinkOrmFactory;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlConversionValue;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlConversionValueImpl;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlNamedConverter;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlObjectTypeConverter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationListIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkOrmObjectTypeConverter
extends EclipseLinkOrmConverter
implements ObjectTypeConverter {
    private String dataType;
    private String objectType;
    private final List<EclipseLinkOrmConversionValue> conversionValues = new ArrayList<EclipseLinkOrmConversionValue>();
    private String defaultObjectValue;

    public EclipseLinkOrmObjectTypeConverter(XmlContextNode parent, XmlObjectTypeConverter xmlResource) {
        super(parent);
        this.initialize(xmlResource);
    }

    @Override
    public String getType() {
        return "objectTypeConverter";
    }

    @Override
    protected XmlObjectTypeConverter getXmlResource() {
        return (XmlObjectTypeConverter)super.getXmlResource();
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    @Override
    public void setDataType(String newDataType) {
        String oldDataType = this.dataType;
        this.dataType = newDataType;
        this.getXmlResource().setDataType(newDataType);
        this.firePropertyChanged("dataTypeProperty", oldDataType, newDataType);
    }

    protected void setDataType_(String newDataType) {
        String oldDataType = this.dataType;
        this.dataType = newDataType;
        this.firePropertyChanged("dataTypeProperty", oldDataType, newDataType);
    }

    @Override
    public String getObjectType() {
        return this.objectType;
    }

    @Override
    public void setObjectType(String newObjectType) {
        String oldObjectType = this.objectType;
        this.objectType = newObjectType;
        this.getXmlResource().setObjectType(newObjectType);
        this.firePropertyChanged("objectTypeProperty", oldObjectType, newObjectType);
    }

    protected void setObjectType_(String newObjectType) {
        String oldObjectType = this.objectType;
        this.objectType = newObjectType;
        this.firePropertyChanged("objectTypeProperty", oldObjectType, newObjectType);
    }

    public ListIterator<EclipseLinkOrmConversionValue> conversionValues() {
        return new CloneListIterator(this.conversionValues);
    }

    @Override
    public int conversionValuesSize() {
        return this.conversionValues.size();
    }

    @Override
    public EclipseLinkOrmConversionValue addConversionValue(int index) {
        XmlConversionValueImpl resourceConversionValue = EclipseLinkOrmFactory.eINSTANCE.createXmlConversionValueImpl();
        EclipseLinkOrmConversionValue contextConversionValue = this.buildConversionValue(resourceConversionValue);
        this.conversionValues.add(index, contextConversionValue);
        this.getXmlResource().getConversionValues().add(index, (Object)resourceConversionValue);
        this.fireItemAdded("conversionValuesList", index, contextConversionValue);
        return contextConversionValue;
    }

    @Override
    public EclipseLinkOrmConversionValue addConversionValue() {
        return this.addConversionValue(this.conversionValues.size());
    }

    protected void addConversionValue(int index, EclipseLinkOrmConversionValue conversionValue) {
        this.addItemToList(index, conversionValue, this.conversionValues, "conversionValuesList");
    }

    protected void addConversionValue(EclipseLinkOrmConversionValue conversionValue) {
        this.addConversionValue(this.conversionValues.size(), conversionValue);
    }

    @Override
    public void removeConversionValue(int index) {
        EclipseLinkOrmConversionValue removedJoinColumn = this.conversionValues.remove(index);
        this.getXmlResource().getConversionValues().remove(index);
        this.fireItemRemoved("conversionValuesList", index, removedJoinColumn);
    }

    @Override
    public void removeConversionValue(ConversionValue conversionValue) {
        this.removeConversionValue(this.conversionValues.indexOf(conversionValue));
    }

    protected void removeConversionValue_(ConversionValue conversionValue) {
        this.removeItemFromList(conversionValue, this.conversionValues, "conversionValuesList");
    }

    @Override
    public void moveConversionValue(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.conversionValues, (int)targetIndex, (int)sourceIndex);
        this.getXmlResource().getConversionValues().move(targetIndex, sourceIndex);
        this.fireItemMoved("conversionValuesList", targetIndex, sourceIndex);
    }

    @Override
    public ListIterator<String> dataValues() {
        return new TransformationListIterator<EclipseLinkOrmConversionValue, String>(this.conversionValues()){

            protected String transform(EclipseLinkOrmConversionValue next) {
                return next.getDataValue();
            }
        };
    }

    @Override
    public String getDefaultObjectValue() {
        return this.defaultObjectValue;
    }

    @Override
    public void setDefaultObjectValue(String newDefaultObjectValue) {
        String oldDefaultObjectValue = this.defaultObjectValue;
        this.defaultObjectValue = newDefaultObjectValue;
        this.getXmlResource().setDefaultObjectValue(newDefaultObjectValue);
        this.firePropertyChanged("defaultObjectValueProperty", oldDefaultObjectValue, newDefaultObjectValue);
    }

    protected void setDefaultObjectValue_(String newDefaultObjectValue) {
        String oldDefaultObjectValue = this.defaultObjectValue;
        this.defaultObjectValue = newDefaultObjectValue;
        this.firePropertyChanged("defaultObjectValueProperty", oldDefaultObjectValue, newDefaultObjectValue);
    }

    @Override
    protected void initialize(XmlNamedConverter xmlResource) {
        super.initialize(xmlResource);
        this.dataType = this.calculateDataType();
        this.objectType = this.calculateObjectType();
        this.defaultObjectValue = this.calculateDefaultObjectValue();
        this.initializeConversionValues();
    }

    protected void initializeConversionValues() {
        for (XmlConversionValue resourceConversionValue : this.getXmlResource().getConversionValues()) {
            this.conversionValues.add(this.buildConversionValue(resourceConversionValue));
        }
    }

    @Override
    public void update() {
        super.update();
        this.setDataType_(this.calculateDataType());
        this.setObjectType_(this.calculateObjectType());
        this.setDefaultObjectValue_(this.calculateDefaultObjectValue());
        this.updateConversionValues();
    }

    protected void updateConversionValues() {
        ListIterator<EclipseLinkOrmConversionValue> contextConversionValues = this.conversionValues();
        CloneListIterator resourceConversionValues = new CloneListIterator(this.getXmlResource().getConversionValues());
        while (contextConversionValues.hasNext()) {
            EclipseLinkOrmConversionValue conversionValues = contextConversionValues.next();
            if (resourceConversionValues.hasNext()) {
                conversionValues.update((XmlConversionValue)resourceConversionValues.next());
                continue;
            }
            this.removeConversionValue_(conversionValues);
        }
        while (resourceConversionValues.hasNext()) {
            this.addConversionValue(this.buildConversionValue((XmlConversionValue)resourceConversionValues.next()));
        }
    }

    protected EclipseLinkOrmConversionValue buildConversionValue(XmlConversionValue resourceConversionValue) {
        EclipseLinkOrmConversionValue conversionValue = new EclipseLinkOrmConversionValue(this);
        conversionValue.initialize(resourceConversionValue);
        return conversionValue;
    }

    protected String calculateDataType() {
        return this.getXmlResource().getDataType();
    }

    protected String calculateObjectType() {
        return this.getXmlResource().getObjectType();
    }

    protected String calculateDefaultObjectValue() {
        return this.getXmlResource().getDefaultObjectValue();
    }

    public void validate(List<IMessage> messages) {
        super.validate(messages);
        ListIterator<EclipseLinkOrmConversionValue> stream = this.conversionValues();
        while (stream.hasNext()) {
            ((EclipseLinkOrmConversionValue)stream.next()).validate(messages);
        }
    }
}

