/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.persistence.customization;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.Property;
import org.eclipse.jpt.eclipselink.core.internal.JptEclipseLinkCorePlugin;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.EclipseLinkPersistenceUnitProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.customization.Customization;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.customization.CustomizerProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.customization.Profiler;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.customization.Weaving;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.value.ListValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkCustomization
extends EclipseLinkPersistenceUnitProperties
implements Customization {
    private Boolean throwExceptions;
    private Weaving weaving;
    private Boolean weavingLazy;
    private Boolean weavingChangeTracking;
    private Boolean weavingFetchGroups;
    private Boolean weavingInternal;
    private Boolean weavingEager;
    private ArrayList<ClassRef> sessionCustomizers;
    private String profiler;
    private Map<String, CustomizerProperties> entitiesCustomizerProperties;
    private static final long serialVersionUID = 1L;

    public EclipseLinkCustomization(PersistenceUnit parent, ListValueModel<Property> propertyListAdapter) {
        super(parent, propertyListAdapter);
    }

    @Override
    protected void initializeProperties() {
        this.entitiesCustomizerProperties = new HashMap<String, CustomizerProperties>();
        this.throwExceptions = this.getBooleanValue("eclipselink.orm.throw.exceptions");
        this.weaving = (Weaving)this.getEnumValue("eclipselink.weaving", Weaving.values());
        this.weavingLazy = this.getBooleanValue("eclipselink.weaving.lazy");
        this.weavingChangeTracking = this.getBooleanValue("eclipselink.weaving.changetracking");
        this.weavingFetchGroups = this.getBooleanValue("eclipselink.weaving.fetchgroups");
        this.weavingInternal = this.getBooleanValue("eclipselink.weaving.internal");
        this.weavingEager = this.getBooleanValue("eclipselink.weaving.eager");
        this.initializeSessionCustomizersFromPersistenceUnit();
        Set<Property> properties = this.getPropertiesSetWithPrefix("eclipselink.descriptor.customizer.");
        this.initializeEntitiesCustomizerClass(properties);
        this.profiler = this.getProfilerProtertyValue();
    }

    private void initializeSessionCustomizersFromPersistenceUnit() {
        Set<Property> properties = this.getPropertiesSetWithPrefix("eclipselink.session.customizer");
        this.sessionCustomizers = new ArrayList(properties.size());
        this.initializeSessionCustomizersWith(properties);
    }

    private void initializeSessionCustomizersWith(Set<Property> properties) {
        for (Property property : properties) {
            String className = property.getValue();
            try {
                IType sessionCustomizerClass = this.getJpaProject().getJavaProject().findType(className);
                if (sessionCustomizerClass == null) {
                    throw new RuntimeException("could not find: \"" + className + "\" in project's classpath");
                }
                ClassRef classRef = this.getJpaProject().getJpaPlatform().getJpaFactory().buildClassRef(this.getPersistenceUnit(), sessionCustomizerClass.getFullyQualifiedName());
                this.sessionCustomizers.add(classRef);
            }
            catch (Exception e) {
                JptEclipseLinkCorePlugin.log(e);
            }
        }
    }

    private void initializeEntitiesCustomizerClass(Set<Property> properties) {
        for (Property property : properties) {
            String entityName = this.getEntityName(property);
            this.setCustomizerClass_(property, entityName);
        }
    }

    private String getProfilerProtertyValue() {
        Profiler standardProfiler = (Profiler)this.getEnumValue("eclipselink.profiler", Profiler.values());
        if (!this.getPersistenceUnit().containsProperty("eclipselink.profiler")) {
            return null;
        }
        if (standardProfiler == null) {
            return this.getStringValue("eclipselink.profiler");
        }
        return EclipseLinkCustomization.getEclipseLinkStringValueOf((Object)standardProfiler);
    }

    @Override
    protected void addPropertyNames(Map<String, String> propertyNames) {
        propertyNames.put("eclipselink.orm.throw.exceptions", "throwExceptionsProperty");
        propertyNames.put("eclipselink.weaving", "weavingProperty");
        propertyNames.put("eclipselink.weaving.lazy", "weavingLazyProperty");
        propertyNames.put("eclipselink.weaving.changetracking", "weavingChangeTrackingProperty");
        propertyNames.put("eclipselink.weaving.fetchgroups", "weavingFetchGroupsProperty");
        propertyNames.put("eclipselink.weaving.internal", "weavingInternalProperty");
        propertyNames.put("eclipselink.weaving.eager", "weavingEagerProperty");
        propertyNames.put("eclipselink.session.customizer", "sessionCustomizerProperty");
        propertyNames.put("eclipselink.profiler", "profilerProperty");
    }

    @Override
    public boolean itemIsProperty(Property item) {
        boolean isProperty = super.itemIsProperty(item);
        if (!isProperty && item.getName() != null && item.getName().startsWith("eclipselink.descriptor.customizer.")) {
            return true;
        }
        return isProperty;
    }

    @Override
    public String propertyIdFor(Property property) {
        try {
            return super.propertyIdFor(property);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (property.getName().startsWith("eclipselink.descriptor.customizer.")) {
                return "descriptorCustomizerProperty";
            }
            throw new IllegalArgumentException("Illegal property: " + property.toString());
        }
    }

    public void propertyChanged(PropertyChangeEvent event) {
        String aspectName = event.getAspectName();
        if (aspectName.equals("throwExceptionsProperty")) {
            this.throwExceptionsChanged(event);
        } else if (aspectName.equals("weavingProperty")) {
            this.weavingChanged(event);
        } else if (aspectName.equals("weavingLazyProperty")) {
            this.weavingLazyChanged(event);
        } else if (aspectName.equals("weavingChangeTrackingProperty")) {
            this.weavingChangeTrackingChanged(event);
        } else if (aspectName.equals("weavingFetchGroupsProperty")) {
            this.weavingFetchGroupsChanged(event);
        } else if (aspectName.equals("weavingInternalProperty")) {
            this.weavingInternalChanged(event);
        } else if (aspectName.equals("weavingEagerProperty")) {
            this.weavingEagerChanged(event);
        } else if (aspectName.equals("sessionCustomizerProperty")) {
            this.sessionCustomizersChanged(event);
        } else if (aspectName.equals("descriptorCustomizerProperty")) {
            this.descriptorCustomizerChanged(event);
        } else if (aspectName.equals("profilerProperty")) {
            this.profilerChanged(event);
        } else {
            throw new IllegalArgumentException("Illegal event received - property not applicable: " + aspectName);
        }
    }

    @Override
    public Boolean getThrowExceptions() {
        return this.throwExceptions;
    }

    @Override
    public void setThrowExceptions(Boolean newThrowExceptions) {
        Boolean old = this.throwExceptions;
        this.throwExceptions = newThrowExceptions;
        this.putProperty("throwExceptionsProperty", newThrowExceptions);
        this.firePropertyChanged("throwExceptionsProperty", old, newThrowExceptions);
    }

    private void throwExceptionsChanged(PropertyChangeEvent event) {
        String stringValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        Boolean newValue = EclipseLinkCustomization.getBooleanValueOf(stringValue);
        Boolean old = this.throwExceptions;
        this.throwExceptions = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public Boolean getDefaultThrowExceptions() {
        return DEFAULT_THROW_EXCEPTIONS;
    }

    @Override
    public Boolean getWeavingLazy() {
        return this.weavingLazy;
    }

    @Override
    public void setWeavingLazy(Boolean newWeavingLazy) {
        Boolean old = this.weavingLazy;
        this.weavingLazy = newWeavingLazy;
        this.putProperty("weavingLazyProperty", newWeavingLazy);
        this.firePropertyChanged("weavingLazyProperty", old, newWeavingLazy);
    }

    private void weavingLazyChanged(PropertyChangeEvent event) {
        String stringValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        Boolean newValue = EclipseLinkCustomization.getBooleanValueOf(stringValue);
        Boolean old = this.weavingLazy;
        this.weavingLazy = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public Boolean getDefaultWeavingLazy() {
        return DEFAULT_WEAVING_LAZY;
    }

    @Override
    public Boolean getWeavingChangeTracking() {
        return this.weavingChangeTracking;
    }

    @Override
    public void setWeavingChangeTracking(Boolean newWeavingChangeTracking) {
        Boolean old = this.weavingChangeTracking;
        this.weavingChangeTracking = newWeavingChangeTracking;
        this.putProperty("weavingChangeTrackingProperty", newWeavingChangeTracking);
        this.firePropertyChanged("weavingChangeTrackingProperty", old, newWeavingChangeTracking);
    }

    private void weavingChangeTrackingChanged(PropertyChangeEvent event) {
        String stringValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        Boolean newValue = EclipseLinkCustomization.getBooleanValueOf(stringValue);
        Boolean old = this.weavingChangeTracking;
        this.weavingChangeTracking = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public Boolean getDefaultWeavingChangeTracking() {
        return DEFAULT_WEAVING_CHANGE_TRACKING;
    }

    @Override
    public Boolean getWeavingFetchGroups() {
        return this.weavingFetchGroups;
    }

    @Override
    public void setWeavingFetchGroups(Boolean newWeavingFetchGroups) {
        Boolean old = this.weavingFetchGroups;
        this.weavingFetchGroups = newWeavingFetchGroups;
        this.putProperty("weavingFetchGroupsProperty", newWeavingFetchGroups);
        this.firePropertyChanged("weavingFetchGroupsProperty", old, newWeavingFetchGroups);
    }

    private void weavingFetchGroupsChanged(PropertyChangeEvent event) {
        String stringValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        Boolean newValue = EclipseLinkCustomization.getBooleanValueOf(stringValue);
        Boolean old = this.weavingFetchGroups;
        this.weavingFetchGroups = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public Boolean getDefaultWeavingFetchGroups() {
        return DEFAULT_WEAVING_FETCH_GROUPS;
    }

    @Override
    public Boolean getWeavingInternal() {
        return this.weavingInternal;
    }

    @Override
    public void setWeavingInternal(Boolean newWeavingInternal) {
        Boolean old = this.weavingInternal;
        this.weavingInternal = newWeavingInternal;
        this.putProperty("weavingInternalProperty", newWeavingInternal);
        this.firePropertyChanged("weavingInternalProperty", old, newWeavingInternal);
    }

    private void weavingInternalChanged(PropertyChangeEvent event) {
        String stringValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        Boolean newValue = EclipseLinkCustomization.getBooleanValueOf(stringValue);
        Boolean old = this.weavingInternal;
        this.weavingInternal = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public Boolean getDefaultWeavingInternal() {
        return DEFAULT_WEAVING_INTERNAL;
    }

    @Override
    public Boolean getWeavingEager() {
        return this.weavingEager;
    }

    @Override
    public void setWeavingEager(Boolean newWeavingEager) {
        Boolean old = this.weavingEager;
        this.weavingEager = newWeavingEager;
        this.putProperty("weavingEagerProperty", newWeavingEager);
        this.firePropertyChanged("weavingEagerProperty", old, newWeavingEager);
    }

    private void weavingEagerChanged(PropertyChangeEvent event) {
        String stringValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        Boolean newValue = EclipseLinkCustomization.getBooleanValueOf(stringValue);
        Boolean old = this.weavingEager;
        this.weavingEager = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public Boolean getDefaultWeavingEager() {
        return DEFAULT_WEAVING_EAGER;
    }

    @Override
    public ListIterator<ClassRef> sessionCustomizers() {
        return new CloneListIterator(this.sessionCustomizers);
    }

    @Override
    public int sessionCustomizersSize() {
        return this.sessionCustomizers.size();
    }

    @Override
    public boolean sessionCustomizerExists(String sessionCustomizerClassName) {
        for (ClassRef sessionCustomizer : this.sessionCustomizers) {
            if (!sessionCustomizer.getClassName().equals(sessionCustomizerClassName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ClassRef addSessionCustomizer(String newSessionCustomizerClassName) {
        if (!this.sessionCustomizerExists(newSessionCustomizerClassName)) {
            ClassRef classRef = this.getJpaProject().getJpaPlatform().getJpaFactory().buildClassRef(this.getPersistenceUnit(), newSessionCustomizerClassName);
            this.sessionCustomizers.add(classRef);
            this.putProperty("sessionCustomizerProperty", classRef.getClassName(), true);
            this.fireListChanged("sessionCustomizerListProperty");
            return classRef;
        }
        return null;
    }

    @Override
    public void removeSessionCustomizer(ClassRef classRef) {
        if (this.removeSessionCustomizer(classRef.getClassName()) != null) {
            this.removeProperty("sessionCustomizerProperty", classRef.getClassName());
            this.fireListChanged("sessionCustomizerListProperty");
        }
    }

    private ClassRef removeSessionCustomizer(String sessionCustomizerClassName) {
        ListIterator<ClassRef> i = this.sessionCustomizers();
        while (i.hasNext()) {
            ClassRef classRef = i.next();
            if (!classRef.getClassName().equals(sessionCustomizerClassName)) continue;
            this.sessionCustomizers.remove(classRef);
            return classRef;
        }
        return null;
    }

    private void sessionCustomizersChanged(PropertyChangeEvent event) {
        this.initializeSessionCustomizersFromPersistenceUnit();
        this.fireListChanged("sessionCustomizerListProperty");
    }

    @Override
    public Weaving getWeaving() {
        return this.weaving;
    }

    @Override
    public void setWeaving(Weaving newWeaving) {
        Weaving old = this.weaving;
        this.weaving = newWeaving;
        this.putProperty("weavingProperty", (Object)newWeaving);
        this.firePropertyChanged("weavingProperty", (Object)old, (Object)newWeaving);
    }

    private void weavingChanged(PropertyChangeEvent event) {
        String stringValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        Weaving newValue = (Weaving)EclipseLinkCustomization.getEnumValueOf((String)stringValue, (Enum[])Weaving.values());
        Weaving old = this.weaving;
        this.weaving = newValue;
        this.firePropertyChanged(event.getAspectName(), (Object)old, (Object)newValue);
    }

    @Override
    public Weaving getDefaultWeaving() {
        return DEFAULT_WEAVING;
    }

    @Override
    public String getDescriptorCustomizer(String entityName) {
        CustomizerProperties customizer = this.customizerPropertiesOf(entityName);
        return customizer == null ? null : customizer.getClassName();
    }

    @Override
    public void setDescriptorCustomizer(String newDescriptorCustomizer, String entityName) {
        CustomizerProperties old = this.setCustomizerClass_(newDescriptorCustomizer, entityName);
        this.putStringValue("eclipselink.descriptor.customizer.", entityName, newDescriptorCustomizer, false);
        this.firePropertyChanged("descriptorCustomizerProperty", old, this.customizerPropertiesOf(entityName));
    }

    private void descriptorCustomizerChanged(PropertyChangeEvent event) {
        Property newProperty = (Property)event.getNewValue();
        String entityName = newProperty == null ? this.getEntityName((Property)event.getOldValue()) : this.getEntityName(newProperty);
        CustomizerProperties old = this.setCustomizerClass_(newProperty, entityName);
        this.firePropertyChanged(event.getAspectName(), old, this.customizerPropertiesOf(entityName));
    }

    @Override
    public String getDefaultDescriptorCustomizer() {
        return DEFAULT_DESCRIPTOR_CUSTOMIZER;
    }

    private CustomizerProperties setCustomizerClass_(Property newProperty, String entityName) {
        String newValue = newProperty == null ? null : newProperty.getValue();
        return this.setCustomizerClass_(newValue, entityName);
    }

    private CustomizerProperties setCustomizerClass_(String newValue, String entityName) {
        CustomizerProperties properties = this.customizerPropertiesOf(entityName);
        CustomizerProperties old = properties.clone();
        properties.setClassName(newValue);
        this.putEntityCustomizerProperties(entityName, properties);
        return old;
    }

    private CustomizerProperties customizerPropertiesOf(String entityName) {
        CustomizerProperties properties = this.entitiesCustomizerProperties.get(entityName);
        if (properties == null) {
            properties = new CustomizerProperties(entityName);
        }
        return properties;
    }

    private void clearCustomizerProperties(String entityName) {
        this.setDescriptorCustomizer(null, entityName);
    }

    private void putEntityCustomizerProperties(String entityName, CustomizerProperties properties) {
        this.addOrReplacePropertiesForEntity(entityName, properties);
    }

    @Override
    public ListIterator<String> entities() {
        return CollectionTools.list(this.entitiesCustomizerProperties.keySet()).listIterator();
    }

    @Override
    public int entitiesSize() {
        return this.entitiesCustomizerProperties.size();
    }

    @Override
    public boolean entityExists(String entity) {
        return this.entitiesCustomizerProperties.containsKey(entity);
    }

    @Override
    public String addEntity(String entity) {
        if (this.entityExists(entity)) {
            throw new IllegalStateException("Entity " + entity + " already exist.");
        }
        return this.addOrReplacePropertiesForEntity(entity, new CustomizerProperties(entity));
    }

    private String addOrReplacePropertiesForEntity(String entity, CustomizerProperties properties) {
        if (this.entityExists(entity)) {
            this.replaceEntity_(entity, properties);
            return null;
        }
        this.entitiesCustomizerProperties.put(entity, properties);
        this.fireListChanged("entitiesListProperty");
        return entity;
    }

    private CustomizerProperties replaceEntity_(String entity, CustomizerProperties properties) {
        CustomizerProperties old = this.entitiesCustomizerProperties.get(entity);
        if (properties.isEmpty()) {
            this.entitiesCustomizerProperties.remove(entity);
            this.fireListChanged("entitiesListProperty");
        } else {
            this.entitiesCustomizerProperties.put(entity, properties);
        }
        return old;
    }

    @Override
    public void removeEntity(String entity) {
        if (!this.entityExists(entity)) {
            return;
        }
        this.clearCustomizerProperties(entity);
        this.entitiesCustomizerProperties.remove(entity);
        this.fireListChanged("entitiesListProperty");
    }

    @Override
    public String getProfiler() {
        return this.profiler;
    }

    @Override
    public void setProfiler(Profiler newProfiler) {
        if (newProfiler == null) {
            this.setProfiler_(null);
            return;
        }
        this.setProfiler_(EclipseLinkCustomization.getEclipseLinkStringValueOf((Object)newProfiler));
    }

    @Override
    public void setProfiler(String newProfiler) {
        if (newProfiler == null) {
            this.setProfiler_(null);
            return;
        }
        Profiler profiler = Profiler.getProfilerFor(newProfiler);
        if (profiler == null) {
            this.setProfiler_(newProfiler);
        } else {
            this.setProfiler(profiler);
        }
    }

    private void setProfiler_(String newProfiler) {
        String old = this.profiler;
        this.profiler = newProfiler;
        this.putProperty("profilerProperty", newProfiler);
        this.firePropertyChanged("profilerProperty", old, newProfiler);
    }

    private void profilerChanged(PropertyChangeEvent event) {
        String newValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        String old = this.profiler;
        this.profiler = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public String getDefaultProfiler() {
        return DEFAULT_PROFILER;
    }
}

