/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.ui.internal.mappings.details;

import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.eclipselink.core.context.TypeConverter;
import org.eclipse.jpt.eclipselink.ui.internal.mappings.EclipseLinkUiMappingsMessages;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.internal.util.PaneEnabler;
import org.eclipse.jpt.ui.internal.widgets.ClassChooserPane;
import org.eclipse.jpt.ui.internal.widgets.FormPane;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeConverterComposite
extends FormPane<TypeConverter> {
    public TypeConverterComposite(PropertyValueModel<? extends TypeConverter> subjectHolder, Composite parent, WidgetFactory widgetFactory) {
        super(subjectHolder, parent, widgetFactory);
    }

    protected void initializeLayout(Composite container) {
        this.addLabeledText(container, EclipseLinkUiMappingsMessages.ConverterComposite_nameTextLabel, this.buildNameTextHolder());
        this.addDataTypeChooser(container);
        this.addObjectTypeChooser(container);
        new PaneEnabler(this.buildBooleanHolder(), (Pane)this);
    }

    protected WritablePropertyValueModel<String> buildNameTextHolder() {
        return new PropertyAspectAdapter<TypeConverter, String>(this.getSubjectHolder(), new String[]{"nameProperty"}){

            protected String buildValue_() {
                return ((TypeConverter)this.subject).getName();
            }

            protected void setValue_(String value) {
                if (value.length() == 0) {
                    value = null;
                }
                ((TypeConverter)this.subject).setName(value);
            }
        };
    }

    private ClassChooserPane<TypeConverter> addDataTypeChooser(Composite container) {
        return new ClassChooserPane<TypeConverter>((Pane)this, container){

            protected WritablePropertyValueModel<String> buildTextHolder() {
                return new PropertyAspectAdapter<TypeConverter, String>(this.getSubjectHolder(), new String[]{"dataTypeProperty"}){

                    protected String buildValue_() {
                        return ((TypeConverter)this.subject).getDataType();
                    }

                    protected void setValue_(String value) {
                        if (value.length() == 0) {
                            value = null;
                        }
                        ((TypeConverter)this.subject).setDataType(value);
                    }
                };
            }

            protected String getClassName() {
                return ((TypeConverter)this.getSubject()).getDataType();
            }

            protected String getLabelText() {
                return EclipseLinkUiMappingsMessages.TypeConverterComposite_dataTypeLabel;
            }

            protected JpaProject getJpaProject() {
                return ((TypeConverter)this.getSubject()).getJpaProject();
            }

            protected void promptType() {
                IType type = this.chooseType();
                if (type != null) {
                    String className = type.getFullyQualifiedName('.');
                    ((TypeConverter)this.getSubject()).setDataType(className);
                }
            }
        };
    }

    private ClassChooserPane<TypeConverter> addObjectTypeChooser(Composite container) {
        return new ClassChooserPane<TypeConverter>((Pane)this, container){

            protected WritablePropertyValueModel<String> buildTextHolder() {
                return new PropertyAspectAdapter<TypeConverter, String>(this.getSubjectHolder(), new String[]{"objectTypeProperty"}){

                    protected String buildValue_() {
                        return ((TypeConverter)this.subject).getObjectType();
                    }

                    protected void setValue_(String value) {
                        if (value.length() == 0) {
                            value = null;
                        }
                        ((TypeConverter)this.subject).setObjectType(value);
                    }
                };
            }

            protected String getClassName() {
                return ((TypeConverter)this.getSubject()).getObjectType();
            }

            protected String getLabelText() {
                return EclipseLinkUiMappingsMessages.TypeConverterComposite_objectTypeLabel;
            }

            protected JpaProject getJpaProject() {
                return ((TypeConverter)this.getSubject()).getJpaProject();
            }

            protected void promptType() {
                IType type = this.chooseType();
                if (type != null) {
                    String className = type.getFullyQualifiedName('.');
                    ((TypeConverter)this.getSubject()).setObjectType(className);
                }
            }
        };
    }

    protected PropertyValueModel<Boolean> buildBooleanHolder() {
        return new TransformationPropertyValueModel<TypeConverter, Boolean>(this.getSubjectHolder()){

            protected Boolean transform(TypeConverter value) {
                return value != null;
            }
        };
    }
}

