/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.internal.context.java.GenericJavaPersistentAttribute;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaAttributeMapping<T extends JavaResourceNode>
extends AbstractJavaJpaContextNode
implements JavaAttributeMapping {
    protected JavaResourcePersistentAttribute resourcePersistentAttribute;

    protected AbstractJavaAttributeMapping(JavaPersistentAttribute parent) {
        super(parent);
    }

    protected T getResourceMapping() {
        if (this.isDefault()) {
            return (T)this.resourcePersistentAttribute.getNullMappingAnnotation(this.getAnnotationName());
        }
        return (T)this.resourcePersistentAttribute.getMappingAnnotation(this.getAnnotationName());
    }

    @Override
    public GenericJavaPersistentAttribute getPersistentAttribute() {
        return (GenericJavaPersistentAttribute)this.getParent();
    }

    protected JavaResourcePersistentAttribute getResourcePersistentAttribute() {
        return this.resourcePersistentAttribute;
    }

    @Override
    public boolean isDefault() {
        return this.getPersistentAttribute().mappingIsDefault(this);
    }

    protected boolean embeddableOwned() {
        return this.getTypeMapping().getKey() == "embeddable";
    }

    protected boolean ownerIsEntity() {
        return this.getTypeMapping().getKey() == "entity";
    }

    @Override
    public TypeMapping getTypeMapping() {
        return this.getPersistentAttribute().getTypeMapping();
    }

    protected String getAttributeName() {
        return this.getPersistentAttribute().getName();
    }

    public Table getDbTable(String tableName) {
        return this.getTypeMapping().getDbTable(tableName);
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return null;
    }

    @Override
    public boolean isOverridableAttributeMapping() {
        return false;
    }

    @Override
    public boolean isOverridableAssociationMapping() {
        return false;
    }

    @Override
    public boolean isIdMapping() {
        return false;
    }

    @Override
    public void initialize(JavaResourcePersistentAttribute javaResourcePersistentAttribute) {
        this.resourcePersistentAttribute = javaResourcePersistentAttribute;
        this.initialize(this.getResourceMapping());
    }

    protected void initialize(T resourceMapping) {
    }

    @Override
    public void update(JavaResourcePersistentAttribute javaResourcePersistentAttribute) {
        this.resourcePersistentAttribute = javaResourcePersistentAttribute;
        this.update(this.getResourceMapping());
    }

    protected void update(T resourceMapping) {
    }

    @Override
    public void validate(List<IMessage> messages, CompilationUnit astRoot) {
        super.validate(messages, astRoot);
        this.validateModifiers(messages, astRoot);
        this.validateMappingType(messages, astRoot);
    }

    protected void validateModifiers(List<IMessage> messages, CompilationUnit astRoot) {
        if (this.getPersistentAttribute().getMappingKey() == "transient") {
            return;
        }
        if (this.resourcePersistentAttribute.isForField()) {
            if (this.resourcePersistentAttribute.isFinal()) {
                messages.add(this.buildAttributeMessage("PERSISTENT_ATTRIBUTE_FINAL_FIELD", astRoot));
            }
            if (this.resourcePersistentAttribute.isPublic()) {
                messages.add(this.buildAttributeMessage("PERSISTENT_ATTRIBUTE_PUBLIC_FIELD", astRoot));
            }
        }
    }

    protected IMessage buildAttributeMessage(String msgID, CompilationUnit astRoot) {
        GenericJavaPersistentAttribute attribute = this.getPersistentAttribute();
        return DefaultJpaValidationMessages.buildMessage(1, msgID, new String[]{attribute.getName()}, attribute, attribute.getValidationTextRange(astRoot));
    }

    protected void validateMappingType(List<IMessage> messages, CompilationUnit astRoot) {
        if (!this.getTypeMapping().attributeMappingKeyAllowed(this.getKey())) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_ATTRIBUTE_INVALID_MAPPING", new String[]{this.getPersistentAttribute().getName()}, this, this.getValidationTextRange(astRoot)));
        }
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getResourceMappingTextRange(astRoot);
        return textRange != null ? textRange : this.getPersistentAttribute().getValidationTextRange(astRoot);
    }

    protected TextRange getResourceMappingTextRange(CompilationUnit astRoot) {
        T resourceMapping = this.getResourceMapping();
        return resourceMapping == null ? null : resourceMapping.getTextRange(astRoot);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getAttributeName());
    }
}

