/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.FetchType;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.Nullable;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaJoinColumn;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaSingleRelationshipMapping;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaRelationshipMapping;
import org.eclipse.jpt.core.internal.context.java.GenericJavaPersistentAttribute;
import org.eclipse.jpt.core.internal.resource.java.NullJoinColumn;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.resource.java.RelationshipMappingAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementListIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaSingleRelationshipMapping<T extends RelationshipMappingAnnotation>
extends AbstractJavaRelationshipMapping<T>
implements JavaSingleRelationshipMapping {
    protected final List<JavaJoinColumn> specifiedJoinColumns = new ArrayList<JavaJoinColumn>();
    protected JavaJoinColumn defaultJoinColumn;
    protected Boolean specifiedOptional;

    protected AbstractJavaSingleRelationshipMapping(JavaPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public ListIterator<JavaJoinColumn> joinColumns() {
        return this.containsSpecifiedJoinColumns() ? this.specifiedJoinColumns() : this.defaultJoinColumns();
    }

    @Override
    public int joinColumnsSize() {
        return this.containsSpecifiedJoinColumns() ? this.specifiedJoinColumnsSize() : this.defaultJoinColumnsSize();
    }

    @Override
    public ListIterator<JavaJoinColumn> specifiedJoinColumns() {
        return new CloneListIterator(this.specifiedJoinColumns);
    }

    @Override
    public int specifiedJoinColumnsSize() {
        return this.specifiedJoinColumns.size();
    }

    @Override
    public boolean containsSpecifiedJoinColumns() {
        return !this.specifiedJoinColumns.isEmpty();
    }

    @Override
    public JavaJoinColumn addSpecifiedJoinColumn(int index) {
        JavaJoinColumn oldDefaultJoinColumn = this.defaultJoinColumn;
        if (oldDefaultJoinColumn != null) {
            this.defaultJoinColumn = null;
        }
        JavaJoinColumn joinColumn = this.getJpaFactory().buildJavaJoinColumn(this, this.createJoinColumnOwner());
        this.specifiedJoinColumns.add(index, joinColumn);
        JoinColumnAnnotation joinColumnAnnotation = (JoinColumnAnnotation)this.getResourcePersistentAttribute().addSupportingAnnotation(index, "javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        joinColumn.initialize(joinColumnAnnotation);
        this.fireItemAdded("specifiedJoinColumnsList", index, joinColumn);
        if (oldDefaultJoinColumn != null) {
            this.firePropertyChanged("defaultJoinColumn", oldDefaultJoinColumn, null);
        }
        return joinColumn;
    }

    protected void addSpecifiedJoinColumn(int index, JavaJoinColumn joinColumn) {
        this.addItemToList(index, joinColumn, this.specifiedJoinColumns, "specifiedJoinColumnsList");
    }

    protected void addSpecifiedJoinColumn(JavaJoinColumn joinColumn) {
        this.addSpecifiedJoinColumn(this.specifiedJoinColumns.size(), joinColumn);
    }

    @Override
    public void removeSpecifiedJoinColumn(JoinColumn joinColumn) {
        this.removeSpecifiedJoinColumn(this.specifiedJoinColumns.indexOf(joinColumn));
    }

    @Override
    public void removeSpecifiedJoinColumn(int index) {
        JavaJoinColumn removedJoinColumn = this.specifiedJoinColumns.remove(index);
        if (this.specifiedJoinColumns.isEmpty()) {
            this.defaultJoinColumn = this.buildJoinColumn(new NullJoinColumn(this.getResourcePersistentAttribute()));
        }
        this.getResourcePersistentAttribute().removeSupportingAnnotation(index, "javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        this.fireItemRemoved("specifiedJoinColumnsList", index, removedJoinColumn);
        if (this.defaultJoinColumn != null) {
            this.firePropertyChanged("defaultJoinColumn", null, this.defaultJoinColumn);
        }
    }

    protected void removeSpecifiedJoinColumn_(JavaJoinColumn joinColumn) {
        this.removeItemFromList(joinColumn, this.specifiedJoinColumns, "specifiedJoinColumnsList");
    }

    @Override
    public void moveSpecifiedJoinColumn(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedJoinColumns, (int)targetIndex, (int)sourceIndex);
        this.getResourcePersistentAttribute().moveSupportingAnnotation(targetIndex, sourceIndex, "javax.persistence.JoinColumns");
        this.fireItemMoved("specifiedJoinColumnsList", targetIndex, sourceIndex);
    }

    @Override
    public JavaJoinColumn getDefaultJoinColumn() {
        return this.defaultJoinColumn;
    }

    protected void setDefaultJoinColumn(JavaJoinColumn column) {
        JavaJoinColumn old = this.defaultJoinColumn;
        this.defaultJoinColumn = column;
        this.firePropertyChanged("defaultJoinColumn", old, column);
    }

    protected ListIterator<JavaJoinColumn> defaultJoinColumns() {
        if (this.defaultJoinColumn != null) {
            return new SingleElementListIterator((Object)this.defaultJoinColumn);
        }
        return EmptyListIterator.instance();
    }

    protected int defaultJoinColumnsSize() {
        return this.defaultJoinColumn == null ? 0 : 1;
    }

    @Override
    public Boolean getOptional() {
        return this.specifiedOptional != null ? this.specifiedOptional : this.getDefaultOptional();
    }

    @Override
    public Boolean getSpecifiedOptional() {
        return this.specifiedOptional;
    }

    @Override
    public void setSpecifiedOptional(Boolean optional) {
        Boolean old = this.specifiedOptional;
        this.specifiedOptional = optional;
        this.setOptionalOnResourceModel(optional);
        this.firePropertyChanged("specifiedOptionalProperty", old, optional);
    }

    protected void setSpecifiedOptional_(Boolean optional) {
        Boolean old = this.specifiedOptional;
        this.specifiedOptional = optional;
        this.firePropertyChanged("specifiedOptionalProperty", old, optional);
    }

    @Override
    public Boolean getDefaultOptional() {
        return Nullable.DEFAULT_OPTIONAL;
    }

    protected abstract void setOptionalOnResourceModel(Boolean var1);

    @Override
    public void initialize(JavaResourcePersistentAttribute javaResourcePersistentAttribute) {
        super.initialize(javaResourcePersistentAttribute);
        this.initializeSpecifiedJoinColumns(javaResourcePersistentAttribute);
        this.initializeDefaultJoinColumn(javaResourcePersistentAttribute);
    }

    @Override
    protected void initialize(T relationshipMapping) {
        super.initialize(relationshipMapping);
        this.specifiedOptional = this.buildSpecifiedOptional(relationshipMapping);
    }

    protected void initializeSpecifiedJoinColumns(JavaResourcePersistentAttribute javaResourcePersistentAttribute) {
        ListIterator<NestableAnnotation> annotations = javaResourcePersistentAttribute.supportingAnnotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        while (annotations.hasNext()) {
            this.specifiedJoinColumns.add(this.buildJoinColumn((JoinColumnAnnotation)((Object)annotations.next())));
        }
    }

    protected void initializeDefaultJoinColumn(JavaResourcePersistentAttribute javaResourcePersistentAttribute) {
        if (this.shouldBuildDefaultJoinColumn()) {
            this.defaultJoinColumn = this.buildJoinColumn(new NullJoinColumn(javaResourcePersistentAttribute));
        }
    }

    protected boolean shouldBuildDefaultJoinColumn() {
        return !this.containsSpecifiedJoinColumns() && this.isRelationshipOwner();
    }

    @Override
    public void update(JavaResourcePersistentAttribute javaResourcePersistentAttribute) {
        super.update(javaResourcePersistentAttribute);
        this.updateSpecifiedJoinColumns(javaResourcePersistentAttribute);
        this.updateDefaultJoinColumn(javaResourcePersistentAttribute);
    }

    @Override
    protected void update(T relationshipMapping) {
        super.update(relationshipMapping);
        this.setSpecifiedOptional_(this.buildSpecifiedOptional(relationshipMapping));
    }

    protected abstract Boolean buildSpecifiedOptional(T var1);

    protected void updateSpecifiedJoinColumns(JavaResourcePersistentAttribute javaResourcePersistentAttribute) {
        ListIterator<JavaJoinColumn> joinColumns = this.specifiedJoinColumns();
        ListIterator<NestableAnnotation> resourceJoinColumns = javaResourcePersistentAttribute.supportingAnnotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        while (joinColumns.hasNext()) {
            JavaJoinColumn joinColumn = joinColumns.next();
            if (resourceJoinColumns.hasNext()) {
                joinColumn.update((JoinColumnAnnotation)((Object)resourceJoinColumns.next()));
                continue;
            }
            this.removeSpecifiedJoinColumn_(joinColumn);
        }
        while (resourceJoinColumns.hasNext()) {
            this.addSpecifiedJoinColumn(this.buildJoinColumn((JoinColumnAnnotation)((Object)resourceJoinColumns.next())));
        }
    }

    protected void updateDefaultJoinColumn(JavaResourcePersistentAttribute javaResourcePersistentAttribute) {
        if (this.shouldBuildDefaultJoinColumn()) {
            NullJoinColumn jcAnnotation = new NullJoinColumn(javaResourcePersistentAttribute);
            if (this.defaultJoinColumn == null) {
                this.setDefaultJoinColumn(this.buildJoinColumn(jcAnnotation));
            } else {
                this.defaultJoinColumn.update(jcAnnotation);
            }
        } else {
            this.setDefaultJoinColumn(null);
        }
    }

    protected JavaJoinColumn buildJoinColumn(JoinColumnAnnotation joinColumnResource) {
        JavaJoinColumn joinColumn = this.getJpaFactory().buildJavaJoinColumn(this, this.createJoinColumnOwner());
        joinColumn.initialize(joinColumnResource);
        return joinColumn;
    }

    protected JavaJoinColumn.Owner createJoinColumnOwner() {
        return new JoinColumnOwner();
    }

    @Override
    protected String buildDefaultTargetEntity(JavaResourcePersistentAttribute jrpa) {
        if (jrpa.typeIsContainer()) {
            return null;
        }
        return jrpa.getQualifiedReferenceEntityTypeName();
    }

    @Override
    public FetchType getDefaultFetch() {
        return DEFAULT_FETCH_TYPE;
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        for (JavaJoinColumn column : CollectionTools.iterable(this.joinColumns())) {
            result = column.javaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public void validate(List<IMessage> messages, CompilationUnit astRoot) {
        super.validate(messages, astRoot);
        if (this.connectionProfileIsActive()) {
            this.validateJoinColumns(messages, astRoot);
        }
    }

    protected void validateJoinColumns(List<IMessage> messages, CompilationUnit astRoot) {
        if (this.ownerIsEntity() && this.isRelationshipOwner()) {
            ListIterator<JavaJoinColumn> stream = this.joinColumns();
            while (stream.hasNext()) {
                this.validateJoinColumn((JavaJoinColumn)stream.next(), messages, astRoot);
            }
        }
    }

    protected void validateJoinColumn(JavaJoinColumn joinColumn, List<IMessage> messages, CompilationUnit astRoot) {
        if (this.getTypeMapping().tableNameIsInvalid(joinColumn.getTable())) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_UNRESOLVED_TABLE", new String[]{joinColumn.getTable(), joinColumn.getName()}, joinColumn, joinColumn.getTableTextRange(astRoot)));
            return;
        }
        if (!joinColumn.isResolved()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_UNRESOLVED_NAME", new String[]{joinColumn.getName()}, joinColumn, joinColumn.getNameTextRange(astRoot)));
        }
        if (!joinColumn.isReferencedColumnResolved()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_REFERENCED_COLUMN_UNRESOLVED_NAME", new String[]{joinColumn.getReferencedColumnName(), joinColumn.getName()}, joinColumn, joinColumn.getReferencedColumnNameTextRange(astRoot)));
        }
    }

    public class JoinColumnOwner
    implements JavaJoinColumn.Owner {
        public String getDefaultTableName() {
            return AbstractJavaSingleRelationshipMapping.this.getTypeMapping().getPrimaryTableName();
        }

        public Entity getTargetEntity() {
            return AbstractJavaSingleRelationshipMapping.this.getResolvedTargetEntity();
        }

        public String getAttributeName() {
            return ((GenericJavaPersistentAttribute)AbstractJavaSingleRelationshipMapping.this.getPersistentAttribute()).getName();
        }

        public RelationshipMapping getRelationshipMapping() {
            return AbstractJavaSingleRelationshipMapping.this;
        }

        public boolean tableNameIsInvalid(String tableName) {
            return AbstractJavaSingleRelationshipMapping.this.getTypeMapping().tableNameIsInvalid(tableName);
        }

        public boolean tableIsAllowed() {
            return true;
        }

        public TypeMapping getTypeMapping() {
            return AbstractJavaSingleRelationshipMapping.this.getTypeMapping();
        }

        public Table getDbTable(String tableName) {
            return this.getTypeMapping().getDbTable(tableName);
        }

        public Table getReferencedColumnDbTable() {
            Entity targetEntity = this.getTargetEntity();
            return targetEntity == null ? null : targetEntity.getPrimaryDbTable();
        }

        public boolean isVirtual(BaseJoinColumn joinColumn) {
            return AbstractJavaSingleRelationshipMapping.this.defaultJoinColumn == joinColumn;
        }

        public String getDefaultColumnName() {
            return null;
        }

        public TextRange getValidationTextRange(CompilationUnit astRoot) {
            return AbstractJavaSingleRelationshipMapping.this.getValidationTextRange(astRoot);
        }

        public int joinColumnsSize() {
            return AbstractJavaSingleRelationshipMapping.this.joinColumnsSize();
        }
    }
}

