/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.Iterator;
import org.eclipse.jpt.core.context.java.JavaMappedSuperclass;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaTypeMapping;
import org.eclipse.jpt.core.resource.java.IdClassAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaMappedSuperclass
extends AbstractJavaTypeMapping
implements JavaMappedSuperclass {
    protected String idClass;

    public GenericJavaMappedSuperclass(JavaPersistentType parent) {
        super(parent);
    }

    @Override
    public boolean isMapped() {
        return true;
    }

    @Override
    public String getKey() {
        return "mappedSuperclass";
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.MappedSuperclass";
    }

    @Override
    public Iterator<String> correspondingAnnotationNames() {
        return new ArrayIterator((Object[])new String[]{"javax.persistence.IdClass", "javax.persistence.ExcludeDefaultListeners", "javax.persistence.ExcludeSuperclassListeners", "javax.persistence.EntityListeners", "javax.persistence.PrePersist", "javax.persistence.PostPersist", "javax.persistence.PreRemove", "javax.persistence.PostRemove", "javax.persistence.PreUpdate", "javax.persistence.PostUpdate", "javax.persistence.PostLoad"});
    }

    @Override
    public String getIdClass() {
        return this.idClass;
    }

    @Override
    public void setIdClass(String newIdClass) {
        String oldIdClass = this.idClass;
        this.idClass = newIdClass;
        if (newIdClass != oldIdClass) {
            if (newIdClass != null) {
                if (this.getIdClassResource() == null) {
                    this.addResourceIdClass();
                }
                this.getIdClassResource().setValue(newIdClass);
            } else {
                this.removeResourceIdClass();
            }
        }
        this.firePropertyChanged("idClassProperty", oldIdClass, newIdClass);
    }

    protected void setIdClass_(String newIdClass) {
        String oldIdClass = this.idClass;
        this.idClass = newIdClass;
        this.firePropertyChanged("idClassProperty", oldIdClass, newIdClass);
    }

    protected IdClassAnnotation getIdClassResource() {
        return (IdClassAnnotation)this.javaResourcePersistentType.getSupportingAnnotation("javax.persistence.IdClass");
    }

    protected void addResourceIdClass() {
        this.javaResourcePersistentType.addSupportingAnnotation("javax.persistence.IdClass");
    }

    protected void removeResourceIdClass() {
        this.javaResourcePersistentType.removeSupportingAnnotation("javax.persistence.IdClass");
    }

    @Override
    public Iterator<String> overridableAttributeNames() {
        return this.namesOf(this.overridableAttributes());
    }

    @Override
    public Iterator<JavaPersistentAttribute> overridableAttributes() {
        return new FilteringIterator<JavaPersistentAttribute, JavaPersistentAttribute>(this.getPersistentType().attributes()){

            protected boolean accept(JavaPersistentAttribute o) {
                return o.isOverridableAttribute();
            }
        };
    }

    @Override
    public Iterator<String> overridableAssociationNames() {
        return this.namesOf(this.overridableAssociations());
    }

    @Override
    public Iterator<JavaPersistentAttribute> overridableAssociations() {
        return new FilteringIterator<JavaPersistentAttribute, JavaPersistentAttribute>(this.getPersistentType().attributes()){

            protected boolean accept(JavaPersistentAttribute o) {
                return o.isOverridableAssociation();
            }
        };
    }

    protected Iterator<String> namesOf(Iterator<JavaPersistentAttribute> attributes) {
        return new TransformationIterator<JavaPersistentAttribute, String>(attributes){

            protected String transform(JavaPersistentAttribute attribute) {
                return attribute.getName();
            }
        };
    }

    @Override
    public void initialize(JavaResourcePersistentType persistentTypeResource) {
        super.initialize(persistentTypeResource);
        this.initializeIdClass(persistentTypeResource);
    }

    protected void initializeIdClass(JavaResourcePersistentType typeResource) {
        IdClassAnnotation idClassResource = (IdClassAnnotation)typeResource.getSupportingAnnotation("javax.persistence.IdClass");
        if (idClassResource != null) {
            this.idClass = idClassResource.getValue();
        }
    }

    @Override
    public void update(JavaResourcePersistentType persistentTypeResource) {
        super.update(persistentTypeResource);
        this.updateIdClass(persistentTypeResource);
    }

    protected void updateIdClass(JavaResourcePersistentType typeResource) {
        IdClassAnnotation idClass = (IdClassAnnotation)typeResource.getSupportingAnnotation("javax.persistence.IdClass");
        if (idClass != null) {
            this.setIdClass_(idClass.getValue());
        } else {
            this.setIdClass_(null);
        }
    }
}

