/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.internal.utility.jdt.JDTTools;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaPersistentAttribute
extends AbstractJavaJpaContextNode
implements JavaPersistentAttribute {
    protected String name;
    protected JavaAttributeMapping defaultMapping;
    protected JavaAttributeMapping specifiedMapping;
    protected JavaResourcePersistentAttribute resourcePersistentAttribute;

    public GenericJavaPersistentAttribute(JavaPersistentType parent, JavaResourcePersistentAttribute jrpa) {
        super(parent);
        this.initialize(jrpa);
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.core.java.persistentAttribute";
    }

    protected void initialize(JavaResourcePersistentAttribute jrpa) {
        this.resourcePersistentAttribute = jrpa;
        this.name = this.name(jrpa);
        this.initializeDefaultMapping(jrpa);
        this.initializeSpecifiedMapping(jrpa);
    }

    protected void initializeDefaultMapping(JavaResourcePersistentAttribute jrpa) {
        this.defaultMapping = this.getJpaPlatform().buildDefaultJavaAttributeMapping(this);
        this.defaultMapping.initialize(jrpa);
    }

    protected void initializeSpecifiedMapping(JavaResourcePersistentAttribute jrpa) {
        String javaMappingAnnotationName = this.javaMappingAnnotationName(jrpa);
        this.specifiedMapping = this.createJavaAttributeMappingFromAnnotation(javaMappingAnnotationName, jrpa);
    }

    @Override
    public JavaResourcePersistentAttribute getResourcePersistentAttribute() {
        return this.resourcePersistentAttribute;
    }

    @Override
    public JavaPersistentType getPersistentType() {
        return (JavaPersistentType)this.getParent();
    }

    @Override
    public JavaTypeMapping getTypeMapping() {
        return this.getPersistentType().getMapping();
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return this.getMapping().getPrimaryKeyColumnName();
    }

    @Override
    public boolean isOverridableAttribute() {
        return this.getMapping().isOverridableAttributeMapping();
    }

    @Override
    public boolean isOverridableAssociation() {
        return this.getMapping().isOverridableAssociationMapping();
    }

    @Override
    public boolean isIdAttribute() {
        return this.getMapping().isIdMapping();
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.firePropertyChanged("nameProperty", oldName, newName);
    }

    @Override
    public JavaAttributeMapping getDefaultMapping() {
        return this.defaultMapping;
    }

    protected void setDefaultMapping(JavaAttributeMapping newDefaultMapping) {
        JavaAttributeMapping oldMapping = this.defaultMapping;
        this.defaultMapping = newDefaultMapping;
        this.firePropertyChanged("defaultMappingProperty", oldMapping, newDefaultMapping);
    }

    @Override
    public JavaAttributeMapping getSpecifiedMapping() {
        return this.specifiedMapping;
    }

    protected void setSpecifiedMapping(JavaAttributeMapping newSpecifiedMapping) {
        JavaAttributeMapping oldMapping = this.specifiedMapping;
        this.specifiedMapping = newSpecifiedMapping;
        this.firePropertyChanged("specifiedMappingProperty", oldMapping, newSpecifiedMapping);
    }

    @Override
    public JavaAttributeMapping getMapping() {
        return this.specifiedMapping != null ? this.specifiedMapping : this.defaultMapping;
    }

    @Override
    public String getMappingKey() {
        return this.getMapping().getKey();
    }

    @Override
    public String getDefaultMappingKey() {
        return this.defaultMapping.getKey();
    }

    public String getSpecifiedMappingKey() {
        return this.specifiedMapping == null ? null : this.specifiedMapping.getKey();
    }

    @Override
    public void setSpecifiedMappingKey(String newKey) {
        JavaAttributeMapping newMapping;
        if (newKey == this.getSpecifiedMappingKey()) {
            return;
        }
        JavaAttributeMapping oldMapping = this.getMapping();
        this.specifiedMapping = newMapping = this.createJavaAttributeMappingFromMappingKey(newKey);
        if (newMapping != null) {
            this.resourcePersistentAttribute.setMappingAnnotation(newMapping.getAnnotationName());
        } else {
            this.resourcePersistentAttribute.setMappingAnnotation(null);
        }
        this.firePropertyChanged("specifiedMappingProperty", oldMapping, newMapping);
        if (oldMapping != null) {
            HashBag annotationsToRemove = CollectionTools.collection(oldMapping.correspondingAnnotationNames());
            if (this.getMapping() != null) {
                CollectionTools.removeAll((Collection)annotationsToRemove, this.getMapping().correspondingAnnotationNames());
            }
            for (String annotationName : annotationsToRemove) {
                this.resourcePersistentAttribute.removeSupportingAnnotation(annotationName);
            }
        }
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        return this;
    }

    @Override
    public boolean contains(int offset, CompilationUnit astRoot) {
        TextRange fullTextRange = this.getFullTextRange(astRoot);
        return fullTextRange == null ? false : fullTextRange.includes(offset);
    }

    public TextRange getFullTextRange(CompilationUnit astRoot) {
        return this.resourcePersistentAttribute.getTextRange(astRoot);
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getSelectionTextRange(astRoot);
    }

    public TextRange getSelectionTextRange(CompilationUnit astRoot) {
        return this.resourcePersistentAttribute.getNameTextRange(astRoot);
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.getSelectionTextRange(this.buildASTRoot());
    }

    protected CompilationUnit buildASTRoot() {
        return JDTTools.buildASTRoot(this.resourcePersistentAttribute.getJpaCompilationUnit().getCompilationUnit());
    }

    @Override
    public void update() {
        this.setName(this.name(this.resourcePersistentAttribute));
        this.updateDefaultMapping(this.resourcePersistentAttribute);
        this.updateSpecifiedMapping(this.resourcePersistentAttribute);
    }

    protected String name(JavaResourcePersistentAttribute jrpa) {
        return jrpa.getName();
    }

    public String specifiedMappingAnnotationName() {
        return this.specifiedMapping == null ? null : this.specifiedMapping.getAnnotationName();
    }

    protected void updateSpecifiedMapping(JavaResourcePersistentAttribute jrpa) {
        String javaMappingAnnotationName = this.javaMappingAnnotationName(jrpa);
        if (this.specifiedMappingAnnotationName() != javaMappingAnnotationName) {
            this.setSpecifiedMapping(this.createJavaAttributeMappingFromAnnotation(javaMappingAnnotationName, jrpa));
        } else if (this.getSpecifiedMapping() != null) {
            this.getSpecifiedMapping().update(jrpa);
        }
    }

    protected void updateDefaultMapping(JavaResourcePersistentAttribute jrpa) {
        String defaultMappingKey = this.getJpaPlatform().getDefaultJavaAttributeMappingKey(this);
        if (this.getDefaultMapping().getKey() != defaultMappingKey) {
            JavaAttributeMapping oldDefaultMapping = this.defaultMapping;
            this.defaultMapping = this.getJpaPlatform().buildDefaultJavaAttributeMapping(this);
            this.defaultMapping.initialize(jrpa);
            this.firePropertyChanged("defaultMappingProperty", oldDefaultMapping, this.defaultMapping);
        } else {
            this.getDefaultMapping().update(jrpa);
        }
    }

    protected String javaMappingAnnotationName(JavaResourcePersistentAttribute jrpa) {
        Annotation mappingAnnotation = (Annotation)jrpa.getMappingAnnotation();
        if (mappingAnnotation != null) {
            return mappingAnnotation.getAnnotationName();
        }
        return null;
    }

    protected JavaAttributeMapping createJavaAttributeMappingFromMappingKey(String key) {
        if (key == MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY) {
            return null;
        }
        return this.getJpaPlatform().buildJavaAttributeMappingFromMappingKey(key, this);
    }

    protected JavaAttributeMapping createJavaAttributeMappingFromAnnotation(String annotationName, JavaResourcePersistentAttribute jrpa) {
        if (annotationName == null) {
            return null;
        }
        JavaAttributeMapping mapping = this.getJpaPlatform().buildJavaAttributeMappingFromAnnotation(annotationName, this);
        mapping.initialize(jrpa);
        return mapping;
    }

    @Override
    public boolean mappingIsDefault(JavaAttributeMapping mapping) {
        return this.defaultMapping == mapping;
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        return this.getMapping().javaCompletionProposals(pos, filter, astRoot);
    }

    @Override
    public void validate(List<IMessage> messages, CompilationUnit astRoot) {
        super.validate(messages, astRoot);
        if (this.specifiedMapping != null) {
            this.specifiedMapping.validate(messages, astRoot);
        } else if (this.defaultMapping != null) {
            this.defaultMapping.validate(messages, astRoot);
        }
    }

    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(this.name);
    }

    @Override
    public void dispose() {
    }
}

