/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import org.eclipse.jpt.core.context.NamedColumn;
import org.eclipse.jpt.core.context.XmlContextNode;
import org.eclipse.jpt.core.context.orm.OrmNamedColumn;
import org.eclipse.jpt.core.internal.context.AbstractXmlContextNode;
import org.eclipse.jpt.core.resource.orm.XmlNamedColumn;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Column;
import org.eclipse.jpt.db.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmNamedColumn<T extends XmlNamedColumn>
extends AbstractXmlContextNode
implements OrmNamedColumn {
    protected OrmNamedColumn.Owner owner;
    protected String specifiedName;
    protected String defaultName;
    protected String columnDefinition;

    protected AbstractOrmNamedColumn(XmlContextNode parent, OrmNamedColumn.Owner owner) {
        super(parent);
        this.owner = owner;
    }

    @Override
    public XmlContextNode getParent() {
        return (XmlContextNode)super.getParent();
    }

    public void initializeFrom(NamedColumn oldColumn) {
        this.setSpecifiedName(oldColumn.getSpecifiedName());
        this.setColumnDefinition(oldColumn.getColumnDefinition());
    }

    protected abstract T getResourceColumn();

    protected abstract void removeResourceColumn();

    protected abstract void addResourceColumn();

    @Override
    public OrmNamedColumn.Owner getOwner() {
        return this.owner;
    }

    @Override
    public String getName() {
        return this.specifiedName != null ? this.specifiedName : this.defaultName;
    }

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    @Override
    public void setSpecifiedName(String newSpecifiedName) {
        String oldSpecifiedName = this.specifiedName;
        this.specifiedName = newSpecifiedName;
        if (oldSpecifiedName != newSpecifiedName) {
            if (this.getResourceColumn() != null) {
                this.getResourceColumn().setName(newSpecifiedName);
                if (this.getResourceColumn().isAllFeaturesUnset()) {
                    this.removeResourceColumn();
                }
            } else if (newSpecifiedName != null) {
                this.addResourceColumn();
                this.getResourceColumn().setName(newSpecifiedName);
            }
        }
        this.firePropertyChanged("specifiedName", oldSpecifiedName, newSpecifiedName);
    }

    protected void setSpecifiedName_(String newSpecifiedName) {
        String oldSpecifiedName = this.specifiedName;
        this.specifiedName = newSpecifiedName;
        this.firePropertyChanged("specifiedName", oldSpecifiedName, newSpecifiedName);
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    protected void setDefaultName(String newDefaultName) {
        String oldDefaultName = this.defaultName;
        this.defaultName = newDefaultName;
        this.firePropertyChanged("defaultName", oldDefaultName, newDefaultName);
    }

    @Override
    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    @Override
    public void setColumnDefinition(String newColumnDefinition) {
        String oldColumnDefinition = this.columnDefinition;
        this.columnDefinition = newColumnDefinition;
        if (oldColumnDefinition != newColumnDefinition) {
            if (this.getResourceColumn() != null) {
                this.getResourceColumn().setColumnDefinition(newColumnDefinition);
                if (this.getResourceColumn().isAllFeaturesUnset()) {
                    this.removeResourceColumn();
                }
            } else if (newColumnDefinition != null) {
                this.addResourceColumn();
                this.getResourceColumn().setColumnDefinition(newColumnDefinition);
            }
        }
        this.firePropertyChanged("columnDefinition", oldColumnDefinition, newColumnDefinition);
    }

    protected void setColumnDefinition_(String newColumnDefinition) {
        String oldColumnDefinition = this.columnDefinition;
        this.columnDefinition = newColumnDefinition;
        this.firePropertyChanged("columnDefinition", oldColumnDefinition, newColumnDefinition);
    }

    @Override
    public Column getDbColumn() {
        Table table = this.getDbTable();
        return table == null ? null : table.getColumnForIdentifier(this.getName());
    }

    @Override
    public Table getDbTable() {
        return this.getOwner().getDbTable(this.tableName());
    }

    protected abstract String tableName();

    @Override
    public boolean isResolved() {
        return this.getDbColumn() != null;
    }

    @Override
    public TextRange getNameTextRange() {
        TextRange textRange;
        if (this.getResourceColumn() != null && (textRange = this.getResourceColumn().getNameTextRange()) != null) {
            return textRange;
        }
        return this.getOwner().getValidationTextRange();
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.getResourceColumn().getValidationTextRange();
        if (textRange != null) {
            return textRange;
        }
        return this.getOwner().getValidationTextRange();
    }

    protected void initialize(T column) {
        this.specifiedName = this.buildSpecifiedName(column);
        this.defaultName = this.buildDefaultName();
        this.columnDefinition = this.buildSpecifiedColumnDefinition(column);
    }

    protected void update(T column) {
        this.setSpecifiedName_(this.buildSpecifiedName(column));
        this.setDefaultName(this.buildDefaultName());
        this.setColumnDefinition_(this.buildSpecifiedColumnDefinition(column));
    }

    protected String buildSpecifiedName(T column) {
        return column == null ? null : column.getName();
    }

    protected String buildSpecifiedColumnDefinition(T column) {
        return column == null ? null : column.getColumnDefinition();
    }

    protected String buildDefaultName() {
        return this.getOwner().getDefaultColumnName();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }
}

