/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.FetchType;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmRelationshipMapping;
import org.eclipse.jpt.core.internal.context.MappingTools;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmAttributeMapping;
import org.eclipse.jpt.core.internal.context.orm.OrmCascade;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.orm.XmlAttributeMapping;
import org.eclipse.jpt.core.resource.orm.XmlRelationshipMapping;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmRelationshipMapping<T extends XmlRelationshipMapping>
extends AbstractOrmAttributeMapping<T>
implements OrmRelationshipMapping {
    protected String specifiedTargetEntity;
    protected String defaultTargetEntity;
    protected Entity resolvedTargetEntity;
    protected final OrmCascade cascade = new OrmCascade(this);
    protected FetchType specifiedFetch;

    protected AbstractOrmRelationshipMapping(OrmPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public OrmPersistentAttribute getParent() {
        return (OrmPersistentAttribute)super.getParent();
    }

    @Override
    public String getTargetEntity() {
        return this.specifiedTargetEntity != null ? this.specifiedTargetEntity : this.defaultTargetEntity;
    }

    @Override
    public String getSpecifiedTargetEntity() {
        return this.specifiedTargetEntity;
    }

    @Override
    public void setSpecifiedTargetEntity(String targetEntity) {
        String old = this.specifiedTargetEntity;
        this.specifiedTargetEntity = targetEntity;
        ((XmlRelationshipMapping)this.resourceAttributeMapping).setTargetEntity(targetEntity);
        this.firePropertyChanged("specifiedTargetEntity", old, targetEntity);
    }

    protected void setSpecifiedTargetEntity_(String targetEntity) {
        String old = this.specifiedTargetEntity;
        this.specifiedTargetEntity = targetEntity;
        this.firePropertyChanged("specifiedTargetEntity", old, targetEntity);
    }

    @Override
    public String getDefaultTargetEntity() {
        return this.defaultTargetEntity;
    }

    protected void setDefaultTargetEntity(String targetEntity) {
        String old = this.defaultTargetEntity;
        this.defaultTargetEntity = targetEntity;
        this.firePropertyChanged("defaultTargetEntity", old, targetEntity);
    }

    @Override
    public Entity getResolvedTargetEntity() {
        return this.resolvedTargetEntity;
    }

    protected void setResolvedTargetEntity(Entity targetEntity) {
        Entity old = this.resolvedTargetEntity;
        this.resolvedTargetEntity = targetEntity;
        this.firePropertyChanged("resolvedTargetEntity", old, targetEntity);
    }

    @Override
    public OrmCascade getCascade() {
        return this.cascade;
    }

    @Override
    public FetchType getFetch() {
        return this.specifiedFetch != null ? this.specifiedFetch : this.getDefaultFetch();
    }

    @Override
    public FetchType getSpecifiedFetch() {
        return this.specifiedFetch;
    }

    @Override
    public void setSpecifiedFetch(FetchType fetch) {
        FetchType old = this.specifiedFetch;
        this.specifiedFetch = fetch;
        ((XmlRelationshipMapping)this.resourceAttributeMapping).setFetch(FetchType.toOrmResourceModel(fetch));
        this.firePropertyChanged("specifiedFetch", (Object)old, (Object)fetch);
    }

    protected void setSpecifiedFetch_(FetchType fetch) {
        FetchType old = this.specifiedFetch;
        this.specifiedFetch = fetch;
        this.firePropertyChanged("specifiedFetch", (Object)old, (Object)fetch);
    }

    @Override
    public void initialize(XmlAttributeMapping relationshipMapping) {
        super.initialize(relationshipMapping);
        this.specifiedTargetEntity = ((XmlRelationshipMapping)this.resourceAttributeMapping).getTargetEntity();
        this.defaultTargetEntity = this.buildDefaultTargetEntity();
        this.resolvedTargetEntity = this.buildResolvedTargetEntity();
        this.specifiedFetch = this.buildSpecifiedFetch();
        this.cascade.initialize((XmlRelationshipMapping)this.resourceAttributeMapping);
    }

    @Override
    public void update() {
        super.update();
        this.setSpecifiedTargetEntity_(((XmlRelationshipMapping)this.resourceAttributeMapping).getTargetEntity());
        this.setDefaultTargetEntity(this.buildDefaultTargetEntity());
        this.setResolvedTargetEntity(this.buildResolvedTargetEntity());
        this.setSpecifiedFetch_(this.buildSpecifiedFetch());
        this.cascade.update();
    }

    protected FetchType buildSpecifiedFetch() {
        return FetchType.fromOrmResourceModel(((XmlRelationshipMapping)this.resourceAttributeMapping).getFetch());
    }

    protected String buildDefaultTargetEntity() {
        RelationshipMapping javaMapping = this.getJavaRelationshipMapping();
        if (javaMapping != null && this.getPersistentAttribute().isVirtual() && !this.getTypeMapping().isMetadataComplete()) {
            return javaMapping.getTargetEntity();
        }
        if (this.findJavaPersistentAttribute() != null) {
            return this.defaultTargetEntity(this.findJavaPersistentAttribute().getResourcePersistentAttribute());
        }
        return null;
    }

    protected RelationshipMapping getJavaRelationshipMapping() {
        if (this.findJavaPersistentAttribute() == null) {
            return null;
        }
        JavaAttributeMapping javaAttributeMapping = this.findJavaPersistentAttribute().getMapping();
        if (javaAttributeMapping instanceof RelationshipMapping) {
            return (RelationshipMapping)((Object)javaAttributeMapping);
        }
        return null;
    }

    protected abstract String defaultTargetEntity(JavaResourcePersistentAttribute var1);

    protected Entity buildResolvedTargetEntity() {
        if (this.getTargetEntity() == null) {
            return null;
        }
        PersistentType persistentType = this.getTargetPersistentType();
        if (persistentType != null && persistentType.getMappingKey() == "entity") {
            return (Entity)persistentType.getMapping();
        }
        return null;
    }

    protected PersistentType getTargetPersistentType() {
        PersistentType persistentType = this.getPersistenceUnit().getPersistentType(this.getTargetEntity());
        if (persistentType == null) {
            String packageName = this.getPersistentAttribute().getPersistentType().getContext().getDefaultPersistentTypePackage();
            persistentType = this.getPersistenceUnit().getPersistentType(String.valueOf(packageName) + '.' + this.getTargetEntity());
        }
        return persistentType;
    }

    @Override
    public Entity getEntity() {
        if (this.getTypeMapping() instanceof Entity) {
            return (Entity)this.getTypeMapping();
        }
        return null;
    }

    @Override
    public String getJoinTableDefaultName() {
        return MappingTools.buildJoinTableDefaultName(this);
    }

    @Override
    public void initializeFromOrmRelationshipMapping(OrmRelationshipMapping oldMapping) {
        super.initializeFromOrmRelationshipMapping(oldMapping);
        this.setSpecifiedTargetEntity(oldMapping.getSpecifiedTargetEntity());
        this.setSpecifiedFetch(oldMapping.getSpecifiedFetch());
        this.getCascade().initializeFrom(oldMapping.getCascade());
    }

    public Iterator<String> allTargetEntityAttributeNames() {
        Entity targetEntity = this.getResolvedTargetEntity();
        return targetEntity == null ? EmptyIterator.instance() : targetEntity.getPersistentType().allAttributeNames();
    }

    public Iterator<String> candidateMappedByAttributeNames() {
        return this.allTargetEntityAttributeNames();
    }

    @Override
    public void validate(List<IMessage> messages) {
        super.validate(messages);
        this.validateTargetEntity(messages);
    }

    protected void validateTargetEntity(List<IMessage> messages) {
        if (this.getTargetEntity() == null) {
            if (this.getPersistentAttribute().isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_TARGET_ENTITY_NOT_DEFINED", new String[]{this.getAttributeName()}, this, this.getValidationTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "TARGET_ENTITY_NOT_DEFINED", new String[]{this.getAttributeName()}, this, this.getValidationTextRange()));
            }
        } else if (this.getResolvedTargetEntity() == null) {
            if (this.getPersistentAttribute().isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_TARGET_ENTITY_IS_NOT_AN_ENTITY", new String[]{this.getAttributeName(), this.getTargetEntity()}, this, this.getValidationTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "TARGET_ENTITY_IS_NOT_AN_ENTITY", new String[]{this.getTargetEntity(), this.getAttributeName()}, this, this.getTargetEntityTextRange()));
            }
        }
    }

    protected TextRange getTextRange(TextRange textRange) {
        return textRange != null ? textRange : this.getParent().getValidationTextRange();
    }

    protected TextRange getTargetEntityTextRange() {
        return this.getTextRange(((XmlRelationshipMapping)this.getResourceAttributeMapping()).getTargetEntityTextRange());
    }
}

