/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.Generator;
import org.eclipse.jpt.core.context.MappingFileRoot;
import org.eclipse.jpt.core.context.NamedNativeQuery;
import org.eclipse.jpt.core.context.NamedQuery;
import org.eclipse.jpt.core.context.Query;
import org.eclipse.jpt.core.context.orm.EntityMappings;
import org.eclipse.jpt.core.context.orm.OrmGenerator;
import org.eclipse.jpt.core.context.orm.OrmNamedNativeQuery;
import org.eclipse.jpt.core.context.orm.OrmNamedQuery;
import org.eclipse.jpt.core.context.orm.OrmPersistenceUnitDefaults;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmQuery;
import org.eclipse.jpt.core.context.orm.OrmSequenceGenerator;
import org.eclipse.jpt.core.context.orm.OrmTableGenerator;
import org.eclipse.jpt.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.core.context.orm.OrmXml;
import org.eclipse.jpt.core.context.orm.PersistenceUnitMetadata;
import org.eclipse.jpt.core.internal.context.AbstractXmlContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.orm.AbstractXmlTypeMapping;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlEmbeddable;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlEntityMappings;
import org.eclipse.jpt.core.resource.orm.XmlMappedSuperclass;
import org.eclipse.jpt.core.resource.orm.XmlNamedNativeQuery;
import org.eclipse.jpt.core.resource.orm.XmlNamedQuery;
import org.eclipse.jpt.core.resource.orm.XmlSequenceGenerator;
import org.eclipse.jpt.core.resource.orm.XmlSequenceGeneratorImpl;
import org.eclipse.jpt.core.resource.orm.XmlTableGenerator;
import org.eclipse.jpt.core.resource.orm.XmlTableGeneratorImpl;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Catalog;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.db.SchemaContainer;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericEntityMappings
extends AbstractXmlContextNode
implements EntityMappings {
    protected XmlEntityMappings xmlEntityMappings;
    protected String version;
    protected String description;
    protected String package_;
    protected AccessType specifiedAccess;
    protected AccessType defaultAccess;
    protected String specifiedCatalog;
    protected String defaultCatalog;
    protected String specifiedSchema;
    protected String defaultSchema;
    protected final PersistenceUnitMetadata persistenceUnitMetadata;
    protected final List<OrmPersistentType> persistentTypes;
    protected final List<OrmSequenceGenerator> sequenceGenerators;
    protected final List<OrmTableGenerator> tableGenerators;
    protected final List<OrmNamedQuery> namedQueries;
    protected final List<OrmNamedNativeQuery> namedNativeQueries;

    public GenericEntityMappings(OrmXml parent, XmlEntityMappings xmlEntityMappings) {
        super(parent);
        this.persistenceUnitMetadata = this.getJpaFactory().buildPersistenceUnitMetadata(this, xmlEntityMappings);
        this.persistentTypes = new ArrayList<OrmPersistentType>();
        this.sequenceGenerators = new ArrayList<OrmSequenceGenerator>();
        this.tableGenerators = new ArrayList<OrmTableGenerator>();
        this.namedQueries = new ArrayList<OrmNamedQuery>();
        this.namedNativeQueries = new ArrayList<OrmNamedNativeQuery>();
        this.initialize(xmlEntityMappings);
    }

    @Override
    public OrmXml getParent() {
        return (OrmXml)super.getParent();
    }

    @Override
    public MappingFileRoot getMappingFileRoot() {
        return this;
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.core.orm.entityMappings";
    }

    @Override
    public AccessType getOverridePersistentTypeAccess() {
        if (this.getPersistenceUnitMetadata().isXmlMappingMetadataComplete()) {
            return this.getSpecifiedAccess();
        }
        return null;
    }

    @Override
    public AccessType getDefaultPersistentTypeAccess() {
        return this.getAccess();
    }

    @Override
    public String getDefaultPersistentTypePackage() {
        return this.getPackage();
    }

    @Override
    public boolean isDefaultPersistentTypeMetadataComplete() {
        return this.getPersistenceUnitMetadata().isXmlMappingMetadataComplete();
    }

    @Override
    public XmlEntityMappings getXmlEntityMappings() {
        return this.xmlEntityMappings;
    }

    @Override
    public void changeMapping(OrmPersistentType ormPersistentType, OrmTypeMapping oldMapping, OrmTypeMapping newMapping) {
        ormPersistentType.dispose();
        int sourceIndex = this.persistentTypes.indexOf(ormPersistentType);
        this.persistentTypes.remove(sourceIndex);
        oldMapping.removeFromResourceModel(this.xmlEntityMappings);
        int targetIndex = this.insertionIndex(ormPersistentType);
        this.persistentTypes.add(targetIndex, ormPersistentType);
        newMapping.addToResourceModel(this.xmlEntityMappings);
        newMapping.initializeFrom(oldMapping);
        this.fireItemMoved("persistentTypes", targetIndex, sourceIndex);
    }

    @Override
    public OrmPersistentType getPersistentType(String fullyQualifiedTypeName) {
        for (OrmPersistentType ormPersistentType : CollectionTools.iterable(this.ormPersistentTypes())) {
            if (!ormPersistentType.isFor(fullyQualifiedTypeName)) continue;
            return ormPersistentType;
        }
        return null;
    }

    @Override
    public PersistenceUnitMetadata getPersistenceUnitMetadata() {
        return this.persistenceUnitMetadata;
    }

    @Override
    public String getPackage() {
        return this.package_;
    }

    @Override
    public void setPackage(String newPackage) {
        String oldPackage = this.package_;
        this.package_ = newPackage;
        this.xmlEntityMappings.setPackage(newPackage);
        this.firePropertyChanged("package", oldPackage, newPackage);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String newDescription) {
        String oldDescription = this.description;
        this.description = newDescription;
        this.xmlEntityMappings.setDescription(newDescription);
        this.firePropertyChanged("description", oldDescription, newDescription);
    }

    @Override
    public AccessType getAccess() {
        return this.specifiedAccess != null ? this.specifiedAccess : this.defaultAccess;
    }

    @Override
    public AccessType getSpecifiedAccess() {
        return this.specifiedAccess;
    }

    @Override
    public void setSpecifiedAccess(AccessType access) {
        AccessType old = this.specifiedAccess;
        this.specifiedAccess = access;
        this.xmlEntityMappings.setAccess(AccessType.toXmlResourceModel(access));
        this.firePropertyChanged("specifiedAccess", (Object)old, (Object)access);
    }

    @Override
    public AccessType getDefaultAccess() {
        return this.defaultAccess;
    }

    protected void setDefaultAccess(AccessType access) {
        AccessType old = this.defaultAccess;
        this.defaultAccess = access;
        this.firePropertyChanged("defaultAccess", (Object)old, (Object)access);
    }

    @Override
    public String getSchema() {
        return this.specifiedSchema != null ? this.specifiedSchema : this.defaultSchema;
    }

    @Override
    public String getSpecifiedSchema() {
        return this.specifiedSchema;
    }

    @Override
    public void setSpecifiedSchema(String schema) {
        String old = this.specifiedSchema;
        this.specifiedSchema = schema;
        this.xmlEntityMappings.setSchema(schema);
        this.firePropertyChanged("specifiedSchema", old, schema);
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    protected void setDefaultSchema(String schema) {
        String old = this.defaultSchema;
        this.defaultSchema = schema;
        this.firePropertyChanged("defaultSchema", old, schema);
    }

    @Override
    public Schema getDbSchema() {
        SchemaContainer dbSchemaContainer = this.getDbSchemaContainer();
        return dbSchemaContainer == null ? null : dbSchemaContainer.getSchemaForIdentifier(this.getSchema());
    }

    @Override
    public String getCatalog() {
        return this.specifiedCatalog != null ? this.specifiedCatalog : this.defaultCatalog;
    }

    @Override
    public String getSpecifiedCatalog() {
        return this.specifiedCatalog;
    }

    @Override
    public void setSpecifiedCatalog(String catalog) {
        String old = this.specifiedCatalog;
        this.specifiedCatalog = catalog;
        this.xmlEntityMappings.setCatalog(catalog);
        this.firePropertyChanged("specifiedCatalog", old, catalog);
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    protected void setDefaultCatalog(String catalog) {
        String old = this.defaultCatalog;
        this.defaultCatalog = catalog;
        this.firePropertyChanged("defaultCatalog", old, catalog);
    }

    @Override
    public Catalog getDbCatalog() {
        String catalog = this.getCatalog();
        if (catalog == null) {
            return null;
        }
        return this.getDbCatalog(catalog);
    }

    @Override
    public SchemaContainer getDbSchemaContainer() {
        String catalog = this.getCatalog();
        return catalog != null ? this.getDbCatalog(catalog) : this.getDatabase();
    }

    @Override
    public ListIterator<OrmPersistentType> ormPersistentTypes() {
        return new CloneListIterator(this.persistentTypes);
    }

    @Override
    public int ormPersistentTypesSize() {
        return this.persistentTypes.size();
    }

    @Override
    public OrmPersistentType addOrmPersistentType(String mappingKey, String className) {
        OrmPersistentType persistentType = this.getJpaFactory().buildOrmPersistentType(this, mappingKey);
        int index = this.insertionIndex(persistentType);
        this.persistentTypes.add(index, persistentType);
        if (className.startsWith(String.valueOf(this.getPackage()) + '.')) {
            className = className.substring(this.getPackage().length() + 1);
        }
        AbstractXmlTypeMapping typeMapping = persistentType.getMapping().addToResourceModel(this.xmlEntityMappings);
        typeMapping.setClassName(className);
        this.fireItemAdded("persistentTypes", index, persistentType);
        return persistentType;
    }

    protected void addOrmPersistentType(OrmPersistentType ormPersistentType) {
        this.addItemToList(ormPersistentType, this.persistentTypes, "persistentTypes");
    }

    protected int insertionIndex(OrmPersistentType ormPersistentType) {
        return CollectionTools.insertionIndexOf(this.persistentTypes, (Object)ormPersistentType, this.buildMappingComparator());
    }

    private Comparator<OrmPersistentType> buildMappingComparator() {
        return new Comparator<OrmPersistentType>(){

            @Override
            public int compare(OrmPersistentType o1, OrmPersistentType o2) {
                int o2Sequence;
                int o1Sequence = o1.getMapping().getXmlSequence();
                if (o1Sequence < (o2Sequence = o2.getMapping().getXmlSequence())) {
                    return -1;
                }
                if (o1Sequence == o2Sequence) {
                    return 0;
                }
                return 1;
            }
        };
    }

    @Override
    public void removeOrmPersistentType(int index) {
        OrmPersistentType ormPersistentType = this.persistentTypes.get(index);
        ormPersistentType.dispose();
        this.persistentTypes.remove(index);
        ormPersistentType.getMapping().removeFromResourceModel(this.xmlEntityMappings);
        this.fireItemRemoved("persistentTypes", index, ormPersistentType);
    }

    @Override
    public void removeOrmPersistentType(OrmPersistentType ormPersistentType) {
        this.removeOrmPersistentType(this.persistentTypes.indexOf(ormPersistentType));
    }

    protected void removeOrmPersistentType_(OrmPersistentType ormPersistentType) {
        ormPersistentType.dispose();
        this.removeItemFromList(ormPersistentType, this.persistentTypes, "persistentTypes");
    }

    @Override
    public ListIterator<OrmSequenceGenerator> sequenceGenerators() {
        return new CloneListIterator(this.sequenceGenerators);
    }

    @Override
    public int sequenceGeneratorsSize() {
        return this.sequenceGenerators.size();
    }

    @Override
    public OrmSequenceGenerator addSequenceGenerator(int index) {
        XmlSequenceGeneratorImpl resourceSequenceGenerator = OrmFactory.eINSTANCE.createXmlSequenceGeneratorImpl();
        OrmSequenceGenerator contextSequenceGenerator = this.buildSequenceGenerator(resourceSequenceGenerator);
        this.sequenceGenerators.add(index, contextSequenceGenerator);
        this.xmlEntityMappings.getSequenceGenerators().add(index, (Object)resourceSequenceGenerator);
        this.fireItemAdded("sequenceGenerators", index, contextSequenceGenerator);
        return contextSequenceGenerator;
    }

    protected void addSequenceGenerator(int index, OrmSequenceGenerator sequenceGenerator) {
        this.addItemToList(index, sequenceGenerator, this.sequenceGenerators, "sequenceGenerators");
    }

    protected void addSequenceGenerator(OrmSequenceGenerator sequenceGenerator) {
        this.addSequenceGenerator(this.sequenceGenerators.size(), sequenceGenerator);
    }

    @Override
    public void removeSequenceGenerator(OrmSequenceGenerator sequenceGenerator) {
        this.removeSequenceGenerator(this.sequenceGenerators.indexOf(sequenceGenerator));
    }

    @Override
    public void removeSequenceGenerator(int index) {
        OrmSequenceGenerator removedSequenceGenerator = this.sequenceGenerators.remove(index);
        this.fireItemRemoved("sequenceGenerators", index, removedSequenceGenerator);
        this.xmlEntityMappings.getSequenceGenerators().remove(index);
    }

    protected void removeSequenceGenerator_(OrmSequenceGenerator sequenceGenerator) {
        this.removeItemFromList(sequenceGenerator, this.sequenceGenerators, "sequenceGenerators");
    }

    @Override
    public void moveSequenceGenerator(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.sequenceGenerators, (int)targetIndex, (int)sourceIndex);
        this.xmlEntityMappings.getSequenceGenerators().move(targetIndex, sourceIndex);
        this.fireItemMoved("sequenceGenerators", targetIndex, sourceIndex);
    }

    @Override
    public ListIterator<OrmTableGenerator> tableGenerators() {
        return new CloneListIterator(this.tableGenerators);
    }

    @Override
    public int tableGeneratorsSize() {
        return this.tableGenerators.size();
    }

    @Override
    public OrmTableGenerator addTableGenerator(int index) {
        XmlTableGeneratorImpl resourceTableGenerator = OrmFactory.eINSTANCE.createXmlTableGeneratorImpl();
        OrmTableGenerator contextTableGenerator = this.buildTableGenerator(resourceTableGenerator);
        this.tableGenerators.add(index, contextTableGenerator);
        this.xmlEntityMappings.getTableGenerators().add(index, (Object)resourceTableGenerator);
        this.fireItemAdded("tableGenerators", index, contextTableGenerator);
        return contextTableGenerator;
    }

    protected void addTableGenerator(int index, OrmTableGenerator tableGenerator) {
        this.addItemToList(index, tableGenerator, this.tableGenerators, "tableGenerators");
    }

    protected void addTableGenerator(OrmTableGenerator tableGenerator) {
        this.addTableGenerator(this.tableGenerators.size(), tableGenerator);
    }

    @Override
    public void removeTableGenerator(OrmTableGenerator tableGenerator) {
        this.removeTableGenerator(this.tableGenerators.indexOf(tableGenerator));
    }

    @Override
    public void removeTableGenerator(int index) {
        OrmTableGenerator removedTableGenerator = this.tableGenerators.remove(index);
        this.xmlEntityMappings.getTableGenerators().remove(index);
        this.fireItemRemoved("tableGenerators", index, removedTableGenerator);
    }

    protected void removeTableGenerator_(OrmTableGenerator tableGenerator) {
        this.removeItemFromList(tableGenerator, this.tableGenerators, "tableGenerators");
    }

    @Override
    public void moveTableGenerator(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.tableGenerators, (int)targetIndex, (int)sourceIndex);
        this.xmlEntityMappings.getTableGenerators().move(targetIndex, sourceIndex);
        this.fireItemMoved("tableGenerators", targetIndex, sourceIndex);
    }

    @Override
    public ListIterator<OrmNamedQuery> namedQueries() {
        return new CloneListIterator(this.namedQueries);
    }

    @Override
    public int namedQueriesSize() {
        return this.namedQueries.size();
    }

    @Override
    public OrmNamedQuery addNamedQuery(int index) {
        XmlNamedQuery resourceNamedQuery = OrmFactory.eINSTANCE.createXmlNamedQuery();
        OrmNamedQuery contextNamedQuery = this.buildNamedQuery(resourceNamedQuery);
        this.namedQueries.add(index, contextNamedQuery);
        this.xmlEntityMappings.getNamedQueries().add(index, (Object)resourceNamedQuery);
        this.fireItemAdded("namedQueriesList", index, contextNamedQuery);
        return contextNamedQuery;
    }

    protected void addNamedQuery(int index, OrmNamedQuery namedQuery) {
        this.addItemToList(index, namedQuery, this.namedQueries, "namedQueriesList");
    }

    protected void addNamedQuery(OrmNamedQuery namedQuery) {
        this.addNamedQuery(this.namedQueries.size(), namedQuery);
    }

    @Override
    public void removeNamedQuery(NamedQuery namedQuery) {
        this.removeNamedQuery(this.namedQueries.indexOf(namedQuery));
    }

    @Override
    public void removeNamedQuery(int index) {
        OrmNamedQuery namedQuery = this.namedQueries.remove(index);
        this.xmlEntityMappings.getNamedQueries().remove(index);
        this.fireItemRemoved("namedQueriesList", index, namedQuery);
    }

    protected void removeNamedQuery_(OrmNamedQuery namedQuery) {
        this.removeItemFromList(namedQuery, this.namedQueries, "namedQueriesList");
    }

    @Override
    public void moveNamedQuery(int targetIndex, int sourceIndex) {
        this.xmlEntityMappings.getNamedQueries().move(targetIndex, sourceIndex);
        this.moveItemInList(targetIndex, sourceIndex, this.namedQueries, "namedQueriesList");
    }

    @Override
    public ListIterator<OrmNamedNativeQuery> namedNativeQueries() {
        return new CloneListIterator(this.namedNativeQueries);
    }

    @Override
    public int namedNativeQueriesSize() {
        return this.namedNativeQueries.size();
    }

    @Override
    public OrmNamedNativeQuery addNamedNativeQuery(int index) {
        XmlNamedNativeQuery resourceNamedNativeQuery = OrmFactory.eINSTANCE.createXmlNamedNativeQuery();
        OrmNamedNativeQuery namedNativeQuery = this.buildNamedNativeQuery(resourceNamedNativeQuery);
        this.namedNativeQueries.add(index, namedNativeQuery);
        this.xmlEntityMappings.getNamedNativeQueries().add(index, (Object)resourceNamedNativeQuery);
        this.fireItemAdded("namedNativeQueriesList", index, namedNativeQuery);
        return namedNativeQuery;
    }

    protected void addNamedNativeQuery(int index, OrmNamedNativeQuery namedNativeQuery) {
        this.addItemToList(index, namedNativeQuery, this.namedNativeQueries, "namedNativeQueriesList");
    }

    protected void addNamedNativeQuery(OrmNamedNativeQuery namedNativeQuery) {
        this.addNamedNativeQuery(this.namedNativeQueries.size(), namedNativeQuery);
    }

    @Override
    public void removeNamedNativeQuery(NamedNativeQuery namedNativeQuery) {
        this.removeNamedNativeQuery(this.namedNativeQueries.indexOf(namedNativeQuery));
    }

    @Override
    public void removeNamedNativeQuery(int index) {
        OrmNamedNativeQuery namedNativeQuery = this.namedNativeQueries.remove(index);
        this.xmlEntityMappings.getNamedNativeQueries().remove(index);
        this.fireItemRemoved("namedNativeQueriesList", index, namedNativeQuery);
    }

    protected void removeNamedNativeQuery_(OrmNamedNativeQuery namedNativeQuery) {
        this.removeItemFromList(namedNativeQuery, this.namedNativeQueries, "namedNativeQueriesList");
    }

    @Override
    public void moveNamedNativeQuery(int targetIndex, int sourceIndex) {
        this.xmlEntityMappings.getNamedNativeQueries().move(targetIndex, sourceIndex);
        this.moveItemInList(targetIndex, sourceIndex, this.namedNativeQueries, "namedNativeQueriesList");
    }

    @Override
    public boolean containsPersistentType(String className) {
        for (OrmPersistentType persistentType : CollectionTools.iterable(this.ormPersistentTypes())) {
            if (!persistentType.getName().equals(className)) continue;
            return true;
        }
        return false;
    }

    @Override
    public OrmPersistenceUnitDefaults getPersistenceUnitDefaults() {
        return this.getPersistenceUnitMetadata().getPersistenceUnitDefaults();
    }

    protected void initialize(XmlEntityMappings entityMappings) {
        this.xmlEntityMappings = entityMappings;
        this.version = this.xmlEntityMappings.getVersion();
        this.description = this.xmlEntityMappings.getDescription();
        this.package_ = this.xmlEntityMappings.getPackage();
        this.defaultAccess = this.getPersistenceUnit().getDefaultAccess();
        this.specifiedAccess = this.buildSpecifiedAccess();
        this.defaultCatalog = this.getPersistenceUnit().getDefaultCatalog();
        this.specifiedCatalog = this.xmlEntityMappings.getCatalog();
        this.defaultSchema = this.getPersistenceUnit().getDefaultSchema();
        this.specifiedSchema = this.xmlEntityMappings.getSchema();
        this.initializePersistentTypes();
        this.initializeTableGenerators();
        this.initializeSequenceGenerators();
        this.initializeNamedQueries();
        this.initializeNamedNativeQueries();
    }

    protected void initializePersistentTypes() {
        this.initializeMappedSuperclasses();
        this.initializeEntities();
        this.initializeEmbeddables();
    }

    protected void initializeMappedSuperclasses() {
        for (XmlMappedSuperclass mappedSuperclass : this.xmlEntityMappings.getMappedSuperclasses()) {
            OrmPersistentType ormPersistentType = this.getJpaFactory().buildOrmPersistentType(this, "mappedSuperclass");
            ormPersistentType.initialize(mappedSuperclass);
            this.persistentTypes.add(ormPersistentType);
        }
    }

    protected void initializeEntities() {
        for (XmlEntity entity : this.xmlEntityMappings.getEntities()) {
            OrmPersistentType ormPersistentType = this.getJpaFactory().buildOrmPersistentType(this, "entity");
            ormPersistentType.initialize(entity);
            this.persistentTypes.add(ormPersistentType);
        }
    }

    protected void initializeEmbeddables() {
        for (XmlEmbeddable embeddable : this.xmlEntityMappings.getEmbeddables()) {
            OrmPersistentType ormPersistentType = this.getJpaFactory().buildOrmPersistentType(this, "embeddable");
            ormPersistentType.initialize(embeddable);
            this.persistentTypes.add(ormPersistentType);
        }
    }

    protected void initializeTableGenerators() {
        for (XmlTableGenerator tableGenerator : this.xmlEntityMappings.getTableGenerators()) {
            this.tableGenerators.add(this.buildTableGenerator(tableGenerator));
        }
    }

    protected void initializeSequenceGenerators() {
        for (XmlSequenceGenerator sequenceGenerator : this.xmlEntityMappings.getSequenceGenerators()) {
            this.sequenceGenerators.add(this.buildSequenceGenerator(sequenceGenerator));
        }
    }

    protected void initializeNamedQueries() {
        for (XmlNamedQuery namedQuery : this.xmlEntityMappings.getNamedQueries()) {
            this.namedQueries.add(this.buildNamedQuery(namedQuery));
        }
    }

    protected void initializeNamedNativeQueries() {
        for (XmlNamedNativeQuery namedNativeQuery : this.xmlEntityMappings.getNamedNativeQueries()) {
            this.namedNativeQueries.add(this.buildNamedNativeQuery(namedNativeQuery));
        }
    }

    @Override
    public void update() {
        this.setDescription(this.xmlEntityMappings.getDescription());
        this.setPackage(this.xmlEntityMappings.getPackage());
        this.setDefaultAccess(this.getPersistenceUnit().getDefaultAccess());
        this.setSpecifiedAccess(this.buildSpecifiedAccess());
        this.setDefaultCatalog(this.getPersistenceUnit().getDefaultCatalog());
        this.setSpecifiedCatalog(this.xmlEntityMappings.getCatalog());
        this.setDefaultSchema(this.getPersistenceUnit().getDefaultSchema());
        this.setSpecifiedSchema(this.xmlEntityMappings.getSchema());
        this.persistenceUnitMetadata.update();
        this.updatePersistentTypes();
        this.updateTableGenerators();
        this.updateSequenceGenerators();
        this.updateNamedQueries();
        this.updateNamedNativeQueries();
    }

    protected AccessType buildSpecifiedAccess() {
        return AccessType.fromXmlResourceModel(this.xmlEntityMappings.getAccess());
    }

    protected void updatePersistentTypes() {
        ListIterator<OrmPersistentType> ormPersistentTypes = this.ormPersistentTypes();
        this.updateMappedSuperclasses(ormPersistentTypes);
        this.updateEntities(ormPersistentTypes);
        this.updateEmbeddables(ormPersistentTypes);
        while (ormPersistentTypes.hasNext()) {
            this.removeOrmPersistentType_(ormPersistentTypes.next());
        }
    }

    protected void updateMappedSuperclasses(ListIterator<OrmPersistentType> ormPersistentTypes) {
        CloneListIterator mappedSuperclasses = new CloneListIterator(this.xmlEntityMappings.getMappedSuperclasses());
        for (XmlMappedSuperclass mappedSuperclass : CollectionTools.iterable((Iterator)mappedSuperclasses)) {
            if (ormPersistentTypes.hasNext()) {
                ormPersistentTypes.next().update(mappedSuperclass);
                continue;
            }
            OrmPersistentType ormPersistentType = this.getJpaFactory().buildOrmPersistentType(this, "mappedSuperclass");
            ormPersistentType.initialize(mappedSuperclass);
            this.addOrmPersistentType(ormPersistentType);
        }
    }

    protected void updateEntities(ListIterator<OrmPersistentType> ormPersistentTypes) {
        CloneListIterator entities = new CloneListIterator(this.xmlEntityMappings.getEntities());
        for (XmlEntity entity : CollectionTools.iterable((Iterator)entities)) {
            if (ormPersistentTypes.hasNext()) {
                ormPersistentTypes.next().update(entity);
                continue;
            }
            OrmPersistentType ormPersistentType = this.getJpaFactory().buildOrmPersistentType(this, "entity");
            ormPersistentType.initialize(entity);
            this.addOrmPersistentType(ormPersistentType);
        }
    }

    protected void updateEmbeddables(ListIterator<OrmPersistentType> ormPersistentTypes) {
        CloneListIterator embeddables = new CloneListIterator(this.xmlEntityMappings.getEmbeddables());
        for (XmlEmbeddable embeddable : CollectionTools.iterable((Iterator)embeddables)) {
            if (ormPersistentTypes.hasNext()) {
                ormPersistentTypes.next().update(embeddable);
                continue;
            }
            OrmPersistentType ormPersistentType = this.getJpaFactory().buildOrmPersistentType(this, "embeddable");
            ormPersistentType.initialize(embeddable);
            this.addOrmPersistentType(ormPersistentType);
        }
    }

    protected void updateTableGenerators() {
        ListIterator<OrmTableGenerator> contextTableGenerators = this.tableGenerators();
        CloneListIterator resourceTableGenerators = new CloneListIterator(this.xmlEntityMappings.getTableGenerators());
        while (contextTableGenerators.hasNext()) {
            OrmTableGenerator contextTableGenerator = contextTableGenerators.next();
            if (resourceTableGenerators.hasNext()) {
                contextTableGenerator.update((XmlTableGenerator)resourceTableGenerators.next());
                continue;
            }
            this.removeTableGenerator_(contextTableGenerator);
        }
        while (resourceTableGenerators.hasNext()) {
            this.addTableGenerator(this.buildTableGenerator((XmlTableGenerator)resourceTableGenerators.next()));
        }
    }

    protected OrmTableGenerator buildTableGenerator(XmlTableGenerator resourceTableGenerator) {
        return this.getJpaFactory().buildOrmTableGenerator(this, resourceTableGenerator);
    }

    protected void updateSequenceGenerators() {
        ListIterator<OrmSequenceGenerator> contextSequenceGenerators = this.sequenceGenerators();
        CloneListIterator resourceSequenceGenerators = new CloneListIterator(this.xmlEntityMappings.getSequenceGenerators());
        while (contextSequenceGenerators.hasNext()) {
            OrmSequenceGenerator contextSequenceGenerator = contextSequenceGenerators.next();
            if (resourceSequenceGenerators.hasNext()) {
                contextSequenceGenerator.update((XmlSequenceGenerator)resourceSequenceGenerators.next());
                continue;
            }
            this.removeSequenceGenerator_(contextSequenceGenerator);
        }
        while (resourceSequenceGenerators.hasNext()) {
            this.addSequenceGenerator(this.buildSequenceGenerator((XmlSequenceGenerator)resourceSequenceGenerators.next()));
        }
    }

    protected OrmSequenceGenerator buildSequenceGenerator(XmlSequenceGenerator resourceSequenceGenerator) {
        return this.getJpaFactory().buildOrmSequenceGenerator(this, resourceSequenceGenerator);
    }

    protected void updateNamedQueries() {
        ListIterator<OrmNamedQuery> contextNamedQueries = this.namedQueries();
        CloneListIterator resourceNamedQueries = new CloneListIterator(this.xmlEntityMappings.getNamedQueries());
        while (contextNamedQueries.hasNext()) {
            OrmNamedQuery contextNamedQuery = contextNamedQueries.next();
            if (resourceNamedQueries.hasNext()) {
                contextNamedQuery.update((XmlNamedQuery)resourceNamedQueries.next());
                continue;
            }
            this.removeNamedQuery_(contextNamedQuery);
        }
        while (resourceNamedQueries.hasNext()) {
            this.addNamedQuery(this.buildNamedQuery((XmlNamedQuery)resourceNamedQueries.next()));
        }
    }

    protected OrmNamedQuery buildNamedQuery(XmlNamedQuery resourceNamedQuery) {
        return this.getJpaFactory().buildOrmNamedQuery(this, resourceNamedQuery);
    }

    protected void updateNamedNativeQueries() {
        ListIterator<OrmNamedNativeQuery> contextQueries = this.namedNativeQueries();
        CloneListIterator resourceQueries = new CloneListIterator(this.xmlEntityMappings.getNamedNativeQueries());
        while (contextQueries.hasNext()) {
            OrmNamedNativeQuery namedQuery = contextQueries.next();
            if (resourceQueries.hasNext()) {
                namedQuery.update((XmlNamedNativeQuery)resourceQueries.next());
                continue;
            }
            this.removeNamedNativeQuery_(namedQuery);
        }
        while (resourceQueries.hasNext()) {
            this.addNamedNativeQuery(this.buildNamedNativeQuery((XmlNamedNativeQuery)resourceQueries.next()));
        }
    }

    protected OrmNamedNativeQuery buildNamedNativeQuery(XmlNamedNativeQuery resourceNamedQuery) {
        return this.getJpaFactory().buildOrmNamedNativeQuery(this, resourceNamedQuery);
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        for (OrmPersistentType persistentType : CollectionTools.iterable(this.ormPersistentTypes())) {
            if (!persistentType.contains(textOffset)) continue;
            return persistentType.getStructureNode(textOffset);
        }
        return this;
    }

    @Override
    public boolean containsOffset(int textOffset) {
        if (this.xmlEntityMappings == null) {
            return false;
        }
        return this.xmlEntityMappings.containsOffset(textOffset);
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.xmlEntityMappings.getSelectionTextRange();
    }

    @Override
    public TextRange getValidationTextRange() {
        return null;
    }

    @Override
    public void validate(List<IMessage> messages) {
        super.validate(messages);
        this.validateGenerators(messages);
        this.validateQueries(messages);
        ListIterator<OrmPersistentType> stream = this.ormPersistentTypes();
        while (stream.hasNext()) {
            this.validatePersistentType((OrmPersistentType)stream.next(), messages);
        }
    }

    protected void validateGenerators(List<IMessage> messages) {
        Iterator<OrmGenerator> localGenerators = this.generators();
        while (localGenerators.hasNext()) {
            OrmGenerator localGenerator = localGenerators.next();
            ListIterator<Generator> globalGenerators = this.getPersistenceUnit().allGenerators();
            while (globalGenerators.hasNext()) {
                if (!localGenerator.duplicates((Generator)globalGenerators.next())) continue;
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "GENERATOR_DUPLICATE_NAME", new String[]{localGenerator.getName()}, localGenerator, localGenerator.getNameTextRange()));
            }
        }
    }

    public Iterator<OrmGenerator> generators() {
        return new CompositeIterator(new Iterator[]{this.tableGenerators(), this.sequenceGenerators()});
    }

    protected void validateQueries(List<IMessage> messages) {
        Iterator<OrmQuery> localQueries = this.queries();
        while (localQueries.hasNext()) {
            OrmQuery localQuery = localQueries.next();
            ListIterator<Query> globalQueries = this.getPersistenceUnit().allQueries();
            while (globalQueries.hasNext()) {
                if (!localQuery.duplicates((Query)globalQueries.next())) continue;
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "QUERY_DUPLICATE_NAME", new String[]{localQuery.getName()}, localQuery, localQuery.getNameTextRange()));
            }
        }
    }

    protected Iterator<OrmQuery> queries() {
        return new CompositeIterator(new Iterator[]{this.namedQueries(), this.namedNativeQueries()});
    }

    protected void validatePersistentType(OrmPersistentType persistentType, List<IMessage> messages) {
        try {
            persistentType.validate(messages);
        }
        catch (Throwable exception) {
            JptCorePlugin.log(exception);
        }
    }

    @Override
    public void dispose() {
        for (OrmPersistentType ormPersistentType : CollectionTools.iterable(this.ormPersistentTypes())) {
            ormPersistentType.dispose();
        }
    }
}

