/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.PersistentTypeContext;
import org.eclipse.jpt.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.core.context.orm.OrmEmbeddable;
import org.eclipse.jpt.core.context.orm.OrmEntity;
import org.eclipse.jpt.core.context.orm.OrmMappedSuperclass;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmPersistentTypeContext;
import org.eclipse.jpt.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.core.context.orm.OrmTypeMappingProvider;
import org.eclipse.jpt.core.internal.context.AbstractXmlContextNode;
import org.eclipse.jpt.core.internal.context.orm.OrmEmbeddableProvider;
import org.eclipse.jpt.core.internal.context.orm.OrmEntityProvider;
import org.eclipse.jpt.core.internal.context.orm.OrmMappedSuperclassProvider;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlAttributeMapping;
import org.eclipse.jpt.core.resource.orm.AbstractXmlTypeMapping;
import org.eclipse.jpt.core.resource.orm.Attributes;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlAttributeMapping;
import org.eclipse.jpt.core.resource.orm.XmlEmbeddable;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlMappedSuperclass;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.jpt.utility.internal.iterators.ChainIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmPersistentType
extends AbstractXmlContextNode
implements OrmPersistentType {
    protected final List<OrmPersistentAttribute> specifiedPersistentAttributes;
    protected final List<OrmPersistentAttribute> virtualPersistentAttributes;
    protected final Collection<OrmTypeMappingProvider> typeMappingProviders = this.buildTypeMappingProviders();
    protected OrmTypeMapping ormTypeMapping;
    protected PersistentType parentPersistentType;

    public GenericOrmPersistentType(PersistentTypeContext parent, String mappingKey) {
        super(parent);
        this.ormTypeMapping = this.buildOrmTypeMapping(mappingKey);
        this.specifiedPersistentAttributes = new ArrayList<OrmPersistentAttribute>();
        this.virtualPersistentAttributes = new ArrayList<OrmPersistentAttribute>();
    }

    @Override
    public OrmPersistentTypeContext getContext() {
        return (OrmPersistentTypeContext)this.getParent();
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.core.orm.persistentType";
    }

    @Override
    public boolean isFor(String fullyQualifiedTypeName) {
        String className = this.getMapping().getClass_();
        if (className == null) {
            return false;
        }
        if (className.equals(fullyQualifiedTypeName)) {
            return true;
        }
        return (String.valueOf(this.getContext().getDefaultPersistentTypePackage()) + '.' + className).equals(fullyQualifiedTypeName);
    }

    protected OrmTypeMapping buildOrmTypeMapping(String key) {
        return this.getTypeMappingProvider(key).buildMapping(this, this.getJpaFactory());
    }

    protected Collection<OrmTypeMappingProvider> buildTypeMappingProviders() {
        ArrayList<OrmTypeMappingProvider> collection = new ArrayList<OrmTypeMappingProvider>();
        collection.add(new OrmEntityProvider());
        collection.add(new OrmMappedSuperclassProvider());
        collection.add(new OrmEmbeddableProvider());
        return collection;
    }

    protected OrmTypeMappingProvider getTypeMappingProvider(String key) {
        for (OrmTypeMappingProvider provider : this.typeMappingProviders) {
            if (!provider.getKey().equals(key)) continue;
            return provider;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public OrmTypeMapping getMapping() {
        return this.ormTypeMapping;
    }

    @Override
    public void setMappingKey(String newMappingKey) {
        if (this.getMappingKey() == newMappingKey) {
            return;
        }
        OrmTypeMapping oldMapping = this.getMapping();
        this.ormTypeMapping = this.buildOrmTypeMapping(newMappingKey);
        this.getContext().changeMapping(this, oldMapping, this.ormTypeMapping);
        this.firePropertyChanged("mapping", oldMapping, this.ormTypeMapping);
    }

    protected void setMappingKey_(String newMappingKey) {
        if (this.getMappingKey() == newMappingKey) {
            return;
        }
        OrmTypeMapping oldMapping = this.getMapping();
        this.ormTypeMapping = this.buildOrmTypeMapping(newMappingKey);
        this.firePropertyChanged("mapping", oldMapping, this.ormTypeMapping);
    }

    @Override
    public Iterator<PersistentType> inheritanceHierarchy() {
        return new ChainIterator<PersistentType>((PersistentType)this){

            protected PersistentType nextLink(PersistentType pt) {
                return pt.getParentPersistentType();
            }
        };
    }

    @Override
    public Iterator<PersistentType> ancestors() {
        return new ChainIterator<PersistentType>(this.getParentPersistentType()){

            protected PersistentType nextLink(PersistentType pt) {
                return pt.getParentPersistentType();
            }
        };
    }

    @Override
    public PersistentType getParentPersistentType() {
        return this.parentPersistentType;
    }

    public void setParentPersistentType(PersistentType newParentPersistentType) {
        if (this.attributeValueHasNotChanged(this.parentPersistentType, newParentPersistentType)) {
            return;
        }
        PersistentType oldParentPersistentType = this.parentPersistentType;
        this.parentPersistentType = newParentPersistentType;
        this.firePropertyChanged("parentPersistentType", oldParentPersistentType, newParentPersistentType);
    }

    @Override
    public AccessType getAccess() {
        return this.getMapping().getAccess();
    }

    @Override
    public void changeMapping(OrmPersistentAttribute ormPersistentAttribute, OrmAttributeMapping oldMapping, OrmAttributeMapping newMapping) {
        int sourceIndex = this.specifiedPersistentAttributes.indexOf(ormPersistentAttribute);
        this.specifiedPersistentAttributes.remove(sourceIndex);
        oldMapping.removeFromResourceModel(this.ormTypeMapping.getResourceTypeMapping());
        int targetIndex = this.insertionIndex(ormPersistentAttribute);
        this.specifiedPersistentAttributes.add(targetIndex, ormPersistentAttribute);
        newMapping.addToResourceModel(this.getMapping().getResourceTypeMapping());
        oldMapping.initializeOn(newMapping);
        this.fireItemMoved("specifiedAttributes", targetIndex, sourceIndex);
    }

    @Override
    public void makePersistentAttributeVirtual(OrmPersistentAttribute ormPersistentAttribute) {
        if (ormPersistentAttribute.isVirtual()) {
            throw new IllegalStateException("Attribute is already virtual");
        }
        JavaPersistentAttribute javaPersistentAttribute = ormPersistentAttribute.getMapping().getJavaPersistentAttribute();
        OrmPersistentAttribute virtualPersistentAttribute = null;
        if (javaPersistentAttribute != null) {
            virtualPersistentAttribute = this.buildVirtualOrmPersistentAttribute(javaPersistentAttribute);
            this.virtualPersistentAttributes.add(virtualPersistentAttribute);
        }
        this.removeSpecifiedPersistentAttribute(ormPersistentAttribute);
        if (virtualPersistentAttribute != null) {
            this.fireItemAdded("virtualAttributes", this.virtualAttributesSize() - 1, virtualPersistentAttribute);
        }
    }

    @Override
    public void makePersistentAttributeSpecified(OrmPersistentAttribute ormPersistentAttribute) {
        this.makePersistentAttributeSpecified(ormPersistentAttribute, ormPersistentAttribute.getMappingKey());
    }

    @Override
    public void makePersistentAttributeSpecified(OrmPersistentAttribute ormPersistentAttribute, String mappingKey) {
        if (!ormPersistentAttribute.isVirtual()) {
            throw new IllegalStateException("Attribute is already specified");
        }
        if (mappingKey == MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY) {
            throw new IllegalStateException("Use makePersistentAttributeSpecified(OrmPersistentAttribute, String) instead and specify a mapping type");
        }
        OrmPersistentAttribute newPersistentAttribute = this.buildOrmPersistentAttribute(mappingKey);
        if (this.getMapping().getResourceTypeMapping().getAttributes() == null) {
            this.getMapping().getResourceTypeMapping().setAttributes(this.createAttributesResource());
        }
        int insertionIndex = this.insertionIndex(newPersistentAttribute);
        this.specifiedPersistentAttributes.add(insertionIndex, newPersistentAttribute);
        newPersistentAttribute.getMapping().addToResourceModel(this.getMapping().getResourceTypeMapping());
        int removalIndex = this.virtualPersistentAttributes.indexOf(ormPersistentAttribute);
        this.virtualPersistentAttributes.remove(ormPersistentAttribute);
        newPersistentAttribute.getSpecifiedMapping().setName(ormPersistentAttribute.getName());
        this.fireItemAdded("specifiedAttributes", insertionIndex, newPersistentAttribute);
        this.fireItemRemoved("virtualAttributes", removalIndex, ormPersistentAttribute);
    }

    protected Attributes createAttributesResource() {
        return OrmFactory.eINSTANCE.createAttributes();
    }

    @Override
    public Iterator<String> allAttributeNames() {
        return this.attributeNames(this.allAttributes());
    }

    @Override
    public Iterator<PersistentAttribute> allAttributes() {
        return new CompositeIterator((Iterator)new TransformationIterator<PersistentType, Iterator<PersistentAttribute>>(this.inheritanceHierarchy()){

            protected Iterator<PersistentAttribute> transform(PersistentType pt) {
                return pt.attributes();
            }
        });
    }

    protected Iterator<OrmPersistentAttribute> attributesNamed(final String attributeName) {
        return new FilteringIterator<OrmPersistentAttribute, OrmPersistentAttribute>(this.attributes()){

            protected boolean accept(OrmPersistentAttribute o) {
                if (attributeName == null && o.getName() == null) {
                    return true;
                }
                return attributeName != null && attributeName.equals(o.getName());
            }
        };
    }

    @Override
    public OrmPersistentAttribute getAttributeNamed(String attributeName) {
        Iterator<OrmPersistentAttribute> stream = this.attributesNamed(attributeName);
        return stream.hasNext() ? stream.next() : null;
    }

    @Override
    public Iterator<String> attributeNames() {
        return this.attributeNames(this.attributes());
    }

    protected Iterator<String> attributeNames(Iterator<? extends PersistentAttribute> attrs) {
        return new TransformationIterator<PersistentAttribute, String>(attrs){

            protected String transform(PersistentAttribute attribute) {
                return attribute.getName();
            }
        };
    }

    protected OrmPersistentAttribute specifiedAttributeNamed(String attributeName) {
        Iterator<OrmPersistentAttribute> stream = this.specifiedAttributesNamed(attributeName);
        return stream.hasNext() ? stream.next() : null;
    }

    protected Iterator<OrmPersistentAttribute> specifiedAttributesNamed(final String attributeName) {
        return new FilteringIterator<OrmPersistentAttribute, OrmPersistentAttribute>(this.specifiedAttributes()){

            protected boolean accept(OrmPersistentAttribute ormPersistentAttribute) {
                return attributeName.equals(ormPersistentAttribute.getName());
            }
        };
    }

    @Override
    public ListIterator<OrmPersistentAttribute> attributes() {
        return new CompositeListIterator(new ListIterator[]{this.specifiedAttributes(), this.virtualAttributes()});
    }

    @Override
    public int attributesSize() {
        return this.specifiedAttributesSize() + this.virtualAttributesSize();
    }

    @Override
    public ListIterator<OrmPersistentAttribute> specifiedAttributes() {
        return new CloneListIterator(this.specifiedPersistentAttributes);
    }

    @Override
    public int specifiedAttributesSize() {
        return this.specifiedPersistentAttributes.size();
    }

    @Override
    public ListIterator<OrmPersistentAttribute> virtualAttributes() {
        return new CloneListIterator(this.virtualPersistentAttributes);
    }

    @Override
    public int virtualAttributesSize() {
        return this.virtualPersistentAttributes.size();
    }

    protected void addVirtualPersistentAttribute(OrmPersistentAttribute ormPersistentAttribute) {
        this.addItemToList(ormPersistentAttribute, this.virtualPersistentAttributes, "virtualAttributes");
    }

    protected void removeVirtualPersistentAttribute(OrmPersistentAttribute ormPersistentAttribute) {
        this.removeItemFromList(ormPersistentAttribute, this.virtualPersistentAttributes, "virtualAttributes");
    }

    protected void moveVirtualPersistentAttribute_(int index, OrmPersistentAttribute attribute) {
        this.moveItemInList(index, this.virtualPersistentAttributes.indexOf(attribute), this.virtualPersistentAttributes, "virtualAttributes");
    }

    @Override
    public boolean containsVirtualPersistentAttribute(OrmPersistentAttribute ormPersistentAttribute) {
        return this.virtualPersistentAttributes.contains(ormPersistentAttribute);
    }

    @Override
    public OrmPersistentAttribute addSpecifiedPersistentAttribute(String mappingKey, String attributeName) {
        OrmPersistentAttribute persistentAttribute = this.buildOrmPersistentAttribute(mappingKey);
        int index = this.insertionIndex(persistentAttribute);
        if (this.getMapping().getResourceTypeMapping().getAttributes() == null) {
            this.getMapping().getResourceTypeMapping().setAttributes(this.createAttributesResource());
        }
        this.specifiedPersistentAttributes.add(index, persistentAttribute);
        persistentAttribute.getMapping().addToResourceModel(this.getMapping().getResourceTypeMapping());
        persistentAttribute.getSpecifiedMapping().setName(attributeName);
        this.fireItemAdded("specifiedAttributes", index, persistentAttribute);
        return persistentAttribute;
    }

    protected int insertionIndex(OrmPersistentAttribute persistentAttribute) {
        return CollectionTools.insertionIndexOf(this.specifiedPersistentAttributes, (Object)persistentAttribute, this.buildMappingComparator());
    }

    protected Comparator<OrmPersistentAttribute> buildMappingComparator() {
        return new Comparator<OrmPersistentAttribute>(){

            @Override
            public int compare(OrmPersistentAttribute o1, OrmPersistentAttribute o2) {
                int o2Sequence;
                int o1Sequence = o1.getMapping().getXmlSequence();
                if (o1Sequence < (o2Sequence = o2.getMapping().getXmlSequence())) {
                    return -1;
                }
                if (o1Sequence == o2Sequence) {
                    return 0;
                }
                return 1;
            }
        };
    }

    protected void addSpecifiedPersistentAttribute_(OrmPersistentAttribute ormPersistentAttribute) {
        this.addItemToList(ormPersistentAttribute, this.specifiedPersistentAttributes, "specifiedAttributes");
    }

    protected void removeSpecifiedPersistentAttribute_(OrmPersistentAttribute ormPersistentAttribute) {
        this.removeItemFromList(ormPersistentAttribute, this.specifiedPersistentAttributes, "specifiedAttributes");
    }

    protected void moveSpecifiedPersistentAttribute_(int index, OrmPersistentAttribute attribute) {
        this.moveItemInList(index, this.specifiedPersistentAttributes.indexOf(attribute), this.specifiedPersistentAttributes, "specifiedAttributes");
    }

    @Override
    public void removeSpecifiedPersistentAttribute(OrmPersistentAttribute ormPersistentAttribute) {
        int index = this.specifiedPersistentAttributes.indexOf(ormPersistentAttribute);
        this.specifiedPersistentAttributes.remove(ormPersistentAttribute);
        ormPersistentAttribute.getMapping().removeFromResourceModel(this.ormTypeMapping.getResourceTypeMapping());
        if (this.ormTypeMapping.getResourceTypeMapping().getAttributes().isAllFeaturesUnset()) {
            this.ormTypeMapping.getResourceTypeMapping().setAttributes(null);
        }
        this.fireItemRemoved("specifiedAttributes", index, ormPersistentAttribute);
    }

    @Override
    public String getName() {
        return this.getMapping().getClass_();
    }

    @Override
    public String getShortName() {
        return this.getName() == null ? null : this.getName().substring(this.getName().lastIndexOf(46) + 1);
    }

    @Override
    public void classChanged(String oldClass, String newClass) {
        this.firePropertyChanged("name", oldClass, newClass);
    }

    @Override
    public boolean isMapped() {
        return true;
    }

    @Override
    public String getMappingKey() {
        return this.getMapping().getKey();
    }

    @Override
    public JavaPersistentType getJavaPersistentType() {
        return this.getMapping().getJavaPersistentType();
    }

    @Override
    public void initialize(XmlEntity entity) {
        ((OrmEntity)this.getMapping()).initialize(entity);
        this.initializeParentPersistentType();
        this.initializePersistentAttributes(entity);
    }

    @Override
    public void initialize(XmlMappedSuperclass mappedSuperclass) {
        ((OrmMappedSuperclass)this.getMapping()).initialize(mappedSuperclass);
        this.initializeParentPersistentType();
        this.initializePersistentAttributes(mappedSuperclass);
    }

    @Override
    public void initialize(XmlEmbeddable embeddable) {
        ((OrmEmbeddable)this.getMapping()).initialize(embeddable);
        this.initializeParentPersistentType();
        this.initializePersistentAttributes(embeddable);
    }

    protected void initializePersistentAttributes(AbstractXmlTypeMapping typeMapping) {
        this.initializeSpecifiedPersistentAttributes(typeMapping.getAttributes());
        this.initializeVirtualPersistentAttributes();
    }

    protected OrmPersistentAttribute buildOrmPersistentAttribute(String mappingKey) {
        return this.getJpaFactory().buildOrmPersistentAttribute(this, mappingKey);
    }

    protected void initializeSpecifiedPersistentAttributes(Attributes attributes) {
        if (attributes == null) {
            return;
        }
        for (XmlAttributeMapping resourceMapping : attributes.getAttributeMappings()) {
            OrmPersistentAttribute ormPersistentAttribute = this.buildOrmPersistentAttribute(resourceMapping.getMappingKey());
            ormPersistentAttribute.initialize(resourceMapping);
            this.specifiedPersistentAttributes.add(ormPersistentAttribute);
        }
    }

    protected void initializeVirtualPersistentAttributes() {
        ListIterator<JavaPersistentAttribute> javaAttributes = this.javaPersistentAttributes();
        while (javaAttributes.hasNext()) {
            JavaPersistentAttribute javaPersistentAttribute = javaAttributes.next();
            if (this.specifiedAttributeNamed(javaPersistentAttribute.getName()) != null) continue;
            OrmPersistentAttribute ormPersistentAttribute = this.buildVirtualOrmPersistentAttribute(javaPersistentAttribute);
            this.virtualPersistentAttributes.add(ormPersistentAttribute);
        }
    }

    protected ListIterator<JavaPersistentAttribute> javaPersistentAttributes() {
        JavaPersistentType javaPersistentType = this.getJavaPersistentType();
        if (javaPersistentType != null) {
            return javaPersistentType.attributes();
        }
        return EmptyListIterator.instance();
    }

    protected void initializeParentPersistentType() {
        JavaPersistentType javaPersistentType = this.getJavaPersistentType();
        if (javaPersistentType != null) {
            this.parentPersistentType = javaPersistentType.getParentPersistentType();
        }
    }

    @Override
    public void update(XmlEntity entity) {
        if (this.getMappingKey() != "entity") {
            this.setMappingKey_("entity");
        }
        ((OrmEntity)this.getMapping()).update(entity);
        this.updateParentPersistentType();
        this.updatePersistentAttributes(entity);
    }

    @Override
    public void update(XmlMappedSuperclass mappedSuperclass) {
        if (this.getMappingKey() != "mappedSuperclass") {
            this.setMappingKey_("mappedSuperclass");
        }
        ((OrmMappedSuperclass)this.getMapping()).update(mappedSuperclass);
        this.updateParentPersistentType();
        this.updatePersistentAttributes(mappedSuperclass);
    }

    @Override
    public void update(XmlEmbeddable embeddable) {
        if (this.getMappingKey() != "embeddable") {
            this.setMappingKey_("embeddable");
        }
        ((OrmEmbeddable)this.getMapping()).update(embeddable);
        this.updateParentPersistentType();
        this.updatePersistentAttributes(embeddable);
    }

    protected void updateParentPersistentType() {
        PersistentType parentPersistentType;
        JavaPersistentType javaPersistentType = this.getJavaPersistentType();
        PersistentType persistentType = parentPersistentType = javaPersistentType == null ? null : javaPersistentType.getParentPersistentType();
        if (parentPersistentType == null) {
            this.setParentPersistentType(null);
        } else if (CollectionTools.contains(parentPersistentType.inheritanceHierarchy(), (Object)this)) {
            this.setParentPersistentType(null);
        } else {
            this.setParentPersistentType(parentPersistentType);
        }
    }

    protected void updatePersistentAttributes(AbstractXmlTypeMapping typeMapping) {
        this.updateSpecifiedPersistentAttributes(typeMapping.getAttributes());
        this.updateVirtualPersistentAttributes();
    }

    protected void updateSpecifiedPersistentAttributes(Attributes attributes) {
        HashBag contextAttributesToRemove = CollectionTools.collection(this.specifiedAttributes());
        ArrayList<OrmPersistentAttribute> contextAttributesToUpdate = new ArrayList<OrmPersistentAttribute>();
        int resourceIndex = 0;
        if (attributes != null) {
            for (XmlAttributeMapping resourceMapping : attributes.getAttributeMappings()) {
                boolean contextAttributeFound = false;
                for (OrmPersistentAttribute contextAttribute : contextAttributesToRemove) {
                    if (contextAttribute.getMapping().getResourceAttributeMapping() != resourceMapping) continue;
                    this.moveSpecifiedPersistentAttribute_(resourceIndex, contextAttribute);
                    contextAttributesToRemove.remove(contextAttribute);
                    contextAttributesToUpdate.add(contextAttribute);
                    contextAttributeFound = true;
                    break;
                }
                if (!contextAttributeFound) {
                    OrmPersistentAttribute ormPersistentAttribute = this.buildOrmPersistentAttribute(resourceMapping.getMappingKey());
                    ormPersistentAttribute.initialize(resourceMapping);
                    this.addSpecifiedPersistentAttribute_(ormPersistentAttribute);
                }
                ++resourceIndex;
            }
        }
        for (OrmPersistentAttribute contextAttribute : contextAttributesToRemove) {
            this.removeSpecifiedPersistentAttribute_(contextAttribute);
        }
        for (OrmPersistentAttribute contextAttribute : contextAttributesToUpdate) {
            contextAttribute.update();
        }
    }

    protected void updateVirtualPersistentAttributes() {
        HashBag contextAttributesToRemove = CollectionTools.collection(this.virtualAttributes());
        ArrayList<OrmPersistentAttribute> contextAttributesToUpdate = new ArrayList<OrmPersistentAttribute>();
        int resourceIndex = 0;
        ListIterator<JavaPersistentAttribute> javaAttributes = this.javaPersistentAttributes();
        for (JavaPersistentAttribute javaAttribute : CollectionTools.iterable(javaAttributes)) {
            if (this.specifiedAttributeNamed(javaAttribute.getName()) != null) continue;
            JavaAttributeMapping javaAttributeMapping = javaAttribute.getMapping();
            if (this.getMapping().isMetadataComplete()) {
                javaAttributeMapping = javaAttribute.getDefaultMapping();
            }
            boolean contextAttributeFound = false;
            for (OrmPersistentAttribute contextAttribute : contextAttributesToRemove) {
                if (((VirtualXmlAttributeMapping)contextAttribute.getMapping().getResourceAttributeMapping()).getJavaAttributeMapping() != javaAttributeMapping) continue;
                this.moveVirtualPersistentAttribute_(resourceIndex, contextAttribute);
                contextAttributesToRemove.remove(contextAttribute);
                contextAttributesToUpdate.add(contextAttribute);
                contextAttributeFound = true;
                break;
            }
            if (!contextAttributeFound) {
                this.addVirtualPersistentAttribute(javaAttribute);
            }
            ++resourceIndex;
        }
        for (OrmPersistentAttribute contextAttribute : contextAttributesToRemove) {
            this.removeVirtualPersistentAttribute(contextAttribute);
        }
        for (OrmPersistentAttribute contextAttribute : contextAttributesToUpdate) {
            contextAttribute.update();
        }
    }

    protected void addVirtualPersistentAttribute(JavaPersistentAttribute javaAttribute) {
        this.addVirtualPersistentAttribute(this.buildVirtualOrmPersistentAttribute(javaAttribute));
    }

    protected OrmPersistentAttribute buildVirtualOrmPersistentAttribute(JavaPersistentAttribute javaAttribute) {
        String javaMappingKey = javaAttribute.getMappingKey();
        JavaAttributeMapping javaAttributeMapping = javaAttribute.getMapping();
        if (this.getMapping().isMetadataComplete()) {
            javaMappingKey = javaAttribute.getDefaultMappingKey();
            javaAttributeMapping = javaAttribute.getDefaultMapping();
        }
        OrmPersistentAttribute ormPersistentAttribute = this.buildOrmPersistentAttribute(javaMappingKey);
        XmlAttributeMapping resourceMapping = this.getJpaPlatform().buildVirtualOrmResourceMappingFromMappingKey(javaMappingKey, this.getMapping(), javaAttributeMapping);
        ormPersistentAttribute.initialize(resourceMapping);
        return ormPersistentAttribute;
    }

    @Override
    public PersistentAttribute resolveAttribute(String attributeName) {
        Iterator<OrmPersistentAttribute> attributes = this.attributesNamed(attributeName);
        if (attributes.hasNext()) {
            OrmPersistentAttribute attribute = attributes.next();
            return attributes.hasNext() ? null : attribute;
        }
        if (this.getParentPersistentType() != null) {
            return this.getParentPersistentType().resolveAttribute(attributeName);
        }
        return null;
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        for (OrmPersistentAttribute attribute : CollectionTools.iterable(this.specifiedAttributes())) {
            if (!attribute.contains(textOffset)) continue;
            return attribute;
        }
        return this;
    }

    @Override
    public boolean contains(int textOffset) {
        return this.ormTypeMapping.containsOffset(textOffset);
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.ormTypeMapping.getSelectionTextRange();
    }

    @Override
    public void validate(List<IMessage> messages) {
        super.validate(messages);
        this.validateMapping(messages);
        this.validateAttributes(messages);
    }

    protected void validateMapping(List<IMessage> messages) {
        try {
            this.ormTypeMapping.validate(messages);
        }
        catch (Throwable t) {
            JptCorePlugin.log(t);
        }
    }

    protected void validateAttributes(List<IMessage> messages) {
        ListIterator<OrmPersistentAttribute> stream = this.attributes();
        while (stream.hasNext()) {
            this.validateAttribute((OrmPersistentAttribute)stream.next(), messages);
        }
    }

    protected void validateAttribute(OrmPersistentAttribute attribute, List<IMessage> messages) {
        try {
            attribute.validate(messages);
        }
        catch (Throwable t) {
            JptCorePlugin.log(t);
        }
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.ormTypeMapping.getValidationTextRange();
    }

    @Override
    public void dispose() {
        if (this.getJavaPersistentType() != null) {
            this.getJavaPersistentType().dispose();
        }
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }
}

