/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.context.MappingFileRoot;
import org.eclipse.jpt.core.context.orm.EntityMappings;
import org.eclipse.jpt.core.context.orm.OrmPersistenceUnitDefaults;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmXml;
import org.eclipse.jpt.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.core.internal.context.AbstractXmlContextNode;
import org.eclipse.jpt.core.resource.common.JpaXmlResource;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.OrmResource;
import org.eclipse.jpt.core.resource.orm.XmlEntityMappings;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrmXmlImpl
extends AbstractXmlContextNode
implements OrmXml {
    protected OrmResource ormResource;
    protected EntityMappings entityMappings;

    public OrmXmlImpl(MappingFileRef parent, OrmResource ormResource) {
        super(parent);
        this.initialize(ormResource);
    }

    @Override
    public MappingFileRef getParent() {
        return (MappingFileRef)super.getParent();
    }

    @Override
    public IResource getResource() {
        return this.ormResource.getFile();
    }

    @Override
    public MappingFileRoot getMappingFileRoot() {
        return this.getEntityMappings();
    }

    @Override
    public JpaXmlResource getEResource() {
        return this.ormResource;
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public JpaXmlResource getXmlResource() {
        return this.ormResource;
    }

    @Override
    public MappingFileRoot getRoot() {
        return this.getEntityMappings();
    }

    @Override
    public OrmPersistentType getPersistentType(String fullyQualifiedTypeName) {
        return this.entityMappings == null ? null : this.entityMappings.getPersistentType(fullyQualifiedTypeName);
    }

    @Override
    public EntityMappings getEntityMappings() {
        return this.entityMappings;
    }

    protected void setEntityMappings(EntityMappings newEntityMappings) {
        EntityMappings oldEntityMappings = this.entityMappings;
        this.entityMappings = newEntityMappings;
        this.firePropertyChanged("entityMappingsProperty", oldEntityMappings, newEntityMappings);
    }

    @Override
    public EntityMappings addEntityMappings() {
        if (this.entityMappings != null) {
            throw new IllegalStateException();
        }
        XmlEntityMappings xmlEntityMappings = this.buildEntityMappingsResource();
        this.entityMappings = this.buildEntityMappings(xmlEntityMappings);
        this.ormResource.getContents().add((Object)xmlEntityMappings);
        this.firePropertyChanged("entityMappingsProperty", null, this.entityMappings);
        return this.entityMappings;
    }

    protected XmlEntityMappings buildEntityMappingsResource() {
        return OrmFactory.eINSTANCE.createXmlEntityMappings();
    }

    @Override
    public void removeEntityMappings() {
        if (this.entityMappings == null) {
            throw new IllegalStateException();
        }
        this.getJpaFile(this.ormResource.getFile()).removeRootStructureNode((Object)this.ormResource);
        this.entityMappings.dispose();
        EntityMappings oldEntityMappings = this.entityMappings;
        this.entityMappings = null;
        XmlEntityMappings xmlEntityMappings = this.ormResource.getEntityMappings();
        this.ormResource.getContents().remove((Object)xmlEntityMappings);
        this.firePropertyChanged("entityMappingsProperty", oldEntityMappings, null);
    }

    public OrmPersistenceUnitDefaults getPersistenceUnitDefaults() {
        return this.entityMappings == null ? null : this.entityMappings.getPersistenceUnitDefaults();
    }

    protected void initialize(OrmResource resource) {
        this.ormResource = resource;
        XmlEntityMappings xmlEntityMappings = resource.getEntityMappings();
        if (xmlEntityMappings != null) {
            this.entityMappings = this.buildEntityMappings(xmlEntityMappings);
        }
    }

    @Override
    public void update(JpaXmlResource resource) {
        OrmResource ormResource;
        try {
            ormResource = (OrmResource)resource;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(resource.toString());
        }
        XmlEntityMappings oldXmlEntityMappings = this.entityMappings == null ? null : this.entityMappings.getXmlEntityMappings();
        XmlEntityMappings newXmlEntityMappings = ormResource.getEntityMappings();
        this.ormResource = ormResource;
        if (oldXmlEntityMappings != newXmlEntityMappings && this.entityMappings != null) {
            this.getJpaFile(this.ormResource.getFile()).removeRootStructureNode((Object)this.ormResource);
            this.entityMappings.dispose();
            this.setEntityMappings(null);
        }
        if (newXmlEntityMappings != null) {
            if (this.entityMappings != null) {
                this.getJpaFile(this.ormResource.getFile()).addRootStructureNode((Object)this.ormResource, this.entityMappings);
                this.entityMappings.update();
            } else {
                this.setEntityMappings(this.buildEntityMappings(newXmlEntityMappings));
            }
        } else {
            if (this.entityMappings != null) {
                this.getJpaFile(this.ormResource.getFile()).removeRootStructureNode((Object)this.ormResource);
                this.entityMappings.dispose();
            }
            this.setEntityMappings(null);
        }
    }

    protected EntityMappings buildEntityMappings(XmlEntityMappings xmlEntityMappings) {
        return this.getJpaFactory().buildEntityMappings(this, xmlEntityMappings);
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        if (this.entityMappings.containsOffset(textOffset)) {
            return this.entityMappings.getStructureNode(textOffset);
        }
        return this;
    }

    @Override
    public TextRange getSelectionTextRange() {
        return TextRange.Empty.instance();
    }

    @Override
    public TextRange getValidationTextRange() {
        return TextRange.Empty.instance();
    }

    @Override
    public void validate(List<IMessage> messages) {
        super.validate(messages);
        if (this.entityMappings != null) {
            this.entityMappings.validate(messages);
        }
    }

    @Override
    public void dispose() {
        if (this.entityMappings != null) {
            this.entityMappings.dispose();
        }
    }
}

