/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractResourceAnnotation;
import org.eclipse.jpt.core.internal.resource.java.AssociationOverrideImpl;
import org.eclipse.jpt.core.internal.resource.java.ContainerAnnotationTools;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.AssociationOverridesAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.NestableAssociationOverride;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssociationOverridesImpl
extends AbstractResourceAnnotation<Member>
implements AssociationOverridesAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.AssociationOverrides");
    protected final List<NestableAssociationOverride> associationOverrides = new ArrayList<NestableAssociationOverride>();

    protected AssociationOverridesImpl(JavaResourceNode parent, Member member) {
        super(parent, member, DECLARATION_ANNOTATION_ADAPTER);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        ContainerAnnotationTools.initializeNestedAnnotations(astRoot, this);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.AssociationOverrides";
    }

    @Override
    public String getNestableAnnotationName() {
        return "javax.persistence.AssociationOverride";
    }

    @Override
    public ListIterator<NestableAssociationOverride> nestedAnnotations() {
        return new CloneListIterator(this.associationOverrides);
    }

    @Override
    public int nestedAnnotationsSize() {
        return this.associationOverrides.size();
    }

    @Override
    public NestableAssociationOverride addInternal(int index) {
        AssociationOverrideImpl associationOverride = this.createAssociationOverride(index);
        this.associationOverrides.add(index, associationOverride);
        return associationOverride;
    }

    @Override
    public NestableAssociationOverride add(int index) {
        AssociationOverrideImpl associationOverride = this.createAssociationOverride(index);
        this.add(index, associationOverride);
        return associationOverride;
    }

    private void add(int index, NestableAssociationOverride associationOverride) {
        this.addItemToList(index, associationOverride, this.associationOverrides, "associationOveridesList");
    }

    @Override
    public void remove(NestableAssociationOverride associationOverride) {
        this.removeItemFromList(associationOverride, this.associationOverrides, "associationOveridesList");
    }

    @Override
    public void remove(int index) {
        this.removeItemFromList(index, this.associationOverrides, "associationOveridesList");
    }

    @Override
    public int indexOf(NestableAssociationOverride associationOverride) {
        return this.associationOverrides.indexOf(associationOverride);
    }

    @Override
    public NestableAssociationOverride nestedAnnotationAt(int index) {
        return this.associationOverrides.get(index);
    }

    @Override
    public NestableAssociationOverride nestedAnnotationFor(Annotation jdtAnnotation) {
        for (NestableAssociationOverride associationOverride : this.associationOverrides) {
            if (jdtAnnotation != associationOverride.getJdtAnnotation((CompilationUnit)jdtAnnotation.getRoot())) continue;
            return associationOverride;
        }
        return null;
    }

    @Override
    public void move(int targetIndex, int sourceIndex) {
        this.moveItemInList(targetIndex, sourceIndex, this.associationOverrides, "associationOveridesList");
    }

    @Override
    public void moveInternal(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.associationOverrides, (int)targetIndex, (int)sourceIndex);
    }

    @Override
    public String getElementName() {
        return "value";
    }

    @Override
    public void update(CompilationUnit astRoot) {
        ContainerAnnotationTools.updateNestedAnnotationsFromJava(astRoot, this);
    }

    private AssociationOverrideImpl createAssociationOverride(int index) {
        return AssociationOverrideImpl.createNestedAssociationOverride(this, this.getMember(), index, this.getDeclarationAnnotationAdapter());
    }

    public static class AssociationOverridesAnnotationDefinition
    implements AnnotationDefinition {
        private static final AssociationOverridesAnnotationDefinition INSTANCE = new AssociationOverridesAnnotationDefinition();

        public static AnnotationDefinition instance() {
            return INSTANCE;
        }

        private AssociationOverridesAnnotationDefinition() {
        }

        public AssociationOverridesAnnotation buildAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new AssociationOverridesImpl(parent, member);
        }

        public AssociationOverridesAnnotation buildNullAnnotation(JavaResourcePersistentMember parent, Member member) {
            return null;
        }

        public String getAnnotationName() {
            return "javax.persistence.AssociationOverrides";
        }
    }
}

