/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jpt.core.internal.resource.java.AbstractJavaResourcePersistentMember;
import org.eclipse.jpt.core.internal.utility.jdt.JDTFieldAttribute;
import org.eclipse.jpt.core.internal.utility.jdt.JDTMethodAttribute;
import org.eclipse.jpt.core.internal.utility.jdt.JDTTools;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.JpaCompilationUnit;
import org.eclipse.jpt.core.utility.jdt.Attribute;
import org.eclipse.jpt.core.utility.jdt.MethodAttribute;
import org.eclipse.jpt.core.utility.jdt.Type;
import org.eclipse.jpt.utility.MethodSignature;
import org.eclipse.jpt.utility.internal.CollectionTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaResourcePersistentAttributeImpl
extends AbstractJavaResourcePersistentMember<Attribute>
implements JavaResourcePersistentAttribute {
    private boolean typeIsBasic;
    private String qualifiedTypeName;
    private boolean typeIsSerializable;
    private boolean typeIsDateOrCalendar;
    private boolean typeIsContainer;
    private String qualifiedReferenceEntityTypeName;
    private String qualifiedReferenceEntityElementTypeName;
    private boolean public_;
    private boolean final_;
    private static final String MAP_TYPE_NAME = Map.class.getName();
    private static final String[] CONTAINER_TYPE_NAMES = new String[]{Collection.class.getName(), Set.class.getName(), List.class.getName(), MAP_TYPE_NAME};
    private static final String[] VALID_ELEMENT_TYPE_NAMES = new String[]{Byte.TYPE.getName(), Character.TYPE.getName(), Byte.class.getName(), Character.class.getName()};
    private static final String[] PRIMITIVE_WRAPPER_TYPE_NAMES = new String[]{Byte.class.getName(), Character.class.getName(), Double.class.getName(), Float.class.getName(), Integer.class.getName(), Long.class.getName(), Short.class.getName(), Boolean.class.getName()};
    private static final String[] OTHER_SUPPORTED_TYPE_NAMES = new String[]{String.class.getName(), BigInteger.class.getName(), BigDecimal.class.getName(), java.util.Date.class.getName(), Calendar.class.getName(), Date.class.getName(), Time.class.getName(), Timestamp.class.getName()};
    private static final String SERIALIZABLE_TYPE_NAME = Serializable.class.getName();
    private static final String DATE_TYPE_NAME = java.util.Date.class.getName();
    private static final String CALENDAR_TYPE_NAME = Calendar.class.getName();

    public static JavaResourcePersistentAttribute newInstance(JavaResourcePersistentType parent, Type declaringType, String name, int occurrence, JpaCompilationUnit jpaCompilationUnit, CompilationUnit astRoot) {
        JDTFieldAttribute attribute = new JDTFieldAttribute(declaringType, name, occurrence, jpaCompilationUnit.getCompilationUnit(), jpaCompilationUnit.getModifySharedDocumentCommandExecutorProvider(), jpaCompilationUnit.getAnnotationEditFormatter());
        JavaResourcePersistentAttributeImpl field = new JavaResourcePersistentAttributeImpl(parent, attribute);
        field.initialize(astRoot);
        return field;
    }

    public static JavaResourcePersistentAttribute newInstance(JavaResourcePersistentType parent, Type declaringType, MethodSignature signature, int occurrence, JpaCompilationUnit jpaCompilationUnit, CompilationUnit astRoot) {
        JDTMethodAttribute attribute = JDTMethodAttribute.newInstance(declaringType, signature, occurrence, jpaCompilationUnit.getCompilationUnit(), jpaCompilationUnit.getModifySharedDocumentCommandExecutorProvider(), jpaCompilationUnit.getAnnotationEditFormatter());
        JavaResourcePersistentAttributeImpl field = new JavaResourcePersistentAttributeImpl(parent, attribute);
        field.initialize(astRoot);
        return field;
    }

    public JavaResourcePersistentAttributeImpl(JavaResourcePersistentType parent, Attribute attribute) {
        super(parent, attribute);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.typeIsBasic = this.buildTypeIsBasic(astRoot);
        this.qualifiedTypeName = this.buildQualifiedTypeName(astRoot);
        this.qualifiedReferenceEntityTypeName = this.buildQualifiedReferenceEntityTypeName(astRoot);
        this.qualifiedReferenceEntityElementTypeName = this.buildQualifiedReferenceEntityElementTypeName(astRoot);
        this.typeIsSerializable = this.buildTypeIsSerializable(astRoot);
        this.typeIsDateOrCalendar = this.buildTypeIsDateOrCalendar(astRoot);
        this.typeIsContainer = this.buildTypeIsContainer(astRoot);
        this.final_ = this.buildFinal(astRoot);
        this.public_ = this.buildPublic(astRoot);
    }

    @Override
    public String getName() {
        return ((Attribute)this.getMember()).getAttributeName();
    }

    @Override
    protected Annotation buildMappingAnnotation(String mappingAnnotationName) {
        return this.getAnnotationProvider().buildAttributeMappingAnnotation(this, (Attribute)this.getMember(), mappingAnnotationName);
    }

    @Override
    protected Annotation buildSupportingAnnotation(String annotationName) {
        return this.getAnnotationProvider().buildAttributeSupportingAnnotation(this, (Attribute)this.getMember(), annotationName);
    }

    @Override
    protected Annotation buildNullSupportingAnnotation(String annotationName) {
        return this.getAnnotationProvider().buildNullAttributeSupportingAnnotation(this, (Attribute)this.getMember(), annotationName);
    }

    @Override
    protected Annotation buildNullMappingAnnotation(String annotationName) {
        return this.getAnnotationProvider().buildNullAttributeMappingAnnotation(this, (Attribute)this.getMember(), annotationName);
    }

    @Override
    protected ListIterator<String> validMappingAnnotationNames() {
        return this.getAnnotationProvider().attributeMappingAnnotationNames();
    }

    @Override
    protected ListIterator<String> validSupportingAnnotationNames() {
        return this.getAnnotationProvider().attributeSupportingAnnotationNames();
    }

    @Override
    public boolean isFor(MethodSignature signature, int occurrence) {
        return ((MethodAttribute)this.getMember()).matches(signature, occurrence);
    }

    @Override
    public boolean isForField() {
        return ((Attribute)this.getMember()).isField();
    }

    @Override
    public boolean isForProperty() {
        return !this.isForField();
    }

    @Override
    public boolean hasAnyAnnotations() {
        if (this.mappingAnnotationsSize() > 0) {
            return true;
        }
        return this.supportingAnnotationsSize() > 0;
    }

    @Override
    public boolean isPublic() {
        return this.public_;
    }

    protected void setPublic(boolean public_) {
        boolean old = this.public_;
        this.public_ = public_;
        this.firePropertyChanged("public", old, public_);
    }

    @Override
    public boolean isFinal() {
        return this.final_;
    }

    protected void setFinal(boolean final_) {
        boolean old = this.final_;
        this.final_ = final_;
        this.firePropertyChanged("final", old, final_);
    }

    @Override
    public boolean typeIsBasic() {
        return this.typeIsBasic;
    }

    protected void setTypeIsBasic(boolean typeIsBasic) {
        boolean old = this.typeIsBasic;
        this.typeIsBasic = typeIsBasic;
        this.firePropertyChanged("typeIsBasic", old, typeIsBasic);
    }

    @Override
    public String getQualifiedTypeName() {
        return this.qualifiedTypeName;
    }

    protected void setQualifiedTypeName(String qualifiedTypeName) {
        String old = this.qualifiedTypeName;
        this.qualifiedTypeName = qualifiedTypeName;
        this.firePropertyChanged("qualifiedTypeName", old, qualifiedTypeName);
    }

    @Override
    public String getQualifiedReferenceEntityTypeName() {
        return this.qualifiedReferenceEntityTypeName;
    }

    protected void setQualifiedReferenceEntityTypeName(String qualifiedReferenceEntityTypeName) {
        String old = this.qualifiedReferenceEntityTypeName;
        this.qualifiedReferenceEntityTypeName = qualifiedReferenceEntityTypeName;
        this.firePropertyChanged("qualifiedReferenceEntityTypeName", old, qualifiedReferenceEntityTypeName);
    }

    @Override
    public String getQualifiedReferenceEntityElementTypeName() {
        return this.qualifiedReferenceEntityElementTypeName;
    }

    protected void setQualifiedReferenceEntityElementTypeName(String qualifiedReferenceEntityElementTypeName) {
        String old = this.qualifiedReferenceEntityElementTypeName;
        this.qualifiedReferenceEntityElementTypeName = qualifiedReferenceEntityElementTypeName;
        this.firePropertyChanged("qualifiedReferenceEntityElementTypeName", old, qualifiedReferenceEntityElementTypeName);
    }

    @Override
    public boolean typeIsSerializable() {
        return this.typeIsSerializable;
    }

    protected void setTypeIsSerializable(boolean typeIsSerializable) {
        boolean old = this.typeIsSerializable;
        this.typeIsSerializable = typeIsSerializable;
        this.firePropertyChanged("typeIsSerializable", old, typeIsSerializable);
    }

    @Override
    public boolean typeIsDateOrCalendar() {
        return this.typeIsDateOrCalendar;
    }

    protected void setTypeIsDateOrCalendar(boolean typeIsDateOrCalendar) {
        boolean old = this.typeIsDateOrCalendar;
        this.typeIsDateOrCalendar = typeIsDateOrCalendar;
        this.firePropertyChanged("typeIsDateOrCalendar", old, typeIsDateOrCalendar);
    }

    @Override
    public boolean typeIsContainer() {
        return this.typeIsContainer;
    }

    protected void setTypeIsContainer(boolean typeIsContainer) {
        boolean old = this.typeIsContainer;
        this.typeIsContainer = typeIsContainer;
        this.firePropertyChanged("typeIsContainer", old, typeIsContainer);
    }

    @Override
    public void update(CompilationUnit astRoot) {
        super.update(astRoot);
        this.setTypeIsBasic(this.buildTypeIsBasic(astRoot));
        this.setQualifiedTypeName(this.buildQualifiedTypeName(astRoot));
        this.setQualifiedReferenceEntityTypeName(this.buildQualifiedReferenceEntityTypeName(astRoot));
        this.setQualifiedReferenceEntityElementTypeName(this.buildQualifiedReferenceEntityElementTypeName(astRoot));
        this.setTypeIsSerializable(this.buildTypeIsSerializable(astRoot));
        this.setTypeIsDateOrCalendar(this.buildTypeIsDateOrCalendar(astRoot));
        this.setTypeIsContainer(this.buildTypeIsContainer(astRoot));
        this.setFinal(this.buildFinal(astRoot));
        this.setPublic(this.buildPublic(astRoot));
    }

    @Override
    public void resolveTypes(CompilationUnit astRoot) {
        super.resolveTypes(astRoot);
        this.setTypeIsBasic(this.buildTypeIsBasic(astRoot));
        this.setQualifiedTypeName(this.buildQualifiedTypeName(astRoot));
        this.setQualifiedReferenceEntityTypeName(this.buildQualifiedReferenceEntityTypeName(astRoot));
        this.setQualifiedReferenceEntityElementTypeName(this.buildQualifiedReferenceEntityElementTypeName(astRoot));
        this.setTypeIsSerializable(this.buildTypeIsSerializable(astRoot));
        this.setTypeIsDateOrCalendar(this.buildTypeIsDateOrCalendar(astRoot));
        this.setTypeIsContainer(this.buildTypeIsContainer(astRoot));
    }

    protected boolean buildTypeIsBasic(CompilationUnit astRoot) {
        return JavaResourcePersistentAttributeImpl.typeIsBasic(((Attribute)this.getMember()).getTypeBinding(astRoot), astRoot.getAST());
    }

    protected boolean buildFinal(CompilationUnit astRoot) {
        IBinding binding = ((Attribute)this.getMember()).getBinding(astRoot);
        return binding == null ? false : Modifier.isFinal((int)binding.getModifiers());
    }

    protected boolean buildPublic(CompilationUnit astRoot) {
        IBinding binding = ((Attribute)this.getMember()).getBinding(astRoot);
        return binding == null ? false : Modifier.isPublic((int)binding.getModifiers());
    }

    protected String buildQualifiedReferenceEntityTypeName(CompilationUnit astRoot) {
        ITypeBinding typeBinding = ((Attribute)this.getMember()).getTypeBinding(astRoot);
        return typeBinding == null ? null : JavaResourcePersistentAttributeImpl.buildReferenceEntityTypeName(typeBinding);
    }

    public static String buildReferenceEntityTypeName(ITypeBinding typeBinding) {
        if (typeBinding == null) {
            return null;
        }
        if (typeBinding.isArray()) {
            return null;
        }
        return typeBinding.getTypeDeclaration().getQualifiedName();
    }

    protected String buildQualifiedReferenceEntityElementTypeName(CompilationUnit astRoot) {
        ITypeBinding elementTypeBinding;
        ITypeBinding typeBinding = ((Attribute)this.getMember()).getTypeBinding(astRoot);
        if (typeBinding == null) {
            return null;
        }
        ITypeBinding[] typeArguments = typeBinding.getTypeArguments();
        if (typeArguments.length == 1) {
            elementTypeBinding = typeArguments[0];
        } else if (typeArguments.length == 2 && JavaResourcePersistentAttributeImpl.typeNamedIsMap(this.buildQualifiedTypeName(astRoot))) {
            elementTypeBinding = typeArguments[1];
        } else {
            return null;
        }
        String elementTypeName = JavaResourcePersistentAttributeImpl.buildReferenceEntityTypeName(elementTypeBinding);
        return JavaResourcePersistentAttributeImpl.typeNamedIsContainer(elementTypeName) ? null : elementTypeName;
    }

    protected boolean buildTypeIsSerializable(CompilationUnit astRoot) {
        return JavaResourcePersistentAttributeImpl.typeImplementsSerializable(((Attribute)this.getMember()).getTypeBinding(astRoot), astRoot.getAST());
    }

    protected boolean buildTypeIsDateOrCalendar(CompilationUnit astRoot) {
        return JavaResourcePersistentAttributeImpl.typeImplementsDateOrCalendar(((Attribute)this.getMember()).getTypeBinding(astRoot));
    }

    protected boolean buildTypeIsContainer(CompilationUnit astRoot) {
        String typeName = JavaResourcePersistentAttributeImpl.buildReferenceEntityTypeName(((Attribute)this.getMember()).getTypeBinding(astRoot));
        return typeName == null ? false : JavaResourcePersistentAttributeImpl.typeNamedIsContainer(typeName);
    }

    public static boolean typeNamedIsMap(String typeName) {
        return MAP_TYPE_NAME.equals(typeName);
    }

    public static boolean typeNamedIsContainer(String typeName) {
        return CollectionTools.contains((Object[])CONTAINER_TYPE_NAMES, (Object)typeName);
    }

    protected String buildQualifiedTypeName(CompilationUnit astRoot) {
        ITypeBinding typeBinding = ((Attribute)this.getMember()).getTypeBinding(astRoot);
        return typeBinding == null ? null : typeBinding.getTypeDeclaration().getQualifiedName();
    }

    public static boolean typeIsBasic(ITypeBinding typeBinding, AST ast) {
        if (typeBinding == null) {
            return false;
        }
        if (typeBinding.isPrimitive()) {
            return true;
        }
        if (typeBinding.isArray()) {
            if (typeBinding.getDimensions() > 1) {
                return false;
            }
            ITypeBinding elementTypeBinding = typeBinding.getElementType();
            if (elementTypeBinding == null) {
                return false;
            }
            return JavaResourcePersistentAttributeImpl.elementTypeIsValid(elementTypeBinding.getQualifiedName());
        }
        String typeName = typeBinding.getQualifiedName();
        if (JavaResourcePersistentAttributeImpl.typeIsPrimitiveWrapper(typeName)) {
            return true;
        }
        if (JavaResourcePersistentAttributeImpl.typeIsOtherSupportedType(typeName)) {
            return true;
        }
        if (typeBinding.isEnum()) {
            return true;
        }
        return JavaResourcePersistentAttributeImpl.typeImplementsSerializable(typeBinding, ast);
    }

    private static boolean elementTypeIsValid(String elementTypeName) {
        return CollectionTools.contains((Object[])VALID_ELEMENT_TYPE_NAMES, (Object)elementTypeName);
    }

    private static boolean typeIsPrimitiveWrapper(String typeName) {
        return CollectionTools.contains((Object[])PRIMITIVE_WRAPPER_TYPE_NAMES, (Object)typeName);
    }

    private static boolean typeIsOtherSupportedType(String typeName) {
        return CollectionTools.contains((Object[])OTHER_SUPPORTED_TYPE_NAMES, (Object)typeName);
    }

    private static boolean typeImplementsSerializable(ITypeBinding typeBinding, AST ast) {
        if (typeBinding == null) {
            return false;
        }
        ITypeBinding serializableTypeBinding = ast.resolveWellKnownType(SERIALIZABLE_TYPE_NAME);
        return typeBinding.isAssignmentCompatible(serializableTypeBinding);
    }

    private static boolean typeImplementsDateOrCalendar(ITypeBinding typeBinding) {
        return JavaResourcePersistentAttributeImpl.typeImplementsDate(typeBinding) || JavaResourcePersistentAttributeImpl.typeImplementsCalendar(typeBinding);
    }

    private static boolean typeImplementsDate(ITypeBinding typeBinding) {
        if (typeBinding == null) {
            return false;
        }
        return JDTTools.findTypeInHierarchy(typeBinding, DATE_TYPE_NAME) != null;
    }

    private static boolean typeImplementsCalendar(ITypeBinding typeBinding) {
        if (typeBinding == null) {
            return false;
        }
        return JDTTools.findTypeInHierarchy(typeBinding, CALENDAR_TYPE_NAME) != null;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }
}

