/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.resource;

import java.io.IOException;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jem.util.emf.workbench.FlexibleProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.resource.JpaResourceModelProvider;
import org.eclipse.jpt.core.resource.JpaResourceModelProviderEvent;
import org.eclipse.jpt.core.resource.JpaResourceModelProviderListener;
import org.eclipse.jpt.core.resource.common.JpaXmlResource;
import org.eclipse.jpt.utility.internal.ListenerList;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.internal.impl.WTPResourceFactoryRegistry;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateInputProvider;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidator;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidatorImpl;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidatorPresenter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResourceModelProvider<R extends JpaXmlResource>
implements JpaResourceModelProvider,
ResourceStateInputProvider,
ResourceStateValidator {
    protected IProject project;
    protected URI fileUri;
    protected R resource;
    protected final ResourceAdapter resourceAdapter = new ResourceAdapter();
    protected final ListenerList<JpaResourceModelProviderListener> listenerList = new ListenerList(JpaResourceModelProviderListener.class);
    protected ResourceStateValidator stateValidator;

    public AbstractResourceModelProvider(IProject project, IPath resourcePath) {
        this.project = project;
        this.fileUri = this.buildFileUri(resourcePath);
    }

    protected URI buildFileUri(IPath resourcePath) {
        URI resourceUri = null;
        resourceUri = resourcePath.isAbsolute() ? URI.createPlatformResourceURI((String)resourcePath.toString(), (boolean)false) : this.getModuleURI(URI.createURI((String)resourcePath.toString()));
        URIConverter uriConverter = this.getResourceSet().getURIConverter();
        return uriConverter.normalize(resourceUri);
    }

    public R getResource() {
        if (this.resource == null) {
            try {
                this.resource = this.ensureCorrectType(WorkbenchResourceHelper.getOrCreateResource((URI)this.fileUri, (ResourceSet)this.getResourceSet()));
            }
            catch (ClassCastException classCastException) {
                Resource.Factory resourceFactory = WTPResourceFactoryRegistry.INSTANCE.getFactory(this.fileUri, this.getContentType(this.getContentTypeDescriber()));
                this.resource = (JpaXmlResource)((FlexibleProjectResourceSet)this.getResourceSet()).createResource(this.fileUri, resourceFactory);
            }
        }
        return this.resource;
    }

    protected abstract R ensureCorrectType(Resource var1) throws ClassCastException;

    public R createResource() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                Object aResource = AbstractResourceModelProvider.this.getResource();
                if (!((JpaXmlResource)((Object)aResource)).exists() && ((JpaXmlResource)((Object)aResource)).getContents().isEmpty()) {
                    AbstractResourceModelProvider.this.populateRoot((JpaXmlResource)((Object)aResource));
                    try {
                        aResource.saveIfNecessary();
                    }
                    catch (Exception e) {
                        JptCorePlugin.log(e);
                    }
                }
            }
        };
        workspace.run(runnable, (ISchedulingRule)workspace.getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
        return this.resource;
    }

    protected URI getModuleURI(URI uri) {
        URI moduleuri = ModuleURIUtil.fullyQualifyURI((IProject)this.project);
        IPath requestPath = new Path(moduleuri.path()).append((IPath)new Path(uri.path()));
        URI resourceURI = URI.createURI((String)("module:" + requestPath.toString()));
        return resourceURI;
    }

    protected IContentDescription getContentType(String contentTypeDescriber) {
        if (contentTypeDescriber != null) {
            return Platform.getContentTypeManager().getContentType(contentTypeDescriber).getDefaultDescription();
        }
        return null;
    }

    protected String getContentTypeDescriber() {
        return null;
    }

    protected void populateRoot(JpaXmlResource resource) {
    }

    protected EList<EObject> getResourceContents(JpaXmlResource resource) {
        return resource.getContents();
    }

    public void addListener(JpaResourceModelProviderListener listener) {
        if (this.listenerList.isEmpty()) {
            this.engageResource();
        }
        this.listenerList.add((EventListener)listener);
    }

    public void removeListener(JpaResourceModelProviderListener listener) {
        this.listenerList.remove((EventListener)listener);
        if (this.listenerList.isEmpty()) {
            this.disengageResource();
        }
    }

    private void engageResource() {
        if (this.resource != null) {
            ((JpaXmlResource)((Object)this.resource)).eAdapters().add((Object)this.resourceAdapter);
        }
    }

    private void disengageResource() {
        if (this.resource != null) {
            ((JpaXmlResource)((Object)this.resource)).eAdapters().remove((Object)this.resourceAdapter);
        }
    }

    protected ProjectResourceSet getResourceSet() {
        return (ProjectResourceSet)WorkbenchResourceHelperBase.getResourceSet((IProject)this.project);
    }

    public IProject getProject() {
        return this.project;
    }

    protected void resourceIsLoadedChanged(Resource aResource, boolean oldValue, boolean newValue) {
        if (!this.listenerList.isEmpty()) {
            int eventType = newValue ? 1 : 2;
            JpaResourceModelProviderEvent evt = new JpaResourceModelProviderEvent(this, eventType);
            this.notifyListeners(evt);
        }
    }

    protected void notifyListeners(JpaResourceModelProviderEvent event) {
        NotifyRunner notifier = new NotifyRunner(event);
        JpaResourceModelProviderListener[] jpaResourceModelProviderListenerArray = (JpaResourceModelProviderListener[])this.listenerList.getListeners();
        int n = jpaResourceModelProviderListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            JpaResourceModelProviderListener listener = jpaResourceModelProviderListenerArray[n2];
            notifier.setListener(listener);
            SafeRunner.run((ISafeRunnable)notifier);
            ++n2;
        }
    }

    @Override
    public IStatus validateEdit(Object context) {
        IWorkspace work = ResourcesPlugin.getWorkspace();
        IFile file = WorkbenchResourceHelper.getFile(this.resource);
        if (file != null) {
            IFile[] files = new IFile[]{file};
            if (context == null) {
                context = IWorkspace.VALIDATE_PROMPT;
            }
            return work.validateEdit(files, context);
        }
        return Status.OK_STATUS;
    }

    @Override
    public void modify(Runnable runnable) {
        try {
            runnable.run();
            try {
                if (this.resource != null) {
                    this.resource.save(Collections.EMPTY_MAP);
                }
            }
            catch (IOException ioe) {
                JptCorePlugin.log(ioe);
            }
        }
        catch (Exception e) {
            JptCorePlugin.log(e);
        }
    }

    public ResourceStateValidator getStateValidator() {
        if (this.stateValidator == null) {
            this.stateValidator = this.createStateValidator();
        }
        return this.stateValidator;
    }

    private ResourceStateValidator createStateValidator() {
        return new ResourceStateValidatorImpl((ResourceStateInputProvider)this);
    }

    public void checkActivation(ResourceStateValidatorPresenter presenter) throws CoreException {
        this.getStateValidator().checkActivation(presenter);
    }

    public void lostActivation(ResourceStateValidatorPresenter presenter) throws CoreException {
        this.getStateValidator().lostActivation(presenter);
    }

    public IStatus validateState(ResourceStateValidatorPresenter presenter) throws CoreException {
        if (presenter == null) {
            return Status.OK_STATUS;
        }
        return this.getStateValidator().validateState(presenter);
    }

    public boolean checkSave(ResourceStateValidatorPresenter presenter) throws CoreException {
        return this.getStateValidator().checkSave(presenter);
    }

    public boolean checkReadOnly() {
        return this.getStateValidator().checkReadOnly();
    }

    public boolean isDirty() {
        return this.resource.isModified();
    }

    public List getNonResourceFiles() {
        return Collections.emptyList();
    }

    public List getNonResourceInconsistentFiles() {
        return Collections.emptyList();
    }

    public List getResources() {
        return Collections.singletonList(this.getResource());
    }

    public void cacheNonResourceValidateState(List roNonResourceFiles) {
    }

    public class NotifyRunner
    implements ISafeRunnable {
        private final JpaResourceModelProviderEvent event;
        private JpaResourceModelProviderListener listener;

        public NotifyRunner(JpaResourceModelProviderEvent event) {
            Assert.isNotNull((Object)event);
            this.event = event;
        }

        public void setListener(JpaResourceModelProviderListener listener) {
            this.listener = listener;
        }

        public void run() throws Exception {
            if (this.listener != null) {
                this.listener.modelChanged(this.event);
            }
        }

        public void handleException(Throwable exception) {
            JptCorePlugin.log(exception);
        }
    }

    protected class ResourceAdapter
    extends AdapterImpl {
        protected ResourceAdapter() {
        }

        public void notifyChanged(Notification notification) {
            if (notification.getEventType() == 1 && notification.getFeatureID(null) == 4) {
                AbstractResourceModelProvider.this.resourceIsLoadedChanged((Resource)notification.getNotifier(), notification.getOldBooleanValue(), notification.getNewBooleanValue());
            }
        }
    }
}

