/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.utility;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jpt.core.JptCorePlugin;

public class PlatformUtilities {
    public static IContentType getContentType(IFile file) {
        InputStream inputStream = null;
        try {
            inputStream = file.getContents();
        }
        catch (CoreException ex) {
            JptCorePlugin.log(ex);
            return null;
        }
        IContentType contentType = null;
        try {
            try {
                contentType = Platform.getContentTypeManager().findContentTypeFor(inputStream, file.getName());
            }
            catch (IOException ex) {
                JptCorePlugin.log(ex);
                try {
                    inputStream.close();
                }
                catch (IOException ex2) {
                    JptCorePlugin.log(ex2);
                }
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException ex) {
                JptCorePlugin.log(ex);
            }
        }
        return contentType;
    }

    private PlatformUtilities() {
        throw new UnsupportedOperationException();
    }
}

