/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.gen.internal;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.text.Collator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.db.Column;
import org.eclipse.jpt.db.ForeignKey;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.gen.internal.GenTable;
import org.eclipse.jpt.gen.internal.JptGenMessages;
import org.eclipse.jpt.gen.internal.ManyToManyRelation;
import org.eclipse.jpt.gen.internal.ManyToOneRelation;
import org.eclipse.jpt.gen.internal.OneToManyRelation;
import org.eclipse.jpt.utility.JavaType;
import org.eclipse.jpt.utility.internal.BooleanHolder;
import org.eclipse.jpt.utility.internal.IndentingPrintWriter;
import org.eclipse.jpt.utility.internal.NameTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityGenerator {
    final Config config;
    private final IPackageFragment packageFragment;
    private final GenTable genTable;
    private final String entityClassName;
    private final String pkClassName;

    static void generateEntity(Config config, IPackageFragment packageFragment, GenTable genTable, IProgressMonitor progressMonitor) {
        if (config == null || packageFragment == null || genTable == null) {
            throw new NullPointerException();
        }
        new EntityGenerator(config, packageFragment, genTable).generateEntity(progressMonitor);
    }

    private EntityGenerator(Config config, IPackageFragment packageFragment, GenTable genTable) {
        this.config = config;
        this.packageFragment = packageFragment;
        this.genTable = genTable;
        this.entityClassName = this.fullyQualify(this.getEntityName());
        this.pkClassName = String.valueOf(this.entityClassName) + '.' + config.getPrimaryKeyMemberClassName();
    }

    private void generateEntity(IProgressMonitor progressMonitor) {
        try {
            this.generateEntity_(progressMonitor);
        }
        catch (JavaModelException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void generateEntity_(IProgressMonitor progressMonitor) throws JavaModelException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)this.buildTaskName(), (int)100);
        String fileName = String.valueOf(this.getEntityName()) + ".java";
        String source = this.buildSource();
        sm.worked(20);
        try {
            this.packageFragment.createCompilationUnit(fileName, source, false, (IProgressMonitor)sm.newChild(40));
        }
        catch (JavaModelException ex) {
            if (ex.getJavaModelStatus().getCode() == 977) {
                if (this.config.getOverwriteConfirmer().overwrite(this.entityClassName)) {
                    this.packageFragment.createCompilationUnit(fileName, source, true, (IProgressMonitor)sm.newChild(40));
                }
            }
            throw ex;
        }
        sm.setWorkRemaining(0);
    }

    private String buildTaskName() {
        return NLS.bind((String)JptGenMessages.EntityGenerator_taskName, (Object)this.getEntityName());
    }

    private String buildSource() {
        BodySource bodySource = this.buildBodySource();
        StringWriter sw = new StringWriter(bodySource.length() + 2000);
        PrintWriter pw = new PrintWriter(sw);
        this.printPackageAndImportsOn(pw, bodySource);
        pw.print(bodySource.getSource());
        return sw.toString();
    }

    private BodySource buildBodySource() {
        EntitySourceWriter pw = new EntitySourceWriter(this.getPackageName(), this.entityClassName);
        this.printBodySourceOn(pw);
        return pw;
    }

    private void printBodySourceOn(EntitySourceWriter pw) {
        this.printClassDeclarationOn(pw);
        pw.indent();
        this.printEntityPrimaryKeyFieldsOn(pw);
        this.printEntityNonPrimaryKeyBasicFieldsOn(pw);
        this.printEntityManyToOneFieldsOn(pw);
        this.printEntityOneToManyFieldsOn(pw);
        this.printEntityOwnedManyToManyFieldsOn(pw);
        this.printEntityNonOwnedManyToManyFieldsOn(pw);
        this.printSerialVersionUIDFieldOn(pw);
        pw.println();
        this.printZeroArgumentConstructorOn(this.getEntityName(), this.config.getMethodVisibilityClause(), pw);
        if (this.config.propertyAccessType() || this.config.generateGettersAndSetters()) {
            this.printEntityPrimaryKeyPropertiesOn(pw);
            this.printEntityNonPrimaryKeyBasicPropertiesOn(pw);
            this.printEntityManyToOnePropertiesOn(pw);
            this.printEntityOneToManyPropertiesOn(pw);
            this.printEntityOwnedManyToManyPropertiesOn(pw);
            this.printEntityNonOwnedManyToManyPropertiesOn(pw);
        }
        if (this.primaryKeyClassIsRequired()) {
            this.printPrimaryKeyClassOn(pw);
        }
        pw.undent();
        pw.print('}');
        pw.println();
    }

    private void printClassDeclarationOn(EntitySourceWriter pw) {
        this.printEntityAnnotationOn(pw);
        this.printTableAnnotationOn(pw);
        this.printIdClassAnnotationOn(pw);
        pw.print("public class ");
        pw.printTypeDeclaration(this.entityClassName);
        if (this.config.serializable()) {
            pw.print(" implements ");
            pw.printTypeDeclaration(Serializable.class.getName());
        }
        pw.print(" {");
        pw.println();
    }

    private void printEntityAnnotationOn(EntitySourceWriter pw) {
        pw.printAnnotation("javax.persistence.Entity");
        pw.println();
    }

    private void printTableAnnotationOn(EntitySourceWriter pw) {
        String tableName = this.config.getDatabaseAnnotationNameBuilder().buildTableAnnotationName(this.getEntityName(), this.getTable());
        if (tableName == null) {
            return;
        }
        pw.printAnnotation("javax.persistence.Table");
        pw.print("(name=");
        pw.printStringLiteral(tableName);
        pw.print(')');
        pw.println();
    }

    private void printIdClassAnnotationOn(EntitySourceWriter pw) {
        if (this.primaryKeyClassIsRequired() && this.config.generateIdClassForCompoundPK()) {
            pw.printAnnotation("javax.persistence.IdClass");
            pw.print('(');
            pw.printTypeDeclaration(this.pkClassName);
            pw.print(".class)");
            pw.println();
        }
    }

    private void printEntityPrimaryKeyFieldsOn(EntitySourceWriter pw) {
        if (this.primaryKeyClassIsRequired() && this.config.generateEmbeddedIdForCompoundPK()) {
            this.printEntityEmbeddedIdPrimaryKeyFieldOn(pw);
        } else {
            this.printEntityReadOnlyPrimaryKeyFieldsOn(pw);
            this.printEntityWritablePrimaryKeyFieldsOn(pw);
        }
    }

    private void printEntityEmbeddedIdPrimaryKeyFieldOn(EntitySourceWriter pw) {
        if (this.config.fieldAccessType()) {
            pw.printAnnotation("javax.persistence.EmbeddedId");
            pw.println();
        }
        this.printFieldOn(this.genTable.getAttributeNameForEmbeddedId(), this.pkClassName, pw);
    }

    private void printEntityReadOnlyPrimaryKeyFieldsOn(EntitySourceWriter pw) {
        this.printPrimaryKeyFieldsOn(pw, true, true);
    }

    private void printEntityWritablePrimaryKeyFieldsOn(EntitySourceWriter pw) {
        this.printPrimaryKeyFieldsOn(pw, false, true);
    }

    private void printPrimaryKeyFieldsOn(EntitySourceWriter pw, boolean readOnly, boolean printIdAnnotation) {
        Iterator<Column> stream = this.primaryKeyColumns(readOnly);
        while (stream.hasNext()) {
            this.printPrimaryKeyFieldOn(stream.next(), pw, readOnly, printIdAnnotation);
        }
    }

    private Iterator<Column> primaryKeyColumns(boolean readOnly) {
        return readOnly ? this.genTable.readOnlyPrimaryKeyColumns() : this.genTable.writablePrimaryKeyColumns();
    }

    private void printPrimaryKeyFieldOn(Column column, EntitySourceWriter pw, boolean readOnly, boolean printIdAnnotation) {
        String fieldName = this.genTable.getAttributeNameFor(column);
        if (this.config.fieldAccessType()) {
            if (printIdAnnotation) {
                pw.printAnnotation("javax.persistence.Id");
                pw.println();
            }
            String columnName = this.config.getDatabaseAnnotationNameBuilder().buildColumnAnnotationName(fieldName, column);
            if (readOnly) {
                this.printReadOnlyColumnAnnotationOn(columnName, pw);
            } else {
                this.printColumnAnnotationOn(columnName, pw);
            }
        }
        this.printFieldOn(fieldName, column.getPrimaryKeyJavaTypeDeclaration(), pw);
    }

    private void printReadOnlyColumnAnnotationOn(String columnName, EntitySourceWriter pw) {
        pw.printAnnotation("javax.persistence.Column");
        pw.print('(');
        if (columnName != null) {
            pw.print("name=");
            pw.printStringLiteral(columnName);
            pw.print(", ");
        }
        pw.print("insertable=false, updatable=false)");
        pw.println();
    }

    private void printEntityNonPrimaryKeyBasicFieldsOn(EntitySourceWriter pw) {
        Iterator<Column> stream = this.genTable.nonPrimaryKeyBasicColumns();
        while (stream.hasNext()) {
            this.printEntityNonPrimaryKeyBasicFieldOn(stream.next(), pw);
        }
    }

    private void printEntityNonPrimaryKeyBasicFieldOn(Column column, EntitySourceWriter pw) {
        String fieldName = this.genTable.getAttributeNameFor(column);
        if (this.config.fieldAccessType()) {
            String columnName = this.config.getDatabaseAnnotationNameBuilder().buildColumnAnnotationName(fieldName, column);
            this.printColumnAnnotationOn(columnName, pw);
        }
        if (column.isLOB()) {
            pw.printAnnotation("javax.persistence.Lob");
            pw.println();
        }
        this.printFieldOn(fieldName, column.getJavaTypeDeclaration(), pw);
    }

    private void printColumnAnnotationOn(String columnName, EntitySourceWriter pw) {
        if (columnName != null) {
            pw.printAnnotation("javax.persistence.Column");
            pw.print("(name=");
            pw.printStringLiteral(columnName);
            pw.print(')');
            pw.println();
        }
    }

    private void printEntityManyToOneFieldsOn(EntitySourceWriter pw) {
        Iterator<ManyToOneRelation> stream = this.genTable.manyToOneRelations();
        while (stream.hasNext()) {
            this.printEntityManyToOneFieldOn(stream.next(), pw);
        }
    }

    private void printEntityManyToOneFieldOn(ManyToOneRelation relation, EntitySourceWriter pw) {
        String fieldName = this.genTable.getAttributeNameFor(relation);
        if (this.config.fieldAccessType()) {
            this.printManyToOneAnnotationOn(fieldName, relation, pw);
        }
        this.printFieldOn(fieldName, this.fullyQualify(relation.getReferencedEntityName()), pw);
    }

    private void printManyToOneAnnotationOn(String attributeName, ManyToOneRelation relation, EntitySourceWriter pw) {
        pw.printAnnotation("javax.persistence.ManyToOne");
        pw.println();
        ForeignKey foreignKey = relation.getForeignKey();
        if (foreignKey.referencesSingleColumnPrimaryKey()) {
            String joinColumnName = this.config.getDatabaseAnnotationNameBuilder().buildJoinColumnAnnotationName(attributeName, foreignKey);
            if (joinColumnName != null) {
                this.printJoinColumnAnnotationOn(joinColumnName, null, pw);
                pw.println();
            }
        } else {
            this.printManyToOneJoinColumnsAnnotationOn(foreignKey, pw);
        }
    }

    private void printManyToOneJoinColumnsAnnotationOn(ForeignKey foreignKey, EntitySourceWriter pw) {
        if (foreignKey.columnPairsSize() > 1) {
            pw.printAnnotation("javax.persistence.JoinColumns");
            pw.print("({");
            pw.println();
            pw.indent();
        }
        this.printJoinColumnAnnotationsOn(foreignKey, pw);
        if (foreignKey.columnPairsSize() > 1) {
            pw.undent();
            pw.println();
            pw.print("})");
        }
        pw.println();
    }

    private void printJoinColumnAnnotationsOn(ForeignKey foreignKey, EntitySourceWriter pw) {
        Iterator stream = foreignKey.columnPairs();
        while (stream.hasNext()) {
            this.printJoinColumnAnnotationOn((ForeignKey.ColumnPair)stream.next(), pw);
            if (!stream.hasNext()) continue;
            pw.println(',');
        }
    }

    private void printJoinColumnAnnotationOn(ForeignKey.ColumnPair columnPair, EntitySourceWriter pw) {
        this.printJoinColumnAnnotationOn(this.config.getDatabaseAnnotationNameBuilder().buildJoinColumnAnnotationName(columnPair.getBaseColumn()), this.config.getDatabaseAnnotationNameBuilder().buildJoinColumnAnnotationName(columnPair.getReferencedColumn()), pw);
    }

    private void printJoinColumnAnnotationOn(String baseColumnName, String referencedColumnName, EntitySourceWriter pw) {
        pw.printAnnotation("javax.persistence.JoinColumn");
        pw.print("(name=");
        pw.printStringLiteral(baseColumnName);
        if (referencedColumnName != null) {
            pw.print(", referencedColumnName=");
            pw.printStringLiteral(referencedColumnName);
        }
        pw.print(')');
    }

    private void printEntityOneToManyFieldsOn(EntitySourceWriter pw) {
        Iterator<OneToManyRelation> stream = this.genTable.oneToManyRelations();
        while (stream.hasNext()) {
            this.printEntityOneToManyFieldOn(stream.next(), pw);
        }
    }

    private void printEntityOneToManyFieldOn(OneToManyRelation relation, EntitySourceWriter pw) {
        String fieldName = this.genTable.getAttributeNameFor(relation);
        if (this.config.fieldAccessType()) {
            this.printOneToManyAnnotationOn(relation, pw);
        }
        this.printCollectionFieldOn(fieldName, this.fullyQualify(relation.getReferencedEntityName()), pw);
    }

    private void printOneToManyAnnotationOn(OneToManyRelation relation, EntitySourceWriter pw) {
        pw.printAnnotation("javax.persistence.OneToMany");
        pw.print("(mappedBy=\"");
        pw.print(relation.getMappedBy());
        pw.print("\")");
        pw.println();
    }

    private void printEntityOwnedManyToManyFieldsOn(EntitySourceWriter pw) {
        Iterator<ManyToManyRelation> stream = this.genTable.ownedManyToManyRelations();
        while (stream.hasNext()) {
            this.printEntityOwnedManyToManyFieldOn(stream.next(), pw);
        }
    }

    private void printEntityOwnedManyToManyFieldOn(ManyToManyRelation relation, EntitySourceWriter pw) {
        String fieldName = this.genTable.getAttributeNameFor(relation);
        if (this.config.fieldAccessType()) {
            this.printOwnedManyToManyAnnotationOn(fieldName, relation, pw);
        }
        this.printCollectionFieldOn(fieldName, this.fullyQualify(relation.getNonOwningEntityName()), pw);
    }

    private void printOwnedManyToManyAnnotationOn(String attributeName, ManyToManyRelation relation, EntitySourceWriter pw) {
        pw.printAnnotation("javax.persistence.ManyToMany");
        pw.println();
        BooleanHolder printJoinTableAnnotation = new BooleanHolder(true);
        if (!relation.joinTableNameIsDefault()) {
            printJoinTableAnnotation.setFalse();
            pw.printAnnotation("javax.persistence.JoinTable");
            pw.print("(name=");
            pw.printStringLiteral(this.config.getDatabaseAnnotationNameBuilder().buildJoinTableAnnotationName(relation.getJoinGenTable().getTable()));
        }
        this.printJoinTableJoinColumnAnnotationsOn("joinColumns", attributeName, relation.getOwningForeignKey(), printJoinTableAnnotation, pw);
        this.printJoinTableJoinColumnAnnotationsOn("inverseJoinColumns", relation.getNonOwningGenTable().getAttributeNameFor(relation), relation.getNonOwningForeignKey(), printJoinTableAnnotation, pw);
        if (printJoinTableAnnotation.isFalse()) {
            pw.print(')');
            pw.println();
        }
    }

    private void printJoinTableJoinColumnAnnotationsOn(String elementName, String attributeName, ForeignKey foreignKey, BooleanHolder printJoinTableAnnotation, EntitySourceWriter pw) {
        boolean printBase;
        boolean printRef = !foreignKey.referencesSingleColumnPrimaryKey();
        String joinColumnName = printRef ? null : this.config.getDatabaseAnnotationNameBuilder().buildJoinColumnAnnotationName(attributeName, foreignKey);
        boolean bl = printBase = printRef || joinColumnName != null;
        if (printBase || printRef) {
            if (printJoinTableAnnotation.isTrue()) {
                printJoinTableAnnotation.setFalse();
                pw.printAnnotation("javax.persistence.JoinTable");
                pw.print('(');
            } else {
                pw.print(',');
            }
            pw.println();
            pw.indent();
            if (printRef) {
                this.printJoinTableJoinColumnAnnotationsOn(elementName, foreignKey, pw);
            } else if (printBase) {
                pw.print(elementName);
                pw.print('=');
                this.printJoinColumnAnnotationOn(joinColumnName, null, pw);
            }
            pw.undent();
        }
    }

    private void printJoinTableJoinColumnAnnotationsOn(String elementName, ForeignKey foreignKey, EntitySourceWriter pw) {
        pw.print(elementName);
        pw.print('=');
        if (foreignKey.columnPairsSize() > 1) {
            pw.print('{');
            pw.println();
            pw.indent();
        }
        this.printJoinColumnAnnotationsOn(foreignKey, pw);
        if (foreignKey.columnPairsSize() > 1) {
            pw.undent();
            pw.println();
            pw.print('}');
            pw.println();
        }
    }

    private void printEntityNonOwnedManyToManyFieldsOn(EntitySourceWriter pw) {
        Iterator<ManyToManyRelation> stream = this.genTable.nonOwnedManyToManyRelations();
        while (stream.hasNext()) {
            this.printEntityNonOwnedManyToManyFieldOn(stream.next(), pw);
        }
    }

    private void printEntityNonOwnedManyToManyFieldOn(ManyToManyRelation relation, EntitySourceWriter pw) {
        String fieldName = this.genTable.getAttributeNameFor(relation);
        if (this.config.fieldAccessType()) {
            this.printNonOwnedManyToManyAnnotationOn(relation, pw);
        }
        this.printCollectionFieldOn(fieldName, this.fullyQualify(relation.getOwningEntityName()), pw);
    }

    private void printNonOwnedManyToManyAnnotationOn(ManyToManyRelation relation, EntitySourceWriter pw) {
        pw.printAnnotation("javax.persistence.ManyToMany");
        pw.print("(mappedBy=\"");
        pw.print(relation.getMappedBy());
        pw.print("\")");
        pw.println();
    }

    private void printSerialVersionUIDFieldOn(EntitySourceWriter pw) {
        if (this.config.generateSerialVersionUID()) {
            pw.print("private static final long serialVersionUID = 1L;");
            pw.println();
        }
    }

    private void printZeroArgumentConstructorOn(String ctorName, String visibility, EntitySourceWriter pw) {
        if (this.config.generateDefaultConstructor()) {
            pw.printVisibility(visibility);
            pw.print(ctorName);
            pw.print("() {");
            pw.println();
            pw.indent();
            pw.println("super();");
            pw.undent();
            pw.print('}');
            pw.println();
            pw.println();
        }
    }

    private void printEntityPrimaryKeyPropertiesOn(EntitySourceWriter pw) {
        if (this.primaryKeyClassIsRequired() && this.config.generateEmbeddedIdForCompoundPK()) {
            this.printEntityEmbeddedIdPrimaryKeyPropertyOn(pw);
        } else {
            this.printEntityReadOnlyPrimaryKeyPropertiesOn(pw);
            this.printEntityWritablePrimaryKeyPropertiesOn(pw);
        }
    }

    private void printEntityEmbeddedIdPrimaryKeyPropertyOn(EntitySourceWriter pw) {
        if (this.config.propertyAccessType()) {
            pw.printAnnotation("javax.persistence.EmbeddedId");
            pw.println();
        }
        this.printPropertyOn(this.genTable.getAttributeNameForEmbeddedId(), this.pkClassName, pw);
    }

    private void printEntityReadOnlyPrimaryKeyPropertiesOn(EntitySourceWriter pw) {
        this.printPrimaryKeyPropertiesOn(pw, true, true);
    }

    private void printEntityWritablePrimaryKeyPropertiesOn(EntitySourceWriter pw) {
        this.printPrimaryKeyPropertiesOn(pw, false, true);
    }

    private void printPrimaryKeyPropertiesOn(EntitySourceWriter pw, boolean readOnly, boolean printIdAnnotation) {
        Iterator<Column> stream = this.primaryKeyColumns(readOnly);
        while (stream.hasNext()) {
            this.printPrimaryKeyPropertyOn(stream.next(), pw, readOnly, printIdAnnotation);
        }
    }

    private void printPrimaryKeyPropertyOn(Column column, EntitySourceWriter pw, boolean readOnly, boolean printIdAnnotation) {
        String propertyName = this.genTable.getAttributeNameFor(column);
        if (this.config.propertyAccessType()) {
            if (printIdAnnotation) {
                pw.printAnnotation("javax.persistence.Id");
                pw.println();
            }
            String columnName = this.config.getDatabaseAnnotationNameBuilder().buildColumnAnnotationName(propertyName, column);
            if (readOnly) {
                this.printReadOnlyColumnAnnotationOn(columnName, pw);
            } else {
                this.printColumnAnnotationOn(columnName, pw);
            }
        }
        this.printPropertyOn(propertyName, column.getPrimaryKeyJavaTypeDeclaration(), pw);
    }

    private void printEntityNonPrimaryKeyBasicPropertiesOn(EntitySourceWriter pw) {
        Iterator<Column> stream = this.genTable.nonPrimaryKeyBasicColumns();
        while (stream.hasNext()) {
            this.printEntityNonPrimaryKeyBasicPropertyOn(stream.next(), pw);
        }
    }

    private void printEntityNonPrimaryKeyBasicPropertyOn(Column column, EntitySourceWriter pw) {
        String propertyName = this.genTable.getAttributeNameFor(column);
        if (this.config.propertyAccessType()) {
            String columnName = this.config.getDatabaseAnnotationNameBuilder().buildColumnAnnotationName(propertyName, column);
            this.printColumnAnnotationOn(columnName, pw);
        }
        this.printPropertyOn(propertyName, column.getJavaTypeDeclaration(), pw);
    }

    private void printEntityManyToOnePropertiesOn(EntitySourceWriter pw) {
        Iterator<ManyToOneRelation> stream = this.genTable.manyToOneRelations();
        while (stream.hasNext()) {
            this.printEntityManyToOnePropertyOn(stream.next(), pw);
        }
    }

    private void printEntityManyToOnePropertyOn(ManyToOneRelation relation, EntitySourceWriter pw) {
        String propertyName = this.genTable.getAttributeNameFor(relation);
        if (this.config.propertyAccessType()) {
            this.printManyToOneAnnotationOn(propertyName, relation, pw);
        }
        String typeDeclaration = this.fullyQualify(relation.getReferencedEntityName());
        this.printPropertyOn(propertyName, typeDeclaration, pw);
    }

    private void printEntityOneToManyPropertiesOn(EntitySourceWriter pw) {
        Iterator<OneToManyRelation> stream = this.genTable.oneToManyRelations();
        while (stream.hasNext()) {
            this.printEntityOneToManyPropertyOn(stream.next(), pw);
        }
    }

    private void printEntityOneToManyPropertyOn(OneToManyRelation relation, EntitySourceWriter pw) {
        String propertyName = this.genTable.getAttributeNameFor(relation);
        if (this.config.propertyAccessType()) {
            this.printOneToManyAnnotationOn(relation, pw);
        }
        String elementTypeDeclaration = this.fullyQualify(relation.getReferencedEntityName());
        this.printCollectionPropertyOn(propertyName, elementTypeDeclaration, pw);
    }

    private void printEntityOwnedManyToManyPropertiesOn(EntitySourceWriter pw) {
        Iterator<ManyToManyRelation> stream = this.genTable.ownedManyToManyRelations();
        while (stream.hasNext()) {
            this.printEntityOwnedManyToManyPropertyOn(stream.next(), pw);
        }
    }

    private void printEntityOwnedManyToManyPropertyOn(ManyToManyRelation relation, EntitySourceWriter pw) {
        String propertyName = this.genTable.getAttributeNameFor(relation);
        if (this.config.propertyAccessType()) {
            this.printOwnedManyToManyAnnotationOn(propertyName, relation, pw);
        }
        String elementTypeDeclaration = this.fullyQualify(relation.getNonOwningEntityName());
        this.printCollectionPropertyOn(propertyName, elementTypeDeclaration, pw);
    }

    private void printEntityNonOwnedManyToManyPropertiesOn(EntitySourceWriter pw) {
        Iterator<ManyToManyRelation> stream = this.genTable.nonOwnedManyToManyRelations();
        while (stream.hasNext()) {
            this.printEntityNonOwnedManyToManyPropertyOn(stream.next(), pw);
        }
    }

    private void printEntityNonOwnedManyToManyPropertyOn(ManyToManyRelation relation, EntitySourceWriter pw) {
        String propertyName = this.genTable.getAttributeNameFor(relation);
        if (this.config.propertyAccessType()) {
            this.printNonOwnedManyToManyAnnotationOn(relation, pw);
        }
        String elementTypeDeclaration = this.fullyQualify(relation.getOwningEntityName());
        this.printCollectionPropertyOn(propertyName, elementTypeDeclaration, pw);
    }

    private void printPrimaryKeyClassOn(EntitySourceWriter pw) {
        pw.println();
        if (this.config.generateEmbeddedIdForCompoundPK()) {
            pw.printAnnotation("javax.persistence.Embeddable");
            pw.println();
        }
        pw.print("public static class ");
        pw.print(this.config.getPrimaryKeyMemberClassName());
        pw.print(" implements ");
        pw.printTypeDeclaration(Serializable.class.getName());
        pw.print(" {");
        pw.println();
        pw.indent();
        if (this.config.generateEmbeddedIdForCompoundPK()) {
            this.printEmbeddableReadOnlyPrimaryKeyFieldsOn(pw);
            this.printEmbeddableWritablePrimaryKeyFieldsOn(pw);
        } else {
            this.printIdFieldsOn(pw);
        }
        this.printSerialVersionUIDFieldOn(pw);
        pw.println();
        this.printZeroArgumentConstructorOn(this.config.getPrimaryKeyMemberClassName(), "public", pw);
        if (this.config.propertyAccessType() || this.config.generateGettersAndSetters()) {
            if (this.config.generateEmbeddedIdForCompoundPK()) {
                this.printEmbeddableReadOnlyPrimaryKeyPropertiesOn(pw);
                this.printEmbeddableWritablePrimaryKeyPropertiesOn(pw);
            } else {
                this.printIdPropertiesOn(pw);
            }
        }
        this.printPrimaryKeyEqualsMethodOn(this.config.getPrimaryKeyMemberClassName(), this.getTable().primaryKeyColumns(), pw);
        this.printPrimaryKeyHashCodeMethodOn(this.getTable().primaryKeyColumns(), pw);
        pw.undent();
        pw.print('}');
        pw.println();
        pw.println();
    }

    private void printEmbeddableReadOnlyPrimaryKeyFieldsOn(EntitySourceWriter pw) {
        this.printPrimaryKeyFieldsOn(pw, true, false);
    }

    private void printEmbeddableWritablePrimaryKeyFieldsOn(EntitySourceWriter pw) {
        this.printPrimaryKeyFieldsOn(pw, false, false);
    }

    private void printIdFieldsOn(EntitySourceWriter pw) {
        Iterator stream = this.getTable().primaryKeyColumns();
        while (stream.hasNext()) {
            this.printIdFieldOn((Column)stream.next(), pw);
        }
    }

    private void printIdFieldOn(Column column, EntitySourceWriter pw) {
        this.printFieldOn(this.genTable.getAttributeNameFor(column), column.getPrimaryKeyJavaTypeDeclaration(), pw);
    }

    private void printEmbeddableReadOnlyPrimaryKeyPropertiesOn(EntitySourceWriter pw) {
        this.printPrimaryKeyPropertiesOn(pw, true, false);
    }

    private void printEmbeddableWritablePrimaryKeyPropertiesOn(EntitySourceWriter pw) {
        this.printPrimaryKeyPropertiesOn(pw, false, false);
    }

    private void printIdPropertiesOn(EntitySourceWriter pw) {
        Iterator stream = this.getTable().primaryKeyColumns();
        while (stream.hasNext()) {
            this.printIdPropertyOn((Column)stream.next(), pw);
        }
    }

    private void printIdPropertyOn(Column column, EntitySourceWriter pw) {
        this.printPropertyOn(this.genTable.getAttributeNameFor(column), column.getPrimaryKeyJavaTypeDeclaration(), pw);
    }

    private void printPrimaryKeyEqualsMethodOn(String className, Iterator<Column> columns, EntitySourceWriter pw) {
        pw.printAnnotation("java.lang.Override");
        pw.println();
        pw.println("public boolean equals(Object o) {");
        pw.indent();
        pw.println("if (o == this) {");
        pw.indent();
        pw.println("return true;");
        pw.undent();
        pw.print('}');
        pw.println();
        pw.print("if ( ! (o instanceof ");
        pw.print(className);
        pw.print(")) {");
        pw.println();
        pw.indent();
        pw.println("return false;");
        pw.undent();
        pw.print('}');
        pw.println();
        pw.print(className);
        pw.print(" other = (");
        pw.print(className);
        pw.print(") o;");
        pw.println();
        pw.print("return ");
        pw.indent();
        while (columns.hasNext()) {
            this.printPrimaryKeyEqualsClauseOn(columns.next(), pw);
            if (!columns.hasNext()) continue;
            pw.println();
            pw.print("&& ");
        }
        pw.print(';');
        pw.println();
        pw.undent();
        pw.undent();
        pw.print('}');
        pw.println();
        pw.println();
    }

    private void printPrimaryKeyEqualsClauseOn(Column column, EntitySourceWriter pw) {
        String fieldName = this.genTable.getAttributeNameFor(column);
        JavaType javaType = column.getPrimaryKeyJavaType();
        if (javaType.isPrimitive()) {
            this.printPrimitiveEqualsClauseOn(fieldName, pw);
        } else {
            this.printReferenceEqualsClauseOn(fieldName, pw);
        }
    }

    private void printPrimitiveEqualsClauseOn(String fieldName, EntitySourceWriter pw) {
        pw.print("(this.");
        pw.print(fieldName);
        pw.print(" == other.");
        pw.print(fieldName);
        pw.print(')');
    }

    private void printReferenceEqualsClauseOn(String fieldName, EntitySourceWriter pw) {
        pw.print("this.");
        pw.print(fieldName);
        pw.print(".equals(other.");
        pw.print(fieldName);
        pw.print(')');
    }

    private void printPrimaryKeyHashCodeMethodOn(Iterator<Column> columns, EntitySourceWriter pw) {
        pw.printAnnotation("java.lang.Override");
        pw.println();
        pw.println("public int hashCode() {");
        pw.indent();
        pw.println("final int prime = 31;");
        pw.println("int hash = 17;");
        while (columns.hasNext()) {
            pw.print("hash = hash * prime + ");
            this.printPrimaryKeyHashCodeClauseOn(columns.next(), pw);
            pw.print(';');
            pw.println();
        }
        pw.println("return hash;");
        pw.undent();
        pw.print('}');
        pw.println();
        pw.println();
    }

    private void printPrimaryKeyHashCodeClauseOn(Column column, EntitySourceWriter pw) {
        String fieldName = this.genTable.getAttributeNameFor(column);
        JavaType javaType = column.getPrimaryKeyJavaType();
        if (javaType.isPrimitive()) {
            this.printPrimitiveHashCodeClauseOn(javaType.getElementTypeName(), fieldName, pw);
        } else {
            this.printReferenceHashCodeClauseOn(fieldName, pw);
        }
    }

    private void printPrimitiveHashCodeClauseOn(String primitiveName, String fieldName, EntitySourceWriter pw) {
        if (primitiveName.equals("int")) {
            pw.print("this.");
            pw.print(fieldName);
        } else if (primitiveName.equals("short") || primitiveName.equals("byte") || primitiveName.equals("char")) {
            pw.print("((int) this.");
            pw.print(fieldName);
            pw.print(')');
        } else if (primitiveName.equals("long")) {
            pw.print("((int) (this.");
            pw.print(fieldName);
            pw.print(" ^ (this.");
            pw.print(fieldName);
            pw.print(" >>> 32)))");
        } else if (primitiveName.equals("float")) {
            pw.printTypeDeclaration("java.lang.Float");
            pw.print(".floatToIntBits(this.");
            pw.print(fieldName);
            pw.print(')');
        } else if (primitiveName.equals("double")) {
            pw.print("((int) (");
            pw.printTypeDeclaration("java.lang.Double");
            pw.print(".doubleToLongBits(this.");
            pw.print(fieldName);
            pw.print(") ^ (");
            pw.printTypeDeclaration("java.lang.Double");
            pw.print(".doubleToLongBits(this.");
            pw.print(fieldName);
            pw.print(") >>> 32)))");
        } else if (primitiveName.equals("boolean")) {
            pw.print("(this.");
            pw.print(fieldName);
            pw.print(" ? 1 : 0)");
        } else {
            throw new IllegalArgumentException(primitiveName);
        }
    }

    private void printReferenceHashCodeClauseOn(String fieldName, EntitySourceWriter pw) {
        pw.print("this.");
        pw.print(fieldName);
        pw.print(".hashCode()");
    }

    private void printPackageAndImportsOn(PrintWriter pw, BodySource bodySource) {
        if (this.getPackageName().length() != 0) {
            pw.print("package ");
            pw.print(this.getPackageName());
            pw.print(';');
            pw.println();
            pw.println();
        }
        Iterator<Map.Entry<String, String>> stream = bodySource.importEntries();
        while (stream.hasNext()) {
            Map.Entry<String, String> entry = stream.next();
            pw.print("import ");
            pw.print(entry.getValue());
            pw.print('.');
            pw.print(entry.getKey());
            pw.print(';');
            pw.println();
        }
        pw.println();
    }

    private void printFieldOn(String fieldName, String typeDeclaration, EntitySourceWriter pw) {
        pw.printField(fieldName, typeDeclaration, this.config.getFieldVisibilityClause());
    }

    private void printCollectionFieldOn(String fieldName, String elementTypeDeclaration, EntitySourceWriter pw) {
        pw.printParameterizedField(fieldName, this.config.getCollectionTypeName(), elementTypeDeclaration, this.config.getFieldVisibilityClause());
    }

    private void printPropertyOn(String propertyName, String typeDeclaration, EntitySourceWriter pw) {
        pw.printGetterAndSetter(propertyName, typeDeclaration, this.config.getMethodVisibilityClause());
    }

    private void printCollectionPropertyOn(String propertyName, String elementTypeDeclaration, EntitySourceWriter pw) {
        pw.printCollectionGetterAndSetter(propertyName, this.config.getCollectionTypeName(), elementTypeDeclaration, this.config.getMethodVisibilityClause());
    }

    private String getPackageName() {
        return this.packageFragment.getElementName();
    }

    private Table getTable() {
        return this.genTable.getTable();
    }

    private String getEntityName() {
        return this.genTable.getEntityName();
    }

    private boolean primaryKeyClassIsRequired() {
        return this.getTable().primaryKeyColumnsSize() > 1;
    }

    private String fullyQualify(String shortClassName) {
        String pkg = this.getPackageName();
        return pkg.length() == 0 ? shortClassName : String.valueOf(pkg) + '.' + shortClassName;
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)(String.valueOf(this.genTable.getName()) + " => " + this.entityClassName));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface BodySource {
        public Iterator<Map.Entry<String, String>> importEntries();

        public String getSource();

        public int length();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Config {
        private boolean convertToJavaStyleIdentifiers = true;
        private boolean propertyAccessType = false;
        private String collectionTypeName = Set.class.getName();
        private String collectionAttributeNameSuffix = "Collection";
        private int fieldVisibility = 2;
        private int methodVisibility = 1;
        private boolean generateGettersAndSetters = true;
        private boolean generateDefaultConstructor = true;
        private boolean serializable = true;
        private boolean generateSerialVersionUID = true;
        private boolean generateEmbeddedIdForCompoundPK = true;
        private String embeddedIdAttributeName = "pk";
        private String primaryKeyMemberClassName = "PK";
        private HashMap<Table, String> tables = new HashMap();
        private DatabaseAnnotationNameBuilder databaseAnnotationNameBuilder = DatabaseAnnotationNameBuilder.Default.INSTANCE;
        private OverwriteConfirmer overwriteConfirmer = OverwriteConfirmer.Never.INSTANCE;
        public static final int PRIVATE = 0;
        public static final int PACKAGE = 1;
        public static final int PROTECTED = 2;
        public static final int PUBLIC = 3;

        public boolean convertToJavaStyleIdentifiers() {
            return this.convertToJavaStyleIdentifiers;
        }

        public void setConvertToJavaStyleIdentifiers(boolean convertToJavaStyleIdentifiers) {
            this.convertToJavaStyleIdentifiers = convertToJavaStyleIdentifiers;
        }

        public boolean propertyAccessType() {
            return this.propertyAccessType;
        }

        public void setPropertyAccessType(boolean propertyAccessType) {
            this.propertyAccessType = propertyAccessType;
        }

        public boolean fieldAccessType() {
            return !this.propertyAccessType;
        }

        public void setFieldAccessType(boolean fieldAccessType) {
            this.propertyAccessType = !fieldAccessType;
        }

        public String getCollectionTypeName() {
            return this.collectionTypeName;
        }

        public void setCollectionTypeName(String collectionTypeName) {
            this.checkRequiredString(collectionTypeName, "collection type name is required");
            this.collectionTypeName = collectionTypeName;
        }

        public String getCollectionAttributeNameSuffix() {
            return this.collectionAttributeNameSuffix;
        }

        public void setCollectionAttributeNameSuffix(String collectionAttributeNameSuffix) {
            this.collectionAttributeNameSuffix = collectionAttributeNameSuffix;
        }

        public int getFieldVisibility() {
            return this.fieldVisibility;
        }

        public void setFieldVisibility(int fieldVisibility) {
            switch (fieldVisibility) {
                case 0: 
                case 1: 
                case 2: {
                    this.fieldVisibility = fieldVisibility;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid field visibility: " + fieldVisibility);
                }
            }
        }

        String getFieldVisibilityClause() {
            switch (this.fieldVisibility) {
                case 0: {
                    return "private";
                }
                case 1: {
                    return "";
                }
                case 2: {
                    return "protected";
                }
            }
            throw new IllegalStateException("invalid field visibility: " + this.fieldVisibility);
        }

        public int getMethodVisibility() {
            return this.methodVisibility;
        }

        public void setMethodVisibility(int methodVisibility) {
            switch (methodVisibility) {
                case 2: 
                case 3: {
                    this.methodVisibility = methodVisibility;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid method visibility: " + methodVisibility);
                }
            }
        }

        String getMethodVisibilityClause() {
            switch (this.methodVisibility) {
                case 2: {
                    return "protected";
                }
                case 3: {
                    return "public";
                }
            }
            throw new IllegalStateException("invalid method visibility: " + this.methodVisibility);
        }

        public boolean generateGettersAndSetters() {
            return this.generateGettersAndSetters;
        }

        public void setGenerateGettersAndSetters(boolean generateGettersAndSetters) {
            this.generateGettersAndSetters = generateGettersAndSetters;
        }

        public boolean generateDefaultConstructor() {
            return this.generateDefaultConstructor;
        }

        public void setGenerateDefaultConstructor(boolean generateDefaultConstructor) {
            this.generateDefaultConstructor = generateDefaultConstructor;
        }

        public boolean serializable() {
            return this.serializable;
        }

        public void setSerializable(boolean serializable) {
            this.serializable = serializable;
        }

        public boolean generateSerialVersionUID() {
            return this.generateSerialVersionUID;
        }

        public void setGenerateSerialVersionUID(boolean generateSerialVersionUID) {
            this.generateSerialVersionUID = generateSerialVersionUID;
        }

        public boolean generateEmbeddedIdForCompoundPK() {
            return this.generateEmbeddedIdForCompoundPK;
        }

        public void setGenerateEmbeddedIdForCompoundPK(boolean generateEmbeddedIdForCompoundPK) {
            this.generateEmbeddedIdForCompoundPK = generateEmbeddedIdForCompoundPK;
        }

        public boolean generateIdClassForCompoundPK() {
            return !this.generateEmbeddedIdForCompoundPK;
        }

        public void setGenerateIdClassForCompoundPK(boolean generateIdClassForCompoundPK) {
            this.generateEmbeddedIdForCompoundPK = !generateIdClassForCompoundPK;
        }

        public String getEmbeddedIdAttributeName() {
            return this.embeddedIdAttributeName;
        }

        public void setEmbeddedIdAttributeName(String embeddedIdAttributeName) {
            this.checkRequiredString(embeddedIdAttributeName, "EmbeddedId attribute name is required");
            this.embeddedIdAttributeName = embeddedIdAttributeName;
        }

        public String getPrimaryKeyMemberClassName() {
            return this.primaryKeyMemberClassName;
        }

        public void setPrimaryKeyMemberClassName(String primaryKeyMemberClassName) {
            this.checkRequiredString(primaryKeyMemberClassName, "primary key member class name is required");
            this.primaryKeyMemberClassName = primaryKeyMemberClassName;
        }

        String getEntityName(Table table) {
            return this.tables.get(table);
        }

        Iterator<Table> tables() {
            return this.tables.keySet().iterator();
        }

        int tablesSize() {
            return this.tables.size();
        }

        public void addTable(Table table, String entityName) {
            if (table == null) {
                throw new NullPointerException("table is required");
            }
            this.checkRequiredString(entityName, "entity name is required");
            if (this.tables.containsKey(table)) {
                throw new IllegalArgumentException("duplicate table: " + table.getName());
            }
            if (this.tables.values().contains(entityName)) {
                throw new IllegalArgumentException("duplicate entity name: " + entityName);
            }
            if (!NameTools.stringConsistsOfJavaIdentifierCharacters((String)entityName)) {
                throw new IllegalArgumentException("entity name is not a valid Java identifier: " + entityName);
            }
            if (NameTools.JAVA_RESERVED_WORDS_SET.contains(entityName)) {
                throw new IllegalArgumentException("entity name is a Java reserved word: " + entityName);
            }
            this.tables.put(table, entityName);
        }

        public DatabaseAnnotationNameBuilder getDatabaseAnnotationNameBuilder() {
            return this.databaseAnnotationNameBuilder;
        }

        public void setDatabaseAnnotationNameBuilder(DatabaseAnnotationNameBuilder databaseAnnotationNameBuilder) {
            if (databaseAnnotationNameBuilder == null) {
                throw new NullPointerException("database annotation name builder is required");
            }
            this.databaseAnnotationNameBuilder = databaseAnnotationNameBuilder;
        }

        public OverwriteConfirmer getOverwriteConfirmer() {
            return this.overwriteConfirmer;
        }

        public void setOverwriteConfirmer(OverwriteConfirmer overwriteConfirmer) {
            if (overwriteConfirmer == null) {
                throw new NullPointerException("overwrite confirmer is required");
            }
            this.overwriteConfirmer = overwriteConfirmer;
        }

        private void checkRequiredString(String string, String message) {
            if (string == null || string.length() == 0) {
                throw new IllegalArgumentException(message);
            }
        }
    }

    public static interface DatabaseAnnotationNameBuilder {
        public String buildTableAnnotationName(String var1, Table var2);

        public String buildColumnAnnotationName(String var1, Column var2);

        public String buildJoinColumnAnnotationName(String var1, ForeignKey var2);

        public String buildJoinColumnAnnotationName(Column var1);

        public String buildJoinTableAnnotationName(Table var1);

        public static final class Default
        implements DatabaseAnnotationNameBuilder {
            public static final DatabaseAnnotationNameBuilder INSTANCE = new Default();

            public static DatabaseAnnotationNameBuilder instance() {
                return INSTANCE;
            }

            private Default() {
            }

            public String buildTableAnnotationName(String entityName, Table table) {
                return table.getName();
            }

            public String buildColumnAnnotationName(String attributeName, Column column) {
                return column.getName();
            }

            public String buildJoinColumnAnnotationName(String attributeName, ForeignKey foreignKey) {
                return foreignKey.getColumnPair().getBaseColumn().getName();
            }

            public String buildJoinColumnAnnotationName(Column column) {
                return column.getName();
            }

            public String buildJoinTableAnnotationName(Table table) {
                return table.getName();
            }

            public String toString() {
                return "DatabaseAnnotationNameBuilder.Default";
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EntitySourceWriter
    extends IndentingPrintWriter
    implements BodySource {
        final String packageName;
        final String className;
        private final Map<String, String> imports = new HashMap<String, String>();

        EntitySourceWriter(String packageName, String className) {
            super((Writer)new StringWriter(20000));
            this.packageName = packageName;
            this.className = className;
        }

        void printStringLiteral(String string) {
            StringTools.convertToJavaStringLiteralOn((String)string, (Writer)((Object)this));
        }

        void printVisibility(String visibilityModifier) {
            if (visibilityModifier.length() != 0) {
                this.print(visibilityModifier);
                this.print(' ');
            }
        }

        void printAnnotation(String annotationName) {
            this.print('@');
            this.printTypeDeclaration(annotationName);
        }

        void printTypeDeclaration(String typeDeclaration) {
            this.print(this.buildImportedTypeDeclaration(typeDeclaration));
        }

        private String buildImportedTypeDeclaration(String typeDeclaration) {
            String shortTypeDeclaration;
            if (this.typeDeclarationIsMemberClass(typeDeclaration)) {
                return this.buildMemberClassTypeDeclaration(typeDeclaration);
            }
            int last = typeDeclaration.lastIndexOf(46);
            String pkg = last == -1 ? "" : typeDeclaration.substring(0, last);
            String shortElementTypeName = shortTypeDeclaration = typeDeclaration.substring(last + 1);
            while (shortElementTypeName.endsWith("[]")) {
                shortElementTypeName = shortElementTypeName.substring(0, shortElementTypeName.length() - 2);
            }
            String prev = this.imports.get(shortElementTypeName);
            if (prev == null) {
                this.imports.put(shortElementTypeName, pkg);
                return shortTypeDeclaration;
            }
            if (prev.equals(pkg)) {
                return shortTypeDeclaration;
            }
            return typeDeclaration;
        }

        private boolean typeDeclarationIsMemberClass(String typeDeclaration) {
            return typeDeclaration.length() > this.className.length() && typeDeclaration.startsWith(this.className) && typeDeclaration.charAt(this.className.length()) == '.';
        }

        private String buildMemberClassTypeDeclaration(String typeDeclaration) {
            int index = this.packageName.length();
            if (index != 0) {
                ++index;
            }
            return typeDeclaration.substring(index);
        }

        private Iterator<Map.Entry<String, String>> sortedImportEntries() {
            TreeSet<Map.Entry<String, String>> sortedImports = new TreeSet<Map.Entry<String, String>>(this.buildImportEntriesComparator());
            sortedImports.addAll(this.imports.entrySet());
            return sortedImports.iterator();
        }

        private Comparator<Map.Entry<String, String>> buildImportEntriesComparator() {
            return new Comparator<Map.Entry<String, String>>(){

                @Override
                public int compare(Map.Entry<String, String> e1, Map.Entry<String, String> e2) {
                    Collator collator = Collator.getInstance();
                    int pkg = collator.compare(e1.getValue(), e2.getValue());
                    return pkg == 0 ? collator.compare(e1.getKey(), e2.getKey()) : pkg;
                }
            };
        }

        void printField(String fieldName, String typeDeclaration, String visibility) {
            this.printVisibility(visibility);
            this.printTypeDeclaration(typeDeclaration);
            this.print(' ');
            this.print(fieldName);
            this.print(';');
            this.println();
            this.println();
        }

        void printParameterizedField(String fieldName, String typeDeclaration, String parameterTypeDeclaration, String visibility) {
            this.printVisibility(visibility);
            this.printTypeDeclaration(typeDeclaration);
            this.print('<');
            this.printTypeDeclaration(parameterTypeDeclaration);
            this.print('>');
            this.print(' ');
            this.print(fieldName);
            this.print(';');
            this.println();
            this.println();
        }

        void printGetterAndSetter(String propertyName, String typeDeclaration, String visibility) {
            this.printGetter(propertyName, typeDeclaration, visibility);
            this.println();
            this.println();
            this.printSetter(propertyName, typeDeclaration, visibility);
            this.println();
            this.println();
        }

        private void printGetter(String propertyName, String typeDeclaration, String visibility) {
            this.printVisibility(visibility);
            this.printTypeDeclaration(typeDeclaration);
            this.print(' ');
            this.print(typeDeclaration.equals("boolean") ? "is" : "get");
            this.print(StringTools.capitalize((String)propertyName));
            this.print("() {");
            this.println();
            this.indent();
            this.print("return this.");
            this.print(propertyName);
            this.print(';');
            this.println();
            this.undent();
            this.print('}');
        }

        private void printSetter(String propertyName, String typeDeclaration, String visibility) {
            this.printVisibility(visibility);
            this.print("void set");
            this.print(StringTools.capitalize((String)propertyName));
            this.print('(');
            this.printTypeDeclaration(typeDeclaration);
            this.print(' ');
            this.print(propertyName);
            this.print(") {");
            this.println();
            this.indent();
            this.print("this.");
            this.print(propertyName);
            this.print(" = ");
            this.print(propertyName);
            this.print(';');
            this.println();
            this.undent();
            this.print('}');
        }

        void printCollectionGetterAndSetter(String propertyName, String collectionTypeDeclaration, String elementTypeDeclaration, String visibility) {
            this.printCollectionGetter(propertyName, collectionTypeDeclaration, elementTypeDeclaration, visibility);
            this.println();
            this.println();
            this.printCollectionSetter(propertyName, collectionTypeDeclaration, elementTypeDeclaration, visibility);
            this.println();
            this.println();
        }

        private void printCollectionGetter(String propertyName, String collectionTypeDeclaration, String elementTypeDeclaration, String visibility) {
            this.printVisibility(visibility);
            this.printTypeDeclaration(collectionTypeDeclaration);
            this.print('<');
            this.printTypeDeclaration(elementTypeDeclaration);
            this.print("> get");
            this.print(StringTools.capitalize((String)propertyName));
            this.print("() {");
            this.println();
            this.indent();
            this.print("return this.");
            this.print(propertyName);
            this.print(';');
            this.println();
            this.undent();
            this.print('}');
        }

        private void printCollectionSetter(String propertyName, String collectionTypeDeclaration, String elementTypeDeclaration, String visibility) {
            this.printVisibility(visibility);
            this.print("void set");
            this.print(StringTools.capitalize((String)propertyName));
            this.print('(');
            this.printTypeDeclaration(collectionTypeDeclaration);
            this.print('<');
            this.printTypeDeclaration(elementTypeDeclaration);
            this.print('>');
            this.print(' ');
            this.print(propertyName);
            this.print(") {");
            this.println();
            this.indent();
            this.print("this.");
            this.print(propertyName);
            this.print(" = ");
            this.print(propertyName);
            this.print(';');
            this.println();
            this.undent();
            this.print('}');
        }

        @Override
        public Iterator<Map.Entry<String, String>> importEntries() {
            return new FilteringIterator<Map.Entry<String, String>, Map.Entry<String, String>>(this.sortedImportEntries()){

                protected boolean accept(Map.Entry<String, String> next) {
                    String pkg = next.getValue();
                    return !pkg.equals("") && !pkg.equals("java.lang") && !pkg.equals(EntitySourceWriter.this.packageName);
                }
            };
        }

        @Override
        public String getSource() {
            return this.out.toString();
        }

        @Override
        public int length() {
            return ((StringWriter)this.out).getBuffer().length();
        }
    }

    public static interface OverwriteConfirmer {
        public boolean overwrite(String var1);

        public static final class Always
        implements OverwriteConfirmer {
            public static final OverwriteConfirmer INSTANCE = new Always();

            public static OverwriteConfirmer instance() {
                return INSTANCE;
            }

            private Always() {
            }

            public boolean overwrite(String arg0) {
                return true;
            }

            public String toString() {
                return "OverwriteConfirmer.Always";
            }
        }

        public static final class Never
        implements OverwriteConfirmer {
            public static final OverwriteConfirmer INSTANCE = new Never();

            public static OverwriteConfirmer instance() {
                return INSTANCE;
            }

            private Never() {
            }

            public boolean overwrite(String arg0) {
                return false;
            }

            public String toString() {
                return "OverwriteConfirmer.Never";
            }
        }
    }
}

