/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.orm;

import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.context.XmlContextNode;
import org.eclipse.jpt.core.internal.context.AbstractXmlContextNode;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.java.EclipseLinkJavaConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlNamedConverter;
import org.eclipse.jpt.utility.internal.StringTools;

public abstract class EclipseLinkOrmConverter
extends AbstractXmlContextNode
implements EclipseLinkConverter {
    private XmlNamedConverter xmlResource;
    private String name;

    public EclipseLinkOrmConverter(XmlContextNode parent) {
        super((JpaContextNode)parent);
    }

    protected XmlNamedConverter getXmlResource() {
        return this.xmlResource;
    }

    public EclipseLinkPersistenceUnit getPersistenceUnit() {
        return (EclipseLinkPersistenceUnit)super.getPersistenceUnit();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.getXmlResource().setName(newName);
        this.firePropertyChanged("nameProperty", oldName, newName);
    }

    protected void setName_(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.firePropertyChanged("nameProperty", oldName, newName);
    }

    protected void initialize(XmlNamedConverter resource) {
        this.xmlResource = resource;
        this.name = this.calculateName();
        this.getPersistenceUnit().addConverter(this);
    }

    public void update() {
        this.setName_(this.calculateName());
        this.getPersistenceUnit().addConverter(this);
    }

    protected String calculateName() {
        return this.getXmlResource().getName();
    }

    public boolean overrides(EclipseLinkConverter converter) {
        if (this.getName() == null) {
            return false;
        }
        return this.getName().equals(converter.getName()) && converter instanceof EclipseLinkJavaConverter;
    }

    public boolean duplicates(EclipseLinkConverter converter) {
        return this != converter && !StringTools.stringIsEmpty((String)this.name) && this.name.equals(converter.getName()) && !this.overrides(converter) && !converter.overrides(this);
    }

    public TextRange getValidationTextRange() {
        return this.getXmlResource().getValidationTextRange();
    }
}

